/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mekanism.client.sound.PlayerSound;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.network.PacketFlamethrowerData;
import mekanism.common.network.PacketJetpackData;
import mekanism.common.network.PacketScubaTankData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class PlayerState {
    private Set<UUID> activeJetpacks = new HashSet<UUID>();
    private Set<UUID> activeGasmasks = new HashSet<UUID>();
    private Set<UUID> activeFlamethrowers = new HashSet<UUID>();
    private World world;

    public void clear() {
        this.activeJetpacks.clear();
        this.activeGasmasks.clear();
        this.activeFlamethrowers.clear();
        if (FMLCommonHandler.instance().getSide().isClient()) {
            SoundHandler.clearPlayerSounds();
        }
    }

    public void clearPlayer(UUID uuid) {
        this.activeJetpacks.remove(uuid);
        this.activeGasmasks.remove(uuid);
        this.activeFlamethrowers.remove(uuid);
        if (FMLCommonHandler.instance().getSide().isClient()) {
            SoundHandler.clearPlayerSounds(uuid);
        }
    }

    public void init(World world) {
        this.world = world;
    }

    public void setJetpackState(UUID uuid, boolean isActive, boolean isLocal) {
        boolean changed;
        boolean alreadyActive = this.activeJetpacks.contains(uuid);
        boolean bl = changed = alreadyActive != isActive;
        if (alreadyActive && !isActive) {
            this.activeJetpacks.remove(uuid);
        } else if (!alreadyActive && isActive) {
            this.activeJetpacks.add(uuid);
        }
        if (changed && this.world.field_72995_K) {
            if (isLocal) {
                Mekanism.packetHandler.sendToServer(PacketJetpackData.JetpackDataMessage.UPDATE(uuid, isActive));
            }
            if (isActive && MekanismConfig.current().client.enablePlayerSounds.val()) {
                SoundHandler.startSound(this.world, uuid, PlayerSound.SoundType.JETPACK);
            }
        }
    }

    public boolean isJetpackOn(EntityPlayer p) {
        return this.activeJetpacks.contains(p.func_110124_au());
    }

    public Set<UUID> getActiveJetpacks() {
        return this.activeJetpacks;
    }

    public void setActiveJetpacks(Set<UUID> newActiveJetpacks) {
        for (UUID activeUser : newActiveJetpacks) {
            this.setJetpackState(activeUser, true, false);
        }
    }

    public void setGasmaskState(UUID uuid, boolean isActive, boolean isLocal) {
        boolean changed;
        boolean alreadyActive = this.activeGasmasks.contains(uuid);
        boolean bl = changed = alreadyActive != isActive;
        if (alreadyActive && !isActive) {
            this.activeGasmasks.remove(uuid);
        } else if (!alreadyActive && isActive) {
            this.activeGasmasks.add(uuid);
        }
        if (changed && this.world.field_72995_K) {
            if (isLocal) {
                Mekanism.packetHandler.sendToServer(PacketScubaTankData.ScubaTankDataMessage.UPDATE(uuid, isActive));
            }
            if (isActive && MekanismConfig.current().client.enablePlayerSounds.val()) {
                SoundHandler.startSound(this.world, uuid, PlayerSound.SoundType.GAS_MASK);
            }
        }
    }

    public boolean isGasmaskOn(EntityPlayer p) {
        return this.activeGasmasks.contains(p.func_110124_au());
    }

    public Set<UUID> getActiveGasmasks() {
        return this.activeGasmasks;
    }

    public void setActiveGasmasks(Set<UUID> newActiveGasmasks) {
        for (UUID activeUser : newActiveGasmasks) {
            this.setGasmaskState(activeUser, true, false);
        }
    }

    public void setFlamethrowerState(UUID uuid, boolean isActive, boolean isLocal) {
        this.setFlamethrowerState(uuid, isActive, isActive, isLocal);
    }

    public void setFlamethrowerState(UUID uuid, boolean hasFlameThrower, boolean isActive, boolean isLocal) {
        boolean changed;
        boolean alreadyActive = this.activeFlamethrowers.contains(uuid);
        boolean bl = changed = alreadyActive != isActive;
        if (alreadyActive && !isActive) {
            this.activeFlamethrowers.remove(uuid);
        } else if (!alreadyActive && isActive) {
            this.activeFlamethrowers.add(uuid);
        }
        if (this.world.field_72995_K) {
            boolean startSound;
            if (changed) {
                if (isLocal) {
                    Mekanism.packetHandler.sendToServer(PacketFlamethrowerData.FlamethrowerDataMessage.UPDATE(uuid, isActive));
                }
                startSound = isActive;
            } else {
                boolean bl2 = startSound = !isActive && hasFlameThrower;
            }
            if (startSound && MekanismConfig.current().client.enablePlayerSounds.val()) {
                SoundHandler.startSound(this.world, uuid, PlayerSound.SoundType.FLAMETHROWER);
            }
        }
    }

    public boolean isFlamethrowerOn(EntityPlayer p) {
        return this.activeFlamethrowers.contains(p.func_110124_au());
    }

    public Set<UUID> getActiveFlamethrowers() {
        return this.activeFlamethrowers;
    }

    public void setActiveFlamethrowers(Set<UUID> newActiveFlamethrowers) {
        for (UUID activeUser : newActiveFlamethrowers) {
            this.setFlamethrowerState(activeUser, true, false);
        }
    }
}

