/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container;

import javax.annotation.Nonnull;
import mekanism.common.tile.prefab.TileEntityBasicBlock;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public abstract class ContainerMekanism<TILE extends TileEntityContainerBlock>
extends Container {
    protected TILE tileEntity;

    protected ContainerMekanism(TILE tile, InventoryPlayer inventory) {
        this.tileEntity = tile;
        if (this.shouldAddSlots()) {
            this.addSlots();
            if (inventory != null) {
                this.addInventorySlots(inventory);
                this.openInventory(inventory);
            }
        }
    }

    protected int getInventoryOffset() {
        return 84;
    }

    protected void addInventorySlots(InventoryPlayer inventory) {
        int slotY;
        int offset = this.getInventoryOffset();
        for (slotY = 0; slotY < 3; ++slotY) {
            for (int slotX = 0; slotX < 9; ++slotX) {
                this.func_75146_a(new Slot((IInventory)inventory, slotX + slotY * 9 + 9, 8 + slotX * 18, offset + slotY * 18));
            }
        }
        offset += 58;
        for (slotY = 0; slotY < 9; ++slotY) {
            this.func_75146_a(new Slot((IInventory)inventory, slotY, 8 + slotY * 18, offset));
        }
    }

    protected boolean shouldAddSlots() {
        return true;
    }

    protected abstract void addSlots();

    protected void openInventory(InventoryPlayer inventory) {
        if (this.tileEntity != null) {
            ((TileEntityBasicBlock)this.tileEntity).open(inventory.field_70458_d);
            ((TileEntityContainerBlock)this.tileEntity).func_174889_b(inventory.field_70458_d);
        }
    }

    public void func_75134_a(EntityPlayer entityplayer) {
        super.func_75134_a(entityplayer);
        this.closeInventory(entityplayer);
    }

    protected void closeInventory(EntityPlayer entityplayer) {
        if (this.tileEntity != null) {
            ((TileEntityBasicBlock)this.tileEntity).close(entityplayer);
            ((TileEntityContainerBlock)this.tileEntity).func_174886_c(entityplayer);
        }
    }

    public boolean func_75145_c(@Nonnull EntityPlayer entityplayer) {
        return this.tileEntity == null || ((TileEntityContainerBlock)this.tileEntity).func_70300_a(entityplayer);
    }
}

