/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import cofh.redstoneflux.api.IEnergyContainerItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.energy.IEnergizedItem;
import mekanism.client.MekKeyHandler;
import mekanism.client.MekanismClient;
import mekanism.client.MekanismKeyHandler;
import mekanism.common.Mekanism;
import mekanism.common.Upgrade;
import mekanism.common.base.FluidItemWrapper;
import mekanism.common.base.IFactory;
import mekanism.common.base.IFluidItemWrapper;
import mekanism.common.base.IItemNetwork;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ISustainedInventory;
import mekanism.common.base.ISustainedTank;
import mekanism.common.base.ITierItem;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.frequency.Frequency;
import mekanism.common.integration.forgeenergy.ForgeEnergyItemWrapper;
import mekanism.common.integration.ic2.IC2ItemManager;
import mekanism.common.integration.redstoneflux.RFIntegration;
import mekanism.common.integration.tesla.TeslaItemWrapper;
import mekanism.common.security.ISecurityItem;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tier.BaseTier;
import mekanism.common.tier.FluidTankTier;
import mekanism.common.tile.TileEntityFactory;
import mekanism.common.tile.TileEntityFluidTank;
import mekanism.common.tile.TileEntityQuantumEntangloporter;
import mekanism.common.tile.prefab.TileEntityBasicBlock;
import mekanism.common.tile.prefab.TileEntityElectricBlock;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import mekanism.common.util.SecurityUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.InterfaceList(value={@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyContainerItem", modid="redstoneflux"), @Optional.Interface(iface="ic2.api.item.ISpecialElectricItem", modid="ic2")})
public class ItemBlockMachine
extends ItemBlock
implements IEnergizedItem,
ISpecialElectricItem,
IFactory,
ISustainedInventory,
ISustainedTank,
IEnergyContainerItem,
IFluidItemWrapper,
ITierItem,
ISecurityItem,
IItemNetwork {
    public Block metaBlock;

    public ItemBlockMachine(Block block) {
        super(block);
        this.metaBlock = block;
        this.func_77627_a(true);
        this.setNoRepair();
        this.func_77625_d(1);
    }

    public int func_77647_b(int i) {
        return i;
    }

    @Nonnull
    public String func_77667_c(ItemStack itemstack) {
        if (BlockStateMachine.MachineType.get(itemstack) != null) {
            return this.func_77658_a() + "." + BlockStateMachine.MachineType.get((ItemStack)itemstack).blockName;
        }
        return "null";
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack itemstack) {
        BlockStateMachine.MachineType type = BlockStateMachine.MachineType.get(itemstack);
        if (type == BlockStateMachine.MachineType.BASIC_FACTORY || type == BlockStateMachine.MachineType.ADVANCED_FACTORY || type == BlockStateMachine.MachineType.ELITE_FACTORY) {
            BaseTier tier = type.factoryTier.getBaseTier();
            IFactory.RecipeType recipeType = this.getRecipeTypeOrNull(itemstack);
            if (recipeType != null) {
                String langKey = "tile." + tier.getSimpleName() + recipeType.getTranslationKey() + "Factory";
                if (LangUtils.canLocalize(langKey)) {
                    return LangUtils.localize(langKey);
                }
                return tier.getLocalizedName() + " " + recipeType.getLocalizedName() + " " + super.func_77653_i(itemstack);
            }
        } else if (type == BlockStateMachine.MachineType.FLUID_TANK) {
            return LangUtils.localize("tile.FluidTank" + this.getBaseTier(itemstack).getSimpleName() + ".name");
        }
        return super.func_77653_i(itemstack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack itemstack, World world, @Nonnull List<String> list, @Nonnull ITooltipFlag flag) {
        BlockStateMachine.MachineType type = BlockStateMachine.MachineType.get(itemstack);
        if (!MekKeyHandler.getIsKeyPressed(MekanismKeyHandler.sneakKey)) {
            Frequency.Identity freq;
            if (type == BlockStateMachine.MachineType.FLUID_TANK) {
                FluidStack fluidStack = this.getFluidStack(itemstack);
                if (fluidStack != null) {
                    int amount = this.getFluidStack((Object[])new Object[]{itemstack}).amount;
                    String amountStr = amount == Integer.MAX_VALUE ? LangUtils.localize("gui.infinite") : amount + "mB";
                    list.add((Object)((Object)EnumColor.AQUA) + LangUtils.localizeFluidStack(fluidStack) + ": " + (Object)((Object)EnumColor.GREY) + amountStr);
                } else {
                    list.add((Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.empty") + ".");
                }
                int cap = FluidTankTier.values()[this.getBaseTier(itemstack).ordinal()].getStorage();
                list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.capacity") + ": " + (Object)((Object)EnumColor.GREY) + (cap == Integer.MAX_VALUE ? LangUtils.localize("gui.infinite") : cap + " mB"));
            }
            if (type == BlockStateMachine.MachineType.QUANTUM_ENTANGLOPORTER && (freq = Frequency.Identity.load(ItemDataUtils.getCompound(itemstack, "entangleporter_frequency"))) != null) {
                list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("gui.frequency") + ": " + (Object)((Object)EnumColor.GREY) + freq.name);
                list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("gui.mode") + ": " + (Object)((Object)EnumColor.GREY) + LangUtils.localize("gui." + (!freq.publicFreq ? "private" : "public")));
            }
            list.add(LangUtils.localize("tooltip.hold") + " " + (Object)((Object)EnumColor.INDIGO) + GameSettings.func_74298_c((int)MekanismKeyHandler.sneakKey.func_151463_i()) + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("tooltip.forDetails") + ".");
            list.add(LangUtils.localize("tooltip.hold") + " " + (Object)((Object)EnumColor.AQUA) + GameSettings.func_74298_c((int)MekanismKeyHandler.sneakKey.func_151463_i()) + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("tooltip.and") + " " + (Object)((Object)EnumColor.AQUA) + GameSettings.func_74298_c((int)MekanismKeyHandler.modeSwitchKey.func_151463_i()) + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("tooltip.forDesc") + ".");
        } else if (!MekKeyHandler.getIsKeyPressed(MekanismKeyHandler.modeSwitchKey)) {
            FluidStack fluidStack;
            IFactory.RecipeType recipeType;
            if (this.hasSecurity(itemstack)) {
                list.add(SecurityUtils.getOwnerDisplay((EntityPlayer)Minecraft.func_71410_x().field_71439_g, MekanismClient.clientUUIDMap.get(this.getOwnerUUID(itemstack))));
                list.add((Object)((Object)EnumColor.GREY) + LangUtils.localize("gui.security") + ": " + SecurityUtils.getSecurityDisplay(itemstack, Side.CLIENT));
                if (SecurityUtils.isOverridden(itemstack, Side.CLIENT)) {
                    list.add((Object)((Object)EnumColor.RED) + "(" + LangUtils.localize("gui.overridden") + ")");
                }
            }
            if ((type == BlockStateMachine.MachineType.BASIC_FACTORY || type == BlockStateMachine.MachineType.ADVANCED_FACTORY || type == BlockStateMachine.MachineType.ELITE_FACTORY) && (recipeType = this.getRecipeTypeOrNull(itemstack)) != null) {
                list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.recipeType") + ": " + (Object)((Object)EnumColor.GREY) + recipeType.getLocalizedName());
            }
            if (type == BlockStateMachine.MachineType.FLUID_TANK) {
                list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localizeWithFormat("mekanism.tooltip.portableTank.bucketMode", LangUtils.transYesNo(this.getBucketMode(itemstack))));
            }
            if (type.isElectric) {
                list.add((Object)((Object)EnumColor.BRIGHT_GREEN) + LangUtils.localize("tooltip.storedEnergy") + ": " + (Object)((Object)EnumColor.GREY) + MekanismUtils.getEnergyDisplay(this.getEnergy(itemstack), this.getMaxEnergy(itemstack)));
            }
            if (this.hasTank(itemstack) && type != BlockStateMachine.MachineType.FLUID_TANK && (fluidStack = this.getFluidStack(itemstack)) != null) {
                list.add((Object)((Object)EnumColor.PINK) + LangUtils.localizeFluidStack(fluidStack) + ": " + (Object)((Object)EnumColor.GREY) + this.getFluidStack((Object[])new Object[]{itemstack}).amount + "mB");
            }
            if (type != BlockStateMachine.MachineType.CHARGEPAD && type != BlockStateMachine.MachineType.LOGISTICAL_SORTER) {
                list.add((Object)((Object)EnumColor.AQUA) + LangUtils.localize("tooltip.inventory") + ": " + (Object)((Object)EnumColor.GREY) + LangUtils.transYesNo(this.getInventory(itemstack) != null && this.getInventory(itemstack).func_74745_c() != 0));
            }
            if (type.supportsUpgrades && ItemDataUtils.hasData(itemstack, "upgrades")) {
                Map<Upgrade, Integer> upgrades = Upgrade.buildMap(ItemDataUtils.getDataMap(itemstack));
                for (Map.Entry<Upgrade, Integer> entry : upgrades.entrySet()) {
                    list.add((Object)((Object)entry.getKey().getColor()) + "- " + entry.getKey().getName() + (entry.getKey().canMultiply() ? ": " + (Object)((Object)EnumColor.GREY) + "x" + entry.getValue() : ""));
                }
            }
        } else {
            list.addAll(MekanismUtils.splitTooltip(type.getDescription(), itemstack));
        }
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        BlockStateMachine.MachineType type = BlockStateMachine.MachineType.get(stack);
        if (type == BlockStateMachine.MachineType.FLUID_TANK && this.getBucketMode(stack)) {
            return EnumActionResult.PASS;
        }
        return super.func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
    }

    public boolean placeBlockAt(@Nonnull ItemStack stack, @Nonnull EntityPlayer player, World world, @Nonnull BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull IBlockState state) {
        BlockPos abovePos;
        boolean place = true;
        BlockStateMachine.MachineType type = BlockStateMachine.MachineType.get(stack);
        if (type == BlockStateMachine.MachineType.DIGITAL_MINER) {
            BlockPos.MutableBlockPos testPos = new BlockPos.MutableBlockPos();
            for (int xPos = -1; xPos <= 1; ++xPos) {
                for (int yPos = 0; yPos <= 1; ++yPos) {
                    for (int zPos = -1; zPos <= 1; ++zPos) {
                        testPos.func_181079_c(pos.func_177958_n() + xPos, pos.func_177956_o() + yPos, pos.func_177952_p() + zPos);
                        Block b = world.func_180495_p((BlockPos)testPos).func_177230_c();
                        if (world.func_175701_a((BlockPos)testPos) && world.func_175668_a((BlockPos)testPos, false) && b.func_176200_f((IBlockAccess)world, (BlockPos)testPos)) continue;
                        place = false;
                    }
                }
            }
        } else if (!(type != BlockStateMachine.MachineType.SOLAR_NEUTRON_ACTIVATOR && type != BlockStateMachine.MachineType.SEISMIC_VIBRATOR || world.func_175701_a(abovePos = pos.func_177984_a()) && world.func_180495_p(abovePos).func_177230_c().func_176200_f((IBlockAccess)world, abovePos))) {
            place = false;
        }
        if (place && super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, state)) {
            Frequency.Identity freq;
            TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_175625_s(pos);
            if (tileEntity instanceof TileEntityFluidTank) {
                TileEntityFluidTank tile = (TileEntityFluidTank)tileEntity;
                tile.tier = FluidTankTier.values()[this.getBaseTier(stack).ordinal()];
                tile.fluidTank.setCapacity(tile.tier.getStorage());
            }
            if (tileEntity instanceof ISecurityTile) {
                ISecurityTile security = (ISecurityTile)((Object)tileEntity);
                security.getSecurity().setOwnerUUID(this.getOwnerUUID(stack));
                if (this.hasSecurity(stack)) {
                    security.getSecurity().setMode(this.getSecurity(stack));
                }
                if (this.getOwnerUUID(stack) == null) {
                    security.getSecurity().setOwnerUUID(player.func_110124_au());
                }
            }
            if (tileEntity instanceof IUpgradeTile && ItemDataUtils.hasData(stack, "upgrades")) {
                ((IUpgradeTile)((Object)tileEntity)).getComponent().read(ItemDataUtils.getDataMap(stack));
            }
            if (tileEntity instanceof ISideConfiguration) {
                ISideConfiguration config = (ISideConfiguration)((Object)tileEntity);
                if (ItemDataUtils.hasData(stack, "sideDataStored")) {
                    config.getConfig().read(ItemDataUtils.getDataMap(stack));
                    config.getEjector().read(ItemDataUtils.getDataMap(stack));
                }
            }
            if (tileEntity instanceof ISustainedData && stack.func_77978_p() != null) {
                ((ISustainedData)((Object)tileEntity)).readSustainedData(stack);
            }
            if (tileEntity instanceof IRedstoneControl && ItemDataUtils.hasData(stack, "controlType")) {
                ((IRedstoneControl)((Object)tileEntity)).setControlType(IRedstoneControl.RedstoneControl.values()[ItemDataUtils.getInt(stack, "controlType")]);
            }
            if (tileEntity instanceof TileEntityFactory) {
                TileEntityFactory factory = (TileEntityFactory)tileEntity;
                IFactory.RecipeType recipeType = this.getRecipeTypeOrNull(stack);
                if (recipeType != null) {
                    factory.setRecipeType(recipeType);
                }
                world.func_175685_c(pos, tileEntity.func_145838_q(), true);
                Mekanism.packetHandler.sendUpdatePacket(tileEntity);
            }
            if (tileEntity instanceof ISustainedTank && this.hasTank(stack) && this.getFluidStack(stack) != null) {
                ((ISustainedTank)((Object)tileEntity)).setFluidStack(this.getFluidStack(stack), new Object[0]);
            }
            if (tileEntity instanceof ISustainedInventory) {
                ((ISustainedInventory)((Object)tileEntity)).setInventory(this.getInventory(stack), new Object[0]);
            }
            if (tileEntity instanceof TileEntityElectricBlock) {
                ((TileEntityElectricBlock)tileEntity).electricityStored = this.getEnergy(stack);
            }
            if (!world.field_72995_K && tileEntity instanceof TileEntityQuantumEntangloporter && ItemDataUtils.hasData(stack, "entangleporter_frequency") && (freq = Frequency.Identity.load(ItemDataUtils.getCompound(stack, "entangleporter_frequency"))) != null) {
                ((TileEntityQuantumEntangloporter)tileEntity).setFrequency(freq.name, freq.publicFreq);
            }
            return true;
        }
        return false;
    }

    public boolean tryPlaceContainedLiquid(World world, ItemStack itemstack, BlockPos pos) {
        boolean flag;
        if (this.getFluidStack(itemstack) == null || !this.getFluidStack(itemstack).getFluid().canBePlacedInWorld()) {
            return false;
        }
        Material material = world.func_180495_p(pos).func_185904_a();
        boolean bl = flag = !material.func_76220_a();
        if (!world.func_175623_d(pos) && !flag) {
            return false;
        }
        if (world.field_73011_w.func_177500_n() && this.getFluidStack(itemstack).getFluid() == FluidRegistry.WATER) {
            world.func_184148_a(null, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n() + Math.random(), (double)pos.func_177956_o() + Math.random(), (double)pos.func_177952_p() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            if (!world.field_72995_K && flag && !material.func_76224_d()) {
                world.func_175655_b(pos, true);
            }
            world.func_180501_a(pos, MekanismUtils.getFlowingBlock(this.getFluidStack(itemstack).getFluid()).func_176223_P(), 3);
        }
        return true;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entityplayer, @Nonnull EnumHand hand) {
        ItemStack itemstack = entityplayer.func_184586_b(hand);
        BlockStateMachine.MachineType type = BlockStateMachine.MachineType.get(itemstack);
        if (BlockStateMachine.MachineType.get(itemstack) == BlockStateMachine.MachineType.PERSONAL_CHEST) {
            if (!world.field_72995_K) {
                if (this.getOwnerUUID(itemstack) == null) {
                    this.setOwnerUUID(itemstack, entityplayer.func_110124_au());
                }
                if (SecurityUtils.canAccess(entityplayer, itemstack)) {
                    MekanismUtils.openItemGui(entityplayer, hand, 19);
                } else {
                    SecurityUtils.displayNoAccess(entityplayer);
                }
            }
        } else if (type == BlockStateMachine.MachineType.FLUID_TANK && this.getBucketMode(itemstack)) {
            if (SecurityUtils.canAccess(entityplayer, itemstack)) {
                RayTraceResult pos = this.func_77621_a(world, entityplayer, !entityplayer.func_70093_af());
                if (pos != null && pos.field_72313_a == RayTraceResult.Type.BLOCK) {
                    Coord4D coord = new Coord4D(pos.func_178782_a(), world);
                    if (!world.field_73011_w.canMineBlock(entityplayer, coord.getPos())) {
                        return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
                    }
                    if (!entityplayer.func_70093_af()) {
                        if (!entityplayer.func_175151_a(coord.getPos(), pos.field_178784_b, itemstack)) {
                            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
                        }
                        FluidStack fluid = MekanismUtils.getFluid(world, coord, false);
                        if (fluid != null && (this.getFluidStack(itemstack) == null || this.getFluidStack(itemstack).isFluidEqual(fluid))) {
                            int needed = this.getCapacity(itemstack) - (this.getFluidStack(itemstack) != null ? this.getFluidStack((Object[])new Object[]{itemstack}).amount : 0);
                            if (fluid.amount > needed) {
                                return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
                            }
                            if (this.getFluidStack(itemstack) == null) {
                                this.setFluidStack(fluid, itemstack);
                            } else {
                                FluidStack newStack = this.getFluidStack(itemstack);
                                newStack.amount += fluid.amount;
                                this.setFluidStack(newStack, itemstack);
                            }
                            world.func_175698_g(coord.getPos());
                        }
                    } else {
                        FluidStack stored = this.getFluidStack(itemstack);
                        if (stored == null || stored.amount < 1000) {
                            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
                        }
                        Coord4D trans = coord.offset(pos.field_178784_b);
                        if (!entityplayer.func_175151_a(trans.getPos(), pos.field_178784_b, itemstack)) {
                            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
                        }
                        if (this.tryPlaceContainedLiquid(world, itemstack, trans.getPos()) && !entityplayer.field_71075_bZ.field_75098_d) {
                            FluidStack newStack = stored.copy();
                            newStack.amount -= 1000;
                            this.setFluidStack((FluidStack)(newStack.amount > 0 ? newStack : null), itemstack);
                        }
                    }
                }
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
            }
            SecurityUtils.displayNoAccess(entityplayer);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
    }

    @Override
    public int getRecipeType(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            return 0;
        }
        return itemStack.func_77978_p().func_74762_e("recipeType");
    }

    @Override
    @Nullable
    public IFactory.RecipeType getRecipeTypeOrNull(ItemStack itemStack) {
        int recipeType = this.getRecipeType(itemStack);
        if (recipeType < IFactory.RecipeType.values().length) {
            return IFactory.RecipeType.values()[recipeType];
        }
        return null;
    }

    @Override
    public void setRecipeType(int type, ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74768_a("recipeType", type);
    }

    @Override
    public void setInventory(NBTTagList nbtTags, Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemDataUtils.setList((ItemStack)data[0], "Items", nbtTags);
        }
    }

    @Override
    public NBTTagList getInventory(Object ... data) {
        if (data[0] instanceof ItemStack) {
            return ItemDataUtils.getList((ItemStack)data[0], "Items");
        }
        return null;
    }

    @Override
    public void setFluidStack(FluidStack fluidStack, Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (fluidStack == null || fluidStack.amount == 0) {
                ItemDataUtils.removeData(itemStack, "fluidTank");
            } else {
                ItemDataUtils.setCompound(itemStack, "fluidTank", fluidStack.writeToNBT(new NBTTagCompound()));
            }
        }
    }

    @Override
    public FluidStack getFluidStack(Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (!ItemDataUtils.hasData(itemStack, "fluidTank")) {
                return null;
            }
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)ItemDataUtils.getCompound(itemStack, "fluidTank"));
        }
        return null;
    }

    @Override
    public boolean hasTank(Object ... data) {
        if (!(data[0] instanceof ItemStack) || !(((ItemStack)data[0]).func_77973_b() instanceof ISustainedTank)) {
            return false;
        }
        BlockStateMachine.MachineType type = BlockStateMachine.MachineType.get((ItemStack)data[0]);
        return type == BlockStateMachine.MachineType.ELECTRIC_PUMP || type == BlockStateMachine.MachineType.FLUID_TANK || type == BlockStateMachine.MachineType.FLUIDIC_PLENISHER;
    }

    public void setBucketMode(ItemStack itemStack, boolean bucketMode) {
        ItemDataUtils.setBoolean(itemStack, "bucketMode", bucketMode);
    }

    public boolean getBucketMode(ItemStack itemStack) {
        return ItemDataUtils.getBoolean(itemStack, "bucketMode");
    }

    @Override
    public double getEnergy(ItemStack itemStack) {
        if (!BlockStateMachine.MachineType.get((ItemStack)itemStack).isElectric) {
            return 0.0;
        }
        return ItemDataUtils.getDouble(itemStack, "energyStored");
    }

    @Override
    public void setEnergy(ItemStack itemStack, double amount) {
        if (!BlockStateMachine.MachineType.get((ItemStack)itemStack).isElectric) {
            return;
        }
        ItemDataUtils.setDouble(itemStack, "energyStored", Math.max(Math.min(amount, this.getMaxEnergy(itemStack)), 0.0));
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        BlockStateMachine.MachineType machineType = BlockStateMachine.MachineType.get(Block.func_149634_a((Item)itemStack.func_77973_b()), itemStack.func_77952_i());
        if (machineType.isFactory()) {
            IFactory.RecipeType recipeType = this.getRecipeTypeOrNull(itemStack);
            int tierProcess = machineType.factoryTier.processes;
            double baseMaxEnergy = (double)tierProcess * (recipeType == null ? 1.0 : Math.max(0.5 * recipeType.getEnergyStorage(), recipeType.getEnergyUsage()));
            return MekanismUtils.getMaxEnergy(itemStack, baseMaxEnergy);
        }
        return MekanismUtils.getMaxEnergy(itemStack, machineType.getStorage());
    }

    @Override
    public double getMaxTransfer(ItemStack itemStack) {
        return this.getMaxEnergy(itemStack) * 0.005;
    }

    @Override
    public boolean canReceive(ItemStack itemStack) {
        return BlockStateMachine.MachineType.get((ItemStack)itemStack).isElectric;
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return false;
    }

    @Optional.Method(modid="redstoneflux")
    public int receiveEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (this.canReceive(theItem)) {
            double energyNeeded = this.getMaxEnergy(theItem) - this.getEnergy(theItem);
            double toReceive = Math.min(RFIntegration.fromRF(energy), energyNeeded);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) + toReceive);
            }
            return RFIntegration.toRF(toReceive);
        }
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public int extractEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (this.canSend(theItem)) {
            double energyRemaining = this.getEnergy(theItem);
            double toSend = Math.min(RFIntegration.fromRF(energy), energyRemaining);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) - toSend);
            }
            return RFIntegration.toRF(toSend);
        }
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public int getEnergyStored(ItemStack theItem) {
        return RFIntegration.toRF(this.getEnergy(theItem));
    }

    @Optional.Method(modid="redstoneflux")
    public int getMaxEnergyStored(ItemStack theItem) {
        return RFIntegration.toRF(this.getMaxEnergy(theItem));
    }

    @Optional.Method(modid="ic2")
    public IElectricItemManager getManager(ItemStack itemStack) {
        return IC2ItemManager.getManager(this);
    }

    @Override
    public FluidStack getFluid(ItemStack container) {
        return this.getFluidStack(container);
    }

    @Override
    public int getCapacity(ItemStack container) {
        return FluidTankTier.values()[this.getBaseTier(container).ordinal()].getStorage();
    }

    @Override
    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (BlockStateMachine.MachineType.get(container) == BlockStateMachine.MachineType.FLUID_TANK && resource != null) {
            if (this.getBaseTier(container) == BaseTier.CREATIVE) {
                this.setFluidStack(PipeUtils.copy(resource, Integer.MAX_VALUE), container);
                return resource.amount;
            }
            FluidStack stored = this.getFluidStack(container);
            if (stored != null && stored.getFluid() != resource.getFluid()) {
                return 0;
            }
            int toFill = stored == null ? Math.min(resource.amount, this.getCapacity(container)) : Math.min(resource.amount, this.getCapacity(container) - stored.amount);
            if (doFill) {
                int fillAmount = toFill + (stored == null ? 0 : stored.amount);
                this.setFluidStack(PipeUtils.copy(resource, fillAmount), container);
            }
            return toFill;
        }
        return 0;
    }

    @Override
    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        FluidStack stored;
        if (BlockStateMachine.MachineType.get(container) == BlockStateMachine.MachineType.FLUID_TANK && (stored = this.getFluidStack(container)) != null) {
            FluidStack toDrain = PipeUtils.copy(stored, Math.min(stored.amount, maxDrain));
            if (doDrain && this.getBaseTier(container) != BaseTier.CREATIVE) {
                stored.amount -= toDrain.amount;
                this.setFluidStack((FluidStack)(stored.amount > 0 ? stored : null), container);
            }
            return toDrain;
        }
        return null;
    }

    @Override
    public BaseTier getBaseTier(ItemStack itemstack) {
        if (!itemstack.func_77942_o()) {
            return BaseTier.BASIC;
        }
        return BaseTier.values()[itemstack.func_77978_p().func_74762_e("tier")];
    }

    @Override
    public void setBaseTier(ItemStack itemstack, BaseTier tier) {
        if (!itemstack.func_77942_o()) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        itemstack.func_77978_p().func_74768_a("tier", tier.ordinal());
    }

    @Override
    public UUID getOwnerUUID(ItemStack stack) {
        if (ItemDataUtils.hasData(stack, "ownerUUID")) {
            return UUID.fromString(ItemDataUtils.getString(stack, "ownerUUID"));
        }
        return null;
    }

    @Override
    public void setOwnerUUID(ItemStack stack, UUID owner) {
        if (owner == null) {
            ItemDataUtils.removeData(stack, "ownerUUID");
            return;
        }
        ItemDataUtils.setString(stack, "ownerUUID", owner.toString());
    }

    @Override
    public ISecurityTile.SecurityMode getSecurity(ItemStack stack) {
        if (!MekanismConfig.current().general.allowProtection.val()) {
            return ISecurityTile.SecurityMode.PUBLIC;
        }
        return ISecurityTile.SecurityMode.values()[ItemDataUtils.getInt(stack, "security")];
    }

    @Override
    public void setSecurity(ItemStack stack, ISecurityTile.SecurityMode mode) {
        ItemDataUtils.setInt(stack, "security", mode.ordinal());
    }

    @Override
    public boolean hasSecurity(ItemStack stack) {
        BlockStateMachine.MachineType type = BlockStateMachine.MachineType.get(stack);
        return type != BlockStateMachine.MachineType.LASER && type != BlockStateMachine.MachineType.CHARGEPAD && type != BlockStateMachine.MachineType.TELEPORTER && type != BlockStateMachine.MachineType.QUANTUM_ENTANGLOPORTER;
    }

    @Override
    public boolean hasOwner(ItemStack stack) {
        return this.hasSecurity(stack);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new ItemCapabilityWrapper(stack, new ItemCapabilityWrapper.ItemCapability[]{new TeslaItemWrapper(), new ForgeEnergyItemWrapper(), new FluidItemWrapper()}){

            @Override
            public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
                if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
                    return BlockStateMachine.MachineType.get(this.itemStack) == BlockStateMachine.MachineType.FLUID_TANK;
                }
                return super.hasCapability(capability, facing);
            }
        };
    }

    @Override
    public void handlePacketData(ItemStack stack, ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer() && BlockStateMachine.MachineType.get(stack) == BlockStateMachine.MachineType.FLUID_TANK) {
            boolean state = dataStream.readBoolean();
            this.setBucketMode(stack, state);
        }
    }
}

