/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import mcmultipart.api.multipart.IMultipart;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.IConfigurable;
import mekanism.api.TileNetworkList;
import mekanism.api.transmitters.IBlockableConnection;
import mekanism.api.transmitters.ITransmitter;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.base.ITileNetwork;
import mekanism.common.block.BlockTransmitter;
import mekanism.common.block.property.PropertyConnection;
import mekanism.common.block.states.BlockStateTransmitter;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.integration.multipart.MultipartMekanism;
import mekanism.common.integration.multipart.MultipartTileNetworkJoiner;
import mekanism.common.tier.BaseTier;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MultipartUtils;
import mekanism.common.util.TextComponentGroup;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.lang3.tuple.Pair;

public abstract class TileEntitySidedPipe
extends TileEntity
implements ITileNetwork,
IBlockableConnection,
IConfigurable,
ITransmitter,
ITickable {
    public int delayTicks;
    public byte currentAcceptorConnections = 0;
    public byte currentTransmitterConnections = 0;
    public boolean sendDesc = false;
    private boolean redstonePowered = false;
    private boolean redstoneReactive = false;
    public boolean forceUpdate = true;
    private boolean redstoneSet = false;
    public ConnectionType[] connectionTypes = new ConnectionType[]{ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL, ConnectionType.NORMAL};
    public TileEntity[] cachedAcceptors = new TileEntity[6];

    public static boolean connectionMapContainsSide(byte connections, EnumFacing side) {
        byte tester = (byte)(1 << side.ordinal());
        return (connections & tester) > 0;
    }

    public static byte setConnectionBit(byte connections, boolean toSet, EnumFacing side) {
        return (byte)(connections & ~((byte)(1 << side.ordinal())) | (byte)((toSet ? 1 : 0) << side.ordinal()));
    }

    public static ConnectionType getConnectionType(EnumFacing side, byte allConnections, byte transmitterConnections, ConnectionType[] types) {
        if (!TileEntitySidedPipe.connectionMapContainsSide(allConnections, side)) {
            return ConnectionType.NONE;
        }
        if (TileEntitySidedPipe.connectionMapContainsSide(transmitterConnections, side)) {
            return ConnectionType.NORMAL;
        }
        return types[side.ordinal()];
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            if (this.delayTicks == 5) {
                this.delayTicks = 6;
                this.refreshConnections();
            } else if (this.delayTicks < 5) {
                ++this.delayTicks;
            }
        } else {
            if (this.forceUpdate) {
                this.refreshConnections();
                this.forceUpdate = false;
            }
            if (this.sendDesc) {
                Mekanism.packetHandler.sendUpdatePacket(this);
                this.sendDesc = false;
            }
        }
    }

    public BaseTier getBaseTier() {
        return BaseTier.BASIC;
    }

    public void setBaseTier(BaseTier baseTier) {
    }

    public boolean handlesRedstone() {
        return true;
    }

    public boolean renderCenter() {
        return false;
    }

    public byte getPossibleTransmitterConnections() {
        byte connections = 0;
        if (this.handlesRedstone() && this.redstoneReactive && this.redstonePowered) {
            return connections;
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            TileEntity tileEntity;
            if (!this.canConnectMutual(side) || !CapabilityUtils.hasCapability((ICapabilityProvider)(tileEntity = MekanismUtils.getTileEntity(this.field_145850_b, this.func_174877_v().func_177972_a(side))), Capabilities.GRID_TRANSMITTER_CAPABILITY, side.func_176734_d()) || !TransmissionType.checkTransmissionType(CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.GRID_TRANSMITTER_CAPABILITY, side.func_176734_d()), this.getTransmitterType().getTransmission()) || !this.isValidTransmitter(tileEntity)) continue;
            connections = (byte)(connections | 1 << side.ordinal());
        }
        return connections;
    }

    public boolean getPossibleAcceptorConnection(EnumFacing side) {
        TileEntity tileEntity;
        if (this.handlesRedstone() && this.redstoneReactive && this.redstonePowered) {
            return false;
        }
        if (this.canConnectMutual(side) && this.isValidAcceptor(tileEntity = MekanismUtils.getTileEntity(this.field_145850_b, this.func_174877_v().func_177972_a(side)), side)) {
            if (this.cachedAcceptors[side.ordinal()] != tileEntity) {
                this.cachedAcceptors[side.ordinal()] = tileEntity;
                this.markDirtyAcceptor(side);
            }
            return true;
        }
        if (this.cachedAcceptors[side.ordinal()] != null) {
            this.cachedAcceptors[side.ordinal()] = null;
            this.markDirtyAcceptor(side);
        }
        return false;
    }

    public boolean getPossibleTransmitterConnection(EnumFacing side) {
        if (this.handlesRedstone() && this.redstoneReactive && this.redstonePowered) {
            return false;
        }
        if (this.canConnectMutual(side)) {
            TileEntity tileEntity = MekanismUtils.getTileEntity(this.field_145850_b, this.func_174877_v().func_177972_a(side));
            return CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, Capabilities.GRID_TRANSMITTER_CAPABILITY, side.func_176734_d()) && TransmissionType.checkTransmissionType(CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.GRID_TRANSMITTER_CAPABILITY, side.func_176734_d()), this.getTransmitterType().getTransmission()) && this.isValidTransmitter(tileEntity);
        }
        return false;
    }

    public byte getPossibleAcceptorConnections() {
        byte connections = 0;
        if (this.handlesRedstone() && this.redstoneReactive && this.redstonePowered) {
            return connections;
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (this.canConnectMutual(side)) {
                Coord4D coord = new Coord4D(this.func_174877_v(), this.func_145831_w()).offset(side);
                if (!this.func_145831_w().field_72995_K && !coord.exists(this.func_145831_w())) {
                    this.forceUpdate = true;
                    continue;
                }
                TileEntity tileEntity = coord.getTileEntity((IBlockAccess)this.func_145831_w());
                if (this.isValidAcceptor(tileEntity, side)) {
                    if (this.cachedAcceptors[side.ordinal()] != tileEntity) {
                        this.cachedAcceptors[side.ordinal()] = tileEntity;
                        this.markDirtyAcceptor(side);
                    }
                    connections = (byte)(connections | 1 << side.ordinal());
                    continue;
                }
            }
            if (this.cachedAcceptors[side.ordinal()] == null) continue;
            this.cachedAcceptors[side.ordinal()] = null;
            this.markDirtyAcceptor(side);
        }
        return connections;
    }

    public byte getAllCurrentConnections() {
        return (byte)(this.currentTransmitterConnections | this.currentAcceptorConnections);
    }

    public boolean isValidTransmitter(TileEntity tileEntity) {
        return true;
    }

    public List<AxisAlignedBB> getCollisionBoxes() {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            int ord = side.ordinal();
            byte connections = this.getAllCurrentConnections();
            if (!TileEntitySidedPipe.connectionMapContainsSide(connections, side)) continue;
            list.add(this.getTransmitterType().getSize() == BlockStateTransmitter.TransmitterType.Size.SMALL ? BlockTransmitter.smallSides[ord] : BlockTransmitter.largeSides[ord]);
        }
        list.add(this.getTransmitterType().getSize() == BlockStateTransmitter.TransmitterType.Size.SMALL ? BlockTransmitter.smallSides[6] : BlockTransmitter.largeSides[6]);
        return list;
    }

    public abstract BlockStateTransmitter.TransmitterType getTransmitterType();

    public List<AxisAlignedBB> getCollisionBoxes(AxisAlignedBB entityBox) {
        AxisAlignedBB box;
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            AxisAlignedBB box2;
            int ord = side.ordinal();
            byte connections = this.getAllCurrentConnections();
            if (!TileEntitySidedPipe.connectionMapContainsSide(connections, side)) continue;
            AxisAlignedBB axisAlignedBB = box2 = this.getTransmitterType().getSize() == BlockStateTransmitter.TransmitterType.Size.SMALL ? BlockTransmitter.smallSides[ord] : BlockTransmitter.largeSides[ord];
            if (!box2.func_72326_a(entityBox)) continue;
            list.add(box2);
        }
        AxisAlignedBB axisAlignedBB = box = this.getTransmitterType().getSize() == BlockStateTransmitter.TransmitterType.Size.SMALL ? BlockTransmitter.smallSides[6] : BlockTransmitter.largeSides[6];
        if (box.func_72326_a(entityBox)) {
            list.add(box);
        }
        return list;
    }

    public abstract boolean isValidAcceptor(TileEntity var1, EnumFacing var2);

    @Override
    public boolean canConnectMutual(EnumFacing side) {
        if (!this.canConnect(side)) {
            return false;
        }
        BlockPos testPos = this.func_174877_v().func_177972_a(side);
        TileEntity tile = MekanismUtils.getTileEntity(this.field_145850_b, testPos);
        if (!CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.BLOCKABLE_CONNECTION_CAPABILITY, side.func_176734_d())) {
            return true;
        }
        return CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.BLOCKABLE_CONNECTION_CAPABILITY, side.func_176734_d()).canConnect(side.func_176734_d());
    }

    @Override
    public boolean canConnect(EnumFacing side) {
        if (this.connectionTypes[side.ordinal()] == ConnectionType.NONE) {
            return false;
        }
        if (this.handlesRedstone()) {
            if (!this.redstoneSet) {
                this.redstonePowered = this.redstoneReactive ? MekanismUtils.isGettingPowered(this.func_145831_w(), new Coord4D(this.func_174877_v(), this.func_145831_w())) : false;
                this.redstoneSet = true;
            }
            if (this.redstoneReactive && this.redstonePowered) {
                return false;
            }
        }
        if (Mekanism.hooks.MCMPLoaded) {
            return MultipartMekanism.hasConnectionWith(this, side);
        }
        return true;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) throws Exception {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.currentTransmitterConnections = dataStream.readByte();
            this.currentAcceptorConnections = dataStream.readByte();
            for (int i = 0; i < 6; ++i) {
                this.connectionTypes[i] = ConnectionType.values()[dataStream.readInt()];
            }
            this.func_70296_d();
            MekanismUtils.updateBlock(this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        if (Mekanism.hooks.MCMPLoaded) {
            MultipartTileNetworkJoiner.addMultipartHeader(this, data, null);
        }
        data.add(this.currentTransmitterConnections);
        data.add(this.currentAcceptorConnections);
        for (int i = 0; i < 6; ++i) {
            data.add(this.connectionTypes[i].ordinal());
        }
        return data;
    }

    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.redstoneReactive = nbtTags.func_74767_n("redstoneReactive");
        for (int i = 0; i < 6; ++i) {
            this.connectionTypes[i] = ConnectionType.values()[nbtTags.func_74762_e("connection" + i)];
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74757_a("redstoneReactive", this.redstoneReactive);
        for (int i = 0; i < 6; ++i) {
            nbtTags.func_74768_a("connection" + i, this.connectionTypes[i].ordinal());
        }
        return nbtTags;
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbtTags = super.func_189517_E_();
        nbtTags.func_74768_a("tier", this.getBaseTier().ordinal());
        return nbtTags;
    }

    protected void onRefresh() {
    }

    public void refreshConnections() {
        if (this.handlesRedstone()) {
            boolean previouslyPowered = this.redstonePowered;
            this.redstonePowered = this.redstoneReactive ? MekanismUtils.isGettingPowered(this.func_145831_w(), new Coord4D(this.func_174877_v(), this.func_145831_w())) : false;
            if (previouslyPowered != this.redstonePowered) {
                this.markDirtyTransmitters();
            }
            this.redstoneSet = true;
        }
        if (!this.func_145831_w().field_72995_K) {
            byte possibleTransmitters = this.getPossibleTransmitterConnections();
            byte possibleAcceptors = this.getPossibleAcceptorConnections();
            byte newlyEnabledTransmitters = 0;
            if ((possibleTransmitters | possibleAcceptors) != this.getAllCurrentConnections()) {
                this.sendDesc = true;
                if (possibleTransmitters != this.currentTransmitterConnections) {
                    newlyEnabledTransmitters = (byte)(possibleTransmitters ^ this.currentTransmitterConnections);
                    newlyEnabledTransmitters = (byte)(newlyEnabledTransmitters & ~this.currentTransmitterConnections);
                }
            }
            this.currentTransmitterConnections = possibleTransmitters;
            this.currentAcceptorConnections = possibleAcceptors;
            if (newlyEnabledTransmitters != 0) {
                this.recheckConnections(newlyEnabledTransmitters);
            }
        }
    }

    public void refreshConnections(EnumFacing side) {
        if (!this.func_145831_w().field_72995_K) {
            boolean possibleTransmitter = this.getPossibleTransmitterConnection(side);
            boolean possibleAcceptor = this.getPossibleAcceptorConnection(side);
            boolean transmitterChanged = false;
            if ((possibleTransmitter || possibleAcceptor) != TileEntitySidedPipe.connectionMapContainsSide(this.getAllCurrentConnections(), side)) {
                this.sendDesc = true;
                if (possibleTransmitter != TileEntitySidedPipe.connectionMapContainsSide(this.currentTransmitterConnections, side)) {
                    transmitterChanged = possibleTransmitter;
                }
            }
            this.currentTransmitterConnections = TileEntitySidedPipe.setConnectionBit(this.currentTransmitterConnections, possibleTransmitter, side);
            this.currentAcceptorConnections = TileEntitySidedPipe.setConnectionBit(this.currentAcceptorConnections, possibleAcceptor, side);
            if (transmitterChanged) {
                this.recheckConnection(side);
            }
        }
    }

    protected void recheckConnections(byte newlyEnabledTransmitters) {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            TileEntity tileEntity;
            if (!TileEntitySidedPipe.connectionMapContainsSide(newlyEnabledTransmitters, side) || !((tileEntity = MekanismUtils.getTileEntity(this.field_145850_b, this.func_174877_v().func_177972_a(side))) instanceof TileEntitySidedPipe)) continue;
            ((TileEntitySidedPipe)tileEntity).refreshConnections();
        }
    }

    protected void recheckConnection(EnumFacing side) {
    }

    protected void onModeChange(EnumFacing side) {
        this.markDirtyAcceptor(side);
        if (this.getPossibleTransmitterConnections() != this.currentTransmitterConnections) {
            this.markDirtyTransmitters();
        }
        this.func_70296_d();
    }

    protected void markDirtyTransmitters() {
        this.notifyTileChange();
    }

    protected void markDirtyAcceptor(EnumFacing side) {
    }

    public abstract void onWorldJoin();

    public abstract void onWorldSeparate();

    public void func_145843_s() {
        this.onWorldSeparate();
        super.func_145843_s();
    }

    public void func_145829_t() {
        this.onWorldJoin();
        super.func_145829_t();
    }

    public void onChunkUnload() {
        this.onWorldSeparate();
        super.onChunkUnload();
    }

    public void onAdded() {
        this.onWorldJoin();
        this.refreshConnections();
    }

    public void onLoad() {
        this.onWorldJoin();
        if (this.getPossibleTransmitterConnections() != this.currentTransmitterConnections) {
            this.refreshConnections();
        }
        super.onLoad();
    }

    public void onNeighborTileChange(EnumFacing side) {
        this.refreshConnections(side);
    }

    public void onNeighborBlockChange(EnumFacing side) {
        this.refreshConnections();
    }

    public void onPartChanged(IMultipart part) {
        byte transmittersBefore = this.currentTransmitterConnections;
        this.refreshConnections();
        if (transmittersBefore != this.currentTransmitterConnections) {
            this.markDirtyTransmitters();
        }
    }

    public ConnectionType getConnectionType(EnumFacing side) {
        return TileEntitySidedPipe.getConnectionType(side, this.getAllCurrentConnections(), this.currentTransmitterConnections, this.connectionTypes);
    }

    public List<EnumFacing> getConnections(ConnectionType type) {
        ArrayList<EnumFacing> sides = new ArrayList<EnumFacing>();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (this.getConnectionType(side) != type) continue;
            sides.add(side);
        }
        return sides;
    }

    @Override
    public EnumActionResult onSneakRightClick(EntityPlayer player, EnumFacing side) {
        if (!this.func_145831_w().field_72995_K) {
            RayTraceResult hit = this.reTrace(this.func_145831_w(), this.func_174877_v(), player);
            if (hit == null) {
                return EnumActionResult.PASS;
            }
            EnumFacing hitSide = this.sideHit(hit.subHit + 1);
            if (hitSide == null) {
                if (this.connectionTypes[side.ordinal()] != ConnectionType.NONE && this.onConfigure(player, 6, side) == EnumActionResult.SUCCESS) {
                    return EnumActionResult.SUCCESS;
                }
                hitSide = side;
            }
            if (hitSide != null) {
                this.connectionTypes[hitSide.ordinal()] = this.connectionTypes[hitSide.ordinal()].next();
                this.sendDesc = true;
                this.onModeChange(EnumFacing.func_82600_a((int)hitSide.ordinal()));
                this.refreshConnections();
                this.notifyTileChange();
                player.func_145747_a((ITextComponent)new TextComponentGroup().translation("tooltip.configurator.modeChange").string(" ").translation(this.connectionTypes[hitSide.ordinal()].translationKey()));
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.PASS;
        }
        return EnumActionResult.SUCCESS;
    }

    private RayTraceResult reTrace(World world, BlockPos pos, EntityPlayer player) {
        Pair<Vec3d, Vec3d> vecs = MultipartUtils.getRayTraceVectors(player);
        MultipartUtils.AdvancedRayTraceResult result = MultipartUtils.collisionRayTrace(this.func_174877_v(), (Vec3d)vecs.getLeft(), (Vec3d)vecs.getRight(), this.getCollisionBoxes());
        return result == null ? null : result.hit;
    }

    protected EnumFacing sideHit(int boxIndex) {
        ArrayList<EnumFacing> list = new ArrayList<EnumFacing>();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            byte connections = this.getAllCurrentConnections();
            if (!TileEntitySidedPipe.connectionMapContainsSide(connections, side)) continue;
            list.add(side);
        }
        if (boxIndex < list.size()) {
            return (EnumFacing)list.get(boxIndex);
        }
        return null;
    }

    protected EnumActionResult onConfigure(EntityPlayer player, int part, EnumFacing side) {
        return EnumActionResult.PASS;
    }

    public EnumColor getRenderColor() {
        return null;
    }

    @Override
    public EnumActionResult onRightClick(EntityPlayer player, EnumFacing side) {
        if (!this.func_145831_w().field_72995_K && this.handlesRedstone()) {
            this.redstoneReactive ^= true;
            this.refreshConnections();
            this.notifyTileChange();
            player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " Redstone sensitivity turned " + (Object)((Object)EnumColor.INDIGO) + (this.redstoneReactive ? "on." : "off.")));
        }
        return EnumActionResult.SUCCESS;
    }

    public List<String> getVisibleGroups() {
        ArrayList<String> visible = new ArrayList<String>();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            visible.add(side.func_176610_l() + this.getConnectionType(side).func_176610_l().toUpperCase());
        }
        return visible;
    }

    public IBlockState getExtendedState(IBlockState state) {
        PropertyConnection connectionProp = new PropertyConnection(this.getAllCurrentConnections(), this.currentTransmitterConnections, this.connectionTypes, this.renderCenter());
        return ((IExtendedBlockState)state).withProperty((IUnlistedProperty)OBJModel.OBJProperty.INSTANCE, (Object)new OBJModel.OBJState(this.getVisibleGroups(), true)).withProperty((IUnlistedProperty)PropertyConnection.INSTANCE, (Object)connectionProp);
    }

    public void notifyTileChange() {
        MekanismUtils.notifyLoadedNeighborsOfTileChange(this.func_145831_w(), new Coord4D(this.func_174877_v(), this.func_145831_w()));
    }

    public boolean canRenderBreaking() {
        return false;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return capability == Capabilities.CONFIGURABLE_CAPABILITY || capability == Capabilities.TILE_NETWORK_CAPABILITY || capability == Capabilities.BLOCKABLE_CONNECTION_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == Capabilities.CONFIGURABLE_CAPABILITY || capability == Capabilities.TILE_NETWORK_CAPABILITY || capability == Capabilities.BLOCKABLE_CONNECTION_CAPABILITY) {
            return (T)this;
        }
        return (T)super.getCapability(capability, facing);
    }

    public static enum ConnectionType implements IStringSerializable
    {
        NORMAL,
        PUSH,
        PULL,
        NONE;


        public ConnectionType next() {
            if (this.ordinal() == ConnectionType.values().length - 1) {
                return NORMAL;
            }
            return ConnectionType.values()[this.ordinal() + 1];
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String translationKey() {
            return "mekanism.pipe.connectiontype." + this.func_176610_l();
        }
    }
}

