/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.item.ItemStack;
import vazkii.botania.api.item.IBaubleRender;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.helper.IconHelper;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;

public final class ContributorFancinessHandler
implements LayerRenderer<EntityPlayer> {
    public static final Map<String, ItemStack> flowerMap = new HashMap<String, ItemStack>();
    private static boolean startedLoading = false;

    public void doRenderLayer(@Nonnull EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (player.func_82150_aj()) {
            return;
        }
        String name = player.func_145748_c_().func_150260_c();
        float yaw = player.field_70758_at + (player.field_70759_as - player.field_70758_at) * partialTicks;
        float yawOffset = player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * partialTicks;
        float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * partialTicks;
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)yawOffset, (float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(yaw - 270.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)0.0f, (float)0.0f, (float)1.0f);
        if (name.equals("haighyorkie")) {
            ContributorFancinessHandler.renderGoldfish(player);
        }
        ContributorFancinessHandler.firstStart();
        name = name.toLowerCase();
        if (player.func_175148_a(EnumPlayerModelParts.CAPE) && flowerMap.containsKey(name)) {
            ContributorFancinessHandler.renderFlower(player, flowerMap.get(name));
        }
        GlStateManager.func_179121_F();
    }

    public boolean func_177142_b() {
        return false;
    }

    public static void firstStart() {
        if (!startedLoading) {
            new ThreadContributorListLoader();
            startedLoading = true;
        }
    }

    public static void load(Properties props) {
        flowerMap.clear();
        for (String key : props.stringPropertyNames()) {
            String value = props.getProperty(key);
            try {
                int i = Integer.parseInt(value);
                if (i < 0 || i >= 16) {
                    throw new NumberFormatException();
                }
                flowerMap.put(key, new ItemStack(ModBlocks.flower, 1, i));
            }
            catch (NumberFormatException e) {
                flowerMap.put(key, ItemBlockSpecialFlower.ofType(value));
            }
        }
    }

    private static void renderGoldfish(EntityPlayer player) {
        GlStateManager.func_179094_E();
        TextureAtlasSprite icon = MiscellaneousIcons.INSTANCE.goldfishIcon;
        float f = icon.func_94209_e();
        float f1 = icon.func_94212_f();
        float f2 = icon.func_94206_g();
        float f3 = icon.func_94210_h();
        IBaubleRender.Helper.rotateIfSneaking(player);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.4f, (float)0.4f, (float)0.4f);
        GlStateManager.func_179109_b((float)-0.5f, (float)1.6f, (float)0.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        IconHelper.renderIconIn3D(Tessellator.func_178181_a(), f1, f2, f, f3, icon.func_94211_a(), icon.func_94216_b(), 0.0625f);
        GlStateManager.func_179121_F();
    }

    private static void renderFlower(EntityPlayer player, ItemStack flower) {
        GlStateManager.func_179094_E();
        IBaubleRender.Helper.translateToHeadLevel(player);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)0.0, (double)-0.85, (double)0.0);
        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
        ShaderHelper.useShader(ShaderHelper.gold);
        Minecraft.func_71410_x().func_175599_af().func_184392_a(flower, (EntityLivingBase)player, ItemCameraTransforms.TransformType.NONE, false);
        ShaderHelper.releaseShader();
        GlStateManager.func_179121_F();
    }

    private static class ThreadContributorListLoader
    extends Thread {
        public ThreadContributorListLoader() {
            this.setName("Botania Contributor Fanciness Thread");
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            try {
                URL url = new URL("https://raw.githubusercontent.com/Vazkii/Botania/master/contributors.properties");
                Properties props = new Properties();
                try (InputStreamReader reader = new InputStreamReader(url.openStream());){
                    props.load(reader);
                    ContributorFancinessHandler.load(props);
                }
            }
            catch (IOException e) {
                Botania.LOGGER.info("Could not load contributors list. Either you're offline or github is down. Nothing to worry about, carry on~");
            }
        }
    }
}

