/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.ISequentialBreaker;
import vazkii.botania.api.item.IWireframeCoordinateListProvider;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.relic.ItemRelicBauble;

@Mod.EventBusSubscriber(modid="botania")
public class ItemLokiRing
extends ItemRelicBauble
implements IWireframeCoordinateListProvider,
IManaUsingItem {
    private static final String TAG_CURSOR_LIST = "cursorList";
    private static final String TAG_CURSOR_PREFIX = "cursor";
    private static final String TAG_CURSOR_COUNT = "cursorCount";
    private static final String TAG_X_OFFSET = "xOffset";
    private static final String TAG_Y_OFFSET = "yOffset";
    private static final String TAG_Z_OFFSET = "zOffset";
    private static final String TAG_X_ORIGIN = "xOrigin";
    private static final String TAG_Y_ORIGIN = "yOrigin";
    private static final String TAG_Z_ORIGIN = "zOrigin";

    public ItemLokiRing() {
        super("lokiRing");
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack lokiRing = ItemLokiRing.getLokiRing(player);
        if (lokiRing.func_190926_b() || !player.func_70093_af()) {
            return;
        }
        int slot = -1;
        IBaublesItemHandler inv = BaublesApi.getBaublesHandler((EntityPlayer)player);
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack != lokiRing) continue;
            slot = i;
            break;
        }
        ItemStack heldItemStack = event.getItemStack();
        BlockPos originCoords = ItemLokiRing.getOriginPos(lokiRing);
        RayTraceResult lookPos = ToolCommons.raytraceFromEntity(player.field_70170_p, (Entity)player, true, 10.0);
        List<BlockPos> cursors = ItemLokiRing.getCursorList(lokiRing);
        int cost = Math.min(cursors.size(), (int)Math.pow(Math.E, (double)cursors.size() * 0.25));
        if (lookPos == null || lookPos.func_178782_a() == null) {
            return;
        }
        if (heldItemStack.func_190926_b()) {
            block12: {
                if (!event.getWorld().field_72995_K) {
                    if (originCoords.func_177956_o() == -1) {
                        ItemLokiRing.setOriginPos(lokiRing, lookPos.func_178782_a());
                        ItemLokiRing.setCursorList(lokiRing, null);
                        BotaniaAPI.internalHandler.sendBaubleUpdatePacket(player, slot);
                    } else if (originCoords.equals((Object)lookPos.func_178782_a())) {
                        ItemLokiRing.setOriginPos(lokiRing, new BlockPos(0, -1, 0));
                        BotaniaAPI.internalHandler.sendBaubleUpdatePacket(player, slot);
                    } else {
                        BlockPos relPos = lookPos.func_178782_a().func_177971_a((Vec3i)new BlockPos(-originCoords.func_177958_n(), -originCoords.func_177956_o(), -originCoords.func_177952_p()));
                        for (BlockPos cursor : cursors) {
                            if (!cursor.equals((Object)relPos)) continue;
                            cursors.remove(cursor);
                            ItemLokiRing.setCursorList(lokiRing, cursors);
                            BotaniaAPI.internalHandler.sendBaubleUpdatePacket(player, slot);
                            break block12;
                        }
                        ItemLokiRing.addCursor(lokiRing, relPos);
                        BotaniaAPI.internalHandler.sendBaubleUpdatePacket(player, slot);
                    }
                }
            }
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
        } else {
            for (BlockPos cursor : cursors) {
                BlockPos pos = lookPos.func_178782_a().func_177971_a((Vec3i)cursor);
                Item item = heldItemStack.func_77973_b();
                if (!player.field_70170_p.func_175623_d(pos) || !ManaItemHandler.requestManaExact(lokiRing, player, cost, true)) continue;
                ItemStack saveHeld = heldItemStack.func_77946_l();
                item.func_180614_a(player, player.field_70170_p, pos, event.getHand(), lookPos.field_178784_b, (float)lookPos.field_72307_f.field_72450_a - (float)pos.func_177958_n(), (float)lookPos.field_72307_f.field_72448_b - (float)pos.func_177956_o(), (float)lookPos.field_72307_f.field_72449_c - (float)pos.func_177952_p());
                if (!player.func_184812_l_()) continue;
                player.func_184611_a(event.getHand(), saveHeld);
            }
        }
    }

    public static void breakOnAllCursors(EntityPlayer player, Item item, ItemStack stack, BlockPos pos, EnumFacing side) {
        ItemStack lokiRing = ItemLokiRing.getLokiRing(player);
        if (lokiRing.func_190926_b() || player.field_70170_p.field_72995_K || !(item instanceof ISequentialBreaker)) {
            return;
        }
        List<BlockPos> cursors = ItemLokiRing.getCursorList(lokiRing);
        ISequentialBreaker breaker = (ISequentialBreaker)item;
        boolean dispose = breaker.disposeOfTrashBlocks(stack);
        for (BlockPos offset : cursors) {
            BlockPos coords = pos.func_177971_a((Vec3i)offset);
            IBlockState state = player.field_70170_p.func_180495_p(coords);
            breaker.breakOtherBlock(player, stack, coords, pos, side);
            ToolCommons.removeBlockWithDrops(player, stack, player.field_70170_p, coords, s -> s.func_177230_c() == state.func_177230_c() && s.func_185904_a() == state.func_185904_a(), dispose);
        }
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return BaubleType.RING;
    }

    @Override
    public void onUnequipped(ItemStack stack, EntityLivingBase player) {
        ItemLokiRing.setCursorList(stack, null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<BlockPos> getWireframesToDraw(EntityPlayer player, ItemStack stack) {
        if (ItemLokiRing.getLokiRing(player) != stack) {
            return ImmutableList.of();
        }
        RayTraceResult lookPos = Minecraft.func_71410_x().field_71476_x;
        if (lookPos != null && lookPos.func_178782_a() != null && !player.field_70170_p.func_175623_d(lookPos.func_178782_a()) && lookPos.field_72308_g == null) {
            List<BlockPos> list = ItemLokiRing.getCursorList(stack);
            BlockPos origin = ItemLokiRing.getOriginPos(stack);
            for (int i = 0; i < list.size(); ++i) {
                if (origin.func_177956_o() != -1) {
                    list.set(i, list.get(i).func_177971_a((Vec3i)origin));
                    continue;
                }
                list.set(i, list.get(i).func_177971_a((Vec3i)lookPos.func_178782_a()));
            }
            return list;
        }
        return ImmutableList.of();
    }

    @Override
    public BlockPos getSourceWireframe(EntityPlayer player, ItemStack stack) {
        return ItemLokiRing.getLokiRing(player) == stack ? ItemLokiRing.getOriginPos(stack) : null;
    }

    private static ItemStack getLokiRing(EntityPlayer player) {
        IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
        int slot = BaublesApi.isBaubleEquipped((EntityPlayer)player, (Item)ModItems.lokiRing);
        if (slot < 0) {
            return ItemStack.field_190927_a;
        }
        return baubles.getStackInSlot(slot);
    }

    private static BlockPos getOriginPos(ItemStack stack) {
        int x = ItemNBTHelper.getInt(stack, TAG_X_ORIGIN, 0);
        int y = ItemNBTHelper.getInt(stack, TAG_Y_ORIGIN, -1);
        int z = ItemNBTHelper.getInt(stack, TAG_Z_ORIGIN, 0);
        return new BlockPos(x, y, z);
    }

    private static void setOriginPos(ItemStack stack, BlockPos pos) {
        ItemNBTHelper.setInt(stack, TAG_X_ORIGIN, pos.func_177958_n());
        ItemNBTHelper.setInt(stack, TAG_Y_ORIGIN, pos.func_177956_o());
        ItemNBTHelper.setInt(stack, TAG_Z_ORIGIN, pos.func_177952_p());
    }

    private static List<BlockPos> getCursorList(ItemStack stack) {
        NBTTagCompound cmp = ItemNBTHelper.getCompound(stack, TAG_CURSOR_LIST, false);
        ArrayList<BlockPos> cursors = new ArrayList<BlockPos>();
        int count = cmp.func_74762_e(TAG_CURSOR_COUNT);
        for (int i = 0; i < count; ++i) {
            NBTTagCompound cursorCmp = cmp.func_74775_l(TAG_CURSOR_PREFIX + i);
            int x = cursorCmp.func_74762_e(TAG_X_OFFSET);
            int y = cursorCmp.func_74762_e(TAG_Y_OFFSET);
            int z = cursorCmp.func_74762_e(TAG_Z_OFFSET);
            cursors.add(new BlockPos(x, y, z));
        }
        return cursors;
    }

    private static void setCursorList(ItemStack stack, List<BlockPos> cursors) {
        if (stack == null) {
            return;
        }
        NBTTagCompound cmp = new NBTTagCompound();
        if (cursors != null) {
            int i = 0;
            for (BlockPos cursor : cursors) {
                NBTTagCompound cursorCmp = ItemLokiRing.cursorToCmp(cursor);
                cmp.func_74782_a(TAG_CURSOR_PREFIX + i, (NBTBase)cursorCmp);
                ++i;
            }
            cmp.func_74768_a(TAG_CURSOR_COUNT, i);
        }
        ItemNBTHelper.setCompound(stack, TAG_CURSOR_LIST, cmp);
    }

    private static NBTTagCompound cursorToCmp(BlockPos pos) {
        NBTTagCompound cmp = new NBTTagCompound();
        cmp.func_74768_a(TAG_X_OFFSET, pos.func_177958_n());
        cmp.func_74768_a(TAG_Y_OFFSET, pos.func_177956_o());
        cmp.func_74768_a(TAG_Z_OFFSET, pos.func_177952_p());
        return cmp;
    }

    private static void addCursor(ItemStack stack, BlockPos pos) {
        NBTTagCompound cmp = ItemNBTHelper.getCompound(stack, TAG_CURSOR_LIST, false);
        int count = cmp.func_74762_e(TAG_CURSOR_COUNT);
        cmp.func_74782_a(TAG_CURSOR_PREFIX + count, (NBTBase)ItemLokiRing.cursorToCmp(pos));
        cmp.func_74768_a(TAG_CURSOR_COUNT, count + 1);
        ItemNBTHelper.setCompound(stack, TAG_CURSOR_LIST, cmp);
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    @Override
    public ResourceLocation getAdvancement() {
        return new ResourceLocation("botania", "challenge/loki_ring");
    }
}

