/*
 * Decompiled with CFR 0.152.
 */
package org.dave.bonsaitrees.base;

import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class BaseTile
extends TileEntity {
    protected String customName = "";
    protected UUID owner;

    public boolean retainNbtData() {
        return true;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.customName = compound.func_74779_i("CustomName");
        this.owner = compound.func_186857_a("owner");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("CustomName", this.customName);
        if (this.hasOwner()) {
            compound.func_186854_a("owner", this.owner);
        }
        return compound;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public String getOwnerName() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax().func_152652_a(this.getOwner()).getName();
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public void setOwner(EntityPlayer player) {
        if (player == null) {
            return;
        }
        this.setOwner(player.func_110124_au());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void dropTile() {
        BaseTile tile;
        BaseTile baseTile = tile = this.field_145850_b.func_175625_s(this.field_174879_c) instanceof BaseTile ? (BaseTile)this.field_145850_b.func_175625_s(this.field_174879_c) : null;
        if (tile != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
            if (this.retainNbtData()) {
                NBTTagCompound tileData = tile.func_189515_b(new NBTTagCompound());
                stack.func_77982_d(tileData);
            }
            EntityItem entityItem = new EntityItem(this.field_145850_b, (double)((float)this.func_174877_v().func_177958_n() + 0.5f), (double)this.func_174877_v().func_177956_o(), (double)((float)this.func_174877_v().func_177952_p() + 0.5f), stack);
            entityItem.lifespan = 600;
            entityItem.func_174867_a(5);
            entityItem.field_70159_w = 0.0;
            entityItem.field_70181_x = 0.1f;
            entityItem.field_70179_y = 0.0;
            this.field_145850_b.func_72838_d((Entity)entityItem);
        }
    }
}

