/*
 * Decompiled with CFR 0.152.
 */
package org.dave.bonsaitrees.command;

import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.dave.bonsaitrees.BonsaiTrees;
import org.dave.bonsaitrees.api.IBonsaiIntegration;
import org.dave.bonsaitrees.api.IBonsaiSoil;
import org.dave.bonsaitrees.api.IBonsaiTreeType;
import org.dave.bonsaitrees.base.CommandBaseExt;
import org.dave.bonsaitrees.integration.IntegrationRegistry;
import org.dave.bonsaitrees.utility.Logz;

public class CommandListIntegrations
extends CommandBaseExt {
    public String func_71517_b() {
        return "listIntegrations";
    }

    @Override
    public boolean isAllowed(EntityPlayer player, boolean creative, boolean isOp) {
        return creative || isOp;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        IBonsaiIntegration integration;
        HashMap<IBonsaiIntegration, Integer> countTypes = new HashMap<IBonsaiIntegration, Integer>();
        HashMap<IBonsaiIntegration, Integer> countSoils = new HashMap<IBonsaiIntegration, Integer>();
        for (IBonsaiIntegration integration2 : IntegrationRegistry.getIntegrations()) {
            countTypes.put(integration2, 0);
            countSoils.put(integration2, 0);
        }
        for (IBonsaiTreeType type : BonsaiTrees.instance.typeRegistry.getAllTypes()) {
            integration = BonsaiTrees.instance.typeRegistry.getIntegrationForType(type);
            if (!countTypes.containsKey(integration)) {
                Logz.warn("Registered tree for unregistered integration detected. Something is off!", new Object[0]);
                countTypes.put(integration, 0);
            }
            countTypes.put(integration, (Integer)countTypes.get(integration) + 1);
        }
        for (IBonsaiSoil soil : BonsaiTrees.instance.soilRegistry.getAllSoils()) {
            integration = BonsaiTrees.instance.soilRegistry.getIntegrationForSoil(soil);
            if (!countSoils.containsKey(integration)) {
                Logz.warn("Registered soil for unregistered integration detected. Something is off!", new Object[0]);
                countSoils.put(integration, 0);
            }
            countSoils.put(integration, (Integer)countSoils.get(integration) + 1);
        }
        HashSet integrationsToList = new HashSet();
        integrationsToList.addAll(countSoils.keySet());
        integrationsToList.addAll(countTypes.keySet());
        int totalTrees = 0;
        int totalSoils = 0;
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.bonsaitrees.listIntegrations.result_title", new Object[0]));
        for (IBonsaiIntegration integration3 : integrationsToList) {
            int trees = countTypes.containsKey(integration3) ? (Integer)countTypes.get(integration3) : 0;
            int soils = countSoils.containsKey(integration3) ? (Integer)countSoils.get(integration3) : 0;
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.bonsaitrees.listIntegrations.result_entry", new Object[]{integration3.getClass().getSimpleName(), trees, soils}));
            totalTrees += trees;
            totalSoils += soils;
        }
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.bonsaitrees.listIntegrations.result_entry_total", new Object[]{totalTrees, totalSoils, totalSoils + totalTrees}));
    }
}

