/*
 * Decompiled with CFR 0.152.
 */
package org.dave.bonsaitrees.compat.Waila;

import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import org.dave.bonsaitrees.block.BlockBonsaiPot;
import org.dave.bonsaitrees.tile.TileBonsaiPot;
import org.dave.bonsaitrees.utility.Logz;

public class WailaProvider {
    public static void register(IWailaRegistrar registry) {
        Logz.info("Enabled support for Waila/Hwyla", new Object[0]);
        registry.registerBodyProvider((IWailaDataProvider)new BonsaiPotProvider(), BlockBonsaiPot.class);
    }

    public static class BonsaiPotProvider
    implements IWailaDataProvider {
        @Nonnull
        public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            if (!(accessor.getTileEntity() instanceof TileBonsaiPot)) {
                return currenttip;
            }
            TileBonsaiPot teBonsai = (TileBonsaiPot)accessor.getTileEntity();
            if (teBonsai.hasSapling()) {
                currenttip.add(TextFormatting.GRAY + teBonsai.getSapling().func_82833_r());
            }
            if (teBonsai.hasSoil()) {
                currenttip.add(TextFormatting.GRAY + teBonsai.getSoilStack().func_82833_r());
            }
            if (teBonsai.hasSapling()) {
                currenttip.add(String.format("%s%.1f%%", TextFormatting.YELLOW, teBonsai.getProgressPercent() * 100.0));
            }
            return currenttip;
        }
    }
}

