/*
 * Decompiled with CFR 0.152.
 */
package org.dave.bonsaitrees.integration.mods;

import com.pam.harvestcraft.blocks.FruitRegistry;
import com.pam.harvestcraft.blocks.growables.BlockPamSapling;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.dave.bonsaitrees.api.BonsaiDropChances;
import org.dave.bonsaitrees.api.BonsaiIntegration;
import org.dave.bonsaitrees.api.IBonsaiIntegration;
import org.dave.bonsaitrees.api.IBonsaiTreeType;
import org.dave.bonsaitrees.api.ITreeTypeRegistry;
import org.dave.bonsaitrees.api.TreeTypeSimple;

@BonsaiIntegration(mod="harvestcraft")
public class PamsHarvestcraft
implements IBonsaiIntegration {
    @Override
    public void registerTrees(ITreeTypeRegistry registry) {
        for (BlockPamSapling sapling : FruitRegistry.getSaplings()) {
            String name = sapling.getRegistryName().toString().replace("_sapling", "");
            TreeTypeSimple pamTreeType = new TreeTypeSimple(name, new ItemStack((Block)sapling, 1, 0));
            pamTreeType.addDrop(new ItemStack((Block)sapling, BonsaiDropChances.saplingAmount), BonsaiDropChances.saplingChance);
            pamTreeType.addDrop(new ItemStack(Items.field_151055_y, BonsaiDropChances.stickAmount), BonsaiDropChances.stickChance);
            pamTreeType.addDrop(new ItemStack(sapling.getFruitItem(), BonsaiDropChances.fruitAmount), BonsaiDropChances.fruitChance);
            IBlockState logState = (IBlockState)ReflectionHelper.getPrivateValue(BlockPamSapling.class, (Object)sapling, (String[])new String[]{"logState"});
            pamTreeType.addDrop(new ItemStack(logState.func_177230_c(), BonsaiDropChances.logAmount), BonsaiDropChances.logChance);
            IBlockState leafState = (IBlockState)ReflectionHelper.getPrivateValue(BlockPamSapling.class, (Object)sapling, (String[])new String[]{"leavesState"});
            pamTreeType.addDrop(new ItemStack(leafState.func_177230_c(), BonsaiDropChances.leafAmount), BonsaiDropChances.leafChance);
            registry.registerTreeType(this, pamTreeType);
        }
    }

    @Override
    public void generateTree(IBonsaiTreeType type, World world, BlockPos pos, Random rand) {
        for (BlockPamSapling sapling : FruitRegistry.getSaplings()) {
            String name = sapling.getRegistryName().toString().replace("_sapling", "");
            if (!name.equals(type.getName())) continue;
            world.func_175656_a(pos, sapling.func_176223_P());
            sapling.func_176474_b(world, rand, pos, sapling.func_176223_P());
        }
    }
}

