/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.vertex;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.IForgeVertexBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.system.MemoryStack;

@OnlyIn(value=Dist.CLIENT)
public interface IVertexBuilder
extends IForgeVertexBuilder {
    public static final Logger field_227884_f_ = LogManager.getLogger();

    public IVertexBuilder func_225582_a_(double var1, double var3, double var5);

    public IVertexBuilder func_225586_a_(int var1, int var2, int var3, int var4);

    public IVertexBuilder func_225583_a_(float var1, float var2);

    public IVertexBuilder func_225585_a_(int var1, int var2);

    public IVertexBuilder func_225587_b_(int var1, int var2);

    public IVertexBuilder func_225584_a_(float var1, float var2, float var3);

    public void func_181675_d();

    default public void func_225588_a_(float x, float y, float z, float red, float green, float blue, float alpha, float texU, float texV, int overlayUV, int lightmapUV, float normalX, float normalY, float normalZ) {
        this.func_225582_a_(x, y, z);
        this.func_227885_a_(red, green, blue, alpha);
        this.func_225583_a_(texU, texV);
        this.func_227891_b_(overlayUV);
        this.func_227886_a_(lightmapUV);
        this.func_225584_a_(normalX, normalY, normalZ);
        this.func_181675_d();
    }

    default public IVertexBuilder func_227885_a_(float red, float green, float blue, float alpha) {
        return this.func_225586_a_((int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f), (int)(alpha * 255.0f));
    }

    default public IVertexBuilder func_227886_a_(int lightmapUV) {
        return this.func_225587_b_(lightmapUV & 0xFFFF, lightmapUV >> 16 & 0xFFFF);
    }

    default public IVertexBuilder func_227891_b_(int overlayUV) {
        return this.func_225585_a_(overlayUV & 0xFFFF, overlayUV >> 16 & 0xFFFF);
    }

    default public void func_227889_a_(MatrixStack.Entry matrixEntryIn, BakedQuad quadIn, float redIn, float greenIn, float blueIn, int combinedLightIn, int combinedOverlayIn) {
        this.func_227890_a_(matrixEntryIn, quadIn, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, redIn, greenIn, blueIn, new int[]{combinedLightIn, combinedLightIn, combinedLightIn, combinedLightIn}, combinedOverlayIn, false);
    }

    default public void func_227890_a_(MatrixStack.Entry matrixEntryIn, BakedQuad quadIn, float[] colorMuls, float redIn, float greenIn, float blueIn, int[] combinedLightsIn, int combinedOverlayIn, boolean mulColor) {
        int[] aint = quadIn.func_178209_a();
        Vector3i vector3i = quadIn.func_178210_d().func_176730_m();
        Vector3f vector3f = new Vector3f(vector3i.func_177958_n(), vector3i.func_177956_o(), vector3i.func_177952_p());
        Matrix4f matrix4f = matrixEntryIn.func_227870_a_();
        vector3f.func_229188_a_(matrixEntryIn.func_227872_b_());
        int i = 8;
        int j = aint.length / 8;
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = memorystack.malloc(DefaultVertexFormats.field_176600_a.func_177338_f());
            IntBuffer intbuffer = bytebuffer.asIntBuffer();
            for (int k = 0; k < j; ++k) {
                float f5;
                float f4;
                float f3;
                ((Buffer)intbuffer).clear();
                intbuffer.put(aint, k * 8, 8);
                float f = bytebuffer.getFloat(0);
                float f1 = bytebuffer.getFloat(4);
                float f2 = bytebuffer.getFloat(8);
                if (mulColor) {
                    float f6 = (float)(bytebuffer.get(12) & 0xFF) / 255.0f;
                    float f7 = (float)(bytebuffer.get(13) & 0xFF) / 255.0f;
                    float f8 = (float)(bytebuffer.get(14) & 0xFF) / 255.0f;
                    f3 = f6 * colorMuls[k] * redIn;
                    f4 = f7 * colorMuls[k] * greenIn;
                    f5 = f8 * colorMuls[k] * blueIn;
                } else {
                    f3 = colorMuls[k] * redIn;
                    f4 = colorMuls[k] * greenIn;
                    f5 = colorMuls[k] * blueIn;
                }
                int l = this.applyBakedLighting(combinedLightsIn[k], bytebuffer);
                float f9 = bytebuffer.getFloat(16);
                float f10 = bytebuffer.getFloat(20);
                Vector4f vector4f = new Vector4f(f, f1, f2, 1.0f);
                vector4f.func_229372_a_(matrix4f);
                this.applyBakedNormals(vector3f, bytebuffer, matrixEntryIn.func_227872_b_());
                this.func_225588_a_(vector4f.func_195910_a(), vector4f.func_195913_b(), vector4f.func_195914_c(), f3, f4, f5, 1.0f, f9, f10, combinedOverlayIn, l, vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c());
            }
        }
    }

    default public IVertexBuilder func_227888_a_(Matrix4f matrixIn, float x, float y, float z) {
        Vector4f vector4f = new Vector4f(x, y, z, 1.0f);
        vector4f.func_229372_a_(matrixIn);
        return this.func_225582_a_(vector4f.func_195910_a(), vector4f.func_195913_b(), vector4f.func_195914_c());
    }

    default public IVertexBuilder func_227887_a_(Matrix3f matrixIn, float x, float y, float z) {
        Vector3f vector3f = new Vector3f(x, y, z);
        vector3f.func_229188_a_(matrixIn);
        return this.func_225584_a_(vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c());
    }
}

