/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class SpongeBlock
extends Block {
    public SpongeBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    @Override
    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.func_203425_a(state.func_177230_c())) {
            this.func_196510_a(worldIn, pos);
        }
    }

    @Override
    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.func_196510_a(worldIn, pos);
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
    }

    protected void func_196510_a(World worldIn, BlockPos pos) {
        if (this.func_176312_d(worldIn, pos)) {
            worldIn.func_180501_a(pos, Blocks.field_196577_ad.func_176223_P(), 2);
            worldIn.func_217379_c(2001, pos, Block.func_196246_j(Blocks.field_150355_j.func_176223_P()));
        }
    }

    private boolean func_176312_d(World worldIn, BlockPos pos) {
        LinkedList queue = Lists.newLinkedList();
        queue.add(new Tuple((Object)pos, (Object)0));
        int i = 0;
        while (!queue.isEmpty()) {
            Tuple tuple = (Tuple)queue.poll();
            BlockPos blockpos = (BlockPos)tuple.func_76341_a();
            int j = (Integer)tuple.func_76340_b();
            for (Direction direction : Direction.values()) {
                BlockPos blockpos1 = blockpos.func_177972_a(direction);
                BlockState blockstate = worldIn.func_180495_p(blockpos1);
                FluidState fluidstate = worldIn.func_204610_c(blockpos1);
                Material material = blockstate.func_185904_a();
                if (!fluidstate.func_206884_a(FluidTags.field_206959_a)) continue;
                if (blockstate.func_177230_c() instanceof IBucketPickupHandler && ((IBucketPickupHandler)blockstate.func_177230_c()).func_204508_a((IWorld)worldIn, blockpos1, blockstate) != Fluids.field_204541_a) {
                    ++i;
                    if (j >= 6) continue;
                    queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
                    continue;
                }
                if (blockstate.func_177230_c() instanceof FlowingFluidBlock) {
                    worldIn.func_180501_a(blockpos1, Blocks.field_150350_a.func_176223_P(), 3);
                    ++i;
                    if (j >= 6) continue;
                    queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
                    continue;
                }
                if (material != Material.field_203243_f && material != Material.field_204868_h) continue;
                TileEntity tileentity = blockstate.hasTileEntity() ? worldIn.func_175625_s(blockpos1) : null;
                SpongeBlock.func_220059_a(blockstate, worldIn, blockpos1, tileentity);
                worldIn.func_180501_a(blockpos1, Blocks.field_150350_a.func_176223_P(), 3);
                ++i;
                if (j >= 6) continue;
                queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
            }
            if (i <= 64) continue;
            break;
        }
        return i > 0;
    }
}

