/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster.piglin;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.piglin.AbstractPiglinEntity;
import net.minecraft.entity.monster.piglin.PiglinAction;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShootableItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class PiglinEntity
extends AbstractPiglinEntity
implements ICrossbowUser {
    private static final DataParameter<Boolean> field_234415_d_ = EntityDataManager.func_187226_a(PiglinEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> field_234409_bv_ = EntityDataManager.func_187226_a(PiglinEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> field_234410_bw_ = EntityDataManager.func_187226_a(PiglinEntity.class, DataSerializers.field_187198_h);
    private static final UUID field_234411_bx_ = UUID.fromString("766bfa64-11f3-11ea-8d71-362b9e155667");
    private static final AttributeModifier field_234412_by_ = new AttributeModifier(field_234411_bx_, "Baby speed boost", (double)0.2f, AttributeModifier.Operation.MULTIPLY_BASE);
    private final Inventory field_234406_bA_ = new Inventory(8);
    private boolean field_234407_bB_ = false;
    protected static final ImmutableList<SensorType<? extends Sensor<? super PiglinEntity>>> field_234405_b_ = ImmutableList.of(SensorType.field_220998_b, SensorType.field_220999_c, SensorType.field_234129_b_, SensorType.field_221002_f, SensorType.field_234130_l_);
    protected static final ImmutableList<MemoryModuleType<?>> field_234414_c_ = ImmutableList.of(MemoryModuleType.field_220951_l, MemoryModuleType.field_225462_q, MemoryModuleType.field_220945_f, MemoryModuleType.field_220946_g, MemoryModuleType.field_220949_j, MemoryModuleType.field_234102_l_, MemoryModuleType.field_234090_X_, MemoryModuleType.field_234089_W_, MemoryModuleType.field_234076_J_, MemoryModuleType.field_220957_r, MemoryModuleType.field_220958_s, MemoryModuleType.field_220950_k, (Object[])new MemoryModuleType[]{MemoryModuleType.field_223021_x, MemoryModuleType.field_234103_o_, MemoryModuleType.field_234104_p_, MemoryModuleType.field_220952_m, MemoryModuleType.field_220954_o, MemoryModuleType.field_234078_L_, MemoryModuleType.field_234079_M_, MemoryModuleType.field_234106_z_, MemoryModuleType.field_234080_N_, MemoryModuleType.field_242310_O, MemoryModuleType.field_234081_O_, MemoryModuleType.field_242311_P, MemoryModuleType.field_234083_Q_, MemoryModuleType.field_234084_R_, MemoryModuleType.field_234082_P_, MemoryModuleType.field_234086_T_, MemoryModuleType.field_234077_K_, MemoryModuleType.field_234093_aa_, MemoryModuleType.field_234105_s_, MemoryModuleType.field_234094_ab_, MemoryModuleType.field_234095_ac_, MemoryModuleType.field_234085_S_, MemoryModuleType.field_234088_V_, MemoryModuleType.field_234096_ad_, MemoryModuleType.field_234097_ae_, MemoryModuleType.field_234098_af_});

    public PiglinEntity(EntityType<? extends AbstractPiglinEntity> p_i231570_1_, World p_i231570_2_) {
        super(p_i231570_1_, p_i231570_2_);
        this.field_70728_aV = 5;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.func_70631_g_()) {
            compound.func_74757_a("IsBaby", true);
        }
        if (this.field_234407_bB_) {
            compound.func_74757_a("CannotHunt", true);
        }
        compound.func_218657_a("Inventory", (INBT)this.field_234406_bA_.func_70487_g());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.func_82227_f(compound.func_74767_n("IsBaby"));
        this.func_234443_v_(compound.func_74767_n("CannotHunt"));
        this.field_234406_bA_.func_70486_a(compound.func_150295_c("Inventory", 10));
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
        super.func_213333_a(source, looting, recentlyHitIn);
        this.field_234406_bA_.func_233543_f_().forEach(arg_0 -> this.func_199701_a_(arg_0));
    }

    protected ItemStack func_234436_k_(ItemStack p_234436_1_) {
        return this.field_234406_bA_.func_174894_a(p_234436_1_);
    }

    protected boolean func_234437_l_(ItemStack p_234437_1_) {
        return this.field_234406_bA_.func_233541_b_(p_234437_1_);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_234415_d_, false);
        this.field_70180_af.func_187214_a(field_234409_bv_, false);
        this.field_70180_af.func_187214_a(field_234410_bw_, false);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (field_234415_d_.equals(key)) {
            this.func_213323_x_();
        }
    }

    public static AttributeModifierMap.MutableAttribute func_234420_eI_() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 16.0).func_233815_a_(Attributes.field_233821_d_, (double)0.35f).func_233815_a_(Attributes.field_233823_f_, 5.0);
    }

    public static boolean func_234418_b_(EntityType<PiglinEntity> p_234418_0_, IWorld p_234418_1_, SpawnReason p_234418_2_, BlockPos p_234418_3_, Random p_234418_4_) {
        return !p_234418_1_.func_180495_p(p_234418_3_.func_177977_b()).func_203425_a(Blocks.field_189878_dg);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (reason != SpawnReason.STRUCTURE) {
            if (worldIn.func_201674_k().nextFloat() < 0.2f) {
                this.func_82227_f(true);
            } else if (this.func_242337_eM()) {
                this.func_184201_a(EquipmentSlotType.MAINHAND, this.func_234432_eW_());
            }
        }
        PiglinTasks.func_234466_a_(this);
        this.func_180481_a(difficultyIn);
        this.func_180483_b(difficultyIn);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected boolean func_225511_J_() {
        return false;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return !this.func_104002_bU();
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        if (this.func_242337_eM()) {
            this.func_234419_d_(EquipmentSlotType.HEAD, new ItemStack(Items.field_151169_ag));
            this.func_234419_d_(EquipmentSlotType.CHEST, new ItemStack(Items.field_151171_ah));
            this.func_234419_d_(EquipmentSlotType.LEGS, new ItemStack(Items.field_151149_ai));
            this.func_234419_d_(EquipmentSlotType.FEET, new ItemStack(Items.field_151151_aj));
        }
    }

    private void func_234419_d_(EquipmentSlotType p_234419_1_, ItemStack p_234419_2_) {
        if (this.field_70170_p.field_73012_v.nextFloat() < 0.1f) {
            this.func_184201_a(p_234419_1_, p_234419_2_);
        }
    }

    protected Brain.BrainCodec<PiglinEntity> func_230289_cH_() {
        return Brain.func_233705_a_(field_234414_c_, field_234405_b_);
    }

    protected Brain<?> func_213364_a(Dynamic<?> dynamicIn) {
        return PiglinTasks.func_234469_a_(this, (Brain<PiglinEntity>)this.func_230289_cH_().func_233748_a_(dynamicIn));
    }

    public Brain<PiglinEntity> func_213375_cj() {
        return super.func_213375_cj();
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ActionResultType actionresulttype = super.func_230254_b_(p_230254_1_, p_230254_2_);
        if (actionresulttype.func_226246_a_()) {
            return actionresulttype;
        }
        if (!this.field_70170_p.field_72995_K) {
            return PiglinTasks.func_234471_a_(this, p_230254_1_, p_230254_2_);
        }
        boolean flag = PiglinTasks.func_234489_b_(this, p_230254_1_.func_184586_b(p_230254_2_)) && this.func_234424_eM_() != PiglinAction.ADMIRING_ITEM;
        return flag ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70631_g_() ? 0.93f : 1.74f;
    }

    public double func_70042_X() {
        return (double)this.func_213302_cg() * 0.92;
    }

    public void func_82227_f(boolean childZombie) {
        this.func_184212_Q().func_187227_b(field_234415_d_, childZombie);
        if (!this.field_70170_p.field_72995_K) {
            ModifiableAttributeInstance modifiableattributeinstance = this.func_110148_a(Attributes.field_233821_d_);
            modifiableattributeinstance.func_111124_b(field_234412_by_);
            if (childZombie) {
                modifiableattributeinstance.func_233767_b_(field_234412_by_);
            }
        }
    }

    public boolean func_70631_g_() {
        return this.func_184212_Q().func_187225_a(field_234415_d_);
    }

    private void func_234443_v_(boolean p_234443_1_) {
        this.field_234407_bB_ = p_234443_1_;
    }

    protected boolean func_234422_eK_() {
        return !this.field_234407_bB_;
    }

    protected void func_70619_bc() {
        this.field_70170_p.func_217381_Z().func_76320_a("piglinBrain");
        this.func_213375_cj().func_218210_a((ServerWorld)this.field_70170_p, (LivingEntity)((Object)this));
        this.field_70170_p.func_217381_Z().func_76319_b();
        PiglinTasks.func_234486_b_(this);
        super.func_70619_bc();
    }

    protected int func_70693_a(PlayerEntity player) {
        return this.field_70728_aV;
    }

    protected void func_234416_a_(ServerWorld p_234416_1_) {
        PiglinTasks.func_234496_c_(this);
        this.field_234406_bA_.func_233543_f_().forEach(arg_0 -> this.func_199701_a_(arg_0));
        super.func_234416_a_(p_234416_1_);
    }

    private ItemStack func_234432_eW_() {
        return (double)this.field_70146_Z.nextFloat() < 0.5 ? new ItemStack(Items.field_222114_py) : new ItemStack(Items.field_151010_B);
    }

    private boolean func_234433_eX_() {
        return this.field_70180_af.func_187225_a(field_234409_bv_);
    }

    public void func_213671_a(boolean isCharging) {
        this.field_70180_af.func_187227_b(field_234409_bv_, isCharging);
    }

    public void func_230283_U__() {
        this.field_70708_bq = 0;
    }

    public PiglinAction func_234424_eM_() {
        if (this.func_234425_eN_()) {
            return PiglinAction.DANCING;
        }
        if (PiglinTasks.func_234480_a_(this.func_184592_cb().func_77973_b())) {
            return PiglinAction.ADMIRING_ITEM;
        }
        if (this.func_213398_dR() && this.func_242338_eO()) {
            return PiglinAction.ATTACKING_WITH_MELEE_WEAPON;
        }
        if (this.func_234433_eX_()) {
            return PiglinAction.CROSSBOW_CHARGE;
        }
        return this.func_213398_dR() && this.func_233631_a_(Items.field_222114_py) ? PiglinAction.CROSSBOW_HOLD : PiglinAction.DEFAULT;
    }

    public boolean func_234425_eN_() {
        return this.field_70180_af.func_187225_a(field_234410_bw_);
    }

    public void func_234442_u_(boolean p_234442_1_) {
        this.field_70180_af.func_187227_b(field_234410_bw_, p_234442_1_);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean flag = super.func_70097_a(source, amount);
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (flag && source.func_76346_g() instanceof LivingEntity) {
            PiglinTasks.func_234468_a_(this, (LivingEntity)source.func_76346_g());
        }
        return flag;
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        this.func_234281_b_((LivingEntity)((Object)this), 1.6f);
    }

    public void func_230284_a_(LivingEntity p_230284_1_, ItemStack p_230284_2_, ProjectileEntity p_230284_3_, float p_230284_4_) {
        this.func_234279_a_((LivingEntity)((Object)this), p_230284_1_, p_230284_3_, p_230284_4_, 1.6f);
    }

    public boolean func_230280_a_(ShootableItem p_230280_1_) {
        return p_230280_1_ == Items.field_222114_py;
    }

    protected void func_234438_m_(ItemStack p_234438_1_) {
        this.func_233657_b_(EquipmentSlotType.MAINHAND, p_234438_1_);
    }

    protected void func_234439_n_(ItemStack p_234439_1_) {
        if (p_234439_1_.isPiglinCurrency()) {
            this.func_184201_a(EquipmentSlotType.OFFHAND, p_234439_1_);
            this.func_233663_d_(EquipmentSlotType.OFFHAND);
        } else {
            this.func_233657_b_(EquipmentSlotType.OFFHAND, p_234439_1_);
        }
    }

    public boolean func_230293_i_(ItemStack p_230293_1_) {
        return this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b) && this.func_98052_bS() && PiglinTasks.func_234474_a_(this, p_230293_1_);
    }

    protected boolean func_234440_o_(ItemStack p_234440_1_) {
        EquipmentSlotType equipmentslottype = MobEntity.func_184640_d(p_234440_1_);
        ItemStack itemstack = this.func_184582_a(equipmentslottype);
        return this.func_208003_a(p_234440_1_, itemstack);
    }

    protected boolean func_208003_a(ItemStack candidate, ItemStack existing) {
        boolean flag1;
        if (EnchantmentHelper.func_190938_b(existing)) {
            return false;
        }
        boolean flag = PiglinTasks.func_234480_a_(candidate.func_77973_b()) || candidate.func_77973_b() == Items.field_222114_py;
        boolean bl = flag1 = PiglinTasks.func_234480_a_(existing.func_77973_b()) || existing.func_77973_b() == Items.field_222114_py;
        if (flag && !flag1) {
            return true;
        }
        if (!flag && flag1) {
            return false;
        }
        return this.func_242337_eM() && candidate.func_77973_b() != Items.field_222114_py && existing.func_77973_b() == Items.field_222114_py ? false : super.func_208003_a(candidate, existing);
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        this.func_233630_a_(itemEntity);
        PiglinTasks.func_234470_a_(this, itemEntity);
    }

    public boolean func_184205_a(Entity entityIn, boolean force) {
        if (this.func_70631_g_() && entityIn.func_200600_R() == EntityType.field_233588_G_) {
            entityIn = this.func_234417_b_(entityIn, 3);
        }
        return super.func_184205_a(entityIn, force);
    }

    private Entity func_234417_b_(Entity p_234417_1_, int p_234417_2_) {
        List<Entity> list = p_234417_1_.func_184188_bt();
        return p_234417_2_ != 1 && !list.isEmpty() ? this.func_234417_b_(list.get(0), p_234417_2_ - 1) : p_234417_1_;
    }

    protected SoundEvent func_184639_G() {
        return this.field_70170_p.field_72995_K ? null : PiglinTasks.func_241429_d_(this).orElse(null);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_232793_kX_;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_232791_kV_;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_232795_kZ_, 0.15f, 1.0f);
    }

    protected void func_241417_a_(SoundEvent p_241417_1_) {
        this.func_184185_a(p_241417_1_, this.func_70599_aP(), this.func_70647_i());
    }

    protected void func_241848_eP() {
        this.func_241417_a_(SoundEvents.field_232799_la_);
    }
}

