/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SweetBerryBushBlock;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FleeSunGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.MoveThroughVillageAtNightGoal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.passive.fish.AbstractGroupFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.eventbus.api.Event;

public class FoxEntity
extends AnimalEntity {
    private static final DataParameter<Integer> field_213523_bz = EntityDataManager.func_187226_a(FoxEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Byte> field_213524_bA = EntityDataManager.func_187226_a(FoxEntity.class, DataSerializers.field_187191_a);
    private static final DataParameter<Optional<UUID>> field_213509_bB = EntityDataManager.func_187226_a(FoxEntity.class, DataSerializers.field_187203_m);
    private static final DataParameter<Optional<UUID>> field_213510_bD = EntityDataManager.func_187226_a(FoxEntity.class, DataSerializers.field_187203_m);
    private static final Predicate<ItemEntity> field_213511_bE = p_213489_0_ -> !p_213489_0_.func_174874_s() && p_213489_0_.func_70089_S();
    private static final Predicate<Entity> field_213512_bF = p_213470_0_ -> {
        if (!(p_213470_0_ instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingentity = (LivingEntity)((Object)p_213470_0_);
        return livingentity.func_110144_aD() != null && livingentity.func_142013_aG() < livingentity.field_70173_aa + 600;
    };
    private static final Predicate<Entity> field_213513_bG = p_213498_0_ -> p_213498_0_ instanceof ChickenEntity || p_213498_0_ instanceof RabbitEntity;
    private static final Predicate<Entity> field_213514_bH = p_213463_0_ -> !p_213463_0_.func_226273_bm_() && EntityPredicates.field_188444_d.test(p_213463_0_);
    private Goal field_213515_bI;
    private Goal field_213516_bJ;
    private Goal field_213517_bK;
    private float field_213518_bL;
    private float field_213519_bM;
    private float field_213520_bN;
    private float field_213521_bO;
    private int field_213522_bP;

    public FoxEntity(EntityType<? extends FoxEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70749_g = new LookHelperController();
        this.field_70765_h = new MoveHelperController();
        this.func_184644_a(PathNodeType.DANGER_OTHER, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_OTHER, 0.0f);
        this.func_98053_h(true);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_213509_bB, Optional.empty());
        this.field_70180_af.func_187214_a(field_213510_bD, Optional.empty());
        this.field_70180_af.func_187214_a(field_213523_bz, 0);
        this.field_70180_af.func_187214_a(field_213524_bA, (byte)0);
    }

    protected void func_184651_r() {
        this.field_213515_bI = new NearestAttackableTargetGoal((MobEntity)((Object)this), AnimalEntity.class, 10, false, false, p_213487_0_ -> p_213487_0_ instanceof ChickenEntity || p_213487_0_ instanceof RabbitEntity);
        this.field_213516_bJ = new NearestAttackableTargetGoal((MobEntity)((Object)this), TurtleEntity.class, 10, false, false, TurtleEntity.field_203029_bx);
        this.field_213517_bK = new NearestAttackableTargetGoal((MobEntity)((Object)this), AbstractFishEntity.class, 20, false, false, p_213456_0_ -> p_213456_0_ instanceof AbstractGroupFishEntity);
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new JumpGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new PanicGoal(2.2));
        this.field_70714_bg.func_75776_a(3, (Goal)new MateGoal(1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 16.0f, 1.6, 1.4, p_213497_1_ -> field_213514_bH.test((Entity)((Object)p_213497_1_)) && !this.func_213468_c(p_213497_1_.func_110124_au()) && !this.func_213473_el()));
        this.field_70714_bg.func_75776_a(4, (Goal)new AvoidEntityGoal((CreatureEntity)this, WolfEntity.class, 8.0f, 1.6, 1.4, p_213469_1_ -> !((WolfEntity)((Object)((Object)p_213469_1_))).func_70909_n() && !this.func_213473_el()));
        this.field_70714_bg.func_75776_a(4, (Goal)new AvoidEntityGoal((CreatureEntity)this, PolarBearEntity.class, 8.0f, 1.6, 1.4, p_213493_1_ -> !this.func_213473_el()));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowTargetGoal());
        this.field_70714_bg.func_75776_a(6, (Goal)new PounceGoal());
        this.field_70714_bg.func_75776_a(6, (Goal)new FindShelterGoal(1.25));
        this.field_70714_bg.func_75776_a(7, (Goal)new BiteGoal((double)1.2f, true));
        this.field_70714_bg.func_75776_a(7, (Goal)new SleepGoal());
        this.field_70714_bg.func_75776_a(8, (Goal)new FollowGoal(this, 1.25));
        this.field_70714_bg.func_75776_a(9, (Goal)new StrollGoal(32, 200));
        this.field_70714_bg.func_75776_a(10, (Goal)new EatBerriesGoal(1.2f, 12, 2));
        this.field_70714_bg.func_75776_a(10, (Goal)new LeapAtTargetGoal((MobEntity)((Object)this), 0.4f));
        this.field_70714_bg.func_75776_a(11, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(11, (Goal)new FindItemsGoal());
        this.field_70714_bg.func_75776_a(12, (Goal)new WatchGoal((MobEntity)((Object)this), PlayerEntity.class, 24.0f));
        this.field_70714_bg.func_75776_a(13, (Goal)new SitAndLookGoal());
        this.field_70715_bh.func_75776_a(3, (Goal)new RevengeGoal(LivingEntity.class, false, false, p_234193_1_ -> field_213512_bF.test((Entity)((Object)p_234193_1_)) && !this.func_213468_c(p_234193_1_.func_110124_au())));
    }

    public SoundEvent func_213353_d(ItemStack itemStackIn) {
        return SoundEvents.field_219634_dx;
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.func_70613_aW()) {
            LivingEntity livingentity;
            ++this.field_213522_bP;
            ItemStack itemstack = this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (this.func_213464_j(itemstack)) {
                if (this.field_213522_bP > 600) {
                    ItemStack itemstack1 = itemstack.func_77950_b(this.field_70170_p, (LivingEntity)((Object)this));
                    if (!itemstack1.func_190926_b()) {
                        this.func_184201_a(EquipmentSlotType.MAINHAND, itemstack1);
                    }
                    this.field_213522_bP = 0;
                } else if (this.field_213522_bP > 560 && this.field_70146_Z.nextFloat() < 0.1f) {
                    this.func_184185_a(this.func_213353_d(itemstack), 1.0f, 1.0f);
                    this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)45);
                }
            }
            if ((livingentity = this.func_70638_az()) == null || !livingentity.func_70089_S()) {
                this.func_213451_t(false);
                this.func_213502_u(false);
            }
        }
        if (this.func_70608_bn() || this.func_70610_aX()) {
            this.field_70703_bu = false;
            this.field_70702_br = 0.0f;
            this.field_191988_bg = 0.0f;
        }
        super.func_70636_d();
        if (this.func_213473_el() && this.field_70146_Z.nextFloat() < 0.05f) {
            this.func_184185_a(SoundEvents.field_219630_dt, 1.0f, 1.0f);
        }
    }

    protected boolean func_70610_aX() {
        return this.func_233643_dh_();
    }

    private boolean func_213464_j(ItemStack itemStackIn) {
        return itemStackIn.func_77973_b().func_219971_r() && this.func_70638_az() == null && this.field_70122_E && !this.func_70608_bn();
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        if (this.field_70146_Z.nextFloat() < 0.2f) {
            float f = this.field_70146_Z.nextFloat();
            ItemStack itemstack = f < 0.05f ? new ItemStack(Items.field_151166_bC) : (f < 0.2f ? new ItemStack(Items.field_151110_aK) : (f < 0.4f ? (this.field_70146_Z.nextBoolean() ? new ItemStack(Items.field_179556_br) : new ItemStack(Items.field_179555_bs)) : (f < 0.6f ? new ItemStack(Items.field_151015_O) : (f < 0.8f ? new ItemStack(Items.field_151116_aA) : new ItemStack(Items.field_151008_G)))));
            this.func_184201_a(EquipmentSlotType.MAINHAND, itemstack);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 45) {
            ItemStack itemstack = this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (!itemstack.func_190926_b()) {
                for (int i = 0; i < 8; ++i) {
                    Vector3d vector3d = new Vector3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).func_178789_a(-this.field_70125_A * ((float)Math.PI / 180)).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
                    this.field_70170_p.func_195594_a(new ItemParticleData(ParticleTypes.field_197591_B, itemstack), this.func_226277_ct_() + this.func_70040_Z().field_72450_a / 2.0, this.func_226278_cu_(), this.func_226281_cx_() + this.func_70040_Z().field_72449_c / 2.0, vector3d.field_72450_a, vector3d.field_72448_b + 0.05, vector3d.field_72449_c);
                }
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public static AttributeModifierMap.MutableAttribute func_234192_eI_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233823_f_, 2.0);
    }

    public FoxEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        FoxEntity foxentity = EntityType.field_220356_B.func_200721_a(p_241840_1_);
        foxentity.func_213474_a(this.field_70146_Z.nextBoolean() ? this.func_213471_dV() : ((FoxEntity)p_241840_2_).func_213471_dV());
        return foxentity;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        Optional optional = worldIn.func_242406_i(this.func_233580_cy_());
        Type foxentity$type = Type.func_242325_a(optional);
        boolean flag = false;
        if (spawnDataIn instanceof FoxData) {
            foxentity$type = ((FoxData)((Object)spawnDataIn)).field_220366_a;
            if (((FoxData)((Object)spawnDataIn)).func_226257_a_() >= 2) {
                flag = true;
            }
        } else {
            spawnDataIn = new FoxData(foxentity$type);
        }
        this.func_213474_a(foxentity$type);
        if (flag) {
            this.func_70873_a(-24000);
        }
        if (worldIn instanceof ServerWorld) {
            this.func_213501_ej();
        }
        this.func_180481_a(difficultyIn);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    private void func_213501_ej() {
        if (this.func_213471_dV() == Type.RED) {
            this.field_70715_bh.func_75776_a(4, this.field_213515_bI);
            this.field_70715_bh.func_75776_a(4, this.field_213516_bJ);
            this.field_70715_bh.func_75776_a(6, this.field_213517_bK);
        } else {
            this.field_70715_bh.func_75776_a(4, this.field_213517_bK);
            this.field_70715_bh.func_75776_a(6, this.field_213515_bI);
            this.field_70715_bh.func_75776_a(6, this.field_213516_bJ);
        }
    }

    @Override
    protected void func_175505_a(PlayerEntity player, ItemStack stack) {
        if (this.func_70877_b(stack)) {
            this.func_184185_a(this.func_213353_d(stack), 1.0f, 1.0f);
        }
        super.func_175505_a(player, stack);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70631_g_() ? sizeIn.field_220316_b * 0.85f : 0.4f;
    }

    public Type func_213471_dV() {
        return Type.func_221080_a(this.field_70180_af.func_187225_a(field_213523_bz));
    }

    private void func_213474_a(Type typeIn) {
        this.field_70180_af.func_187227_b(field_213523_bz, typeIn.func_221083_c());
    }

    private List<UUID> func_213479_ek() {
        ArrayList list = Lists.newArrayList();
        list.add(this.field_70180_af.func_187225_a(field_213509_bB).orElse(null));
        list.add(this.field_70180_af.func_187225_a(field_213510_bD).orElse(null));
        return list;
    }

    private void func_213465_b(@Nullable UUID uuidIn) {
        if (this.field_70180_af.func_187225_a(field_213509_bB).isPresent()) {
            this.field_70180_af.func_187227_b(field_213510_bD, Optional.ofNullable(uuidIn));
        } else {
            this.field_70180_af.func_187227_b(field_213509_bB, Optional.ofNullable(uuidIn));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        List<UUID> list = this.func_213479_ek();
        ListNBT listnbt = new ListNBT();
        for (UUID uuid : list) {
            if (uuid == null) continue;
            listnbt.add((Object)NBTUtil.func_240626_a_((UUID)uuid));
        }
        compound.func_218657_a("Trusted", (INBT)listnbt);
        compound.func_74757_a("Sleeping", this.func_70608_bn());
        compound.func_74778_a("Type", this.func_213471_dV().func_221082_a());
        compound.func_74757_a("Sitting", this.func_213455_dW());
        compound.func_74757_a("Crouching", this.func_213453_ef());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        ListNBT listnbt = compound.func_150295_c("Trusted", 11);
        for (int i = 0; i < listnbt.size(); ++i) {
            this.func_213465_b(NBTUtil.func_186860_b((INBT)listnbt.get(i)));
        }
        this.func_213485_x(compound.func_74767_n("Sleeping"));
        this.func_213474_a(Type.func_221087_a(compound.func_74779_i("Type")));
        this.func_213466_r(compound.func_74767_n("Sitting"));
        this.func_213451_t(compound.func_74767_n("Crouching"));
        if (this.field_70170_p instanceof ServerWorld) {
            this.func_213501_ej();
        }
    }

    public boolean func_213455_dW() {
        return this.func_213507_r(1);
    }

    public void func_213466_r(boolean p_213466_1_) {
        this.func_213505_d(1, p_213466_1_);
    }

    public boolean func_213472_dX() {
        return this.func_213507_r(64);
    }

    private void func_213492_v(boolean p_213492_1_) {
        this.func_213505_d(64, p_213492_1_);
    }

    private boolean func_213473_el() {
        return this.func_213507_r(128);
    }

    private void func_213482_w(boolean p_213482_1_) {
        this.func_213505_d(128, p_213482_1_);
    }

    public boolean func_70608_bn() {
        return this.func_213507_r(32);
    }

    private void func_213485_x(boolean p_213485_1_) {
        this.func_213505_d(32, p_213485_1_);
    }

    private void func_213505_d(int p_213505_1_, boolean p_213505_2_) {
        if (p_213505_2_) {
            this.field_70180_af.func_187227_b(field_213524_bA, (byte)(this.field_70180_af.func_187225_a(field_213524_bA) | p_213505_1_));
        } else {
            this.field_70180_af.func_187227_b(field_213524_bA, (byte)(this.field_70180_af.func_187225_a(field_213524_bA) & ~p_213505_1_));
        }
    }

    private boolean func_213507_r(int p_213507_1_) {
        return (this.field_70180_af.func_187225_a(field_213524_bA) & p_213507_1_) != 0;
    }

    public boolean func_213365_e(ItemStack itemstackIn) {
        EquipmentSlotType equipmentslottype = MobEntity.func_184640_d(itemstackIn);
        if (!this.func_184582_a(equipmentslottype).func_190926_b()) {
            return false;
        }
        return equipmentslottype == EquipmentSlotType.MAINHAND && super.func_213365_e(itemstackIn);
    }

    public boolean func_175448_a(ItemStack stack) {
        Item item = stack.func_77973_b();
        ItemStack itemstack = this.func_184582_a(EquipmentSlotType.MAINHAND);
        return itemstack.func_190926_b() || this.field_213522_bP > 0 && item.func_219971_r() && !itemstack.func_77973_b().func_219971_r();
    }

    private void func_213495_k(ItemStack stackIn) {
        if (!stackIn.func_190926_b() && !this.field_70170_p.field_72995_K) {
            ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_() + this.func_70040_Z().field_72450_a, this.func_226278_cu_() + 1.0, this.func_226281_cx_() + this.func_70040_Z().field_72449_c, stackIn);
            itementity.func_174867_a(40);
            itementity.func_200216_c(this.func_110124_au());
            this.func_184185_a(SoundEvents.field_219629_dC, 1.0f, 1.0f);
            this.field_70170_p.func_217376_c(itementity);
        }
    }

    private void func_213486_l(ItemStack stackIn) {
        ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stackIn);
        this.field_70170_p.func_217376_c(itementity);
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.func_92059_d();
        if (this.func_175448_a(itemstack)) {
            int i = itemstack.func_190916_E();
            if (i > 1) {
                this.func_213486_l(itemstack.func_77979_a(i - 1));
            }
            this.func_213495_k(this.func_184582_a(EquipmentSlotType.MAINHAND));
            this.func_233630_a_(itemEntity);
            this.func_184201_a(EquipmentSlotType.MAINHAND, itemstack.func_77979_a(1));
            this.field_82174_bp[EquipmentSlotType.MAINHAND.func_188454_b()] = 2.0f;
            this.func_71001_a(itemEntity, itemstack.func_190916_E());
            itemEntity.func_70106_y();
            this.field_213522_bP = 0;
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70613_aW()) {
            boolean flag = this.func_70090_H();
            if (flag || this.func_70638_az() != null || this.field_70170_p.func_72911_I()) {
                this.func_213454_em();
            }
            if (flag || this.func_70608_bn()) {
                this.func_213466_r(false);
            }
            if (this.func_213472_dX() && this.field_70170_p.field_73012_v.nextFloat() < 0.2f) {
                BlockPos blockpos = this.func_233580_cy_();
                BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
                this.field_70170_p.func_217379_c(2001, blockpos, Block.func_196246_j(blockstate));
            }
        }
        this.field_213519_bM = this.field_213518_bL;
        this.field_213518_bL = this.func_213467_eg() ? (this.field_213518_bL += (1.0f - this.field_213518_bL) * 0.4f) : (this.field_213518_bL += (0.0f - this.field_213518_bL) * 0.4f);
        this.field_213521_bO = this.field_213520_bN;
        if (this.func_213453_ef()) {
            this.field_213520_bN += 0.2f;
            if (this.field_213520_bN > 3.0f) {
                this.field_213520_bN = 3.0f;
            }
        } else {
            this.field_213520_bN = 0.0f;
        }
    }

    @Override
    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_222112_pR;
    }

    protected void func_213406_a(PlayerEntity playerIn, MobEntity child) {
        ((FoxEntity)((Object)child)).func_213465_b(playerIn.func_110124_au());
    }

    public boolean func_213480_dY() {
        return this.func_213507_r(16);
    }

    public void func_213461_s(boolean p_213461_1_) {
        this.func_213505_d(16, p_213461_1_);
    }

    public boolean func_213490_ee() {
        return this.field_213520_bN == 3.0f;
    }

    public void func_213451_t(boolean p_213451_1_) {
        this.func_213505_d(4, p_213451_1_);
    }

    public boolean func_213453_ef() {
        return this.func_213507_r(4);
    }

    public void func_213502_u(boolean p_213502_1_) {
        this.func_213505_d(8, p_213502_1_);
    }

    public boolean func_213467_eg() {
        return this.func_213507_r(8);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_213475_v(float p_213475_1_) {
        return MathHelper.func_219799_g((float)p_213475_1_, (float)this.field_213519_bM, (float)this.field_213518_bL) * 0.11f * (float)Math.PI;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_213503_w(float p_213503_1_) {
        return MathHelper.func_219799_g((float)p_213503_1_, (float)this.field_213521_bO, (float)this.field_213520_bN);
    }

    public void func_70624_b(@Nullable LivingEntity entitylivingbaseIn) {
        if (this.func_213473_el() && entitylivingbaseIn == null) {
            this.func_213482_w(false);
        }
        super.func_70624_b(entitylivingbaseIn);
    }

    protected int func_225508_e_(float p_225508_1_, float p_225508_2_) {
        return MathHelper.func_76123_f((float)((p_225508_1_ - 5.0f) * p_225508_2_));
    }

    private void func_213454_em() {
        this.func_213485_x(false);
    }

    private void func_213499_en() {
        this.func_213502_u(false);
        this.func_213451_t(false);
        this.func_213466_r(false);
        this.func_213485_x(false);
        this.func_213482_w(false);
        this.func_213492_v(false);
    }

    private boolean func_213478_eo() {
        return !this.func_70608_bn() && !this.func_213455_dW() && !this.func_213472_dX();
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent == SoundEvents.field_219636_dz) {
            this.func_184185_a(soundevent, 2.0f, this.func_70647_i());
        } else {
            super.func_70642_aH();
        }
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        List<PlayerEntity> list;
        if (this.func_70608_bn()) {
            return SoundEvents.field_219627_dA;
        }
        if (!this.field_70170_p.func_72935_r() && this.field_70146_Z.nextFloat() < 0.1f && (list = this.field_70170_p.func_175647_a(PlayerEntity.class, this.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0), EntityPredicates.field_180132_d)).isEmpty()) {
            return SoundEvents.field_219636_dz;
        }
        return SoundEvents.field_219631_du;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_219635_dy;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_219633_dw;
    }

    private boolean func_213468_c(UUID p_213468_1_) {
        return this.func_213479_ek().contains(p_213468_1_);
    }

    protected void func_213345_d(DamageSource damageSourceIn) {
        ItemStack itemstack = this.func_184582_a(EquipmentSlotType.MAINHAND);
        if (!itemstack.func_190926_b()) {
            this.func_199701_a_(itemstack);
            this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
        }
        super.func_213345_d(damageSourceIn);
    }

    public static boolean func_213481_a(FoxEntity p_213481_0_, LivingEntity p_213481_1_) {
        double d0 = p_213481_1_.func_226281_cx_() - p_213481_0_.func_226281_cx_();
        double d1 = p_213481_1_.func_226277_ct_() - p_213481_0_.func_226277_ct_();
        double d2 = d0 / d1;
        int i = 6;
        for (int j = 0; j < 6; ++j) {
            double d3 = d2 == 0.0 ? 0.0 : d0 * (double)((float)j / 6.0f);
            double d4 = d2 == 0.0 ? d1 * (double)((float)j / 6.0f) : d3 / d2;
            for (int k = 1; k < 4; ++k) {
                if (p_213481_0_.field_70170_p.func_180495_p(new BlockPos(p_213481_0_.func_226277_ct_() + d4, p_213481_0_.func_226278_cu_() + (double)k, p_213481_0_.func_226281_cx_() + d3)).func_185904_a().func_76222_j()) continue;
                return false;
            }
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d func_241205_ce_() {
        return new Vector3d(0.0, 0.55f * this.func_70047_e(), this.func_213311_cf() * 0.4f);
    }

    class WatchGoal
    extends LookAtGoal {
        public WatchGoal(MobEntity p_i50733_2_, Class<? extends LivingEntity> p_i50733_3_, float p_i50733_4_) {
            super(p_i50733_2_, p_i50733_3_, p_i50733_4_);
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !FoxEntity.this.func_213472_dX() && !FoxEntity.this.func_213467_eg();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && !FoxEntity.this.func_213472_dX() && !FoxEntity.this.func_213467_eg();
        }
    }

    public static enum Type {
        RED(0, "red", Biomes.field_76768_g, Biomes.field_76784_u, Biomes.field_150590_f, Biomes.field_150578_U, Biomes.field_185432_ad, Biomes.field_150581_V, Biomes.field_185433_ae),
        SNOW(1, "snow", Biomes.field_150584_S, Biomes.field_150579_T, Biomes.field_185431_ac);

        private static final Type[] field_221088_c;
        private static final Map<String, Type> field_221089_d;
        private final int field_221090_e;
        private final String field_221091_f;
        private final List<RegistryKey<Biome>> field_221092_g;

        private Type(int p_i241911_3_, String p_i241911_4_, RegistryKey<Biome> ... p_i241911_5_) {
            this.field_221090_e = p_i241911_3_;
            this.field_221091_f = p_i241911_4_;
            this.field_221092_g = Arrays.asList(p_i241911_5_);
        }

        public String func_221082_a() {
            return this.field_221091_f;
        }

        public int func_221083_c() {
            return this.field_221090_e;
        }

        public static Type func_221087_a(String nameIn) {
            return field_221089_d.getOrDefault(nameIn, RED);
        }

        public static Type func_221080_a(int indexIn) {
            if (indexIn < 0 || indexIn > field_221088_c.length) {
                indexIn = 0;
            }
            return field_221088_c[indexIn];
        }

        public static Type func_242325_a(Optional<RegistryKey<Biome>> p_242325_0_) {
            return p_242325_0_.isPresent() && Type.SNOW.field_221092_g.contains(p_242325_0_.get()) ? SNOW : RED;
        }

        static {
            field_221088_c = (Type[])Arrays.stream(Type.values()).sorted(Comparator.comparingInt(Type::func_221083_c)).toArray(Type[]::new);
            field_221089_d = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::func_221082_a, p_221081_0_ -> p_221081_0_));
        }
    }

    class SwimGoal
    extends net.minecraft.entity.ai.goal.SwimGoal {
        public SwimGoal() {
            super((MobEntity)((Object)FoxEntity.this));
        }

        public void func_75249_e() {
            super.func_75249_e();
            FoxEntity.this.func_213499_en();
        }

        public boolean func_75250_a() {
            return FoxEntity.this.func_70090_H() && FoxEntity.this.func_233571_b_(FluidTags.field_206959_a) > 0.25 || FoxEntity.this.func_180799_ab();
        }
    }

    class StrollGoal
    extends MoveThroughVillageAtNightGoal {
        public StrollGoal(int p_i50726_2_, int p_i50726_3_) {
            super((CreatureEntity)FoxEntity.this, p_i50726_3_);
        }

        public void func_75249_e() {
            FoxEntity.this.func_213499_en();
            super.func_75249_e();
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && this.func_220759_g();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && this.func_220759_g();
        }

        private boolean func_220759_g() {
            return !FoxEntity.this.func_70608_bn() && !FoxEntity.this.func_213455_dW() && !FoxEntity.this.func_213473_el() && FoxEntity.this.func_70638_az() == null;
        }
    }

    class SleepGoal
    extends BaseGoal {
        private int field_220825_c;

        public SleepGoal() {
            this.field_220825_c = FoxEntity.this.field_70146_Z.nextInt(140);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean func_75250_a() {
            if (FoxEntity.this.field_70702_br == 0.0f && FoxEntity.this.field_70701_bs == 0.0f && FoxEntity.this.field_191988_bg == 0.0f) {
                return this.func_220823_j() || FoxEntity.this.func_70608_bn();
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.func_220823_j();
        }

        private boolean func_220823_j() {
            if (this.field_220825_c > 0) {
                --this.field_220825_c;
                return false;
            }
            return FoxEntity.this.field_70170_p.func_72935_r() && this.func_220813_g() && !this.func_220814_h();
        }

        public void func_75251_c() {
            this.field_220825_c = FoxEntity.this.field_70146_Z.nextInt(140);
            FoxEntity.this.func_213499_en();
        }

        public void func_75249_e() {
            FoxEntity.this.func_213466_r(false);
            FoxEntity.this.func_213451_t(false);
            FoxEntity.this.func_213502_u(false);
            FoxEntity.this.func_70637_d(false);
            FoxEntity.this.func_213485_x(true);
            FoxEntity.this.func_70661_as().func_75499_g();
            FoxEntity.this.func_70605_aq().func_75642_a(FoxEntity.this.func_226277_ct_(), FoxEntity.this.func_226278_cu_(), FoxEntity.this.func_226281_cx_(), 0.0);
        }
    }

    class SitAndLookGoal
    extends BaseGoal {
        private double field_220819_c;
        private double field_220820_d;
        private int field_220821_e;
        private int field_220822_f;

        public SitAndLookGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return FoxEntity.this.func_70643_av() == null && FoxEntity.this.func_70681_au().nextFloat() < 0.02f && !FoxEntity.this.func_70608_bn() && FoxEntity.this.func_70638_az() == null && FoxEntity.this.func_70661_as().func_75500_f() && !this.func_220814_h() && !FoxEntity.this.func_213480_dY() && !FoxEntity.this.func_213453_ef();
        }

        public boolean func_75253_b() {
            return this.field_220822_f > 0;
        }

        public void func_75249_e() {
            this.func_220817_j();
            this.field_220822_f = 2 + FoxEntity.this.func_70681_au().nextInt(3);
            FoxEntity.this.func_213466_r(true);
            FoxEntity.this.func_70661_as().func_75499_g();
        }

        public void func_75251_c() {
            FoxEntity.this.func_213466_r(false);
        }

        public void func_75246_d() {
            --this.field_220821_e;
            if (this.field_220821_e <= 0) {
                --this.field_220822_f;
                this.func_220817_j();
            }
            FoxEntity.this.func_70671_ap().func_75650_a(FoxEntity.this.func_226277_ct_() + this.field_220819_c, FoxEntity.this.func_226280_cw_(), FoxEntity.this.func_226281_cx_() + this.field_220820_d, (float)FoxEntity.this.func_184649_cE(), (float)FoxEntity.this.func_70646_bf());
        }

        private void func_220817_j() {
            double d0 = Math.PI * 2 * FoxEntity.this.func_70681_au().nextDouble();
            this.field_220819_c = Math.cos(d0);
            this.field_220820_d = Math.sin(d0);
            this.field_220821_e = 80 + FoxEntity.this.func_70681_au().nextInt(20);
        }
    }

    class RevengeGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        @Nullable
        private LivingEntity field_220786_j;
        private LivingEntity field_220787_k;
        private int field_220788_l;

        public RevengeGoal(Class<LivingEntity> p_i50743_2_, boolean p_i50743_3_, @Nullable boolean p_i50743_4_, Predicate<LivingEntity> p_i50743_5_) {
            super((MobEntity)((Object)FoxEntity.this), p_i50743_2_, 10, p_i50743_3_, p_i50743_4_, p_i50743_5_);
        }

        public boolean func_75250_a() {
            if (this.field_75308_c > 0 && this.field_75299_d.func_70681_au().nextInt(this.field_75308_c) != 0) {
                return false;
            }
            for (UUID uuid : FoxEntity.this.func_213479_ek()) {
                LivingEntity livingentity;
                Entity entity;
                if (uuid == null || !(FoxEntity.this.field_70170_p instanceof ServerWorld) || !((entity = ((ServerWorld)FoxEntity.this.field_70170_p).func_217461_a(uuid)) instanceof LivingEntity)) continue;
                this.field_220787_k = livingentity = (LivingEntity)entity;
                this.field_220786_j = livingentity.func_70643_av();
                int i = livingentity.func_142015_aE();
                return i != this.field_220788_l && this.func_220777_a(this.field_220786_j, this.field_220779_d);
            }
            return false;
        }

        public void func_75249_e() {
            this.func_234054_a_(this.field_220786_j);
            this.field_75309_a = this.field_220786_j;
            if (this.field_220787_k != null) {
                this.field_220788_l = this.field_220787_k.func_142015_aE();
            }
            FoxEntity.this.func_184185_a(SoundEvents.field_219630_dt, 1.0f, 1.0f);
            FoxEntity.this.func_213482_w(true);
            FoxEntity.this.func_213454_em();
            super.func_75249_e();
        }
    }

    public class PounceGoal
    extends net.minecraft.entity.ai.goal.JumpGoal {
        public boolean func_75250_a() {
            if (!FoxEntity.this.func_213490_ee()) {
                return false;
            }
            LivingEntity livingentity = FoxEntity.this.func_70638_az();
            if (livingentity != null && livingentity.func_70089_S()) {
                if (livingentity.func_184172_bi() != livingentity.func_174811_aO()) {
                    return false;
                }
                boolean flag = FoxEntity.func_213481_a(FoxEntity.this, livingentity);
                if (!flag) {
                    FoxEntity.this.func_70661_as().func_75494_a((Entity)livingentity, 0);
                    FoxEntity.this.func_213451_t(false);
                    FoxEntity.this.func_213502_u(false);
                }
                return flag;
            }
            return false;
        }

        public boolean func_75253_b() {
            LivingEntity livingentity = FoxEntity.this.func_70638_az();
            if (livingentity != null && livingentity.func_70089_S()) {
                double d0 = FoxEntity.this.func_213322_ci().field_72448_b;
                return !(d0 * d0 < (double)0.05f && Math.abs(FoxEntity.this.field_70125_A) < 15.0f && FoxEntity.this.field_70122_E || FoxEntity.this.func_213472_dX());
            }
            return false;
        }

        public boolean func_220685_C_() {
            return false;
        }

        public void func_75249_e() {
            FoxEntity.this.func_70637_d(true);
            FoxEntity.this.func_213461_s(true);
            FoxEntity.this.func_213502_u(false);
            LivingEntity livingentity = FoxEntity.this.func_70638_az();
            FoxEntity.this.func_70671_ap().func_75651_a((Entity)livingentity, 60.0f, 30.0f);
            Vector3d vector3d = new Vector3d(livingentity.func_226277_ct_() - FoxEntity.this.func_226277_ct_(), livingentity.func_226278_cu_() - FoxEntity.this.func_226278_cu_(), livingentity.func_226281_cx_() - FoxEntity.this.func_226281_cx_()).func_72432_b();
            FoxEntity.this.func_213317_d(FoxEntity.this.func_213322_ci().func_72441_c(vector3d.field_72450_a * 0.8, 0.9, vector3d.field_72449_c * 0.8));
            FoxEntity.this.func_70661_as().func_75499_g();
        }

        public void func_75251_c() {
            FoxEntity.this.func_213451_t(false);
            FoxEntity.this.field_213520_bN = 0.0f;
            FoxEntity.this.field_213521_bO = 0.0f;
            FoxEntity.this.func_213502_u(false);
            FoxEntity.this.func_213461_s(false);
        }

        public void func_75246_d() {
            LivingEntity livingentity = FoxEntity.this.func_70638_az();
            if (livingentity != null) {
                FoxEntity.this.func_70671_ap().func_75651_a((Entity)livingentity, 60.0f, 30.0f);
            }
            if (!FoxEntity.this.func_213472_dX()) {
                Vector3d vector3d = FoxEntity.this.func_213322_ci();
                if (vector3d.field_72448_b * vector3d.field_72448_b < (double)0.03f && FoxEntity.this.field_70125_A != 0.0f) {
                    FoxEntity.this.field_70125_A = MathHelper.func_226167_j_((float)FoxEntity.this.field_70125_A, (float)0.0f, (float)0.2f);
                } else {
                    double d0 = Math.sqrt(Entity.func_213296_b(vector3d));
                    double d1 = Math.signum(-vector3d.field_72448_b) * Math.acos(d0 / vector3d.func_72433_c()) * 57.2957763671875;
                    FoxEntity.this.field_70125_A = (float)d1;
                }
            }
            if (livingentity != null && FoxEntity.this.func_70032_d(livingentity) <= 2.0f) {
                FoxEntity.this.func_70652_k(livingentity);
            } else if (FoxEntity.this.field_70125_A > 0.0f && FoxEntity.this.field_70122_E && (float)FoxEntity.this.func_213322_ci().field_72448_b != 0.0f && FoxEntity.this.field_70170_p.func_180495_p(FoxEntity.this.func_233580_cy_()).func_203425_a(Blocks.field_150433_aE)) {
                FoxEntity.this.field_70125_A = 60.0f;
                FoxEntity.this.func_70624_b(null);
                FoxEntity.this.func_213492_v(true);
            }
        }
    }

    class PanicGoal
    extends net.minecraft.entity.ai.goal.PanicGoal {
        public PanicGoal(double p_i50729_2_) {
            super((CreatureEntity)FoxEntity.this, p_i50729_2_);
        }

        public boolean func_75250_a() {
            return !FoxEntity.this.func_213473_el() && super.func_75250_a();
        }
    }

    class MoveHelperController
    extends MovementController {
        public MoveHelperController() {
            super((MobEntity)((Object)FoxEntity.this));
        }

        public void func_75641_c() {
            if (FoxEntity.this.func_213478_eo()) {
                super.func_75641_c();
            }
        }
    }

    class MateGoal
    extends BreedGoal {
        public MateGoal(double p_i50738_2_) {
            super((AnimalEntity)FoxEntity.this, p_i50738_2_);
        }

        public void func_75249_e() {
            ((FoxEntity)this.field_75390_d).func_213499_en();
            ((FoxEntity)this.field_75391_e).func_213499_en();
            super.func_75249_e();
        }

        protected void func_75388_i() {
            ServerWorld serverworld = (ServerWorld)this.field_75394_a;
            FoxEntity foxentity = (FoxEntity)this.field_75390_d.func_241840_a(serverworld, this.field_75391_e);
            BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((MobEntity)((Object)this.field_75390_d), (MobEntity)((Object)this.field_75391_e), (AgeableEntity)foxentity);
            boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)event);
            foxentity = (FoxEntity)event.getChild();
            if (cancelled) {
                this.field_75390_d.func_70873_a(6000);
                this.field_75391_e.func_70873_a(6000);
                this.field_75390_d.func_70875_t();
                this.field_75391_e.func_70875_t();
                return;
            }
            if (foxentity != null) {
                ServerPlayerEntity serverplayerentity = this.field_75390_d.func_191993_do();
                ServerPlayerEntity serverplayerentity1 = this.field_75391_e.func_191993_do();
                ServerPlayerEntity serverplayerentity2 = serverplayerentity;
                if (serverplayerentity != null) {
                    foxentity.func_213465_b(serverplayerentity.func_110124_au());
                } else {
                    serverplayerentity2 = serverplayerentity1;
                }
                if (serverplayerentity1 != null && serverplayerentity != serverplayerentity1) {
                    foxentity.func_213465_b(serverplayerentity1.func_110124_au());
                }
                if (serverplayerentity2 != null) {
                    serverplayerentity2.func_195066_a(Stats.field_151186_x);
                    CriteriaTriggers.field_192134_n.func_192168_a(serverplayerentity2, this.field_75390_d, this.field_75391_e, (AgeableEntity)foxentity);
                }
                this.field_75390_d.func_70873_a(6000);
                this.field_75391_e.func_70873_a(6000);
                this.field_75390_d.func_70875_t();
                this.field_75391_e.func_70875_t();
                foxentity.func_70873_a(-24000);
                foxentity.func_70012_b(this.field_75390_d.func_226277_ct_(), this.field_75390_d.func_226278_cu_(), this.field_75390_d.func_226281_cx_(), 0.0f, 0.0f);
                serverworld.func_242417_l((Entity)((Object)foxentity));
                this.field_75394_a.func_72960_a((Entity)((Object)this.field_75390_d), (byte)18);
                if (this.field_75394_a.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                    this.field_75394_a.func_217376_c(new ExperienceOrbEntity(this.field_75394_a, this.field_75390_d.func_226277_ct_(), this.field_75390_d.func_226278_cu_(), this.field_75390_d.func_226281_cx_(), this.field_75390_d.func_70681_au().nextInt(7) + 1));
                }
            }
        }
    }

    public class LookHelperController
    extends LookController {
        public LookHelperController() {
            super((MobEntity)((Object)FoxEntity.this));
        }

        public void func_75649_a() {
            if (!FoxEntity.this.func_70608_bn()) {
                super.func_75649_a();
            }
        }

        protected boolean func_220680_b() {
            return !FoxEntity.this.func_213480_dY() && !FoxEntity.this.func_213453_ef() && !FoxEntity.this.func_213467_eg() & !FoxEntity.this.func_213472_dX();
        }
    }

    class JumpGoal
    extends Goal {
        int field_220811_a;

        public JumpGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return FoxEntity.this.func_213472_dX();
        }

        public boolean func_75253_b() {
            return this.func_75250_a() && this.field_220811_a > 0;
        }

        public void func_75249_e() {
            this.field_220811_a = 40;
        }

        public void func_75251_c() {
            FoxEntity.this.func_213492_v(false);
        }

        public void func_75246_d() {
            --this.field_220811_a;
        }
    }

    public static class FoxData
    extends AgeableEntity.AgeableData {
        public final Type field_220366_a;

        public FoxData(Type p_i50734_1_) {
            super(false);
            this.field_220366_a = p_i50734_1_;
        }
    }

    class FollowTargetGoal
    extends Goal {
        public FollowTargetGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            if (FoxEntity.this.func_70608_bn()) {
                return false;
            }
            LivingEntity livingentity = FoxEntity.this.func_70638_az();
            return livingentity != null && livingentity.func_70089_S() && field_213513_bG.test(livingentity) && FoxEntity.this.func_70068_e(livingentity) > 36.0 && !FoxEntity.this.func_213453_ef() && !FoxEntity.this.func_213467_eg() && !FoxEntity.this.field_70703_bu;
        }

        public void func_75249_e() {
            FoxEntity.this.func_213466_r(false);
            FoxEntity.this.func_213492_v(false);
        }

        public void func_75251_c() {
            LivingEntity livingentity = FoxEntity.this.func_70638_az();
            if (livingentity != null && FoxEntity.func_213481_a(FoxEntity.this, livingentity)) {
                FoxEntity.this.func_213502_u(true);
                FoxEntity.this.func_213451_t(true);
                FoxEntity.this.func_70661_as().func_75499_g();
                FoxEntity.this.func_70671_ap().func_75651_a((Entity)livingentity, (float)FoxEntity.this.func_184649_cE(), (float)FoxEntity.this.func_70646_bf());
            } else {
                FoxEntity.this.func_213502_u(false);
                FoxEntity.this.func_213451_t(false);
            }
        }

        public void func_75246_d() {
            LivingEntity livingentity = FoxEntity.this.func_70638_az();
            FoxEntity.this.func_70671_ap().func_75651_a((Entity)livingentity, (float)FoxEntity.this.func_184649_cE(), (float)FoxEntity.this.func_70646_bf());
            if (FoxEntity.this.func_70068_e(livingentity) <= 36.0) {
                FoxEntity.this.func_213502_u(true);
                FoxEntity.this.func_213451_t(true);
                FoxEntity.this.func_70661_as().func_75499_g();
            } else {
                FoxEntity.this.func_70661_as().func_75497_a((Entity)livingentity, 1.5);
            }
        }
    }

    class FollowGoal
    extends FollowParentGoal {
        private final FoxEntity field_220706_b;

        public FollowGoal(FoxEntity p_i50735_2_, double p_i50735_3_) {
            super((AnimalEntity)p_i50735_2_, p_i50735_3_);
            this.field_220706_b = p_i50735_2_;
        }

        public boolean func_75250_a() {
            return !this.field_220706_b.func_213473_el() && super.func_75250_a();
        }

        public boolean func_75253_b() {
            return !this.field_220706_b.func_213473_el() && super.func_75253_b();
        }

        public void func_75249_e() {
            this.field_220706_b.func_213499_en();
            super.func_75249_e();
        }
    }

    class FindShelterGoal
    extends FleeSunGoal {
        private int field_220704_c;

        public FindShelterGoal(double p_i50724_2_) {
            super((CreatureEntity)FoxEntity.this, p_i50724_2_);
            this.field_220704_c = 100;
        }

        public boolean func_75250_a() {
            if (!FoxEntity.this.func_70608_bn() && this.field_75372_a.func_70638_az() == null) {
                if (FoxEntity.this.field_70170_p.func_72911_I()) {
                    return true;
                }
                if (this.field_220704_c > 0) {
                    --this.field_220704_c;
                    return false;
                }
                this.field_220704_c = 100;
                BlockPos blockpos = this.field_75372_a.func_233580_cy_();
                return FoxEntity.this.field_70170_p.func_72935_r() && FoxEntity.this.field_70170_p.func_226660_f_(blockpos) && !((ServerWorld)FoxEntity.this.field_70170_p).func_217483_b_(blockpos) && this.func_220702_g();
            }
            return false;
        }

        public void func_75249_e() {
            FoxEntity.this.func_213499_en();
            super.func_75249_e();
        }
    }

    class FindItemsGoal
    extends Goal {
        public FindItemsGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (!FoxEntity.this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b()) {
                return false;
            }
            if (FoxEntity.this.func_70638_az() == null && FoxEntity.this.func_70643_av() == null) {
                if (!FoxEntity.this.func_213478_eo()) {
                    return false;
                }
                if (FoxEntity.this.func_70681_au().nextInt(10) != 0) {
                    return false;
                }
                List<ItemEntity> list = FoxEntity.this.field_70170_p.func_175647_a(ItemEntity.class, FoxEntity.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), field_213511_bE);
                return !list.isEmpty() && FoxEntity.this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b();
            }
            return false;
        }

        public void func_75246_d() {
            List<ItemEntity> list = FoxEntity.this.field_70170_p.func_175647_a(ItemEntity.class, FoxEntity.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), field_213511_bE);
            ItemStack itemstack = FoxEntity.this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (itemstack.func_190926_b() && !list.isEmpty()) {
                FoxEntity.this.func_70661_as().func_75497_a((Entity)list.get(0), (double)1.2f);
            }
        }

        public void func_75249_e() {
            List<ItemEntity> list = FoxEntity.this.field_70170_p.func_175647_a(ItemEntity.class, FoxEntity.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), field_213511_bE);
            if (!list.isEmpty()) {
                FoxEntity.this.func_70661_as().func_75497_a((Entity)list.get(0), (double)1.2f);
            }
        }
    }

    public class EatBerriesGoal
    extends MoveToBlockGoal {
        protected int field_220731_g;

        public EatBerriesGoal(double p_i50737_2_, int p_i50737_4_, int p_i50737_5_) {
            super((CreatureEntity)FoxEntity.this, p_i50737_2_, p_i50737_4_, p_i50737_5_);
        }

        public double func_203110_f() {
            return 2.0;
        }

        public boolean func_203108_i() {
            return this.field_179493_e % 100 == 0;
        }

        protected boolean func_179488_a(IWorldReader worldIn, BlockPos pos) {
            BlockState blockstate = worldIn.func_180495_p(pos);
            return blockstate.func_203425_a(Blocks.field_222434_lW) && (Integer)blockstate.func_177229_b((Property)SweetBerryBushBlock.field_220125_a) >= 2;
        }

        public void func_75246_d() {
            if (this.func_179487_f()) {
                if (this.field_220731_g >= 40) {
                    this.func_220730_m();
                } else {
                    ++this.field_220731_g;
                }
            } else if (!this.func_179487_f() && FoxEntity.this.field_70146_Z.nextFloat() < 0.05f) {
                FoxEntity.this.func_184185_a(SoundEvents.field_219628_dB, 1.0f, 1.0f);
            }
            super.func_75246_d();
        }

        protected void func_220730_m() {
            BlockState blockstate;
            if (ForgeEventFactory.getMobGriefingEvent((World)FoxEntity.this.field_70170_p, (Entity)((Object)FoxEntity.this)) && (blockstate = FoxEntity.this.field_70170_p.func_180495_p(this.field_179494_b)).func_203425_a(Blocks.field_222434_lW)) {
                int i = (Integer)blockstate.func_177229_b((Property)SweetBerryBushBlock.field_220125_a);
                blockstate.func_206870_a((Property)SweetBerryBushBlock.field_220125_a, Integer.valueOf(1));
                int j = 1 + FoxEntity.this.field_70170_p.field_73012_v.nextInt(2) + (i == 3 ? 1 : 0);
                ItemStack itemstack = FoxEntity.this.func_184582_a(EquipmentSlotType.MAINHAND);
                if (itemstack.func_190926_b()) {
                    FoxEntity.this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack(Items.field_222112_pR));
                    --j;
                }
                if (j > 0) {
                    Block.func_180635_a(FoxEntity.this.field_70170_p, this.field_179494_b, new ItemStack(Items.field_222112_pR, j));
                }
                FoxEntity.this.func_184185_a(SoundEvents.field_219693_lB, 1.0f, 1.0f);
                FoxEntity.this.field_70170_p.func_180501_a(this.field_179494_b, (BlockState)((Object)blockstate.func_206870_a((Property)SweetBerryBushBlock.field_220125_a, Integer.valueOf(1))), 2);
            }
        }

        public boolean func_75250_a() {
            return !FoxEntity.this.func_70608_bn() && super.func_75250_a();
        }

        public void func_75249_e() {
            this.field_220731_g = 0;
            FoxEntity.this.func_213466_r(false);
            super.func_75249_e();
        }
    }

    class BiteGoal
    extends MeleeAttackGoal {
        public BiteGoal(double p_i50731_2_, boolean p_i50731_4_) {
            super((CreatureEntity)FoxEntity.this, p_i50731_2_, p_i50731_4_);
        }

        @Override
        protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.func_179512_a(enemy);
            if (distToEnemySqr <= d0 && this.func_234040_h_()) {
                this.func_234039_g_();
                this.field_75441_b.func_70652_k((Entity)enemy);
                FoxEntity.this.func_184185_a(SoundEvents.field_219632_dv, 1.0f, 1.0f);
            }
        }

        @Override
        public void func_75249_e() {
            FoxEntity.this.func_213502_u(false);
            super.func_75249_e();
        }

        @Override
        public boolean func_75250_a() {
            return !FoxEntity.this.func_213455_dW() && !FoxEntity.this.func_70608_bn() && !FoxEntity.this.func_213453_ef() && !FoxEntity.this.func_213472_dX() && super.func_75250_a();
        }
    }

    abstract class BaseGoal
    extends Goal {
        private final EntityPredicate field_220816_b;

        private BaseGoal() {
            this.field_220816_b = new EntityPredicate().func_221013_a(12.0).func_221014_c().func_221012_a((Predicate)new AlertablePredicate());
        }

        protected boolean func_220813_g() {
            BlockPos blockpos = new BlockPos(FoxEntity.this.func_226277_ct_(), FoxEntity.this.func_174813_aQ().field_72337_e, FoxEntity.this.func_226281_cx_());
            return !FoxEntity.this.field_70170_p.func_226660_f_(blockpos) && FoxEntity.this.func_180484_a(blockpos) >= 0.0f;
        }

        protected boolean func_220814_h() {
            return !FoxEntity.this.field_70170_p.func_217374_a(LivingEntity.class, this.field_220816_b, (LivingEntity)((Object)FoxEntity.this), FoxEntity.this.func_174813_aQ().func_72314_b(12.0, 6.0, 12.0)).isEmpty();
        }
    }

    public class AlertablePredicate
    implements Predicate<LivingEntity> {
        @Override
        public boolean test(LivingEntity p_test_1_) {
            if (p_test_1_ instanceof FoxEntity) {
                return false;
            }
            if (!(p_test_1_ instanceof ChickenEntity || p_test_1_ instanceof RabbitEntity || p_test_1_ instanceof MonsterEntity)) {
                if (p_test_1_ instanceof TameableEntity) {
                    return !((TameableEntity)p_test_1_).func_70909_n();
                }
                if (!(p_test_1_ instanceof PlayerEntity) || !p_test_1_.func_175149_v() && !((PlayerEntity)p_test_1_).func_184812_l_()) {
                    if (FoxEntity.this.func_213468_c(p_test_1_.func_110124_au())) {
                        return false;
                    }
                    return !p_test_1_.func_70608_bn() && !p_test_1_.func_226273_bm_();
                }
                return false;
            }
            return true;
        }
    }
}

