/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BegGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.ResetAngerGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TickRangeConverter;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class WolfEntity
extends TameableEntity
implements IAngerable {
    private static final DataParameter<Boolean> field_184760_bA = EntityDataManager.func_187226_a(WolfEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Integer> field_184758_bB = EntityDataManager.func_187226_a(WolfEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_234232_bz_ = EntityDataManager.func_187226_a(WolfEntity.class, DataSerializers.field_187192_b);
    public static final Predicate<LivingEntity> field_213441_bD = p_213440_0_ -> {
        EntityType<?> entitytype = p_213440_0_.func_200600_R();
        return entitytype == EntityType.field_200737_ac || entitytype == EntityType.field_200736_ab || entitytype == EntityType.field_220356_B;
    };
    private float field_70926_e;
    private float field_70924_f;
    private boolean field_70925_g;
    private boolean field_70928_h;
    private float field_70929_i;
    private float field_70927_j;
    private static final RangedInteger field_234230_bG_ = TickRangeConverter.func_233037_a_((int)20, (int)39);
    private UUID field_234231_bH_;

    public WolfEntity(EntityType<? extends WolfEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_70903_f(false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)((Object)this)));
        this.field_70714_bg.func_75776_a(2, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(3, new AvoidEntityGoal<LlamaEntity>(this, LlamaEntity.class, 24.0f, 1.5, 1.5));
        this.field_70714_bg.func_75776_a(4, (Goal)new LeapAtTargetGoal((MobEntity)((Object)this), 0.4f));
        this.field_70714_bg.func_75776_a(5, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new BreedGoal((AnimalEntity)((Object)this), 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (Goal)new BegGoal(this, 8.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)((Object)this), PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookRandomlyGoal((MobEntity)((Object)this)));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)((Object)this), PlayerEntity.class, 10, true, false, arg_0 -> ((WolfEntity)this).func_233680_b_(arg_0)));
        this.field_70715_bh.func_75776_a(5, (Goal)new NonTamedTargetGoal((TameableEntity)this, AnimalEntity.class, false, field_213441_bD));
        this.field_70715_bh.func_75776_a(6, (Goal)new NonTamedTargetGoal((TameableEntity)this, TurtleEntity.class, false, TurtleEntity.field_203029_bx));
        this.field_70715_bh.func_75776_a(7, (Goal)new NearestAttackableTargetGoal((MobEntity)((Object)this), AbstractSkeletonEntity.class, false));
        this.field_70715_bh.func_75776_a(8, (Goal)new ResetAngerGoal((MobEntity)((Object)this), true));
    }

    public static AttributeModifierMap.MutableAttribute func_234233_eS_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233818_a_, 8.0).func_233815_a_(Attributes.field_233823_f_, 2.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184760_bA, false);
        this.field_70180_af.func_187214_a(field_184758_bB, DyeColor.RED.func_196059_a());
        this.field_70180_af.func_187214_a(field_234232_bz_, 0);
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74774_a("CollarColor", (byte)this.func_175546_cu().func_196059_a());
        this.func_233682_c_(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("CollarColor", 99)) {
            this.func_175547_a(DyeColor.func_196056_a(compound.func_74762_e("CollarColor")));
        }
        this.func_241358_a_((ServerWorld)this.field_70170_p, compound);
    }

    protected SoundEvent func_184639_G() {
        if (this.func_233678_J__()) {
            return SoundEvents.field_187861_gG;
        }
        if (this.field_70146_Z.nextInt(3) == 0) {
            return this.func_70909_n() && this.func_110143_aJ() < 10.0f ? SoundEvents.field_187871_gL : SoundEvents.field_187865_gI;
        }
        return SoundEvents.field_187857_gE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187863_gH;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187859_gF;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.field_70925_g && !this.field_70928_h && !this.func_70781_l() && this.field_70122_E) {
            this.field_70928_h = true;
            this.field_70929_i = 0.0f;
            this.field_70927_j = 0.0f;
            this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)8);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_241359_a_((ServerWorld)this.field_70170_p, true);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70089_S()) {
            this.field_70924_f = this.field_70926_e;
            this.field_70926_e = this.func_70922_bv() ? (this.field_70926_e += (1.0f - this.field_70926_e) * 0.4f) : (this.field_70926_e += (0.0f - this.field_70926_e) * 0.4f);
            if (this.func_203008_ap()) {
                this.field_70925_g = true;
                if (this.field_70928_h && !this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)56);
                    this.func_242326_eZ();
                }
            } else if ((this.field_70925_g || this.field_70928_h) && this.field_70928_h) {
                if (this.field_70929_i == 0.0f) {
                    this.func_184185_a(SoundEvents.field_187867_gJ, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                }
                this.field_70927_j = this.field_70929_i;
                this.field_70929_i += 0.05f;
                if (this.field_70927_j >= 2.0f) {
                    this.field_70925_g = false;
                    this.field_70928_h = false;
                    this.field_70927_j = 0.0f;
                    this.field_70929_i = 0.0f;
                }
                if (this.field_70929_i > 0.4f) {
                    float f = (float)this.func_226278_cu_();
                    int i = (int)(MathHelper.func_76126_a((float)((this.field_70929_i - 0.4f) * (float)Math.PI)) * 7.0f);
                    Vector3d vector3d = this.func_213322_ci();
                    for (int j = 0; j < i; ++j) {
                        float f1 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.func_213311_cf() * 0.5f;
                        float f2 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.func_213311_cf() * 0.5f;
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, this.func_226277_ct_() + (double)f1, f + 0.8f, this.func_226281_cx_() + (double)f2, vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
                    }
                }
            }
        }
    }

    private void func_242326_eZ() {
        this.field_70928_h = false;
        this.field_70929_i = 0.0f;
        this.field_70927_j = 0.0f;
    }

    public void func_70645_a(DamageSource cause) {
        this.field_70925_g = false;
        this.field_70928_h = false;
        this.field_70927_j = 0.0f;
        this.field_70929_i = 0.0f;
        super.func_70645_a(cause);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70921_u() {
        return this.field_70925_g;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_70915_j(float p_70915_1_) {
        return Math.min(0.5f + MathHelper.func_219799_g((float)p_70915_1_, (float)this.field_70927_j, (float)this.field_70929_i) / 2.0f * 0.5f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_70923_f(float p_70923_1_, float p_70923_2_) {
        float f = (MathHelper.func_219799_g((float)p_70923_1_, (float)this.field_70927_j, (float)this.field_70929_i) + p_70923_2_) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return MathHelper.func_76126_a((float)(f * (float)Math.PI)) * MathHelper.func_76126_a((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_70917_k(float p_70917_1_) {
        return MathHelper.func_219799_g((float)p_70917_1_, (float)this.field_70924_f, (float)this.field_70926_e) * 0.15f * (float)Math.PI;
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.8f;
    }

    public int func_70646_bf() {
        return this.func_233684_eK_() ? 20 : super.func_70646_bf();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        this.func_233687_w_(false);
        if (entity != null && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)((Object)this)), (int)this.func_233637_b_(Attributes.field_233823_f_));
        if (flag) {
            this.func_174815_a((LivingEntity)((Object)this), entityIn);
        }
        return flag;
    }

    public void func_70903_f(boolean tamed) {
        super.func_70903_f(tamed);
        if (tamed) {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(20.0);
            this.func_70606_j(20.0f);
        } else {
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(8.0);
        }
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(4.0);
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        Item item = itemstack.func_77973_b();
        if (this.field_70170_p.field_72995_K) {
            boolean flag = this.func_152114_e(p_230254_1_) || this.func_70909_n() || item == Items.field_151103_aS && !this.func_70909_n() && !this.func_233678_J__();
            return flag ? ActionResultType.CONSUME : ActionResultType.PASS;
        }
        if (this.func_70909_n()) {
            if (this.func_70877_b(itemstack) && this.func_110143_aJ() < this.func_110138_aP()) {
                if (!p_230254_1_.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                this.func_70691_i(item.func_219967_s().func_221466_a());
                return ActionResultType.SUCCESS;
            }
            if (!(item instanceof DyeItem)) {
                ActionResultType actionresulttype = super.func_230254_b_(p_230254_1_, p_230254_2_);
                if ((!actionresulttype.func_226246_a_() || this.func_70631_g_()) && this.func_152114_e(p_230254_1_)) {
                    this.func_233687_w_(!this.func_233685_eM_());
                    this.field_70703_bu = false;
                    this.field_70699_by.func_75499_g();
                    this.func_70624_b(null);
                    return ActionResultType.SUCCESS;
                }
                return actionresulttype;
            }
            DyeColor dyecolor = ((DyeItem)item).func_195962_g();
            if (dyecolor != this.func_175546_cu()) {
                this.func_175547_a(dyecolor);
                if (!p_230254_1_.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
        } else if (item == Items.field_151103_aS && !this.func_233678_J__()) {
            if (!p_230254_1_.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((AnimalEntity)((Object)this), (PlayerEntity)p_230254_1_)) {
                this.func_193101_c(p_230254_1_);
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                this.func_233687_w_(true);
                this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)7);
            } else {
                this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)6);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 8) {
            this.field_70928_h = true;
            this.field_70929_i = 0.0f;
            this.field_70927_j = 0.0f;
        } else if (id == 56) {
            this.func_242326_eZ();
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_70920_v() {
        if (this.func_233678_J__()) {
            return 1.5393804f;
        }
        return this.func_70909_n() ? (0.55f - (this.func_110138_aP() - this.func_110143_aJ()) * 0.02f) * (float)Math.PI : 0.62831855f;
    }

    public boolean func_70877_b(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item.func_219971_r() && item.func_219967_s().func_221467_c();
    }

    public int func_70641_bl() {
        return 8;
    }

    public int func_230256_F__() {
        return this.field_70180_af.func_187225_a(field_234232_bz_);
    }

    public void func_230260_a__(int p_230260_1_) {
        this.field_70180_af.func_187227_b(field_234232_bz_, p_230260_1_);
    }

    public void func_230258_H__() {
        this.func_230260_a__(field_234230_bG_.func_233018_a_(this.field_70146_Z));
    }

    @Nullable
    public UUID func_230257_G__() {
        return this.field_234231_bH_;
    }

    public void func_230259_a_(@Nullable UUID p_230259_1_) {
        this.field_234231_bH_ = p_230259_1_;
    }

    public DyeColor func_175546_cu() {
        return DyeColor.func_196056_a(this.field_70180_af.func_187225_a(field_184758_bB));
    }

    public void func_175547_a(DyeColor collarcolor) {
        this.field_70180_af.func_187227_b(field_184758_bB, collarcolor.func_196059_a());
    }

    public WolfEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        WolfEntity wolfentity = EntityType.field_200724_aC.func_200721_a(p_241840_1_);
        UUID uuid = this.func_184753_b();
        if (uuid != null) {
            wolfentity.func_184754_b(uuid);
            wolfentity.func_70903_f(true);
        }
        return wolfentity;
    }

    public void func_70918_i(boolean beg) {
        this.field_70180_af.func_187227_b(field_184760_bA, beg);
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(otherAnimal instanceof WolfEntity)) {
            return false;
        }
        WolfEntity wolfentity = (WolfEntity)((Object)otherAnimal);
        if (!wolfentity.func_70909_n()) {
            return false;
        }
        if (wolfentity.func_233684_eK_()) {
            return false;
        }
        return this.func_70880_s() && wolfentity.func_70880_s();
    }

    public boolean func_70922_bv() {
        return this.field_70180_af.func_187225_a(field_184760_bA);
    }

    public boolean func_142018_a(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof CreeperEntity) && !(target instanceof GhastEntity)) {
            if (target instanceof WolfEntity) {
                WolfEntity wolfentity = (WolfEntity)((Object)target);
                return !wolfentity.func_70909_n() || wolfentity.func_70902_q() != owner;
            }
            if (target instanceof PlayerEntity && owner instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a((PlayerEntity)target)) {
                return false;
            }
            if (target instanceof AbstractHorseEntity && ((AbstractHorseEntity)((Object)target)).func_110248_bS()) {
                return false;
            }
            return !(target instanceof TameableEntity) || !((TameableEntity)target).func_70909_n();
        }
        return false;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return !this.func_233678_J__() && super.func_184652_a(player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d func_241205_ce_() {
        return new Vector3d(0.0, 0.6f * this.func_70047_e(), this.func_213311_cf() * 0.4f);
    }

    class AvoidEntityGoal<T extends LivingEntity>
    extends net.minecraft.entity.ai.goal.AvoidEntityGoal<T> {
        private final WolfEntity field_190856_d;

        public AvoidEntityGoal(WolfEntity wolfIn, Class<T> entityClassToAvoidIn, float avoidDistanceIn, double farSpeedIn, double nearSpeedIn) {
            super((CreatureEntity)wolfIn, entityClassToAvoidIn, avoidDistanceIn, farSpeedIn, nearSpeedIn);
            this.field_190856_d = wolfIn;
        }

        public boolean func_75250_a() {
            if (super.func_75250_a() && this.field_75376_d instanceof LlamaEntity) {
                return !this.field_190856_d.func_70909_n() && this.func_190854_a((LlamaEntity)this.field_75376_d);
            }
            return false;
        }

        private boolean func_190854_a(LlamaEntity llamaIn) {
            return llamaIn.func_190707_dL() >= WolfEntity.this.field_70146_Z.nextInt(5);
        }

        public void func_75249_e() {
            WolfEntity.this.func_70624_b(null);
            super.func_75249_e();
        }

        public void func_75246_d() {
            WolfEntity.this.func_70624_b(null);
            super.func_75246_d();
        }
    }
}

