/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ShapedRecipe
implements ICraftingRecipe,
IShapedRecipe<CraftingInventory> {
    static int MAX_WIDTH = 3;
    static int MAX_HEIGHT = 3;
    private final int field_77576_b;
    private final int field_77577_c;
    private final NonNullList<Ingredient> field_77574_d;
    private final ItemStack field_77575_e;
    private final ResourceLocation field_199561_e;
    private final String field_194137_e;

    public static void setCraftingSize(int width, int height) {
        if (MAX_WIDTH < width) {
            MAX_WIDTH = width;
        }
        if (MAX_HEIGHT < height) {
            MAX_HEIGHT = height;
        }
    }

    public ShapedRecipe(ResourceLocation idIn, String groupIn, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn) {
        this.field_199561_e = idIn;
        this.field_194137_e = groupIn;
        this.field_77576_b = recipeWidthIn;
        this.field_77577_c = recipeHeightIn;
        this.field_77574_d = recipeItemsIn;
        this.field_77575_e = recipeOutputIn;
    }

    public ResourceLocation func_199560_c() {
        return this.field_199561_e;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return IRecipeSerializer.field_222157_a;
    }

    public String func_193358_e() {
        return this.field_194137_e;
    }

    public ItemStack func_77571_b() {
        return this.field_77575_e;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.field_77574_d;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= this.field_77576_b && height >= this.field_77577_c;
    }

    public boolean func_77569_a(CraftingInventory inv, World worldIn) {
        for (int i = 0; i <= inv.func_174922_i() - this.field_77576_b; ++i) {
            for (int j = 0; j <= inv.func_174923_h() - this.field_77577_c; ++j) {
                if (this.func_77573_a(inv, i, j, true)) {
                    return true;
                }
                if (!this.func_77573_a(inv, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean func_77573_a(CraftingInventory craftingInventory, int p_77573_2_, int p_77573_3_, boolean p_77573_4_) {
        for (int i = 0; i < craftingInventory.func_174922_i(); ++i) {
            for (int j = 0; j < craftingInventory.func_174923_h(); ++j) {
                int k = i - p_77573_2_;
                int l = j - p_77573_3_;
                Ingredient ingredient = Ingredient.field_193370_a;
                if (k >= 0 && l >= 0 && k < this.field_77576_b && l < this.field_77577_c) {
                    ingredient = p_77573_4_ ? (Ingredient)this.field_77574_d.get(this.field_77576_b - k - 1 + l * this.field_77576_b) : (Ingredient)this.field_77574_d.get(k + l * this.field_77576_b);
                }
                if (ingredient.test(craftingInventory.func_70301_a(i + j * craftingInventory.func_174922_i()))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        return this.func_77571_b().func_77946_l();
    }

    public int func_192403_f() {
        return this.field_77576_b;
    }

    public int getRecipeWidth() {
        return this.func_192403_f();
    }

    public int func_192404_g() {
        return this.field_77577_c;
    }

    public int getRecipeHeight() {
        return this.func_192404_g();
    }

    private static NonNullList<Ingredient> func_192402_a(String[] pattern, Map<String, Ingredient> keys, int patternWidth, int patternHeight) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)(patternWidth * patternHeight), (Object)Ingredient.field_193370_a);
        HashSet set = Sets.newHashSet(keys.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String s = pattern[i].substring(j, j + 1);
                Ingredient ingredient = keys.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                nonnulllist.set(j + patternWidth * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }

    @VisibleForTesting
    static String[] func_194134_a(String ... toShrink) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < toShrink.length; ++i1) {
            String s = toShrink[i1];
            i = Math.min(i, ShapedRecipe.func_194135_a(s));
            int j1 = ShapedRecipe.func_194136_b(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (toShrink.length == l) {
            return new String[0];
        }
        String[] astring = new String[toShrink.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = toShrink[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    private static int func_194135_a(String str) {
        int i;
        for (i = 0; i < str.length() && str.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int func_194136_b(String str) {
        int i;
        for (i = str.length() - 1; i >= 0 && str.charAt(i) == ' '; --i) {
        }
        return i;
    }

    private static String[] func_192407_a(JsonArray jsonArr) {
        String[] astring = new String[jsonArr.size()];
        if (astring.length > MAX_HEIGHT) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, " + MAX_HEIGHT + " is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = JSONUtils.func_151206_a((JsonElement)jsonArr.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > MAX_WIDTH) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, " + MAX_WIDTH + " is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    private static Map<String, Ingredient> func_192408_a(JsonObject json) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : json.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put(entry.getKey(), Ingredient.func_199802_a((JsonElement)entry.getValue()));
        }
        map.put(" ", Ingredient.field_193370_a);
        return map;
    }

    public static ItemStack func_199798_a(JsonObject p_199798_0_) {
        String s = JSONUtils.func_151200_h((JsonObject)p_199798_0_, (String)"item");
        Item item = (Item)((Object)Registry.field_212630_s.func_241873_b(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + s + "'")));
        if (p_199798_0_.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int i = JSONUtils.func_151208_a((JsonObject)p_199798_0_, (String)"count", (int)1);
        return CraftingHelper.getItemStack((JsonObject)p_199798_0_, (boolean)true);
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ShapedRecipe> {
        private static final ResourceLocation NAME = new ResourceLocation("minecraft", "crafting_shaped");

        @Override
        public ShapedRecipe func_199425_a_(ResourceLocation recipeId, JsonObject json) {
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            Map map = ShapedRecipe.func_192408_a(JSONUtils.func_152754_s((JsonObject)json, (String)"key"));
            String[] astring = ShapedRecipe.func_194134_a(ShapedRecipe.func_192407_a(JSONUtils.func_151214_t((JsonObject)json, (String)"pattern")));
            int i = astring[0].length();
            int j = astring.length;
            NonNullList nonnulllist = ShapedRecipe.func_192402_a(astring, map, i, j);
            ItemStack itemstack = ShapedRecipe.func_199798_a(JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new ShapedRecipe(recipeId, s, i, j, (NonNullList<Ingredient>)nonnulllist, itemstack);
        }

        @Override
        public ShapedRecipe func_199426_a_(ResourceLocation recipeId, PacketBuffer buffer) {
            int i = buffer.func_150792_a();
            int j = buffer.func_150792_a();
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            NonNullList nonnulllist = NonNullList.func_191197_a((int)(i * j), (Object)Ingredient.field_193370_a);
            for (int k = 0; k < nonnulllist.size(); ++k) {
                nonnulllist.set(k, (Object)Ingredient.func_199566_b(buffer));
            }
            ItemStack itemstack = buffer.func_150791_c();
            return new ShapedRecipe(recipeId, s, i, j, (NonNullList<Ingredient>)nonnulllist, itemstack);
        }

        @Override
        public void func_199427_a_(PacketBuffer buffer, ShapedRecipe recipe) {
            buffer.func_150787_b(recipe.field_77576_b);
            buffer.func_150787_b(recipe.field_77577_c);
            buffer.func_180714_a(recipe.field_194137_e);
            for (Ingredient ingredient : recipe.field_77574_d) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.field_77575_e);
        }
    }
}

