/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.DoubleSidedInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

@OnlyIn(value=Dist.CLIENT, _interface=IChestLid.class)
public class ChestTileEntity
extends LockableLootTileEntity
implements IChestLid,
ITickableTileEntity {
    private NonNullList<ItemStack> field_145985_p = NonNullList.func_191197_a((int)27, (Object)((Object)ItemStack.field_190927_a));
    protected float field_145989_m;
    protected float field_145986_n;
    protected int field_145987_o;
    private int field_145983_q;
    private LazyOptional<IItemHandlerModifiable> chestHandler;

    protected ChestTileEntity(TileEntityType<?> typeIn) {
        super(typeIn);
    }

    public ChestTileEntity() {
        this(TileEntityType.field_200972_c);
    }

    public int func_70302_i_() {
        return 27;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.chest");
    }

    public void func_230337_a_(BlockState p_230337_1_, CompoundNBT p_230337_2_) {
        super.func_230337_a_(p_230337_1_, p_230337_2_);
        this.field_145985_p = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)((Object)ItemStack.field_190927_a));
        if (!this.func_184283_b(p_230337_2_)) {
            ItemStackHelper.func_191283_b((CompoundNBT)p_230337_2_, this.field_145985_p);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191282_a((CompoundNBT)compound, this.field_145985_p);
        }
        return compound;
    }

    public void func_73660_a() {
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        ++this.field_145983_q;
        this.field_145987_o = ChestTileEntity.func_213977_a(this.field_145850_b, (LockableTileEntity)((Object)this), this.field_145983_q, i, j, k, this.field_145987_o);
        this.field_145986_n = this.field_145989_m;
        float f = 0.1f;
        if (this.field_145987_o > 0 && this.field_145989_m == 0.0f) {
            this.func_195483_a(SoundEvents.field_187657_V);
        }
        if (this.field_145987_o == 0 && this.field_145989_m > 0.0f || this.field_145987_o > 0 && this.field_145989_m < 1.0f) {
            float f1 = this.field_145989_m;
            this.field_145989_m = this.field_145987_o > 0 ? (this.field_145989_m += 0.1f) : (this.field_145989_m -= 0.1f);
            if (this.field_145989_m > 1.0f) {
                this.field_145989_m = 1.0f;
            }
            float f2 = 0.5f;
            if (this.field_145989_m < 0.5f && f1 >= 0.5f) {
                this.func_195483_a(SoundEvents.field_187651_T);
            }
            if (this.field_145989_m < 0.0f) {
                this.field_145989_m = 0.0f;
            }
        }
    }

    public static int func_213977_a(World p_213977_0_, LockableTileEntity p_213977_1_, int p_213977_2_, int p_213977_3_, int p_213977_4_, int p_213977_5_, int p_213977_6_) {
        if (!p_213977_0_.field_72995_K && p_213977_6_ != 0 && (p_213977_2_ + p_213977_3_ + p_213977_4_ + p_213977_5_) % 200 == 0) {
            p_213977_6_ = ChestTileEntity.func_213976_a(p_213977_0_, p_213977_1_, p_213977_3_, p_213977_4_, p_213977_5_);
        }
        return p_213977_6_;
    }

    public static int func_213976_a(World p_213976_0_, LockableTileEntity p_213976_1_, int p_213976_2_, int p_213976_3_, int p_213976_4_) {
        int i = 0;
        float f = 5.0f;
        for (PlayerEntity playerentity : p_213976_0_.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)((float)p_213976_2_ - 5.0f), (double)((float)p_213976_3_ - 5.0f), (double)((float)p_213976_4_ - 5.0f), (double)((float)(p_213976_2_ + 1) + 5.0f), (double)((float)(p_213976_3_ + 1) + 5.0f), (double)((float)(p_213976_4_ + 1) + 5.0f)))) {
            IInventory iinventory;
            if (!(playerentity.field_71070_bA instanceof ChestContainer) || (iinventory = ((ChestContainer)playerentity.field_71070_bA).func_85151_d()) != p_213976_1_ && (!(iinventory instanceof DoubleSidedInventory) || !((DoubleSidedInventory)iinventory).func_90010_a((IInventory)p_213976_1_))) continue;
            ++i;
        }
        return i;
    }

    private void func_195483_a(SoundEvent soundIn) {
        ChestType chesttype = (ChestType)this.func_195044_w().func_177229_b((Property)ChestBlock.field_196314_b);
        if (chesttype != ChestType.LEFT) {
            double d0 = (double)this.field_174879_c.func_177958_n() + 0.5;
            double d1 = (double)this.field_174879_c.func_177956_o() + 0.5;
            double d2 = (double)this.field_174879_c.func_177952_p() + 0.5;
            if (chesttype == ChestType.RIGHT) {
                Direction direction = ChestBlock.func_196311_i((BlockState)this.func_195044_w());
                d0 += (double)direction.func_82601_c() * 0.5;
                d2 += (double)direction.func_82599_e() * 0.5;
            }
            this.field_145850_b.func_184148_a(null, d0, d1, d2, soundIn, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.field_145987_o = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void func_174889_b(PlayerEntity player) {
        if (!player.func_175149_v()) {
            if (this.field_145987_o < 0) {
                this.field_145987_o = 0;
            }
            ++this.field_145987_o;
            this.func_195482_p();
        }
    }

    public void func_174886_c(PlayerEntity player) {
        if (!player.func_175149_v()) {
            --this.field_145987_o;
            this.func_195482_p();
        }
    }

    protected void func_195482_p() {
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof ChestBlock) {
            this.field_145850_b.func_175641_c(this.field_174879_c, block, 1, this.field_145987_o);
            this.field_145850_b.func_195593_d(this.field_174879_c, block);
        }
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.field_145985_p;
    }

    protected void func_199721_a(NonNullList<ItemStack> itemsIn) {
        this.field_145985_p = itemsIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_195480_a(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.field_145986_n, (float)this.field_145989_m);
    }

    public static int func_195481_a(IBlockReader reader, BlockPos posIn) {
        TileEntity tileentity;
        BlockState blockstate = reader.func_180495_p(posIn);
        if (blockstate.hasTileEntity() && (tileentity = reader.func_175625_s(posIn)) instanceof ChestTileEntity) {
            return ((ChestTileEntity)((Object)tileentity)).field_145987_o;
        }
        return 0;
    }

    public static void func_199722_a(ChestTileEntity chest, ChestTileEntity otherChest) {
        NonNullList<ItemStack> nonnulllist = chest.func_190576_q();
        chest.func_199721_a(otherChest.func_190576_q());
        otherChest.func_199721_a(nonnulllist);
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return ChestContainer.func_216992_a((int)id, (PlayerInventory)player, (IInventory)this);
    }

    public void func_145836_u() {
        super.func_145836_u();
        if (this.chestHandler != null) {
            this.chestHandler.invalidate();
            this.chestHandler = null;
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.chestHandler == null) {
                this.chestHandler = LazyOptional.of(this::createHandler);
            }
            return this.chestHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    private IItemHandlerModifiable createHandler() {
        BlockState state = this.func_195044_w();
        if (!(state.func_177230_c() instanceof ChestBlock)) {
            return new InvWrapper((IInventory)this);
        }
        IInventory inv = ChestBlock.func_226916_a_((ChestBlock)((ChestBlock)state.func_177230_c()), (BlockState)state, (World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (boolean)true);
        return new InvWrapper((IInventory)(inv == null ? this : inv));
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.chestHandler != null) {
            this.chestHandler.invalidate();
        }
    }
}

