/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Util;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.registry.Registry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobSpawnInfo {
    public static final Logger field_242550_a = LogManager.getLogger();
    public static final MobSpawnInfo field_242551_b = new MobSpawnInfo(0.1f, (Map)Stream.of(EntityClassification.values()).collect(ImmutableMap.toImmutableMap(p_242565_0_ -> p_242565_0_, p_242563_0_ -> ImmutableList.of())), (Map<EntityType<?>, SpawnCosts>)ImmutableMap.of(), false);
    public static final MapCodec<MobSpawnInfo> field_242552_c = RecordCodecBuilder.mapCodec(p_242561_0_ -> p_242561_0_.group((App)Codec.FLOAT.optionalFieldOf("creature_spawn_probability", (Object)Float.valueOf(0.1f)).forGetter(p_242566_0_ -> Float.valueOf(p_242566_0_.field_242553_d)), (App)Codec.simpleMap(EntityClassification.field_233667_g_, (Codec)Spawners.field_242587_b.listOf().promotePartial(Util.func_240982_a_((String)"Spawn data: ", arg_0 -> ((Logger)field_242550_a).error(arg_0))), (Keyable)IStringSerializable.func_233025_a_((IStringSerializable[])EntityClassification.values())).fieldOf("spawners").forGetter(p_242564_0_ -> p_242564_0_.field_242554_e), (App)Codec.simpleMap(Registry.field_212629_r, SpawnCosts.field_242579_a, Registry.field_212629_r).fieldOf("spawn_costs").forGetter(p_242560_0_ -> p_242560_0_.field_242555_f), (App)Codec.BOOL.fieldOf("player_spawn_friendly").orElse((Object)false).forGetter(MobSpawnInfo::func_242562_b)).apply((Applicative)p_242561_0_, MobSpawnInfo::new));
    private final float field_242553_d;
    private final Map<EntityClassification, List<Spawners>> field_242554_e;
    private final Map<EntityType<?>, SpawnCosts> field_242555_f;
    private final boolean field_242556_g;
    private final Set<EntityClassification> typesView;
    private final Set<EntityType<?>> costView;

    private MobSpawnInfo(float p_i241946_1_, Map<EntityClassification, List<Spawners>> p_i241946_2_, Map<EntityType<?>, SpawnCosts> p_i241946_3_, boolean p_i241946_4_) {
        this.field_242553_d = p_i241946_1_;
        this.field_242554_e = p_i241946_2_;
        this.field_242555_f = p_i241946_3_;
        this.field_242556_g = p_i241946_4_;
        this.typesView = Collections.unmodifiableSet(this.field_242554_e.keySet());
        this.costView = Collections.unmodifiableSet(this.field_242555_f.keySet());
    }

    public List<Spawners> func_242559_a(EntityClassification p_242559_1_) {
        return this.field_242554_e.getOrDefault((Object)p_242559_1_, (List<Spawners>)ImmutableList.of());
    }

    public Set<EntityClassification> getSpawnerTypes() {
        return this.typesView;
    }

    @Nullable
    public SpawnCosts func_242558_a(EntityType<?> p_242558_1_) {
        return this.field_242555_f.get(p_242558_1_);
    }

    public Set<EntityType<?>> getEntityTypes() {
        return this.costView;
    }

    public float func_242557_a() {
        return this.field_242553_d;
    }

    public boolean func_242562_b() {
        return this.field_242556_g;
    }

    public static class Spawners
    extends WeightedRandom.Item {
        public static final Codec<Spawners> field_242587_b = RecordCodecBuilder.create(p_242592_0_ -> p_242592_0_.group((App)Registry.field_212629_r.fieldOf("type").forGetter(p_242595_0_ -> p_242595_0_.field_242588_c), (App)Codec.INT.fieldOf("weight").forGetter(p_242594_0_ -> p_242594_0_.field_76292_a), (App)Codec.INT.fieldOf("minCount").forGetter(p_242593_0_ -> p_242593_0_.field_242589_d), (App)Codec.INT.fieldOf("maxCount").forGetter(p_242591_0_ -> p_242591_0_.field_242590_e)).apply((Applicative)p_242592_0_, Spawners::new));
        public final EntityType<?> field_242588_c;
        public final int field_242589_d;
        public final int field_242590_e;

        public Spawners(EntityType<?> p_i241950_1_, int p_i241950_2_, int p_i241950_3_, int p_i241950_4_) {
            super(p_i241950_2_);
            this.field_242588_c = p_i241950_1_.func_220339_d() == EntityClassification.MISC ? EntityType.field_200784_X : p_i241950_1_;
            this.field_242589_d = p_i241950_3_;
            this.field_242590_e = p_i241950_4_;
        }

        public String toString() {
            return EntityType.func_200718_a(this.field_242588_c) + "*(" + this.field_242589_d + "-" + this.field_242590_e + "):" + this.field_76292_a;
        }
    }

    public static class SpawnCosts {
        public static final Codec<SpawnCosts> field_242579_a = RecordCodecBuilder.create(p_242584_0_ -> p_242584_0_.group((App)Codec.DOUBLE.fieldOf("energy_budget").forGetter(p_242586_0_ -> p_242586_0_.field_242580_b), (App)Codec.DOUBLE.fieldOf("charge").forGetter(p_242583_0_ -> p_242583_0_.field_242581_c)).apply((Applicative)p_242584_0_, SpawnCosts::new));
        private final double field_242580_b;
        private final double field_242581_c;

        private SpawnCosts(double p_i241948_1_, double p_i241948_3_) {
            this.field_242580_b = p_i241948_1_;
            this.field_242581_c = p_i241948_3_;
        }

        public double func_242582_a() {
            return this.field_242580_b;
        }

        public double func_242585_b() {
            return this.field_242581_c;
        }
    }

    public static class Builder {
        protected final Map<EntityClassification, List<Spawners>> field_242567_a = (Map)Stream.of(EntityClassification.values()).collect(ImmutableMap.toImmutableMap(p_242578_0_ -> p_242578_0_, p_242574_0_ -> Lists.newArrayList()));
        protected final Map<EntityType<?>, SpawnCosts> field_242568_b = Maps.newLinkedHashMap();
        protected float field_242569_c = 0.1f;
        protected boolean field_242570_d;

        public Builder func_242575_a(EntityClassification p_242575_1_, Spawners p_242575_2_) {
            this.field_242567_a.get((Object)p_242575_1_).add(p_242575_2_);
            return this;
        }

        public Builder func_242573_a(EntityType<?> p_242573_1_, double p_242573_2_, double p_242573_4_) {
            this.field_242568_b.put(p_242573_1_, new SpawnCosts(p_242573_4_, p_242573_2_));
            return this;
        }

        public Builder func_242572_a(float p_242572_1_) {
            this.field_242569_c = p_242572_1_;
            return this;
        }

        public Builder func_242571_a() {
            this.field_242570_d = true;
            return this;
        }

        public MobSpawnInfo func_242577_b() {
            return new MobSpawnInfo(this.field_242569_c, (Map)this.field_242567_a.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, p_242576_0_ -> ImmutableList.copyOf((Collection)((Collection)p_242576_0_.getValue())))), (Map)ImmutableMap.copyOf(this.field_242568_b), this.field_242570_d);
        }
    }
}

