/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import java.lang.ref.WeakReference;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class BlockSnapshot {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugBlockSnapshot", "false"));
    private final RegistryKey<World> dim;
    private final BlockPos pos;
    private final int flags;
    private final BlockState block;
    @Nullable
    private final CompoundNBT nbt;
    @Nullable
    private WeakReference<IWorld> world;
    private String toString = null;

    private BlockSnapshot(RegistryKey<World> dim, IWorld world, BlockPos pos, BlockState state, @Nullable CompoundNBT nbt, int flags) {
        this.dim = dim;
        this.pos = pos.func_185334_h();
        this.block = state;
        this.flags = flags;
        this.nbt = nbt;
        this.world = new WeakReference<IWorld>(world);
        if (DEBUG) {
            System.out.println("Created " + this.toString());
        }
    }

    public static BlockSnapshot create(RegistryKey<World> dim, IWorld world, BlockPos pos) {
        return BlockSnapshot.create(dim, world, pos, 3);
    }

    public static BlockSnapshot create(RegistryKey<World> dim, IWorld world, BlockPos pos, int flag) {
        return new BlockSnapshot(dim, world, pos, world.func_180495_p(pos), BlockSnapshot.getTileNBT(world.func_175625_s(pos)), flag);
    }

    @Nullable
    private static CompoundNBT getTileNBT(@Nullable TileEntity te) {
        return te == null ? null : te.func_189515_b(new CompoundNBT());
    }

    public BlockState getCurrentBlock() {
        IWorld world = this.getWorld();
        return world == null ? Blocks.field_150350_a.func_176223_P() : world.func_180495_p(this.pos);
    }

    @Nullable
    public IWorld getWorld() {
        IWorld world;
        IWorld iWorld = world = this.world != null ? (IWorld)this.world.get() : null;
        if (world == null) {
            world = ServerLifecycleHooks.getCurrentServer().func_71218_a(this.dim);
            this.world = new WeakReference<IWorld>(world);
        }
        return world;
    }

    public BlockState getReplacedBlock() {
        return this.block;
    }

    @Nullable
    public TileEntity getTileEntity() {
        return this.getNbt() != null ? TileEntity.func_235657_b_((BlockState)this.getReplacedBlock(), (CompoundNBT)this.getNbt()) : null;
    }

    public boolean restore() {
        return this.restore(false);
    }

    public boolean restore(boolean force) {
        return this.restore(force, true);
    }

    public boolean restore(boolean force, boolean notifyNeighbors) {
        return this.restoreToLocation(this.getWorld(), this.getPos(), force, notifyNeighbors);
    }

    public boolean restoreToLocation(IWorld world, BlockPos pos, boolean force, boolean notifyNeighbors) {
        int flags;
        BlockState current = this.getCurrentBlock();
        BlockState replaced = this.getReplacedBlock();
        int n = flags = notifyNeighbors ? 3 : 2;
        if (current != replaced) {
            if (force) {
                world.func_180501_a(pos, replaced, flags);
            } else {
                return false;
            }
        }
        world.func_180501_a(pos, replaced, flags);
        if (world instanceof World) {
            ((World)world).func_184138_a(pos, current, replaced, flags);
        }
        TileEntity te = null;
        if (this.getNbt() != null && (te = world.func_175625_s(pos)) != null) {
            te.func_230337_a_(this.getReplacedBlock(), this.getNbt());
            te.func_70296_d();
        }
        if (DEBUG) {
            System.out.println("Restored " + this.toString());
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BlockSnapshot other = (BlockSnapshot)obj;
        return this.dim.equals(other.dim) && this.pos.equals((Object)other.pos) && this.block == other.block && this.flags == other.flags && Objects.equals(this.nbt, other.nbt);
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + this.dim.hashCode();
        hash = 73 * hash + this.pos.hashCode();
        hash = 73 * hash + this.block.hashCode();
        hash = 73 * hash + this.flags;
        hash = 73 * hash + Objects.hashCode(this.getNbt());
        return hash;
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = "BlockSnapshot[World:" + this.dim.func_240901_a_() + ',' + "Pos: " + this.pos + ',' + "State: " + this.block + ',' + "Flags: " + this.flags + ',' + "NBT: " + (this.nbt == null ? "null" : this.nbt.toString()) + ']';
        }
        return this.toString;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getFlag() {
        return this.flags;
    }

    @Nullable
    public CompoundNBT getNbt() {
        return this.nbt;
    }
}

