/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.world;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.PortalSize;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public class BlockEvent
extends Event {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugBlockEvent", "false"));
    private final IWorld world;
    private final BlockPos pos;
    private final BlockState state;

    public BlockEvent(IWorld world, BlockPos pos, BlockState state) {
        this.pos = pos;
        this.world = world;
        this.state = state;
    }

    public IWorld getWorld() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public BlockState getState() {
        return this.state;
    }

    @Cancelable
    public static class BlockToolInteractEvent
    extends BlockEvent {
        private final PlayerEntity player;
        private final ItemStack stack;
        private final ToolType toolType;
        private BlockState state;

        public BlockToolInteractEvent(IWorld world, BlockPos pos, BlockState originalState, PlayerEntity player, ItemStack stack, ToolType toolType) {
            super(world, pos, originalState);
            this.player = player;
            this.stack = stack;
            this.state = originalState;
            this.toolType = toolType;
        }

        public PlayerEntity getPlayer() {
            return this.player;
        }

        public ItemStack getHeldItemStack() {
            return this.stack;
        }

        public ToolType getToolType() {
            return this.toolType;
        }

        public void setFinalState(BlockState finalState) {
            this.state = finalState;
        }

        public BlockState getFinalState() {
            return this.state;
        }
    }

    @Cancelable
    public static class PortalSpawnEvent
    extends BlockEvent {
        private final PortalSize size;

        public PortalSpawnEvent(IWorld world, BlockPos pos, BlockState state, PortalSize size) {
            super(world, pos, state);
            this.size = size;
        }

        public PortalSize getPortalSize() {
            return this.size;
        }
    }

    @Cancelable
    public static class FarmlandTrampleEvent
    extends BlockEvent {
        private final Entity entity;
        private final float fallDistance;

        public FarmlandTrampleEvent(World world, BlockPos pos, BlockState state, float fallDistance, Entity entity) {
            super((IWorld)world, pos, state);
            this.entity = entity;
            this.fallDistance = fallDistance;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public float getFallDistance() {
            return this.fallDistance;
        }
    }

    public static class CropGrowEvent
    extends BlockEvent {
        public CropGrowEvent(World world, BlockPos pos, BlockState state) {
            super((IWorld)world, pos, state);
        }

        public static class Post
        extends CropGrowEvent {
            private final BlockState originalState;

            public Post(World world, BlockPos pos, BlockState original, BlockState state) {
                super(world, pos, state);
                this.originalState = original;
            }

            public BlockState getOriginalState() {
                return this.originalState;
            }
        }

        @Event.HasResult
        public static class Pre
        extends CropGrowEvent {
            public Pre(World world, BlockPos pos, BlockState state) {
                super(world, pos, state);
            }
        }
    }

    @Cancelable
    public static class FluidPlaceBlockEvent
    extends BlockEvent {
        private final BlockPos liquidPos;
        private BlockState newState;
        private BlockState origState;

        public FluidPlaceBlockEvent(IWorld world, BlockPos pos, BlockPos liquidPos, BlockState state) {
            super(world, pos, state);
            this.liquidPos = liquidPos;
            this.newState = state;
            this.origState = world.func_180495_p(pos);
        }

        public BlockPos getLiquidPos() {
            return this.liquidPos;
        }

        public BlockState getNewState() {
            return this.newState;
        }

        public void setNewState(BlockState state) {
            this.newState = state;
        }

        public BlockState getOriginalState() {
            return this.origState;
        }
    }

    @Event.HasResult
    public static class CreateFluidSourceEvent
    extends Event {
        private final IWorldReader world;
        private final BlockPos pos;
        private final BlockState state;

        public CreateFluidSourceEvent(IWorldReader world, BlockPos pos, BlockState state) {
            this.world = world;
            this.pos = pos;
            this.state = state;
        }

        public IWorldReader getWorld() {
            return this.world;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public BlockState getState() {
            return this.state;
        }
    }

    @Cancelable
    public static class NeighborNotifyEvent
    extends BlockEvent {
        private final EnumSet<Direction> notifiedSides;
        private final boolean forceRedstoneUpdate;

        public NeighborNotifyEvent(World world, BlockPos pos, BlockState state, EnumSet<Direction> notifiedSides, boolean forceRedstoneUpdate) {
            super((IWorld)world, pos, state);
            this.notifiedSides = notifiedSides;
            this.forceRedstoneUpdate = forceRedstoneUpdate;
        }

        public EnumSet<Direction> getNotifiedSides() {
            return this.notifiedSides;
        }

        public boolean getForceRedstoneUpdate() {
            return this.forceRedstoneUpdate;
        }
    }

    @Cancelable
    public static class EntityMultiPlaceEvent
    extends EntityPlaceEvent {
        private final List<BlockSnapshot> blockSnapshots;

        public EntityMultiPlaceEvent(@Nonnull List<BlockSnapshot> blockSnapshots, @Nonnull BlockState placedAgainst, @Nullable Entity entity) {
            super(blockSnapshots.get(0), placedAgainst, entity);
            this.blockSnapshots = ImmutableList.copyOf(blockSnapshots);
            if (DEBUG) {
                System.out.printf("Created EntityMultiPlaceEvent - [PlacedAgainst: %s ][Entity: %s ]\n", placedAgainst, entity);
            }
        }

        public List<BlockSnapshot> getReplacedBlockSnapshots() {
            return this.blockSnapshots;
        }
    }

    @Cancelable
    public static class EntityPlaceEvent
    extends BlockEvent {
        private final Entity entity;
        private final BlockSnapshot blockSnapshot;
        private final BlockState placedBlock;
        private final BlockState placedAgainst;

        public EntityPlaceEvent(@Nonnull BlockSnapshot blockSnapshot, @Nonnull BlockState placedAgainst, @Nullable Entity entity) {
            super(blockSnapshot.getWorld(), blockSnapshot.getPos(), !(entity instanceof PlayerEntity) ? blockSnapshot.getReplacedBlock() : blockSnapshot.getCurrentBlock());
            this.entity = entity;
            this.blockSnapshot = blockSnapshot;
            this.placedBlock = !(entity instanceof PlayerEntity) ? blockSnapshot.getReplacedBlock() : blockSnapshot.getCurrentBlock();
            this.placedAgainst = placedAgainst;
            if (DEBUG) {
                System.out.printf("Created EntityPlaceEvent - [PlacedBlock: %s ][PlacedAgainst: %s ][Entity: %s ]\n", this.getPlacedBlock(), placedAgainst, entity);
            }
        }

        @Nullable
        public Entity getEntity() {
            return this.entity;
        }

        public BlockSnapshot getBlockSnapshot() {
            return this.blockSnapshot;
        }

        public BlockState getPlacedBlock() {
            return this.placedBlock;
        }

        public BlockState getPlacedAgainst() {
            return this.placedAgainst;
        }
    }

    @Cancelable
    public static class BreakEvent
    extends BlockEvent {
        private final PlayerEntity player;
        private int exp;

        public BreakEvent(World world, BlockPos pos, BlockState state, PlayerEntity player) {
            super((IWorld)world, pos, state);
            this.player = player;
            if (state == null || !ForgeHooks.canHarvestBlock(state, player, (IBlockReader)world, pos)) {
                this.exp = 0;
            } else {
                int bonusLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)player.func_184614_ca());
                int silklevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)player.func_184614_ca());
                this.exp = state.getExpDrop((IWorldReader)world, pos, bonusLevel, silklevel);
            }
        }

        public PlayerEntity getPlayer() {
            return this.player;
        }

        public int getExpToDrop() {
            return this.isCanceled() ? 0 : this.exp;
        }

        public void setExpToDrop(int exp) {
            this.exp = exp;
        }
    }
}

