/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import com.google.common.collect.ImmutableList;
import cpw.mods.modlauncher.TransformingClassLoader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.CrashReportExtender;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LoadingFailedException;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingException;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.ModWorkManager;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.InvalidModIdentifier;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.loading.progress.StartupMessageManager;
import net.minecraftforge.fml.network.FMLNetworkConstants;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.IModLanguageProvider;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.ObjectHolderRegistry;
import net.minecraftforge.versions.forge.ForgeVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static ModLoader INSTANCE;
    private final TransformingClassLoader launchClassLoader;
    private final LoadingModList loadingModList;
    private final List<ModLoadingException> loadingExceptions;
    private final List<ModLoadingWarning> loadingWarnings;
    private boolean loadingStateValid;
    private final Optional<Consumer<String>> statusConsumer = StartupMessageManager.modLoaderConsumer();
    private static boolean runningDataGen;

    private ModLoader() {
        INSTANCE = this;
        this.launchClassLoader = FMLLoader.getLaunchClassLoader();
        this.loadingModList = FMLLoader.getLoadingModList();
        this.loadingExceptions = FMLLoader.getLoadingModList().getErrors().stream().flatMap(ModLoadingException::fromEarlyException).collect(Collectors.toList());
        this.loadingWarnings = FMLLoader.getLoadingModList().getBrokenFiles().stream().map(file -> new ModLoadingWarning(null, ModLoadingStage.VALIDATE, InvalidModIdentifier.identifyJarProblem((Path)file.getFilePath()).orElse("fml.modloading.brokenfile"), file.getFileName())).collect(Collectors.toList());
        FMLLoader.getLoadingModList().getModFiles().stream().filter(ModFileInfo::missingLicense).filter(modFileInfo -> modFileInfo.getMods().stream().noneMatch(thisModInfo -> this.loadingExceptions.stream().map(ModLoadingException::getModInfo).anyMatch(otherInfo -> otherInfo == thisModInfo))).map(modFileInfo -> new ModLoadingException(null, ModLoadingStage.VALIDATE, "fml.modloading.missinglicense", null, modFileInfo.getFile())).forEach(this.loadingExceptions::add);
        LOGGER.debug(Logging.CORE, "Loading Network data for FML net version: {}", (Object)FMLNetworkConstants.init());
        CrashReportExtender.registerCrashCallable("ModLauncher", FMLLoader::getLauncherInfo);
        CrashReportExtender.registerCrashCallable("ModLauncher launch target", FMLLoader::launcherHandlerName);
        CrashReportExtender.registerCrashCallable("ModLauncher naming", FMLLoader::getNaming);
        CrashReportExtender.registerCrashCallable("ModLauncher services", this::computeModLauncherServiceList);
        CrashReportExtender.registerCrashCallable("FML", ForgeVersion::getSpec);
        CrashReportExtender.registerCrashCallable("Forge", () -> ForgeVersion.getGroup() + ":" + ForgeVersion.getVersion());
        CrashReportExtender.registerCrashCallable("FML Language Providers", this::computeLanguageList);
    }

    private String computeLanguageList() {
        return "\n" + FMLLoader.getLanguageLoadingProvider().applyForEach(lp -> lp.name() + "@" + lp.getClass().getPackage().getImplementationVersion()).collect(Collectors.joining("\n\t\t", "\t\t", ""));
    }

    private String computeModLauncherServiceList() {
        List mods = FMLLoader.modLauncherModList();
        return "\n" + mods.stream().map(mod -> mod.getOrDefault("file", "nofile") + " " + mod.getOrDefault("name", "missing") + " " + mod.getOrDefault("type", "NOTYPE") + " " + mod.getOrDefault("description", "")).collect(Collectors.joining("\n\t\t", "\t\t", ""));
    }

    public static ModLoader get() {
        return INSTANCE == null ? (INSTANCE = new ModLoader()) : INSTANCE;
    }

    public void gatherAndInitializeMods(ModWorkManager.DrivenExecutor syncExecutor, Executor parallelExecutor, Runnable periodicTask) {
        this.loadingStateValid = true;
        this.statusConsumer.ifPresent(c -> c.accept("Waiting for scan to complete"));
        FMLLoader.backgroundScanHandler.waitForScanToComplete(periodicTask);
        this.statusConsumer.ifPresent(c -> c.accept("Loading mods"));
        ModList modList = ModList.of(this.loadingModList.getModFiles().stream().map(ModFileInfo::getFile).collect(Collectors.toList()), this.loadingModList.getMods());
        if (!this.loadingExceptions.isEmpty()) {
            LOGGER.fatal(Logging.CORE, "Error during pre-loading phase", (Throwable)this.loadingExceptions.get(0));
            modList.setLoadedMods(Collections.emptyList());
            this.loadingStateValid = false;
            throw new LoadingFailedException(this.loadingExceptions);
        }
        this.statusConsumer.ifPresent(c -> c.accept("Building Mod List"));
        List<ModContainer> modContainers = this.loadingModList.getModFiles().stream().map(ModFileInfo::getFile).map(mf -> this.buildMods((ModFile)mf, this.launchClassLoader)).flatMap(Collection::stream).collect(Collectors.toList());
        if (!this.loadingExceptions.isEmpty()) {
            LOGGER.fatal(Logging.CORE, "Failed to initialize mod containers", (Throwable)this.loadingExceptions.get(0));
            modList.setLoadedMods(Collections.emptyList());
            this.loadingStateValid = false;
            throw new LoadingFailedException(this.loadingExceptions);
        }
        modList.setLoadedMods(modContainers);
        this.statusConsumer.ifPresent(c -> c.accept(String.format("Constructing %d mods", modList.size())));
        this.dispatchAndHandleError(ModLoadingStage.CONSTRUCT, syncExecutor, parallelExecutor, periodicTask);
        this.statusConsumer.ifPresent(c -> c.accept("Creating registries"));
        this.dispatchAndHandleError(ModLoadingStage.CREATE_REGISTRIES, syncExecutor, parallelExecutor, periodicTask);
        ObjectHolderRegistry.findObjectHolders();
        CapabilityManager.INSTANCE.injectCapabilities(modList.getAllScanData());
        this.statusConsumer.ifPresent(c -> c.accept("Adding custom tag types"));
        GameData.setCustomTagTypesFromRegistries();
        this.statusConsumer.ifPresent(c -> c.accept("Populating registries"));
        this.dispatchAndHandleError(ModLoadingStage.LOAD_REGISTRIES, syncExecutor, parallelExecutor, periodicTask);
        this.statusConsumer.ifPresent(c -> c.accept("Early mod loading complete"));
    }

    public void loadMods(ModWorkManager.DrivenExecutor syncExecutor, Executor parallelExecutor, Function<Executor, CompletableFuture<Void>> beforeSidedEvent, Function<Executor, CompletableFuture<Void>> afterSidedEvent, Runnable periodicTask) {
        this.statusConsumer.ifPresent(c -> c.accept("Loading mod config"));
        DistExecutor.unsafeRunWhenOn(Dist.CLIENT, () -> () -> ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.CLIENT, FMLPaths.CONFIGDIR.get()));
        ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.COMMON, FMLPaths.CONFIGDIR.get());
        this.statusConsumer.ifPresent(c -> c.accept("Mod setup: SETUP"));
        this.dispatchAndHandleError(ModLoadingStage.COMMON_SETUP, syncExecutor, parallelExecutor, periodicTask);
        this.statusConsumer.ifPresent(c -> c.accept("Mod setup: SIDED SETUP"));
        this.dispatchAndHandleError(ModLoadingStage.SIDED_SETUP, syncExecutor, parallelExecutor, periodicTask, beforeSidedEvent, afterSidedEvent);
        this.statusConsumer.ifPresent(c -> c.accept("Mod setup complete"));
    }

    public void finishMods(ModWorkManager.DrivenExecutor syncExecutor, Executor parallelExecutor, Runnable periodicTask) {
        this.statusConsumer.ifPresent(c -> c.accept("Mod setup: ENQUEUE IMC"));
        this.dispatchAndHandleError(ModLoadingStage.ENQUEUE_IMC, syncExecutor, parallelExecutor, periodicTask);
        this.statusConsumer.ifPresent(c -> c.accept("Mod setup: PROCESS IMC"));
        this.dispatchAndHandleError(ModLoadingStage.PROCESS_IMC, syncExecutor, parallelExecutor, periodicTask);
        this.statusConsumer.ifPresent(c -> c.accept("Mod setup: Final completion"));
        this.dispatchAndHandleError(ModLoadingStage.COMPLETE, syncExecutor, parallelExecutor, periodicTask);
        this.statusConsumer.ifPresent(c -> c.accept("Freezing data"));
        GameData.freezeData();
        NetworkRegistry.lock();
        this.statusConsumer.ifPresent(c -> c.accept(String.format("Mod loading complete - %d mods loaded", ModList.get().size())));
    }

    private void dispatchAndHandleError(ModLoadingStage state, ModWorkManager.DrivenExecutor syncExecutor, Executor parallelExecutor, Runnable ticker) {
        if (!ModLoader.isLoadingStateValid()) {
            LOGGER.error("Cowardly refusing to process mod state change request from {}", (Object)state);
            return;
        }
        this.waitForTransition(state, syncExecutor, ticker, state.buildTransition(syncExecutor, parallelExecutor));
    }

    private void dispatchAndHandleError(ModLoadingStage state, ModWorkManager.DrivenExecutor syncExecutor, Executor parallelExecutor, Runnable ticker, Function<Executor, CompletableFuture<Void>> preSyncTask, Function<Executor, CompletableFuture<Void>> postSyncTask) {
        if (!ModLoader.isLoadingStateValid()) {
            LOGGER.error("Cowardly refusing to process mod state change request from {}", (Object)state);
            return;
        }
        this.waitForTransition(state, syncExecutor, ticker, state.buildTransition(syncExecutor, parallelExecutor, preSyncTask, postSyncTask));
    }

    private void waitForTransition(ModLoadingStage state, ModWorkManager.DrivenExecutor syncExecutor, Runnable ticker, CompletableFuture<List<Throwable>> transition) {
        while (!transition.isDone()) {
            syncExecutor.drive(ticker);
        }
        try {
            transition.join();
        }
        catch (CompletionException e) {
            this.loadingStateValid = false;
            Throwable t = e.getCause();
            List notModLoading = Arrays.stream(t.getSuppressed()).filter(obj -> !(obj instanceof ModLoadingException)).collect(Collectors.toList());
            if (!notModLoading.isEmpty()) {
                LOGGER.fatal("Encountered non-modloading exceptions!", (Throwable)e);
                throw e;
            }
            List<ModLoadingException> modLoadingExceptions = Arrays.stream(t.getSuppressed()).filter(ModLoadingException.class::isInstance).map(ModLoadingException.class::cast).collect(Collectors.toList());
            LOGGER.fatal(Logging.LOADING, "Failed to complete lifecycle event {}, {} errors found", (Object)state, (Object)modLoadingExceptions.size());
            throw new LoadingFailedException(modLoadingExceptions);
        }
    }

    private List<ModContainer> buildMods(ModFile modFile, TransformingClassLoader modClassLoader) {
        Map modInfoMap = modFile.getModFileInfo().getMods().stream().collect(Collectors.toMap(IModInfo::getModId, Function.identity()));
        LOGGER.debug(Logging.LOADING, "ModContainer is {}", (Object)ModContainer.class.getClassLoader());
        List<ModContainer> containers = modFile.getScanResult().getTargets().entrySet().stream().map(e -> this.buildModContainerFromTOML(modFile, modClassLoader, modInfoMap, (Map.Entry<String, ? extends IModLanguageProvider.IModLanguageLoader>)e)).filter(Objects::nonNull).collect(Collectors.toList());
        if (containers.size() != modInfoMap.size()) {
            LOGGER.fatal(Logging.LOADING, "File {} constructed {} mods: {}, but had {} mods specified: {}", (Object)modFile.getFilePath(), (Object)containers.size(), containers.stream().map(c -> c != null ? c.getModId() : "(null)").sorted().collect(Collectors.toList()), (Object)modInfoMap.size(), modInfoMap.values().stream().map(IModInfo::getModId).sorted().collect(Collectors.toList()));
            this.loadingExceptions.add(new ModLoadingException(null, ModLoadingStage.CONSTRUCT, "fml.modloading.missingclasses", null, modFile.getFilePath()));
        }
        return containers;
    }

    private ModContainer buildModContainerFromTOML(ModFile modFile, TransformingClassLoader modClassLoader, Map<String, IModInfo> modInfoMap, Map.Entry<String, ? extends IModLanguageProvider.IModLanguageLoader> idToProviderEntry) {
        try {
            String modId = idToProviderEntry.getKey();
            IModLanguageProvider.IModLanguageLoader languageLoader = idToProviderEntry.getValue();
            IModInfo info = Optional.ofNullable(modInfoMap.get(modId)).orElseThrow(() -> new ModLoadingException(null, ModLoadingStage.CONSTRUCT, "fml.modloading.missingmetadata", null, modId));
            return (ModContainer)languageLoader.loadMod(info, (ClassLoader)modClassLoader, modFile.getScanResult());
        }
        catch (ModLoadingException mle) {
            this.loadingExceptions.add(mle);
            return null;
        }
    }

    public static boolean isLoadingStateValid() {
        return ModLoader.get().loadingStateValid;
    }

    public <T extends Event> void runEventGenerator(Function<ModContainer, T> generator) {
        if (!this.loadingStateValid) {
            LOGGER.error("Cowardly refusing to send event generator to a broken mod state");
            return;
        }
        ModList.get().forEachModContainer((id, mc) -> mc.acceptEvent((Event)generator.apply((ModContainer)mc)));
    }

    public <T extends Event> void postEvent(T e) {
        if (!this.loadingStateValid) {
            LOGGER.error("Cowardly refusing to send event {} to a broken mod state", (Object)e.getClass().getName());
            return;
        }
        ModList.get().forEachModContainer((id, mc) -> mc.acceptEvent(e));
    }

    public List<ModLoadingWarning> getWarnings() {
        return ImmutableList.copyOf(this.loadingWarnings);
    }

    public void addWarning(ModLoadingWarning warning) {
        this.loadingWarnings.add(warning);
    }

    public static boolean isDataGenRunning() {
        return runningDataGen;
    }

    static {
        runningDataGen = false;
    }
}

