/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.registries.GameData;

public enum ModLoadingStage {
    ERROR,
    VALIDATE,
    CONSTRUCT(FMLConstructModEvent.class),
    CREATE_REGISTRIES(() -> Stream.of(EventGenerator.fromFunction(RegistryEvent.NewRegistry::new))),
    LOAD_REGISTRIES(GameData::generateRegistryEvents, GameData::preRegistryEventDispatch, GameData::postRegistryEventDispatch),
    COMMON_SETUP(FMLCommonSetupEvent.class),
    SIDED_SETUP((Class)DistExecutor.unsafeRunForDist(() -> () -> FMLClientSetupEvent.class, () -> () -> FMLDedicatedServerSetupEvent.class)),
    ENQUEUE_IMC(InterModEnqueueEvent.class),
    PROCESS_IMC(InterModProcessEvent.class),
    COMPLETE(FMLLoadCompleteEvent.class),
    DONE;

    private final Supplier<Stream<EventGenerator<?>>> eventFunctionStream;
    private final Optional<Class<? extends ParallelDispatchEvent>> parallelEventClass;
    private final ThreadSelector threadSelector;
    private final BiFunction<Executor, CompletableFuture<List<Throwable>>, CompletableFuture<List<Throwable>>> finalActivityGenerator;
    private final BiFunction<Executor, ? extends EventGenerator<?>, CompletableFuture<List<Throwable>>> preDispatchHook;
    private final BiFunction<Executor, ? extends EventGenerator<?>, CompletableFuture<List<Throwable>>> postDispatchHook;
    private DeferredWorkQueue deferredWorkQueue;

    private ModLoadingStage(Class<? extends ParallelDispatchEvent> parallelClass) {
        EventGenerator event = EventGenerator.fromFunction(LamdbaExceptionUtils.rethrowFunction(mc -> (ParallelDispatchEvent)parallelClass.getConstructor(ModContainer.class).newInstance(mc)));
        this.eventFunctionStream = () -> Stream.of(event);
        this.threadSelector = ThreadSelector.PARALLEL;
        this.parallelEventClass = Optional.of(parallelClass);
        this.deferredWorkQueue = new DeferredWorkQueue(this, parallelClass);
        this.finalActivityGenerator = (e, prev) -> prev.thenApplyAsync(t -> {
            this.deferredWorkQueue.runTasks();
            return t;
        }, (Executor)e);
        this.preDispatchHook = (t, f) -> CompletableFuture.completedFuture(Collections.emptyList());
        this.postDispatchHook = (t, f) -> CompletableFuture.completedFuture(Collections.emptyList());
    }

    private ModLoadingStage(Supplier<Stream<EventGenerator<?>>> eventStream) {
        this(eventStream, (t, f) -> CompletableFuture.completedFuture(Collections.emptyList()), (t, f) -> CompletableFuture.completedFuture(Collections.emptyList()));
    }

    private <T extends Event> ModLoadingStage(Supplier<Stream<EventGenerator<?>>> eventStream, BiFunction<Executor, ? extends EventGenerator<T>, CompletableFuture<List<Throwable>>> preDispatchHook, BiFunction<Executor, ? extends EventGenerator<T>, CompletableFuture<List<Throwable>>> postDispatchHook) {
        this.eventFunctionStream = eventStream;
        this.parallelEventClass = Optional.empty();
        this.threadSelector = ThreadSelector.SYNC;
        this.preDispatchHook = preDispatchHook;
        this.postDispatchHook = postDispatchHook;
        this.finalActivityGenerator = (e, prev) -> prev.thenApplyAsync(Function.identity(), (Executor)e);
    }

    private ModLoadingStage() {
        this(ParallelDispatchEvent.class);
    }

    public <T extends Event> CompletableFuture<List<Throwable>> buildTransition(Executor syncExecutor, Executor parallelExecutor) {
        return this.buildTransition(syncExecutor, parallelExecutor, e -> CompletableFuture.runAsync(() -> {}, e), e -> CompletableFuture.runAsync(() -> {}, e));
    }

    public <T extends Event> CompletableFuture<List<Throwable>> buildTransition(Executor syncExecutor, Executor parallelExecutor, Function<Executor, CompletableFuture<Void>> preSyncTask, Function<Executor, CompletableFuture<Void>> postSyncTask) {
        ArrayList cfs = new ArrayList();
        this.eventFunctionStream.get().map(f -> f).reduce((head, tail) -> this.addCompletableFutureTaskForModDispatch(syncExecutor, parallelExecutor, cfs, (EventGenerator)head, ModLoadingStage::currentState, (EventGenerator)tail)).ifPresent(last -> this.addCompletableFutureTaskForModDispatch(syncExecutor, parallelExecutor, cfs, (EventGenerator)last, ModLoadingStage::nextState, null));
        CompletableFuture<Void> preSyncTaskCF = preSyncTask.apply(syncExecutor);
        CompletionStage eventDispatchCF = ModList.gather(cfs).thenCompose(ModList::completableFutureFromExceptionList);
        CompletionStage postEventDispatchCF = ((CompletableFuture)preSyncTaskCF.thenComposeAsync(arg_0 -> ModLoadingStage.lambda$buildTransition$21((CompletableFuture)eventDispatchCF, arg_0), parallelExecutor)).thenApply(r -> {
            postSyncTask.apply(syncExecutor);
            return r;
        });
        return this.finalActivityGenerator.apply(syncExecutor, (CompletableFuture<List<Throwable>>)postEventDispatchCF);
    }

    private <T extends Event> EventGenerator<T> addCompletableFutureTaskForModDispatch(Executor syncExecutor, Executor parallelExecutor, List<CompletableFuture<List<Throwable>>> completeableFutures, EventGenerator<T> eventGenerator, BiFunction<ModLoadingStage, Throwable, ModLoadingStage> nextState, EventGenerator<T> nextGenerator) {
        completeableFutures.add(this.preDispatchHook.apply(this.threadSelector.apply(syncExecutor, parallelExecutor), eventGenerator));
        completeableFutures.add(ModList.get().futureVisitor(eventGenerator, nextState).apply(this.threadSelector.apply(syncExecutor, parallelExecutor)));
        completeableFutures.add(this.postDispatchHook.apply(this.threadSelector.apply(syncExecutor, parallelExecutor), eventGenerator));
        return nextGenerator;
    }

    ModLoadingStage nextState(Throwable exception) {
        return exception != null ? ERROR : ModLoadingStage.values()[this.ordinal() + 1];
    }

    ModLoadingStage currentState(Throwable exception) {
        return exception != null ? ERROR : this;
    }

    public Optional<Class<? extends ParallelDispatchEvent>> getParallelEventClass() {
        return this.parallelEventClass;
    }

    public DeferredWorkQueue getDeferredWorkQueue() {
        return this.deferredWorkQueue;
    }

    private static /* synthetic */ CompletionStage lambda$buildTransition$21(CompletableFuture eventDispatchCF, Void n) {
        return eventDispatchCF;
    }

    public static interface EventGenerator<T extends Event>
    extends Function<ModContainer, T> {
        public static <FN extends Event> EventGenerator<FN> fromFunction(Function<ModContainer, FN> fn) {
            return fn::apply;
        }
    }

    static enum ThreadSelector implements BinaryOperator<Executor>
    {
        SYNC((sync, parallel) -> sync),
        PARALLEL((sync, parallel) -> parallel);

        private final BinaryOperator<Executor> selector;

        private ThreadSelector(BinaryOperator<Executor> selector) {
            this.selector = selector;
        }

        @Override
        public Executor apply(Executor sync, Executor parallel) {
            return (Executor)this.selector.apply(sync, parallel);
        }
    }
}

