/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import it.unimi.dsi.fastutil.ints.Int2ShortMap;
import it.unimi.dsi.fastutil.ints.Int2ShortOpenHashMap;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CommandBlockBlock;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.ChatVisibility;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.container.BeaconContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.MerchantContainer;
import net.minecraft.inventory.container.RecipeBookContainer;
import net.minecraft.inventory.container.RepairContainer;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.WritableBookItem;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketThreadUtil;
import net.minecraft.network.play.IServerPlayNetHandler;
import net.minecraft.network.play.client.CAnimateHandPacket;
import net.minecraft.network.play.client.CChatMessagePacket;
import net.minecraft.network.play.client.CClickWindowPacket;
import net.minecraft.network.play.client.CClientSettingsPacket;
import net.minecraft.network.play.client.CClientStatusPacket;
import net.minecraft.network.play.client.CCloseWindowPacket;
import net.minecraft.network.play.client.CConfirmTeleportPacket;
import net.minecraft.network.play.client.CConfirmTransactionPacket;
import net.minecraft.network.play.client.CCreativeInventoryActionPacket;
import net.minecraft.network.play.client.CCustomPayloadPacket;
import net.minecraft.network.play.client.CEditBookPacket;
import net.minecraft.network.play.client.CEnchantItemPacket;
import net.minecraft.network.play.client.CEntityActionPacket;
import net.minecraft.network.play.client.CHeldItemChangePacket;
import net.minecraft.network.play.client.CInputPacket;
import net.minecraft.network.play.client.CJigsawBlockGeneratePacket;
import net.minecraft.network.play.client.CKeepAlivePacket;
import net.minecraft.network.play.client.CLockDifficultyPacket;
import net.minecraft.network.play.client.CMarkRecipeSeenPacket;
import net.minecraft.network.play.client.CMoveVehiclePacket;
import net.minecraft.network.play.client.CPickItemPacket;
import net.minecraft.network.play.client.CPlaceRecipePacket;
import net.minecraft.network.play.client.CPlayerAbilitiesPacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.network.play.client.CPlayerPacket;
import net.minecraft.network.play.client.CPlayerTryUseItemOnBlockPacket;
import net.minecraft.network.play.client.CPlayerTryUseItemPacket;
import net.minecraft.network.play.client.CQueryEntityNBTPacket;
import net.minecraft.network.play.client.CQueryTileEntityNBTPacket;
import net.minecraft.network.play.client.CRenameItemPacket;
import net.minecraft.network.play.client.CResourcePackStatusPacket;
import net.minecraft.network.play.client.CSeenAdvancementsPacket;
import net.minecraft.network.play.client.CSelectTradePacket;
import net.minecraft.network.play.client.CSetDifficultyPacket;
import net.minecraft.network.play.client.CSpectatePacket;
import net.minecraft.network.play.client.CSteerBoatPacket;
import net.minecraft.network.play.client.CTabCompletePacket;
import net.minecraft.network.play.client.CUpdateBeaconPacket;
import net.minecraft.network.play.client.CUpdateCommandBlockPacket;
import net.minecraft.network.play.client.CUpdateJigsawBlockPacket;
import net.minecraft.network.play.client.CUpdateMinecartCommandBlockPacket;
import net.minecraft.network.play.client.CUpdateRecipeBookStatusPacket;
import net.minecraft.network.play.client.CUpdateSignPacket;
import net.minecraft.network.play.client.CUpdateStructureBlockPacket;
import net.minecraft.network.play.client.CUseEntityPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.network.play.server.SChatPacket;
import net.minecraft.network.play.server.SConfirmTransactionPacket;
import net.minecraft.network.play.server.SDisconnectPacket;
import net.minecraft.network.play.server.SHeldItemChangePacket;
import net.minecraft.network.play.server.SKeepAlivePacket;
import net.minecraft.network.play.server.SMoveVehiclePacket;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.network.play.server.SQueryNBTResponsePacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.network.play.server.STabCompletePacket;
import net.minecraft.potion.Effects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.CommandBlockLogic;
import net.minecraft.tileentity.CommandBlockTileEntity;
import net.minecraft.tileentity.JigsawTileEntity;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.StructureBlockTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerPlayNetHandler
implements IServerPlayNetHandler {
    private static final Logger field_147370_c = LogManager.getLogger();
    public final NetworkManager field_147371_a;
    private final MinecraftServer field_147367_d;
    public ServerPlayerEntity field_147369_b;
    private int field_147368_e;
    private long field_194402_f;
    private boolean field_194403_g;
    private long field_194404_h;
    private int field_147374_l;
    private int field_147375_m;
    private final Int2ShortMap field_147372_n = new Int2ShortOpenHashMap();
    private double field_184349_l;
    private double field_184350_m;
    private double field_184351_n;
    private double field_184352_o;
    private double field_184353_p;
    private double field_184354_q;
    private Entity field_184355_r;
    private double field_184356_s;
    private double field_184357_t;
    private double field_184358_u;
    private double field_184359_v;
    private double field_184360_w;
    private double field_184361_x;
    private Vector3d field_184362_y;
    private int field_184363_z;
    private int field_184343_A;
    private boolean field_184344_B;
    private int field_147365_f;
    private boolean field_184345_D;
    private int field_184346_E;
    private int field_184347_F;
    private int field_184348_G;

    public ServerPlayNetHandler(MinecraftServer minecraftServer, NetworkManager networkManager, ServerPlayerEntity serverPlayerEntity) {
        this.field_147367_d = minecraftServer;
        this.field_147371_a = networkManager;
        networkManager.func_150719_a(this);
        this.field_147369_b = serverPlayerEntity;
        serverPlayerEntity.field_71135_a = this;
    }

    public void func_73660_a() {
        this.func_184342_d();
        this.field_147369_b.field_70169_q = this.field_147369_b.func_226277_ct_();
        this.field_147369_b.field_70167_r = this.field_147369_b.func_226278_cu_();
        this.field_147369_b.field_70166_s = this.field_147369_b.func_226281_cx_();
        this.field_147369_b.func_71127_g();
        this.field_147369_b.func_70080_a(this.field_184349_l, this.field_184350_m, this.field_184351_n, this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
        ++this.field_147368_e;
        this.field_184348_G = this.field_184347_F;
        if (this.field_184344_B && !this.field_147369_b.func_70608_bn()) {
            if (++this.field_147365_f > 80) {
                field_147370_c.warn("{} was kicked for floating too long!", (Object)this.field_147369_b.func_200200_C_().getString());
                this.func_194028_b(new TranslationTextComponent("multiplayer.disconnect.flying"));
                return;
            }
        } else {
            this.field_184344_B = false;
            this.field_147365_f = 0;
        }
        this.field_184355_r = this.field_147369_b.func_184208_bv();
        if (this.field_184355_r == this.field_147369_b || this.field_184355_r.func_184179_bs() != this.field_147369_b) {
            this.field_184355_r = null;
            this.field_184345_D = false;
            this.field_184346_E = 0;
        } else {
            this.field_184356_s = this.field_184355_r.func_226277_ct_();
            this.field_184357_t = this.field_184355_r.func_226278_cu_();
            this.field_184358_u = this.field_184355_r.func_226281_cx_();
            this.field_184359_v = this.field_184355_r.func_226277_ct_();
            this.field_184360_w = this.field_184355_r.func_226278_cu_();
            this.field_184361_x = this.field_184355_r.func_226281_cx_();
            if (this.field_184345_D && this.field_147369_b.func_184208_bv().func_184179_bs() == this.field_147369_b) {
                if (++this.field_184346_E > 80) {
                    field_147370_c.warn("{} was kicked for floating a vehicle too long!", (Object)this.field_147369_b.func_200200_C_().getString());
                    this.func_194028_b(new TranslationTextComponent("multiplayer.disconnect.flying"));
                    return;
                }
            } else {
                this.field_184345_D = false;
                this.field_184346_E = 0;
            }
        }
        this.field_147367_d.func_213185_aS().func_76320_a("keepAlive");
        long l = Util.func_211177_b();
        if (l - this.field_194402_f >= 15000L) {
            if (this.field_194403_g) {
                this.func_194028_b(new TranslationTextComponent("disconnect.timeout"));
            } else {
                this.field_194403_g = true;
                this.field_194402_f = l;
                this.field_194404_h = l;
                this.func_147359_a(new SKeepAlivePacket(this.field_194404_h));
            }
        }
        this.field_147367_d.func_213185_aS().func_76319_b();
        if (this.field_147374_l > 0) {
            --this.field_147374_l;
        }
        if (this.field_147375_m > 0) {
            --this.field_147375_m;
        }
        if (this.field_147369_b.func_154331_x() > 0L && this.field_147367_d.func_143007_ar() > 0 && Util.func_211177_b() - this.field_147369_b.func_154331_x() > (long)(this.field_147367_d.func_143007_ar() * 1000 * 60)) {
            this.func_194028_b(new TranslationTextComponent("multiplayer.disconnect.idling"));
        }
    }

    public void func_184342_d() {
        this.field_184349_l = this.field_147369_b.func_226277_ct_();
        this.field_184350_m = this.field_147369_b.func_226278_cu_();
        this.field_184351_n = this.field_147369_b.func_226281_cx_();
        this.field_184352_o = this.field_147369_b.func_226277_ct_();
        this.field_184353_p = this.field_147369_b.func_226278_cu_();
        this.field_184354_q = this.field_147369_b.func_226281_cx_();
    }

    @Override
    public NetworkManager func_147298_b() {
        return this.field_147371_a;
    }

    private boolean func_217264_d() {
        return this.field_147367_d.func_213199_b(this.field_147369_b.func_146103_bH());
    }

    public void func_194028_b(ITextComponent iTextComponent) {
        this.field_147371_a.func_201058_a(new SDisconnectPacket(iTextComponent), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)future -> this.field_147371_a.func_150718_a(iTextComponent)));
        this.field_147371_a.func_150721_g();
        this.field_147367_d.func_213167_f(this.field_147371_a::func_179293_l);
    }

    @Override
    public void func_147358_a(CInputPacket cInputPacket) {
        PacketThreadUtil.func_218796_a(cInputPacket, this, this.field_147369_b.func_71121_q());
        this.field_147369_b.func_110430_a(cInputPacket.func_149620_c(), cInputPacket.func_192620_b(), cInputPacket.func_149618_e(), cInputPacket.func_229755_e_());
    }

    private static boolean func_183006_b(CPlayerPacket cPlayerPacket) {
        if (!(Doubles.isFinite((double)cPlayerPacket.func_186997_a(0.0)) && Doubles.isFinite((double)cPlayerPacket.func_186996_b(0.0)) && Doubles.isFinite((double)cPlayerPacket.func_187000_c(0.0)) && Floats.isFinite((float)cPlayerPacket.func_186998_b(0.0f)) && Floats.isFinite((float)cPlayerPacket.func_186999_a(0.0f)))) {
            return true;
        }
        return Math.abs(cPlayerPacket.func_186997_a(0.0)) > 3.0E7 || Math.abs(cPlayerPacket.func_186996_b(0.0)) > 3.0E7 || Math.abs(cPlayerPacket.func_187000_c(0.0)) > 3.0E7;
    }

    private static boolean func_184341_b(CMoveVehiclePacket cMoveVehiclePacket) {
        return !Doubles.isFinite((double)cMoveVehiclePacket.func_187004_a()) || !Doubles.isFinite((double)cMoveVehiclePacket.func_187002_b()) || !Doubles.isFinite((double)cMoveVehiclePacket.func_187003_c()) || !Floats.isFinite((float)cMoveVehiclePacket.func_187005_e()) || !Floats.isFinite((float)cMoveVehiclePacket.func_187006_d());
    }

    @Override
    public void func_184338_a(CMoveVehiclePacket cMoveVehiclePacket) {
        PacketThreadUtil.func_218796_a(cMoveVehiclePacket, this, this.field_147369_b.func_71121_q());
        if (ServerPlayNetHandler.func_184341_b(cMoveVehiclePacket)) {
            this.func_194028_b(new TranslationTextComponent("multiplayer.disconnect.invalid_vehicle_movement"));
            return;
        }
        Entity entity = this.field_147369_b.func_184208_bv();
        if (entity != this.field_147369_b && entity.func_184179_bs() == this.field_147369_b && entity == this.field_184355_r) {
            ServerWorld serverWorld = this.field_147369_b.func_71121_q();
            double \u26032 = entity.func_226277_ct_();
            double \u26033 = entity.func_226278_cu_();
            double \u26034 = entity.func_226281_cx_();
            double \u26035 = cMoveVehiclePacket.func_187004_a();
            double \u26036 = cMoveVehiclePacket.func_187002_b();
            double \u26037 = cMoveVehiclePacket.func_187003_c();
            float \u26038 = cMoveVehiclePacket.func_187006_d();
            float \u26039 = cMoveVehiclePacket.func_187005_e();
            double \u260310 = \u26035 - this.field_184356_s;
            double \u260311 = \u26036 - this.field_184357_t;
            double \u260312 = \u26037 - this.field_184358_u;
            double \u260313 = \u260310 * \u260310 + \u260311 * \u260311 + \u260312 * \u260312;
            double \u260314 = entity.func_213322_ci().func_189985_c();
            if (\u260313 - \u260314 > 100.0 && !this.func_217264_d()) {
                field_147370_c.warn("{} (vehicle of {}) moved too quickly! {},{},{}", (Object)entity.func_200200_C_().getString(), (Object)this.field_147369_b.func_200200_C_().getString(), (Object)\u260310, (Object)\u260311, (Object)\u260312);
                this.field_147371_a.func_179290_a(new SMoveVehiclePacket(entity));
                return;
            }
            boolean \u260315 = serverWorld.func_226665_a__(entity, entity.func_174813_aQ().func_186664_h(0.0625));
            \u260310 = \u26035 - this.field_184359_v;
            \u260311 = \u26036 - this.field_184360_w - 1.0E-6;
            \u260312 = \u26037 - this.field_184361_x;
            entity.func_213315_a(MoverType.PLAYER, new Vector3d(\u260310, \u260311, \u260312));
            double \u260316 = \u260311;
            \u260310 = \u26035 - entity.func_226277_ct_();
            \u260311 = \u26036 - entity.func_226278_cu_();
            if (\u260311 > -0.5 || \u260311 < 0.5) {
                \u260311 = 0.0;
            }
            \u260312 = \u26037 - entity.func_226281_cx_();
            \u260313 = \u260310 * \u260310 + \u260311 * \u260311 + \u260312 * \u260312;
            boolean \u260317 = false;
            if (\u260313 > 0.0625) {
                \u260317 = true;
                field_147370_c.warn("{} (vehicle of {}) moved wrongly! {}", (Object)entity.func_200200_C_().getString(), (Object)this.field_147369_b.func_200200_C_().getString(), (Object)Math.sqrt(\u260313));
            }
            entity.func_70080_a(\u26035, \u26036, \u26037, \u26038, \u26039);
            boolean \u260318 = serverWorld.func_226665_a__(entity, entity.func_174813_aQ().func_186664_h(0.0625));
            if (\u260315 && (\u260317 || !\u260318)) {
                entity.func_70080_a(\u26032, \u26033, \u26034, \u26038, \u26039);
                this.field_147371_a.func_179290_a(new SMoveVehiclePacket(entity));
                return;
            }
            this.field_147369_b.func_71121_q().func_72863_F().func_217221_a(this.field_147369_b);
            this.field_147369_b.func_71000_j(this.field_147369_b.func_226277_ct_() - \u26032, this.field_147369_b.func_226278_cu_() - \u26033, this.field_147369_b.func_226281_cx_() - \u26034);
            this.field_184345_D = \u260316 >= -0.03125 && !this.field_147367_d.func_71231_X() && this.func_241162_a_(entity);
            this.field_184359_v = entity.func_226277_ct_();
            this.field_184360_w = entity.func_226278_cu_();
            this.field_184361_x = entity.func_226281_cx_();
        }
    }

    private boolean func_241162_a_(Entity entity) {
        return entity.field_70170_p.func_234853_a_(entity.func_174813_aQ().func_186662_g(0.0625).func_72321_a(0.0, -0.55, 0.0)).allMatch(AbstractBlock.AbstractBlockState::func_196958_f);
    }

    @Override
    public void func_184339_a(CConfirmTeleportPacket cConfirmTeleportPacket) {
        PacketThreadUtil.func_218796_a(cConfirmTeleportPacket, this, this.field_147369_b.func_71121_q());
        if (cConfirmTeleportPacket.func_186987_a() == this.field_184363_z) {
            this.field_147369_b.func_70080_a(this.field_184362_y.field_72450_a, this.field_184362_y.field_72448_b, this.field_184362_y.field_72449_c, this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
            this.field_184352_o = this.field_184362_y.field_72450_a;
            this.field_184353_p = this.field_184362_y.field_72448_b;
            this.field_184354_q = this.field_184362_y.field_72449_c;
            if (this.field_147369_b.func_184850_K()) {
                this.field_147369_b.func_184846_L();
            }
            this.field_184362_y = null;
        }
    }

    @Override
    public void func_191984_a(CMarkRecipeSeenPacket cMarkRecipeSeenPacket) {
        PacketThreadUtil.func_218796_a(cMarkRecipeSeenPacket, this, this.field_147369_b.func_71121_q());
        this.field_147367_d.func_199529_aN().func_215367_a(cMarkRecipeSeenPacket.func_244321_b()).ifPresent(this.field_147369_b.func_192037_E()::func_194074_f);
    }

    @Override
    public void func_241831_a(CUpdateRecipeBookStatusPacket cUpdateRecipeBookStatusPacket) {
        PacketThreadUtil.func_218796_a(cUpdateRecipeBookStatusPacket, this, this.field_147369_b.func_71121_q());
        this.field_147369_b.func_192037_E().func_242144_a(cUpdateRecipeBookStatusPacket.func_244317_b(), cUpdateRecipeBookStatusPacket.func_244318_c(), cUpdateRecipeBookStatusPacket.func_244319_d());
    }

    @Override
    public void func_194027_a(CSeenAdvancementsPacket cSeenAdvancementsPacket) {
        PacketThreadUtil.func_218796_a(cSeenAdvancementsPacket, this, this.field_147369_b.func_71121_q());
        if (cSeenAdvancementsPacket.func_194162_b() == CSeenAdvancementsPacket.Action.OPENED_TAB) {
            ResourceLocation resourceLocation = cSeenAdvancementsPacket.func_194165_c();
            Advancement \u26032 = this.field_147367_d.func_191949_aK().func_192778_a(resourceLocation);
            if (\u26032 != null) {
                this.field_147369_b.func_192039_O().func_194220_a(\u26032);
            }
        }
    }

    @Override
    public void func_195518_a(CTabCompletePacket cTabCompletePacket) {
        PacketThreadUtil.func_218796_a(cTabCompletePacket, this, this.field_147369_b.func_71121_q());
        StringReader stringReader = new StringReader(cTabCompletePacket.func_197707_b());
        if (stringReader.canRead() && stringReader.peek() == '/') {
            stringReader.skip();
        }
        ParseResults \u26032 = this.field_147367_d.func_195571_aL().func_197054_a().parse(stringReader, (Object)this.field_147369_b.func_195051_bN());
        this.field_147367_d.func_195571_aL().func_197054_a().getCompletionSuggestions(\u26032).thenAccept(suggestions -> this.field_147371_a.func_179290_a(new STabCompletePacket(cTabCompletePacket.func_197709_a(), (Suggestions)suggestions)));
    }

    @Override
    public void func_210153_a(CUpdateCommandBlockPacket cUpdateCommandBlockPacket) {
        PacketThreadUtil.func_218796_a(cUpdateCommandBlockPacket, this, this.field_147369_b.func_71121_q());
        if (!this.field_147367_d.func_82356_Z()) {
            this.field_147369_b.func_145747_a(new TranslationTextComponent("advMode.notEnabled"), Util.field_240973_b_);
            return;
        }
        if (!this.field_147369_b.func_195070_dx()) {
            this.field_147369_b.func_145747_a(new TranslationTextComponent("advMode.notAllowed"), Util.field_240973_b_);
            return;
        }
        CommandBlockLogic commandBlockLogic = null;
        CommandBlockTileEntity \u26032 = null;
        BlockPos \u26033 = cUpdateCommandBlockPacket.func_210361_a();
        TileEntity \u26034 = this.field_147369_b.field_70170_p.func_175625_s(\u26033);
        if (\u26034 instanceof CommandBlockTileEntity) {
            \u26032 = (CommandBlockTileEntity)\u26034;
            commandBlockLogic = \u26032.func_145993_a();
        }
        String \u26035 = cUpdateCommandBlockPacket.func_210359_b();
        boolean \u26036 = cUpdateCommandBlockPacket.func_210363_c();
        if (commandBlockLogic != null) {
            CommandBlockTileEntity.Mode mode = \u26032.func_184251_i();
            Direction \u26037 = this.field_147369_b.field_70170_p.func_180495_p(\u26033).func_177229_b(CommandBlockBlock.field_185564_a);
            switch (cUpdateCommandBlockPacket.func_210360_f()) {
                case SEQUENCE: {
                    BlockState blockState = Blocks.field_185777_dd.func_176223_P();
                    this.field_147369_b.field_70170_p.func_180501_a(\u26033, (BlockState)((BlockState)blockState.func_206870_a(CommandBlockBlock.field_185564_a, \u26037)).func_206870_a(CommandBlockBlock.field_185565_b, cUpdateCommandBlockPacket.func_210364_d()), 2);
                    break;
                }
                case AUTO: {
                    BlockState blockState = Blocks.field_185776_dc.func_176223_P();
                    this.field_147369_b.field_70170_p.func_180501_a(\u26033, (BlockState)((BlockState)blockState.func_206870_a(CommandBlockBlock.field_185564_a, \u26037)).func_206870_a(CommandBlockBlock.field_185565_b, cUpdateCommandBlockPacket.func_210364_d()), 2);
                    break;
                }
                default: {
                    BlockState blockState = Blocks.field_150483_bI.func_176223_P();
                    this.field_147369_b.field_70170_p.func_180501_a(\u26033, (BlockState)((BlockState)blockState.func_206870_a(CommandBlockBlock.field_185564_a, \u26037)).func_206870_a(CommandBlockBlock.field_185565_b, cUpdateCommandBlockPacket.func_210364_d()), 2);
                }
            }
            \u26034.func_145829_t();
            this.field_147369_b.field_70170_p.func_175690_a(\u26033, \u26034);
            commandBlockLogic.func_145752_a(\u26035);
            commandBlockLogic.func_175573_a(\u26036);
            if (!\u26036) {
                commandBlockLogic.func_145750_b(null);
            }
            \u26032.func_184253_b(cUpdateCommandBlockPacket.func_210362_e());
            if (mode != cUpdateCommandBlockPacket.func_210360_f()) {
                \u26032.func_226987_h_();
            }
            commandBlockLogic.func_145756_e();
            if (!StringUtils.func_151246_b(\u26035)) {
                this.field_147369_b.func_145747_a(new TranslationTextComponent("advMode.setCommand.success", \u26035), Util.field_240973_b_);
            }
        }
    }

    @Override
    public void func_210158_a(CUpdateMinecartCommandBlockPacket cUpdateMinecartCommandBlockPacket) {
        PacketThreadUtil.func_218796_a(cUpdateMinecartCommandBlockPacket, this, this.field_147369_b.func_71121_q());
        if (!this.field_147367_d.func_82356_Z()) {
            this.field_147369_b.func_145747_a(new TranslationTextComponent("advMode.notEnabled"), Util.field_240973_b_);
            return;
        }
        if (!this.field_147369_b.func_195070_dx()) {
            this.field_147369_b.func_145747_a(new TranslationTextComponent("advMode.notAllowed"), Util.field_240973_b_);
            return;
        }
        CommandBlockLogic commandBlockLogic = cUpdateMinecartCommandBlockPacket.func_210371_a(this.field_147369_b.field_70170_p);
        if (commandBlockLogic != null) {
            commandBlockLogic.func_145752_a(cUpdateMinecartCommandBlockPacket.func_210372_a());
            commandBlockLogic.func_175573_a(cUpdateMinecartCommandBlockPacket.func_210373_b());
            if (!cUpdateMinecartCommandBlockPacket.func_210373_b()) {
                commandBlockLogic.func_145750_b(null);
            }
            commandBlockLogic.func_145756_e();
            this.field_147369_b.func_145747_a(new TranslationTextComponent("advMode.setCommand.success", cUpdateMinecartCommandBlockPacket.func_210372_a()), Util.field_240973_b_);
        }
    }

    @Override
    public void func_210152_a(CPickItemPacket cPickItemPacket) {
        PacketThreadUtil.func_218796_a(cPickItemPacket, this, this.field_147369_b.func_71121_q());
        this.field_147369_b.field_71071_by.func_184430_d(cPickItemPacket.func_210349_a());
        this.field_147369_b.field_71135_a.func_147359_a(new SSetSlotPacket(-2, this.field_147369_b.field_71071_by.field_70461_c, this.field_147369_b.field_71071_by.func_70301_a(this.field_147369_b.field_71071_by.field_70461_c)));
        this.field_147369_b.field_71135_a.func_147359_a(new SSetSlotPacket(-2, cPickItemPacket.func_210349_a(), this.field_147369_b.field_71071_by.func_70301_a(cPickItemPacket.func_210349_a())));
        this.field_147369_b.field_71135_a.func_147359_a(new SHeldItemChangePacket(this.field_147369_b.field_71071_by.field_70461_c));
    }

    @Override
    public void func_210155_a(CRenameItemPacket cRenameItemPacket) {
        PacketThreadUtil.func_218796_a(cRenameItemPacket, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.field_71070_bA instanceof RepairContainer) {
            RepairContainer repairContainer = (RepairContainer)this.field_147369_b.field_71070_bA;
            String \u26032 = SharedConstants.func_71565_a(cRenameItemPacket.func_210351_a());
            if (\u26032.length() <= 35) {
                repairContainer.func_82850_a(\u26032);
            }
        }
    }

    @Override
    public void func_210154_a(CUpdateBeaconPacket cUpdateBeaconPacket) {
        PacketThreadUtil.func_218796_a(cUpdateBeaconPacket, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.field_71070_bA instanceof BeaconContainer) {
            ((BeaconContainer)this.field_147369_b.field_71070_bA).func_216966_c(cUpdateBeaconPacket.func_210355_a(), cUpdateBeaconPacket.func_210356_b());
        }
    }

    @Override
    public void func_210157_a(CUpdateStructureBlockPacket cUpdateStructureBlockPacket2) {
        PacketThreadUtil.func_218796_a(cUpdateStructureBlockPacket2, this, this.field_147369_b.func_71121_q());
        if (!this.field_147369_b.func_195070_dx()) {
            return;
        }
        BlockPos blockPos = cUpdateStructureBlockPacket2.func_210380_a();
        BlockState \u26032 = this.field_147369_b.field_70170_p.func_180495_p(blockPos);
        TileEntity \u26033 = this.field_147369_b.field_70170_p.func_175625_s(blockPos);
        if (\u26033 instanceof StructureBlockTileEntity) {
            StructureBlockTileEntity structureBlockTileEntity = (StructureBlockTileEntity)\u26033;
            structureBlockTileEntity.func_184405_a(cUpdateStructureBlockPacket2.func_210378_c());
            structureBlockTileEntity.func_184404_a(cUpdateStructureBlockPacket2.func_210377_d());
            structureBlockTileEntity.func_184414_b(cUpdateStructureBlockPacket2.func_210383_e());
            structureBlockTileEntity.func_184409_c(cUpdateStructureBlockPacket2.func_210385_f());
            structureBlockTileEntity.func_184411_a(cUpdateStructureBlockPacket2.func_210386_g());
            structureBlockTileEntity.func_184408_a(cUpdateStructureBlockPacket2.func_210379_h());
            structureBlockTileEntity.func_184410_b(cUpdateStructureBlockPacket2.func_210388_i());
            structureBlockTileEntity.func_184406_a(cUpdateStructureBlockPacket2.func_210389_j());
            structureBlockTileEntity.func_189703_e(cUpdateStructureBlockPacket2.func_210390_k());
            structureBlockTileEntity.func_189710_f(cUpdateStructureBlockPacket2.func_210387_l());
            structureBlockTileEntity.func_189718_a(cUpdateStructureBlockPacket2.func_210382_m());
            structureBlockTileEntity.func_189725_a(cUpdateStructureBlockPacket2.func_210381_n());
            if (structureBlockTileEntity.func_208404_d()) {
                String string = structureBlockTileEntity.func_189715_d();
                if (cUpdateStructureBlockPacket2.func_210384_b() == StructureBlockTileEntity.UpdateCommand.SAVE_AREA) {
                    if (structureBlockTileEntity.func_184419_m()) {
                        this.field_147369_b.func_146105_b(new TranslationTextComponent("structure_block.save_success", string), false);
                    } else {
                        this.field_147369_b.func_146105_b(new TranslationTextComponent("structure_block.save_failure", string), false);
                    }
                } else if (cUpdateStructureBlockPacket2.func_210384_b() == StructureBlockTileEntity.UpdateCommand.LOAD_AREA) {
                    if (!structureBlockTileEntity.func_189709_F()) {
                        this.field_147369_b.func_146105_b(new TranslationTextComponent("structure_block.load_not_found", string), false);
                    } else if (structureBlockTileEntity.func_242687_a(this.field_147369_b.func_71121_q())) {
                        this.field_147369_b.func_146105_b(new TranslationTextComponent("structure_block.load_success", string), false);
                    } else {
                        this.field_147369_b.func_146105_b(new TranslationTextComponent("structure_block.load_prepare", string), false);
                    }
                } else if (cUpdateStructureBlockPacket2.func_210384_b() == StructureBlockTileEntity.UpdateCommand.SCAN_AREA) {
                    if (structureBlockTileEntity.func_184417_l()) {
                        this.field_147369_b.func_146105_b(new TranslationTextComponent("structure_block.size_success", string), false);
                    } else {
                        this.field_147369_b.func_146105_b(new TranslationTextComponent("structure_block.size_failure"), false);
                    }
                }
            } else {
                CUpdateStructureBlockPacket cUpdateStructureBlockPacket2;
                this.field_147369_b.func_146105_b(new TranslationTextComponent("structure_block.invalid_structure_name", cUpdateStructureBlockPacket2.func_210377_d()), false);
            }
            structureBlockTileEntity.func_70296_d();
            this.field_147369_b.field_70170_p.func_184138_a(blockPos, \u26032, \u26032, 3);
        }
    }

    @Override
    public void func_217262_a(CUpdateJigsawBlockPacket cUpdateJigsawBlockPacket) {
        PacketThreadUtil.func_218796_a(cUpdateJigsawBlockPacket, this, this.field_147369_b.func_71121_q());
        if (!this.field_147369_b.func_195070_dx()) {
            return;
        }
        BlockPos blockPos = cUpdateJigsawBlockPacket.func_218789_b();
        BlockState \u26032 = this.field_147369_b.field_70170_p.func_180495_p(blockPos);
        TileEntity \u26033 = this.field_147369_b.field_70170_p.func_175625_s(blockPos);
        if (\u26033 instanceof JigsawTileEntity) {
            JigsawTileEntity jigsawTileEntity = (JigsawTileEntity)\u26033;
            jigsawTileEntity.func_235664_a_(cUpdateJigsawBlockPacket.func_240851_c_());
            jigsawTileEntity.func_235666_b_(cUpdateJigsawBlockPacket.func_240852_d_());
            jigsawTileEntity.func_235667_c_(cUpdateJigsawBlockPacket.func_240853_e_());
            jigsawTileEntity.func_214055_a(cUpdateJigsawBlockPacket.func_218788_e());
            jigsawTileEntity.func_235662_a_(cUpdateJigsawBlockPacket.func_240854_g_());
            jigsawTileEntity.func_70296_d();
            this.field_147369_b.field_70170_p.func_184138_a(blockPos, \u26032, \u26032, 3);
        }
    }

    @Override
    public void func_230549_a_(CJigsawBlockGeneratePacket cJigsawBlockGeneratePacket) {
        PacketThreadUtil.func_218796_a(cJigsawBlockGeneratePacket, this, this.field_147369_b.func_71121_q());
        if (!this.field_147369_b.func_195070_dx()) {
            return;
        }
        BlockPos blockPos = cJigsawBlockGeneratePacket.func_240844_b_();
        TileEntity \u26032 = this.field_147369_b.field_70170_p.func_175625_s(blockPos);
        if (\u26032 instanceof JigsawTileEntity) {
            JigsawTileEntity jigsawTileEntity = (JigsawTileEntity)\u26032;
            jigsawTileEntity.func_235665_a_(this.field_147369_b.func_71121_q(), cJigsawBlockGeneratePacket.func_240845_c_(), cJigsawBlockGeneratePacket.func_240846_d_());
        }
    }

    @Override
    public void func_210159_a(CSelectTradePacket cSelectTradePacket) {
        PacketThreadUtil.func_218796_a(cSelectTradePacket, this, this.field_147369_b.func_71121_q());
        int n = cSelectTradePacket.func_210353_a();
        Container \u26032 = this.field_147369_b.field_71070_bA;
        if (\u26032 instanceof MerchantContainer) {
            MerchantContainer merchantContainer = (MerchantContainer)\u26032;
            merchantContainer.func_75175_c(n);
            merchantContainer.func_217046_g(n);
        }
    }

    @Override
    public void func_210156_a(CEditBookPacket cEditBookPacket) {
        PacketThreadUtil.func_218796_a(cEditBookPacket, this, this.field_147369_b.func_71121_q());
        ItemStack itemStack = cEditBookPacket.func_210346_a();
        if (itemStack.func_190926_b()) {
            return;
        }
        if (!WritableBookItem.func_150930_a(itemStack.func_77978_p())) {
            return;
        }
        \u2603 = this.field_147369_b.func_184586_b(cEditBookPacket.func_212644_d());
        if (itemStack.func_77973_b() == Items.field_151099_bA && \u2603.func_77973_b() == Items.field_151099_bA) {
            if (cEditBookPacket.func_210345_b()) {
                \u2603 = new ItemStack(Items.field_151164_bB);
                CompoundNBT compoundNBT = \u2603.func_77978_p();
                if (compoundNBT != null) {
                    \u2603.func_77982_d(compoundNBT.func_74737_b());
                }
                \u2603.func_77983_a("author", StringNBT.func_229705_a_(this.field_147369_b.func_200200_C_().getString()));
                \u2603.func_77983_a("title", StringNBT.func_229705_a_(itemStack.func_77978_p().func_74779_i("title")));
                ListNBT \u26032 = itemStack.func_77978_p().func_150295_c("pages", 8);
                for (int i = 0; i < \u26032.size(); ++i) {
                    String string = \u26032.func_150307_f(i);
                    StringTextComponent \u26033 = new StringTextComponent(string);
                    string = ITextComponent.Serializer.func_150696_a(\u26033);
                    \u26032.set(i, StringNBT.func_229705_a_(string));
                }
                \u2603.func_77983_a("pages", \u26032);
                this.field_147369_b.func_184611_a(cEditBookPacket.func_212644_d(), \u2603);
            } else {
                \u2603.func_77983_a("pages", itemStack.func_77978_p().func_150295_c("pages", 8));
            }
        }
    }

    @Override
    public void func_211526_a(CQueryEntityNBTPacket cQueryEntityNBTPacket) {
        PacketThreadUtil.func_218796_a(cQueryEntityNBTPacket, this, this.field_147369_b.func_71121_q());
        if (!this.field_147369_b.func_211513_k(2)) {
            return;
        }
        Entity entity = this.field_147369_b.func_71121_q().func_73045_a(cQueryEntityNBTPacket.func_211720_c());
        if (entity != null) {
            CompoundNBT compoundNBT = entity.func_189511_e(new CompoundNBT());
            this.field_147369_b.field_71135_a.func_147359_a(new SQueryNBTResponsePacket(cQueryEntityNBTPacket.func_211721_b(), compoundNBT));
        }
    }

    @Override
    public void func_211525_a(CQueryTileEntityNBTPacket cQueryTileEntityNBTPacket) {
        PacketThreadUtil.func_218796_a(cQueryTileEntityNBTPacket, this, this.field_147369_b.func_71121_q());
        if (!this.field_147369_b.func_211513_k(2)) {
            return;
        }
        TileEntity tileEntity = this.field_147369_b.func_71121_q().func_175625_s(cQueryTileEntityNBTPacket.func_211717_c());
        CompoundNBT \u26032 = tileEntity != null ? tileEntity.func_189515_b(new CompoundNBT()) : null;
        this.field_147369_b.field_71135_a.func_147359_a(new SQueryNBTResponsePacket(cQueryTileEntityNBTPacket.func_211716_b(), \u26032));
    }

    @Override
    public void func_147347_a(CPlayerPacket cPlayerPacket) {
        PacketThreadUtil.func_218796_a(cPlayerPacket, this, this.field_147369_b.func_71121_q());
        if (ServerPlayNetHandler.func_183006_b(cPlayerPacket)) {
            this.func_194028_b(new TranslationTextComponent("multiplayer.disconnect.invalid_player_movement"));
            return;
        }
        ServerWorld serverWorld = this.field_147369_b.func_71121_q();
        if (this.field_147369_b.field_71136_j) {
            return;
        }
        if (this.field_147368_e == 0) {
            this.func_184342_d();
        }
        if (this.field_184362_y != null) {
            if (this.field_147368_e - this.field_184343_A > 20) {
                this.field_184343_A = this.field_147368_e;
                this.func_147364_a(this.field_184362_y.field_72450_a, this.field_184362_y.field_72448_b, this.field_184362_y.field_72449_c, this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
            }
            return;
        }
        this.field_184343_A = this.field_147368_e;
        if (this.field_147369_b.func_184218_aH()) {
            this.field_147369_b.func_70080_a(this.field_147369_b.func_226277_ct_(), this.field_147369_b.func_226278_cu_(), this.field_147369_b.func_226281_cx_(), cPlayerPacket.func_186999_a(this.field_147369_b.field_70177_z), cPlayerPacket.func_186998_b(this.field_147369_b.field_70125_A));
            this.field_147369_b.func_71121_q().func_72863_F().func_217221_a(this.field_147369_b);
            return;
        }
        double \u26032 = this.field_147369_b.func_226277_ct_();
        double \u26033 = this.field_147369_b.func_226278_cu_();
        double \u26034 = this.field_147369_b.func_226281_cx_();
        double \u26035 = this.field_147369_b.func_226278_cu_();
        double \u26036 = cPlayerPacket.func_186997_a(this.field_147369_b.func_226277_ct_());
        double \u26037 = cPlayerPacket.func_186996_b(this.field_147369_b.func_226278_cu_());
        double \u26038 = cPlayerPacket.func_187000_c(this.field_147369_b.func_226281_cx_());
        float \u26039 = cPlayerPacket.func_186999_a(this.field_147369_b.field_70177_z);
        float \u260310 = cPlayerPacket.func_186998_b(this.field_147369_b.field_70125_A);
        double \u260311 = \u26036 - this.field_184349_l;
        double \u260312 = \u26037 - this.field_184350_m;
        double \u260313 = \u26038 - this.field_184351_n;
        double \u260314 = this.field_147369_b.func_213322_ci().func_189985_c();
        double \u260315 = \u260311 * \u260311 + \u260312 * \u260312 + \u260313 * \u260313;
        if (this.field_147369_b.func_70608_bn()) {
            if (\u260315 > 1.0) {
                this.func_147364_a(this.field_147369_b.func_226277_ct_(), this.field_147369_b.func_226278_cu_(), this.field_147369_b.func_226281_cx_(), cPlayerPacket.func_186999_a(this.field_147369_b.field_70177_z), cPlayerPacket.func_186998_b(this.field_147369_b.field_70125_A));
            }
            return;
        }
        ++this.field_184347_F;
        int \u260316 = this.field_184347_F - this.field_184348_G;
        if (\u260316 > 5) {
            field_147370_c.debug("{} is sending move packets too frequently ({} packets since last tick)", (Object)this.field_147369_b.func_200200_C_().getString(), (Object)\u260316);
            \u260316 = 1;
        }
        if (!(this.field_147369_b.func_184850_K() || this.field_147369_b.func_71121_q().func_82736_K().func_223586_b(GameRules.field_223615_r) && this.field_147369_b.func_184613_cA())) {
            float f = \u2603 = this.field_147369_b.func_184613_cA() ? 300.0f : 100.0f;
            if (\u260315 - \u260314 > (double)(\u2603 * (float)\u260316) && !this.func_217264_d()) {
                field_147370_c.warn("{} moved too quickly! {},{},{}", (Object)this.field_147369_b.func_200200_C_().getString(), (Object)\u260311, (Object)\u260312, (Object)\u260313);
                this.func_147364_a(this.field_147369_b.func_226277_ct_(), this.field_147369_b.func_226278_cu_(), this.field_147369_b.func_226281_cx_(), this.field_147369_b.field_70177_z, this.field_147369_b.field_70125_A);
                return;
            }
        }
        AxisAlignedBB \u260317 = this.field_147369_b.func_174813_aQ();
        \u260311 = \u26036 - this.field_184352_o;
        \u260312 = \u26037 - this.field_184353_p;
        \u260313 = \u26038 - this.field_184354_q;
        boolean bl = \u2603 = \u260312 > 0.0;
        if (this.field_147369_b.func_233570_aj_() && !cPlayerPacket.func_149465_i() && \u2603) {
            this.field_147369_b.func_70664_aZ();
        }
        this.field_147369_b.func_213315_a(MoverType.PLAYER, new Vector3d(\u260311, \u260312, \u260313));
        double \u260318 = \u260312;
        \u260311 = \u26036 - this.field_147369_b.func_226277_ct_();
        \u260312 = \u26037 - this.field_147369_b.func_226278_cu_();
        if (\u260312 > -0.5 || \u260312 < 0.5) {
            \u260312 = 0.0;
        }
        \u260313 = \u26038 - this.field_147369_b.func_226281_cx_();
        \u260315 = \u260311 * \u260311 + \u260312 * \u260312 + \u260313 * \u260313;
        boolean \u260319 = false;
        if (!this.field_147369_b.func_184850_K() && \u260315 > 0.0625 && !this.field_147369_b.func_70608_bn() && !this.field_147369_b.field_71134_c.func_73083_d() && this.field_147369_b.field_71134_c.func_73081_b() != GameType.SPECTATOR) {
            \u260319 = true;
            field_147370_c.warn("{} moved wrongly!", (Object)this.field_147369_b.func_200200_C_().getString());
        }
        this.field_147369_b.func_70080_a(\u26036, \u26037, \u26038, \u26039, \u260310);
        if (!this.field_147369_b.field_70145_X && !this.field_147369_b.func_70608_bn() && (\u260319 && serverWorld.func_226665_a__(this.field_147369_b, \u260317) || this.func_241163_a_(serverWorld, \u260317))) {
            this.func_147364_a(\u26032, \u26033, \u26034, \u26039, \u260310);
            return;
        }
        this.field_184344_B = \u260318 >= -0.03125 && this.field_147369_b.field_71134_c.func_73081_b() != GameType.SPECTATOR && !this.field_147367_d.func_71231_X() && !this.field_147369_b.field_71075_bZ.field_75101_c && !this.field_147369_b.func_70644_a(Effects.field_188424_y) && !this.field_147369_b.func_184613_cA() && this.func_241162_a_(this.field_147369_b);
        this.field_147369_b.func_71121_q().func_72863_F().func_217221_a(this.field_147369_b);
        this.field_147369_b.func_71122_b(this.field_147369_b.func_226278_cu_() - \u26035, cPlayerPacket.func_149465_i());
        this.field_147369_b.func_230245_c_(cPlayerPacket.func_149465_i());
        if (\u2603) {
            this.field_147369_b.field_70143_R = 0.0f;
        }
        this.field_147369_b.func_71000_j(this.field_147369_b.func_226277_ct_() - \u26032, this.field_147369_b.func_226278_cu_() - \u26033, this.field_147369_b.func_226281_cx_() - \u26034);
        this.field_184352_o = this.field_147369_b.func_226277_ct_();
        this.field_184353_p = this.field_147369_b.func_226278_cu_();
        this.field_184354_q = this.field_147369_b.func_226281_cx_();
    }

    private boolean func_241163_a_(IWorldReader iWorldReader, AxisAlignedBB axisAlignedBB) {
        Stream<VoxelShape> stream = iWorldReader.func_234867_d_(this.field_147369_b, this.field_147369_b.func_174813_aQ().func_186664_h(1.0E-5f), entity -> true);
        VoxelShape \u26032 = VoxelShapes.func_197881_a(axisAlignedBB.func_186664_h(1.0E-5f));
        return stream.anyMatch(voxelShape2 -> !VoxelShapes.func_197879_c(voxelShape2, \u26032, IBooleanFunction.field_223238_i_));
    }

    public void func_147364_a(double d, double d2, double d3, float f, float f2) {
        this.func_175089_a(d, d2, d3, f, f2, Collections.emptySet());
    }

    public void func_175089_a(double d, double d2, double d3, float f, float f2, Set<SPlayerPositionLookPacket.Flags> set) {
        double d4 = set.contains((Object)SPlayerPositionLookPacket.Flags.X) ? this.field_147369_b.func_226277_ct_() : 0.0;
        \u2603 = set.contains((Object)SPlayerPositionLookPacket.Flags.Y) ? this.field_147369_b.func_226278_cu_() : 0.0;
        \u2603 = set.contains((Object)SPlayerPositionLookPacket.Flags.Z) ? this.field_147369_b.func_226281_cx_() : 0.0;
        float \u26032 = set.contains((Object)SPlayerPositionLookPacket.Flags.Y_ROT) ? this.field_147369_b.field_70177_z : 0.0f;
        float \u26033 = set.contains((Object)SPlayerPositionLookPacket.Flags.X_ROT) ? this.field_147369_b.field_70125_A : 0.0f;
        this.field_184362_y = new Vector3d(d, d2, d3);
        if (++this.field_184363_z == Integer.MAX_VALUE) {
            this.field_184363_z = 0;
        }
        this.field_184343_A = this.field_147368_e;
        this.field_147369_b.func_70080_a(d, d2, d3, f, f2);
        this.field_147369_b.field_71135_a.func_147359_a(new SPlayerPositionLookPacket(d - d4, d2 - \u2603, d3 - \u2603, f - \u26032, f2 - \u26033, set, this.field_184363_z));
    }

    @Override
    public void func_147345_a(CPlayerDiggingPacket cPlayerDiggingPacket) {
        PacketThreadUtil.func_218796_a(cPlayerDiggingPacket, this, this.field_147369_b.func_71121_q());
        BlockPos blockPos = cPlayerDiggingPacket.func_179715_a();
        this.field_147369_b.func_143004_u();
        CPlayerDiggingPacket.Action \u26032 = cPlayerDiggingPacket.func_180762_c();
        switch (\u26032) {
            case SWAP_ITEM_WITH_OFFHAND: {
                if (!this.field_147369_b.func_175149_v()) {
                    ItemStack itemStack = this.field_147369_b.func_184586_b(Hand.OFF_HAND);
                    this.field_147369_b.func_184611_a(Hand.OFF_HAND, this.field_147369_b.func_184586_b(Hand.MAIN_HAND));
                    this.field_147369_b.func_184611_a(Hand.MAIN_HAND, itemStack);
                    this.field_147369_b.func_184602_cy();
                }
                return;
            }
            case DROP_ITEM: {
                if (!this.field_147369_b.func_175149_v()) {
                    this.field_147369_b.func_225609_n_(false);
                }
                return;
            }
            case DROP_ALL_ITEMS: {
                if (!this.field_147369_b.func_175149_v()) {
                    this.field_147369_b.func_225609_n_(true);
                }
                return;
            }
            case RELEASE_USE_ITEM: {
                this.field_147369_b.func_184597_cx();
                return;
            }
            case START_DESTROY_BLOCK: 
            case ABORT_DESTROY_BLOCK: 
            case STOP_DESTROY_BLOCK: {
                this.field_147369_b.field_71134_c.func_225416_a(blockPos, \u26032, cPlayerDiggingPacket.func_179714_b(), this.field_147367_d.func_71207_Z());
                return;
            }
        }
        throw new IllegalArgumentException("Invalid player action");
    }

    private static boolean func_241166_a_(ServerPlayerEntity serverPlayerEntity, ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        return (item instanceof BlockItem || item instanceof BucketItem) && !serverPlayerEntity.func_184811_cZ().func_185141_a(item);
    }

    @Override
    public void func_184337_a(CPlayerTryUseItemOnBlockPacket cPlayerTryUseItemOnBlockPacket) {
        PacketThreadUtil.func_218796_a(cPlayerTryUseItemOnBlockPacket, this, this.field_147369_b.func_71121_q());
        ServerWorld serverWorld = this.field_147369_b.func_71121_q();
        Hand \u26032 = cPlayerTryUseItemOnBlockPacket.func_187022_c();
        ItemStack \u26033 = this.field_147369_b.func_184586_b(\u26032);
        BlockRayTraceResult \u26034 = cPlayerTryUseItemOnBlockPacket.func_218794_c();
        BlockPos \u26035 = \u26034.func_216350_a();
        Direction \u26036 = \u26034.func_216354_b();
        this.field_147369_b.func_143004_u();
        if (\u26035.func_177956_o() < this.field_147367_d.func_71207_Z()) {
            if (this.field_184362_y == null && this.field_147369_b.func_70092_e((double)\u26035.func_177958_n() + 0.5, (double)\u26035.func_177956_o() + 0.5, (double)\u26035.func_177952_p() + 0.5) < 64.0 && serverWorld.func_175660_a(this.field_147369_b, \u26035)) {
                ActionResultType actionResultType = this.field_147369_b.field_71134_c.func_219441_a(this.field_147369_b, serverWorld, \u26033, \u26032, \u26034);
                if (\u26036 == Direction.UP && !actionResultType.func_226246_a_() && \u26035.func_177956_o() >= this.field_147367_d.func_71207_Z() - 1 && ServerPlayNetHandler.func_241166_a_(this.field_147369_b, \u26033)) {
                    IFormattableTextComponent iFormattableTextComponent = new TranslationTextComponent("build.tooHigh", this.field_147367_d.func_71207_Z()).func_240699_a_(TextFormatting.RED);
                    this.field_147369_b.field_71135_a.func_147359_a(new SChatPacket(iFormattableTextComponent, ChatType.GAME_INFO, Util.field_240973_b_));
                } else if (actionResultType.func_226247_b_()) {
                    this.field_147369_b.func_226292_a_(\u26032, true);
                }
            }
        } else {
            IFormattableTextComponent iFormattableTextComponent = new TranslationTextComponent("build.tooHigh", this.field_147367_d.func_71207_Z()).func_240699_a_(TextFormatting.RED);
            this.field_147369_b.field_71135_a.func_147359_a(new SChatPacket(iFormattableTextComponent, ChatType.GAME_INFO, Util.field_240973_b_));
        }
        this.field_147369_b.field_71135_a.func_147359_a(new SChangeBlockPacket(serverWorld, \u26035));
        this.field_147369_b.field_71135_a.func_147359_a(new SChangeBlockPacket(serverWorld, \u26035.func_177972_a(\u26036)));
    }

    @Override
    public void func_147346_a(CPlayerTryUseItemPacket cPlayerTryUseItemPacket) {
        PacketThreadUtil.func_218796_a(cPlayerTryUseItemPacket, this, this.field_147369_b.func_71121_q());
        ServerWorld serverWorld = this.field_147369_b.func_71121_q();
        Hand \u26032 = cPlayerTryUseItemPacket.func_187028_a();
        ItemStack \u26033 = this.field_147369_b.func_184586_b(\u26032);
        this.field_147369_b.func_143004_u();
        if (\u26033.func_190926_b()) {
            return;
        }
        ActionResultType \u26034 = this.field_147369_b.field_71134_c.func_187250_a(this.field_147369_b, serverWorld, \u26033, \u26032);
        if (\u26034.func_226247_b_()) {
            this.field_147369_b.func_226292_a_(\u26032, true);
        }
    }

    @Override
    public void func_175088_a(CSpectatePacket cSpectatePacket) {
        PacketThreadUtil.func_218796_a(cSpectatePacket, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_175149_v()) {
            for (ServerWorld serverWorld : this.field_147367_d.func_212370_w()) {
                Entity entity = cSpectatePacket.func_179727_a(serverWorld);
                if (entity == null) continue;
                this.field_147369_b.func_200619_a(serverWorld, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
                return;
            }
        }
    }

    @Override
    public void func_175086_a(CResourcePackStatusPacket cResourcePackStatusPacket) {
    }

    @Override
    public void func_184340_a(CSteerBoatPacket cSteerBoatPacket) {
        PacketThreadUtil.func_218796_a(cSteerBoatPacket, this, this.field_147369_b.func_71121_q());
        Entity entity = this.field_147369_b.func_184187_bx();
        if (entity instanceof BoatEntity) {
            ((BoatEntity)entity).func_184445_a(cSteerBoatPacket.func_187012_a(), cSteerBoatPacket.func_187014_b());
        }
    }

    @Override
    public void func_147231_a(ITextComponent iTextComponent) {
        field_147370_c.info("{} lost connection: {}", (Object)this.field_147369_b.func_200200_C_().getString(), (Object)iTextComponent.getString());
        this.field_147367_d.func_147132_au();
        this.field_147367_d.func_184103_al().func_232641_a_(new TranslationTextComponent("multiplayer.player.left", this.field_147369_b.func_145748_c_()).func_240699_a_(TextFormatting.YELLOW), ChatType.SYSTEM, Util.field_240973_b_);
        this.field_147369_b.func_71123_m();
        this.field_147367_d.func_184103_al().func_72367_e(this.field_147369_b);
        if (this.func_217264_d()) {
            field_147370_c.info("Stopping singleplayer server as player logged out");
            this.field_147367_d.func_71263_m(false);
        }
    }

    public void func_147359_a(IPacket<?> iPacket) {
        this.func_211148_a(iPacket, null);
    }

    public void func_211148_a(IPacket<?> iPacket, @Nullable GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
        Object \u26032;
        if (iPacket instanceof SChatPacket) {
            SChatPacket sChatPacket = (SChatPacket)iPacket;
            \u26032 = this.field_147369_b.func_147096_v();
            if (\u26032 == ChatVisibility.HIDDEN && sChatPacket.func_192590_c() != ChatType.GAME_INFO) {
                return;
            }
            if (\u26032 == ChatVisibility.SYSTEM && !sChatPacket.func_148916_d()) {
                return;
            }
        }
        try {
            this.field_147371_a.func_201058_a(iPacket, genericFutureListener);
        }
        catch (Throwable throwable) {
            \u26032 = CrashReport.func_85055_a(throwable, "Sending packet");
            CrashReportCategory crashReportCategory = ((CrashReport)\u26032).func_85058_a("Packet being sent");
            crashReportCategory.func_189529_a("Packet class", () -> iPacket.getClass().getCanonicalName());
            throw new ReportedException((CrashReport)\u26032);
        }
    }

    @Override
    public void func_147355_a(CHeldItemChangePacket cHeldItemChangePacket) {
        PacketThreadUtil.func_218796_a(cHeldItemChangePacket, this, this.field_147369_b.func_71121_q());
        if (cHeldItemChangePacket.func_149614_c() < 0 || cHeldItemChangePacket.func_149614_c() >= PlayerInventory.func_70451_h()) {
            field_147370_c.warn("{} tried to set an invalid carried item", (Object)this.field_147369_b.func_200200_C_().getString());
            return;
        }
        if (this.field_147369_b.field_71071_by.field_70461_c != cHeldItemChangePacket.func_149614_c() && this.field_147369_b.func_184600_cs() == Hand.MAIN_HAND) {
            this.field_147369_b.func_184602_cy();
        }
        this.field_147369_b.field_71071_by.field_70461_c = cHeldItemChangePacket.func_149614_c();
        this.field_147369_b.func_143004_u();
    }

    @Override
    public void func_147354_a(CChatMessagePacket cChatMessagePacket) {
        PacketThreadUtil.func_218796_a(cChatMessagePacket, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.func_147096_v() == ChatVisibility.HIDDEN) {
            this.func_147359_a(new SChatPacket(new TranslationTextComponent("chat.cannotSend").func_240699_a_(TextFormatting.RED), ChatType.SYSTEM, Util.field_240973_b_));
            return;
        }
        this.field_147369_b.func_143004_u();
        String string = org.apache.commons.lang3.StringUtils.normalizeSpace((String)cChatMessagePacket.func_149439_c());
        for (int i = 0; i < string.length(); ++i) {
            if (SharedConstants.func_71566_a(string.charAt(i))) continue;
            this.func_194028_b(new TranslationTextComponent("multiplayer.disconnect.illegal_characters"));
            return;
        }
        if (string.startsWith("/")) {
            this.func_147361_d(string);
        } else {
            TranslationTextComponent translationTextComponent = new TranslationTextComponent("chat.type.text", this.field_147369_b.func_145748_c_(), string);
            this.field_147367_d.func_184103_al().func_232641_a_(translationTextComponent, ChatType.CHAT, this.field_147369_b.func_110124_au());
        }
        this.field_147374_l += 20;
        if (this.field_147374_l > 200 && !this.field_147367_d.func_184103_al().func_152596_g(this.field_147369_b.func_146103_bH())) {
            this.func_194028_b(new TranslationTextComponent("disconnect.spam"));
        }
    }

    private void func_147361_d(String string) {
        this.field_147367_d.func_195571_aL().func_197059_a(this.field_147369_b.func_195051_bN(), string);
    }

    @Override
    public void func_175087_a(CAnimateHandPacket cAnimateHandPacket) {
        PacketThreadUtil.func_218796_a(cAnimateHandPacket, this, this.field_147369_b.func_71121_q());
        this.field_147369_b.func_143004_u();
        this.field_147369_b.func_184609_a(cAnimateHandPacket.func_187018_a());
    }

    @Override
    public void func_147357_a(CEntityActionPacket cEntityActionPacket) {
        PacketThreadUtil.func_218796_a(cEntityActionPacket, this, this.field_147369_b.func_71121_q());
        this.field_147369_b.func_143004_u();
        switch (cEntityActionPacket.func_180764_b()) {
            case PRESS_SHIFT_KEY: {
                this.field_147369_b.func_226284_e_(true);
                break;
            }
            case RELEASE_SHIFT_KEY: {
                this.field_147369_b.func_226284_e_(false);
                break;
            }
            case START_SPRINTING: {
                this.field_147369_b.func_70031_b(true);
                break;
            }
            case STOP_SPRINTING: {
                this.field_147369_b.func_70031_b(false);
                break;
            }
            case STOP_SLEEPING: {
                if (!this.field_147369_b.func_70608_bn()) break;
                this.field_147369_b.func_225652_a_(false, true);
                this.field_184362_y = this.field_147369_b.func_213303_ch();
                break;
            }
            case START_RIDING_JUMP: {
                if (!(this.field_147369_b.func_184187_bx() instanceof IJumpingMount)) break;
                IJumpingMount iJumpingMount = (IJumpingMount)((Object)this.field_147369_b.func_184187_bx());
                int \u26032 = cEntityActionPacket.func_149512_e();
                if (!iJumpingMount.func_184776_b() || \u26032 <= 0) break;
                iJumpingMount.func_184775_b(\u26032);
                break;
            }
            case STOP_RIDING_JUMP: {
                if (!(this.field_147369_b.func_184187_bx() instanceof IJumpingMount)) break;
                \u2603 = (IJumpingMount)((Object)this.field_147369_b.func_184187_bx());
                \u2603.func_184777_r_();
                break;
            }
            case OPEN_INVENTORY: {
                if (!(this.field_147369_b.func_184187_bx() instanceof AbstractHorseEntity)) break;
                ((AbstractHorseEntity)this.field_147369_b.func_184187_bx()).func_110199_f(this.field_147369_b);
                break;
            }
            case START_FALL_FLYING: {
                if (this.field_147369_b.func_226566_ei_()) break;
                this.field_147369_b.func_226568_ek_();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid client command!");
            }
        }
    }

    @Override
    public void func_147340_a(CUseEntityPacket cUseEntityPacket) {
        PacketThreadUtil.func_218796_a(cUseEntityPacket, this, this.field_147369_b.func_71121_q());
        ServerWorld serverWorld = this.field_147369_b.func_71121_q();
        Entity \u26032 = cUseEntityPacket.func_149564_a(serverWorld);
        this.field_147369_b.func_143004_u();
        this.field_147369_b.func_226284_e_(cUseEntityPacket.func_241792_e_());
        if (\u26032 != null) {
            double d = 36.0;
            if (this.field_147369_b.func_70068_e(\u26032) < 36.0) {
                Hand hand = cUseEntityPacket.func_186994_b();
                ItemStack \u26033 = hand != null ? this.field_147369_b.func_184586_b(hand).func_77946_l() : ItemStack.field_190927_a;
                Optional<Object> \u26034 = Optional.empty();
                if (cUseEntityPacket.func_149565_c() == CUseEntityPacket.Action.INTERACT) {
                    \u26034 = Optional.of(this.field_147369_b.func_190775_a(\u26032, hand));
                } else if (cUseEntityPacket.func_149565_c() == CUseEntityPacket.Action.INTERACT_AT) {
                    \u26034 = Optional.of(\u26032.func_184199_a(this.field_147369_b, cUseEntityPacket.func_179712_b(), hand));
                } else if (cUseEntityPacket.func_149565_c() == CUseEntityPacket.Action.ATTACK) {
                    if (\u26032 instanceof ItemEntity || \u26032 instanceof ExperienceOrbEntity || \u26032 instanceof AbstractArrowEntity || \u26032 == this.field_147369_b) {
                        this.func_194028_b(new TranslationTextComponent("multiplayer.disconnect.invalid_entity_attacked"));
                        field_147370_c.warn("Player {} tried to attack an invalid entity", (Object)this.field_147369_b.func_200200_C_().getString());
                        return;
                    }
                    this.field_147369_b.func_71059_n(\u26032);
                }
                if (\u26034.isPresent() && ((ActionResultType)((Object)\u26034.get())).func_226246_a_()) {
                    CriteriaTriggers.field_241276_P_.func_241476_a_(this.field_147369_b, \u26033, \u26032);
                    if (((ActionResultType)((Object)\u26034.get())).func_226247_b_()) {
                        this.field_147369_b.func_226292_a_(hand, true);
                    }
                }
            }
        }
    }

    @Override
    public void func_147342_a(CClientStatusPacket cClientStatusPacket) {
        PacketThreadUtil.func_218796_a(cClientStatusPacket, this, this.field_147369_b.func_71121_q());
        this.field_147369_b.func_143004_u();
        CClientStatusPacket.State state = cClientStatusPacket.func_149435_c();
        switch (state) {
            case PERFORM_RESPAWN: {
                if (this.field_147369_b.field_71136_j) {
                    this.field_147369_b.field_71136_j = false;
                    this.field_147369_b = this.field_147367_d.func_184103_al().func_232644_a_(this.field_147369_b, true);
                    CriteriaTriggers.field_193134_u.func_233551_a_(this.field_147369_b, World.field_234920_i_, World.field_234918_g_);
                    break;
                }
                if (this.field_147369_b.func_110143_aJ() > 0.0f) {
                    return;
                }
                this.field_147369_b = this.field_147367_d.func_184103_al().func_232644_a_(this.field_147369_b, false);
                if (!this.field_147367_d.func_71199_h()) break;
                this.field_147369_b.func_71033_a(GameType.SPECTATOR);
                this.field_147369_b.func_71121_q().func_82736_K().func_223585_a(GameRules.field_223613_p).func_223570_a(false, this.field_147367_d);
                break;
            }
            case REQUEST_STATS: {
                this.field_147369_b.func_147099_x().func_150876_a(this.field_147369_b);
            }
        }
    }

    @Override
    public void func_147356_a(CCloseWindowPacket cCloseWindowPacket) {
        PacketThreadUtil.func_218796_a(cCloseWindowPacket, this, this.field_147369_b.func_71121_q());
        this.field_147369_b.func_71128_l();
    }

    @Override
    public void func_147351_a(CClickWindowPacket cClickWindowPacket2) {
        PacketThreadUtil.func_218796_a(cClickWindowPacket2, this, this.field_147369_b.func_71121_q());
        this.field_147369_b.func_143004_u();
        if (this.field_147369_b.field_71070_bA.field_75152_c == cClickWindowPacket2.func_149548_c() && this.field_147369_b.field_71070_bA.func_75129_b(this.field_147369_b)) {
            if (this.field_147369_b.func_175149_v()) {
                NonNullList<ItemStack> nonNullList = NonNullList.func_191196_a();
                for (int i = 0; i < this.field_147369_b.field_71070_bA.field_75151_b.size(); ++i) {
                    nonNullList.add(this.field_147369_b.field_71070_bA.field_75151_b.get(i).func_75211_c());
                }
                this.field_147369_b.func_71110_a(this.field_147369_b.field_71070_bA, nonNullList);
            } else {
                CClickWindowPacket cClickWindowPacket2;
                ItemStack \u26032 = this.field_147369_b.field_71070_bA.func_184996_a(cClickWindowPacket2.func_149544_d(), cClickWindowPacket2.func_149543_e(), cClickWindowPacket2.func_186993_f(), this.field_147369_b);
                if (ItemStack.func_77989_b(cClickWindowPacket2.func_149546_g(), \u26032)) {
                    this.field_147369_b.field_71135_a.func_147359_a(new SConfirmTransactionPacket(cClickWindowPacket2.func_149548_c(), cClickWindowPacket2.func_149547_f(), true));
                    this.field_147369_b.field_71137_h = true;
                    this.field_147369_b.field_71070_bA.func_75142_b();
                    this.field_147369_b.func_71113_k();
                    this.field_147369_b.field_71137_h = false;
                } else {
                    this.field_147372_n.put(this.field_147369_b.field_71070_bA.field_75152_c, cClickWindowPacket2.func_149547_f());
                    this.field_147369_b.field_71135_a.func_147359_a(new SConfirmTransactionPacket(cClickWindowPacket2.func_149548_c(), cClickWindowPacket2.func_149547_f(), false));
                    this.field_147369_b.field_71070_bA.func_75128_a(this.field_147369_b, false);
                    NonNullList<ItemStack> nonNullList = NonNullList.func_191196_a();
                    for (int i = 0; i < this.field_147369_b.field_71070_bA.field_75151_b.size(); ++i) {
                        ItemStack itemStack = this.field_147369_b.field_71070_bA.field_75151_b.get(i).func_75211_c();
                        nonNullList.add(itemStack.func_190926_b() ? ItemStack.field_190927_a : itemStack);
                    }
                    this.field_147369_b.func_71110_a(this.field_147369_b.field_71070_bA, nonNullList);
                }
            }
        }
    }

    @Override
    public void func_194308_a(CPlaceRecipePacket cPlaceRecipePacket) {
        PacketThreadUtil.func_218796_a(cPlaceRecipePacket, this, this.field_147369_b.func_71121_q());
        this.field_147369_b.func_143004_u();
        if (this.field_147369_b.func_175149_v() || this.field_147369_b.field_71070_bA.field_75152_c != cPlaceRecipePacket.func_194318_a() || !this.field_147369_b.field_71070_bA.func_75129_b(this.field_147369_b) || !(this.field_147369_b.field_71070_bA instanceof RecipeBookContainer)) {
            return;
        }
        this.field_147367_d.func_199529_aN().func_215367_a(cPlaceRecipePacket.func_199618_b()).ifPresent(iRecipe -> ((RecipeBookContainer)this.field_147369_b.field_71070_bA).func_217056_a(cPlaceRecipePacket.func_194319_c(), (IRecipe<?>)iRecipe, this.field_147369_b));
    }

    @Override
    public void func_147338_a(CEnchantItemPacket cEnchantItemPacket) {
        PacketThreadUtil.func_218796_a(cEnchantItemPacket, this, this.field_147369_b.func_71121_q());
        this.field_147369_b.func_143004_u();
        if (this.field_147369_b.field_71070_bA.field_75152_c == cEnchantItemPacket.func_149539_c() && this.field_147369_b.field_71070_bA.func_75129_b(this.field_147369_b) && !this.field_147369_b.func_175149_v()) {
            this.field_147369_b.field_71070_bA.func_75140_a(this.field_147369_b, cEnchantItemPacket.func_149537_d());
            this.field_147369_b.field_71070_bA.func_75142_b();
        }
    }

    @Override
    public void func_147344_a(CCreativeInventoryActionPacket cCreativeInventoryActionPacket2) {
        PacketThreadUtil.func_218796_a(cCreativeInventoryActionPacket2, this, this.field_147369_b.func_71121_q());
        if (this.field_147369_b.field_71134_c.func_73083_d()) {
            CCreativeInventoryActionPacket cCreativeInventoryActionPacket2;
            boolean bl = cCreativeInventoryActionPacket2.func_149627_c() < 0;
            ItemStack \u26032 = cCreativeInventoryActionPacket2.func_149625_d();
            CompoundNBT \u26033 = \u26032.func_179543_a("BlockEntityTag");
            if (!\u26032.func_190926_b() && \u26033 != null && \u26033.func_74764_b("x") && \u26033.func_74764_b("y") && \u26033.func_74764_b("z") && (\u2603 = this.field_147369_b.field_70170_p.func_175625_s(\u2603 = new BlockPos(\u26033.func_74762_e("x"), \u26033.func_74762_e("y"), \u26033.func_74762_e("z")))) != null) {
                CompoundNBT compoundNBT = \u2603.func_189515_b(new CompoundNBT());
                compoundNBT.func_82580_o("x");
                compoundNBT.func_82580_o("y");
                compoundNBT.func_82580_o("z");
                \u26032.func_77983_a("BlockEntityTag", compoundNBT);
            }
            boolean \u26034 = cCreativeInventoryActionPacket2.func_149627_c() >= 1 && cCreativeInventoryActionPacket2.func_149627_c() <= 45;
            boolean bl2 = \u2603 = \u26032.func_190926_b() || \u26032.func_77952_i() >= 0 && \u26032.func_190916_E() <= 64 && !\u26032.func_190926_b();
            if (\u26034 && \u2603) {
                if (\u26032.func_190926_b()) {
                    this.field_147369_b.field_71069_bz.func_75141_a(cCreativeInventoryActionPacket2.func_149627_c(), ItemStack.field_190927_a);
                } else {
                    this.field_147369_b.field_71069_bz.func_75141_a(cCreativeInventoryActionPacket2.func_149627_c(), \u26032);
                }
                this.field_147369_b.field_71069_bz.func_75128_a(this.field_147369_b, true);
                this.field_147369_b.field_71069_bz.func_75142_b();
            } else if (bl && \u2603 && this.field_147375_m < 200) {
                this.field_147375_m += 20;
                this.field_147369_b.func_71019_a(\u26032, true);
            }
        }
    }

    @Override
    public void func_147339_a(CConfirmTransactionPacket cConfirmTransactionPacket) {
        PacketThreadUtil.func_218796_a(cConfirmTransactionPacket, this, this.field_147369_b.func_71121_q());
        int n = this.field_147369_b.field_71070_bA.field_75152_c;
        if (n == cConfirmTransactionPacket.func_149532_c() && this.field_147372_n.getOrDefault(n, (short)(cConfirmTransactionPacket.func_149533_d() + 1)) == cConfirmTransactionPacket.func_149533_d() && !this.field_147369_b.field_71070_bA.func_75129_b(this.field_147369_b) && !this.field_147369_b.func_175149_v()) {
            this.field_147369_b.field_71070_bA.func_75128_a(this.field_147369_b, true);
        }
    }

    @Override
    public void func_147343_a(CUpdateSignPacket cUpdateSignPacket) {
        PacketThreadUtil.func_218796_a(cUpdateSignPacket, this, this.field_147369_b.func_71121_q());
        this.field_147369_b.func_143004_u();
        ServerWorld serverWorld = this.field_147369_b.func_71121_q();
        BlockPos \u26032 = cUpdateSignPacket.func_179722_a();
        if (serverWorld.func_175667_e(\u26032)) {
            BlockState blockState = serverWorld.func_180495_p(\u26032);
            TileEntity \u26033 = serverWorld.func_175625_s(\u26032);
            if (!(\u26033 instanceof SignTileEntity)) {
                return;
            }
            SignTileEntity \u26034 = (SignTileEntity)\u26033;
            if (!\u26034.func_145914_a() || \u26034.func_145911_b() != this.field_147369_b) {
                field_147370_c.warn("Player {} just tried to change non-editable sign", (Object)this.field_147369_b.func_200200_C_().getString());
                return;
            }
            String[] \u26035 = cUpdateSignPacket.func_187017_b();
            for (int i = 0; i < \u26035.length; ++i) {
                \u26034.func_212365_a(i, new StringTextComponent(TextFormatting.func_110646_a(\u26035[i])));
            }
            \u26034.func_70296_d();
            serverWorld.func_184138_a(\u26032, blockState, blockState, 3);
        }
    }

    @Override
    public void func_147353_a(CKeepAlivePacket cKeepAlivePacket) {
        if (this.field_194403_g && cKeepAlivePacket.func_149460_c() == this.field_194404_h) {
            int n = (int)(Util.func_211177_b() - this.field_194402_f);
            this.field_147369_b.field_71138_i = (this.field_147369_b.field_71138_i * 3 + n) / 4;
            this.field_194403_g = false;
        } else if (!this.func_217264_d()) {
            this.func_194028_b(new TranslationTextComponent("disconnect.timeout"));
        }
    }

    @Override
    public void func_147348_a(CPlayerAbilitiesPacket cPlayerAbilitiesPacket) {
        PacketThreadUtil.func_218796_a(cPlayerAbilitiesPacket, this, this.field_147369_b.func_71121_q());
        this.field_147369_b.field_71075_bZ.field_75100_b = cPlayerAbilitiesPacket.func_149488_d() && this.field_147369_b.field_71075_bZ.field_75101_c;
    }

    @Override
    public void func_147352_a(CClientSettingsPacket cClientSettingsPacket) {
        PacketThreadUtil.func_218796_a(cClientSettingsPacket, this, this.field_147369_b.func_71121_q());
        this.field_147369_b.func_147100_a(cClientSettingsPacket);
    }

    @Override
    public void func_147349_a(CCustomPayloadPacket cCustomPayloadPacket) {
    }

    @Override
    public void func_217263_a(CSetDifficultyPacket cSetDifficultyPacket) {
        PacketThreadUtil.func_218796_a(cSetDifficultyPacket, this, this.field_147369_b.func_71121_q());
        if (!this.field_147369_b.func_211513_k(2) && !this.func_217264_d()) {
            return;
        }
        this.field_147367_d.func_147139_a(cSetDifficultyPacket.func_218773_b(), false);
    }

    @Override
    public void func_217261_a(CLockDifficultyPacket cLockDifficultyPacket) {
        PacketThreadUtil.func_218796_a(cLockDifficultyPacket, this, this.field_147369_b.func_71121_q());
        if (!this.field_147369_b.func_211513_k(2) && !this.func_217264_d()) {
            return;
        }
        this.field_147367_d.func_213209_d(cLockDifficultyPacket.func_218776_b());
    }
}

