/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractUUIDFix
extends DataFix {
    protected static final Logger field_233051_a_ = LogManager.getLogger();
    protected DSL.TypeReference field_233052_b_;

    public AbstractUUIDFix(Schema schema, DSL.TypeReference typeReference) {
        super(schema, false);
        this.field_233052_b_ = typeReference;
    }

    protected Typed<?> func_233053_a_(Typed<?> typed2, String string, Function<Dynamic<?>, Dynamic<?>> function) {
        Type type = this.getInputSchema().getChoiceType(this.field_233052_b_, string);
        \u2603 = this.getOutputSchema().getChoiceType(this.field_233052_b_, string);
        return typed2.updateTyped(DSL.namedChoice((String)string, (Type)type), \u2603, typed -> typed.update(DSL.remainderFinder(), function));
    }

    protected static Optional<Dynamic<?>> func_233058_a_(Dynamic<?> dynamic, String string, String string2) {
        return AbstractUUIDFix.func_233057_a_(dynamic, string).map(dynamic2 -> dynamic.remove(string).set(string2, dynamic2));
    }

    protected static Optional<Dynamic<?>> func_233062_b_(Dynamic<?> dynamic, String string, String string2) {
        return dynamic.get(string).result().flatMap(AbstractUUIDFix::func_233054_a_).map(dynamic2 -> dynamic.remove(string).set(string2, dynamic2));
    }

    protected static Optional<Dynamic<?>> func_233064_c_(Dynamic<?> dynamic, String string, String string2) {
        \u2603 = string + "Most";
        \u2603 = string + "Least";
        return AbstractUUIDFix.func_233065_d_(dynamic, \u2603, \u2603).map(dynamic2 -> dynamic.remove(\u2603).remove(\u2603).set(string2, dynamic2));
    }

    protected static Optional<Dynamic<?>> func_233057_a_(Dynamic<?> dynamic, String string) {
        return dynamic.get(string).result().flatMap(dynamic2 -> {
            String string = dynamic2.asString(null);
            if (string != null) {
                try {
                    UUID uUID = UUID.fromString(string);
                    return AbstractUUIDFix.func_233055_a_(dynamic, uUID.getMostSignificantBits(), uUID.getLeastSignificantBits());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return Optional.empty();
        });
    }

    protected static Optional<Dynamic<?>> func_233054_a_(Dynamic<?> dynamic) {
        return AbstractUUIDFix.func_233065_d_(dynamic, "M", "L");
    }

    protected static Optional<Dynamic<?>> func_233065_d_(Dynamic<?> dynamic, String string, String string2) {
        long l = dynamic.get(string).asLong(0L);
        \u2603 = dynamic.get(string2).asLong(0L);
        if (l == 0L || \u2603 == 0L) {
            return Optional.empty();
        }
        return AbstractUUIDFix.func_233055_a_(dynamic, l, \u2603);
    }

    protected static Optional<Dynamic<?>> func_233055_a_(Dynamic<?> dynamic, long l, long l2) {
        return Optional.of(dynamic.createIntList(Arrays.stream(new int[]{(int)(l >> 32), (int)l, (int)(l2 >> 32), (int)l2})));
    }
}

