/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.tuple.Pair;

public final class MultiLayerModel
implements IModelCustomData {
    public static final MultiLayerModel INSTANCE = new MultiLayerModel((ImmutableMap<Optional<aji>, cbj>)ImmutableMap.of());
    private final ImmutableMap<Optional<aji>, cbj> models;

    public MultiLayerModel(ImmutableMap<Optional<aji>, cbj> models) {
        this.models = models;
    }

    @Override
    public Collection<kq> getDependencies() {
        return ImmutableList.copyOf((Collection)this.models.values());
    }

    @Override
    public Collection<kq> getTextures() {
        return ImmutableList.of();
    }

    private static ImmutableMap<Optional<aji>, cbe> buildModels(ImmutableMap<Optional<aji>, cbj> models, IModelState state, bzg format, Function<kq, byw> bakedTextureGetter) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Optional key : models.keySet()) {
            IModel model = ModelLoaderRegistry.getModelOrLogError((kq)models.get((Object)key), "Couldn't load MultiLayerModel dependency: " + models.get((Object)key));
            builder.put((Object)key, (Object)model.bake(new ModelStateComposition(state, model.getDefaultState()), format, bakedTextureGetter));
        }
        return builder.build();
    }

    @Override
    public cbe bake(IModelState state, bzg format, Function<kq, byw> bakedTextureGetter) {
        IModel missing = ModelLoaderRegistry.getMissingModel();
        return new MultiLayerBakedModel(MultiLayerModel.buildModels(this.models, state, format, bakedTextureGetter), missing.bake(missing.getDefaultState(), format, bakedTextureGetter), IPerspectiveAwareModel.MapWrapper.getTransforms(state));
    }

    @Override
    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    @Override
    public MultiLayerModel process(ImmutableMap<String, String> customData) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String key : customData.keySet()) {
            if ("base".equals(key)) {
                builder.put((Object)Optional.absent(), (Object)this.getLocation((String)customData.get((Object)key)));
            }
            for (aji layer : aji.values()) {
                if (!layer.toString().equals(key)) continue;
                builder.put((Object)Optional.of((Object)layer), (Object)this.getLocation((String)customData.get((Object)key)));
            }
        }
        ImmutableMap models = builder.build();
        if (models.isEmpty()) {
            return INSTANCE;
        }
        return new MultiLayerModel((ImmutableMap<Optional<aji>, cbj>)models);
    }

    private cbj getLocation(String json) {
        JsonElement e = new JsonParser().parse(json);
        if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isString()) {
            return new cbj(e.getAsString());
        }
        FMLLog.severe("Expect ModelResourceLocation, got: ", json);
        return new cbj("builtin/missing", "missing");
    }

    public static enum Loader implements ICustomModelLoader
    {
        INSTANCE;


        public void a(bzv resourceManager) {
        }

        @Override
        public boolean accepts(kq modelLocation) {
            return modelLocation.b().equals("forge") && (modelLocation.a().equals("multi-layer") || modelLocation.a().equals("models/block/multi-layer") || modelLocation.a().equals("models/item/multi-layer"));
        }

        @Override
        public IModel loadModel(kq modelLocation) {
            return INSTANCE;
        }
    }

    private static final class MultiLayerBakedModel
    implements IPerspectiveAwareModel {
        private final ImmutableMap<Optional<aji>, cbe> models;
        private final ImmutableMap<bro.b, TRSRTransformation> cameraTransforms;
        private final cbe base;
        private final cbe missing;
        private final ImmutableMap<Optional<cv>, ImmutableList<brb>> quads;

        public MultiLayerBakedModel(ImmutableMap<Optional<aji>, cbe> models, cbe missing, ImmutableMap<bro.b, TRSRTransformation> cameraTransforms) {
            this.models = models;
            this.cameraTransforms = cameraTransforms;
            this.missing = missing;
            this.base = models.containsKey((Object)Optional.absent()) ? (cbe)models.get((Object)Optional.absent()) : missing;
            ImmutableMap.Builder quadBuilder = ImmutableMap.builder();
            quadBuilder.put((Object)Optional.absent(), MultiLayerBakedModel.buildQuads(models, (Optional<cv>)Optional.absent()));
            for (cv side : cv.values()) {
                quadBuilder.put((Object)Optional.of((Object)side), MultiLayerBakedModel.buildQuads(models, (Optional<cv>)Optional.of((Object)side)));
            }
            this.quads = quadBuilder.build();
        }

        private static ImmutableList<brb> buildQuads(ImmutableMap<Optional<aji>, cbe> models, Optional<cv> side) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (cbe model : models.values()) {
                builder.addAll((Iterable)model.a(null, (cv)side.orNull(), 0L));
            }
            return builder.build();
        }

        public List<brb> a(atj state, cv side, long rand) {
            aji layer = MinecraftForgeClient.getRenderLayer();
            if (layer == null) {
                return (List)this.quads.get((Object)Optional.fromNullable((Object)side));
            }
            cbe model = !this.models.containsKey((Object)Optional.of((Object)layer)) ? this.missing : (cbe)this.models.get((Object)Optional.of((Object)layer));
            return model.a(state, side, rand);
        }

        public boolean a() {
            return this.base.a();
        }

        public boolean b() {
            return this.base.b();
        }

        public boolean c() {
            return this.base.c();
        }

        public byw d() {
            return this.base.d();
        }

        public bro e() {
            return bro.a;
        }

        @Override
        public Pair<? extends cbe, Matrix4f> handlePerspective(bro.b cameraTransformType) {
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((cbe)this, this.cameraTransforms, cameraTransformType);
        }

        public brm f() {
            return brm.a;
        }
    }
}

