/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BiomeDictionary {
    private static final Map<kq, BiomeInfo> biomeInfoMap = new HashMap<kq, BiomeInfo>();

    public static void addTypes(akd biome, Type ... types) {
        Preconditions.checkArgument((boolean)ForgeRegistries.BIOMES.containsValue(biome), (String)"Cannot add types to unregistered biome %s", (Object[])new Object[]{biome});
        List<Type> subTypes = BiomeDictionary.listSubTypes(types);
        for (Type type : subTypes) {
            type.biomes.add(biome);
        }
        BiomeDictionary.getBiomeInfo(biome).types.addAll(subTypes);
    }

    @Nonnull
    public static Set<akd> getBiomes(Type type) {
        return type.biomesUn;
    }

    @Nonnull
    public static Set<Type> getTypes(akd biome) {
        BiomeDictionary.ensureHasTypes(biome);
        return BiomeDictionary.getBiomeInfo(biome).typesUn;
    }

    public static boolean areSimilar(akd biomeA, akd biomeB) {
        for (Type type : BiomeDictionary.getTypes(biomeA)) {
            if (!BiomeDictionary.containsType(BiomeDictionary.getTypes(biomeB), type)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasType(akd biome, Type type) {
        return BiomeDictionary.getTypes(biome).contains(type);
    }

    public static boolean hasAnyType(akd biome) {
        return !BiomeDictionary.getBiomeInfo(biome).types.isEmpty();
    }

    public static void makeBestGuess(akd biome) {
        if (biome.t.z >= 3) {
            if (biome.e() && biome.n() >= 0.9f) {
                BiomeDictionary.addTypes(biome, Type.JUNGLE);
            } else if (!biome.e()) {
                BiomeDictionary.addTypes(biome, Type.FOREST);
                if (biome.n() <= 0.2f) {
                    BiomeDictionary.addTypes(biome, Type.CONIFEROUS);
                }
            }
        } else if (biome.m() <= 0.3f && biome.m() >= 0.0f && (!biome.e() || biome.j() >= 0.0f)) {
            BiomeDictionary.addTypes(biome, Type.PLAINS);
        }
        if (biome.k() > 0.85f) {
            BiomeDictionary.addTypes(biome, Type.WET);
        }
        if (biome.k() < 0.15f) {
            BiomeDictionary.addTypes(biome, Type.DRY);
        }
        if (biome.n() > 0.85f) {
            BiomeDictionary.addTypes(biome, Type.HOT);
        }
        if (biome.n() < 0.15f) {
            BiomeDictionary.addTypes(biome, Type.COLD);
        }
        if (biome.t.z > 0 && biome.t.z < 3) {
            BiomeDictionary.addTypes(biome, Type.SPARSE);
        } else if (biome.t.z >= 10) {
            BiomeDictionary.addTypes(biome, Type.DENSE);
        }
        if (biome.e() && biome.j() < 0.0f && biome.m() <= 0.3f && biome.m() >= 0.0f) {
            BiomeDictionary.addTypes(biome, Type.SWAMP);
        }
        if (biome.j() <= -0.5f) {
            if (biome.m() == 0.0f) {
                BiomeDictionary.addTypes(biome, Type.RIVER);
            } else {
                BiomeDictionary.addTypes(biome, Type.OCEAN);
            }
        }
        if (biome.m() >= 0.4f && biome.m() < 1.5f) {
            BiomeDictionary.addTypes(biome, Type.HILLS);
        }
        if (biome.m() >= 1.5f) {
            BiomeDictionary.addTypes(biome, Type.MOUNTAIN);
        }
        if (biome.c()) {
            BiomeDictionary.addTypes(biome, Type.SNOWY);
        }
        if (biome.r != alt.m && biome.n() >= 1.0f && biome.k() < 0.2f) {
            BiomeDictionary.addTypes(biome, Type.SAVANNA);
        }
        if (biome.r == alt.m) {
            BiomeDictionary.addTypes(biome, Type.SANDY);
        } else if (biome.r == alt.bw) {
            BiomeDictionary.addTypes(biome, Type.MUSHROOM);
        }
        if (biome.s == alt.cz) {
            BiomeDictionary.addTypes(biome, Type.MESA);
        }
    }

    private static BiomeInfo getBiomeInfo(akd biome) {
        BiomeInfo info = biomeInfoMap.get(biome.getRegistryName());
        if (info == null) {
            info = new BiomeInfo();
            biomeInfoMap.put(biome.getRegistryName(), info);
        }
        return info;
    }

    static void ensureHasTypes(akd biome) {
        if (!BiomeDictionary.hasAnyType(biome)) {
            BiomeDictionary.makeBestGuess(biome);
            FMLLog.warning("No types have been added to Biome %s, types have been assigned on a best-effort guess: %s", biome.getRegistryName(), BiomeDictionary.getTypes(biome));
        }
    }

    private static boolean containsType(Set<Type> types, Type type) {
        if (type.hasSubTypes()) {
            return !Collections.disjoint(types, type.subTypes);
        }
        return types.contains(type);
    }

    private static List<Type> listSubTypes(Type ... types) {
        ArrayList<Type> subTags = new ArrayList<Type>();
        for (Type type : types) {
            if (type.hasSubTypes()) {
                subTags.addAll(type.subTypes);
                continue;
            }
            subTags.add(type);
        }
        return subTags;
    }

    private static void registerVanillaBiomes() {
        BiomeDictionary.addTypes(aki.a, Type.OCEAN);
        BiomeDictionary.addTypes(aki.c, Type.PLAINS);
        BiomeDictionary.addTypes(aki.d, Type.HOT, Type.DRY, Type.SANDY);
        BiomeDictionary.addTypes(aki.e, Type.MOUNTAIN, Type.HILLS);
        BiomeDictionary.addTypes(aki.f, Type.FOREST);
        BiomeDictionary.addTypes(aki.g, Type.COLD, Type.CONIFEROUS, Type.FOREST);
        BiomeDictionary.addTypes(aki.h, Type.WET, Type.SWAMP);
        BiomeDictionary.addTypes(aki.i, Type.RIVER);
        BiomeDictionary.addTypes(aki.j, Type.HOT, Type.DRY, Type.NETHER);
        BiomeDictionary.addTypes(aki.k, Type.COLD, Type.DRY, Type.END);
        BiomeDictionary.addTypes(aki.l, Type.COLD, Type.OCEAN, Type.SNOWY);
        BiomeDictionary.addTypes(aki.m, Type.COLD, Type.RIVER, Type.SNOWY);
        BiomeDictionary.addTypes(aki.n, Type.COLD, Type.SNOWY, Type.WASTELAND);
        BiomeDictionary.addTypes(aki.o, Type.COLD, Type.SNOWY, Type.MOUNTAIN);
        BiomeDictionary.addTypes(aki.p, Type.MUSHROOM, Type.RARE);
        BiomeDictionary.addTypes(aki.q, Type.MUSHROOM, Type.BEACH, Type.RARE);
        BiomeDictionary.addTypes(aki.r, Type.BEACH);
        BiomeDictionary.addTypes(aki.s, Type.HOT, Type.DRY, Type.SANDY, Type.HILLS);
        BiomeDictionary.addTypes(aki.t, Type.FOREST, Type.HILLS);
        BiomeDictionary.addTypes(aki.u, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.HILLS);
        BiomeDictionary.addTypes(aki.v, Type.MOUNTAIN);
        BiomeDictionary.addTypes(aki.w, Type.HOT, Type.WET, Type.DENSE, Type.JUNGLE);
        BiomeDictionary.addTypes(aki.x, Type.HOT, Type.WET, Type.DENSE, Type.JUNGLE, Type.HILLS);
        BiomeDictionary.addTypes(aki.y, Type.HOT, Type.WET, Type.JUNGLE, Type.FOREST, Type.RARE);
        BiomeDictionary.addTypes(aki.z, Type.OCEAN);
        BiomeDictionary.addTypes(aki.A, Type.BEACH);
        BiomeDictionary.addTypes(aki.B, Type.COLD, Type.BEACH, Type.SNOWY);
        BiomeDictionary.addTypes(aki.C, Type.FOREST);
        BiomeDictionary.addTypes(aki.D, Type.FOREST, Type.HILLS);
        BiomeDictionary.addTypes(aki.E, Type.SPOOKY, Type.DENSE, Type.FOREST);
        BiomeDictionary.addTypes(aki.F, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.SNOWY);
        BiomeDictionary.addTypes(aki.G, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.SNOWY, Type.HILLS);
        BiomeDictionary.addTypes(aki.H, Type.COLD, Type.CONIFEROUS, Type.FOREST);
        BiomeDictionary.addTypes(aki.I, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.HILLS);
        BiomeDictionary.addTypes(aki.J, Type.MOUNTAIN, Type.FOREST, Type.SPARSE);
        BiomeDictionary.addTypes(aki.K, Type.HOT, Type.SAVANNA, Type.PLAINS, Type.SPARSE);
        BiomeDictionary.addTypes(aki.L, Type.HOT, Type.SAVANNA, Type.PLAINS, Type.SPARSE, Type.RARE);
        BiomeDictionary.addTypes(aki.M, Type.MESA, Type.SANDY);
        BiomeDictionary.addTypes(aki.N, Type.MESA, Type.SPARSE, Type.SANDY);
        BiomeDictionary.addTypes(aki.O, Type.MESA, Type.SANDY);
        BiomeDictionary.addTypes(aki.P, Type.VOID);
        BiomeDictionary.addTypes(aki.Q, Type.PLAINS, Type.RARE);
        BiomeDictionary.addTypes(aki.R, Type.HOT, Type.DRY, Type.SANDY, Type.RARE);
        BiomeDictionary.addTypes(aki.S, Type.MOUNTAIN, Type.SPARSE, Type.RARE);
        BiomeDictionary.addTypes(aki.T, Type.FOREST, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(aki.U, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(aki.V, Type.WET, Type.SWAMP, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(aki.W, Type.COLD, Type.SNOWY, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(aki.X, Type.HOT, Type.WET, Type.DENSE, Type.JUNGLE, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(aki.Y, Type.HOT, Type.SPARSE, Type.JUNGLE, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(aki.Z, Type.FOREST, Type.DENSE, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(aki.aa, Type.FOREST, Type.DENSE, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(aki.ab, Type.SPOOKY, Type.DENSE, Type.FOREST, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(aki.ac, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.SNOWY, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(aki.ad, Type.DENSE, Type.FOREST, Type.RARE);
        BiomeDictionary.addTypes(aki.ae, Type.DENSE, Type.FOREST, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(aki.af, Type.MOUNTAIN, Type.SPARSE, Type.RARE);
        BiomeDictionary.addTypes(aki.ag, Type.HOT, Type.DRY, Type.SPARSE, Type.SAVANNA, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(aki.ah, Type.HOT, Type.DRY, Type.SPARSE, Type.SAVANNA, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(aki.ai, Type.HOT, Type.DRY, Type.SPARSE, Type.SAVANNA, Type.MOUNTAIN, Type.RARE);
        BiomeDictionary.addTypes(aki.aj, Type.HOT, Type.DRY, Type.SPARSE, Type.HILLS, Type.RARE);
        BiomeDictionary.addTypes(aki.ak, Type.HOT, Type.DRY, Type.SPARSE, Type.SAVANNA, Type.MOUNTAIN, Type.RARE);
    }

    static {
        BiomeDictionary.registerVanillaBiomes();
    }

    private static class BiomeInfo {
        private final Set<Type> types = new HashSet<Type>();
        private final Set<Type> typesUn = Collections.unmodifiableSet(this.types);

        private BiomeInfo() {
        }
    }

    public static final class Type {
        private static final Map<String, Type> byName = new HashMap<String, Type>();
        public static final Type HOT = new Type("HOT", new Type[0]);
        public static final Type COLD = new Type("COLD", new Type[0]);
        public static final Type SPARSE = new Type("SPARSE", new Type[0]);
        public static final Type DENSE = new Type("DENSE", new Type[0]);
        public static final Type WET = new Type("WET", new Type[0]);
        public static final Type DRY = new Type("DRY", new Type[0]);
        public static final Type SAVANNA = new Type("SAVANNA", new Type[0]);
        public static final Type CONIFEROUS = new Type("CONIFEROUS", new Type[0]);
        public static final Type JUNGLE = new Type("JUNGLE", new Type[0]);
        public static final Type SPOOKY = new Type("SPOOKY", new Type[0]);
        public static final Type DEAD = new Type("DEAD", new Type[0]);
        public static final Type LUSH = new Type("LUSH", new Type[0]);
        public static final Type NETHER = new Type("NETHER", new Type[0]);
        public static final Type END = new Type("END", new Type[0]);
        public static final Type MUSHROOM = new Type("MUSHROOM", new Type[0]);
        public static final Type MAGICAL = new Type("MAGICAL", new Type[0]);
        public static final Type RARE = new Type("RARE", new Type[0]);
        public static final Type OCEAN = new Type("OCEAN", new Type[0]);
        public static final Type RIVER = new Type("RIVER", new Type[0]);
        public static final Type WATER = new Type("WATER", OCEAN, RIVER);
        public static final Type MESA = new Type("MESA", new Type[0]);
        public static final Type FOREST = new Type("FOREST", new Type[0]);
        public static final Type PLAINS = new Type("PLAINS", new Type[0]);
        public static final Type MOUNTAIN = new Type("MOUNTAIN", new Type[0]);
        public static final Type HILLS = new Type("HILLS", new Type[0]);
        public static final Type SWAMP = new Type("SWAMP", new Type[0]);
        public static final Type SANDY = new Type("SANDY", new Type[0]);
        public static final Type SNOWY = new Type("SNOWY", new Type[0]);
        public static final Type WASTELAND = new Type("WASTELAND", new Type[0]);
        public static final Type BEACH = new Type("BEACH", new Type[0]);
        public static final Type VOID = new Type("VOID", new Type[0]);
        private final String name;
        private final List<Type> subTypes;
        private final Set<akd> biomes = new HashSet<akd>();
        private final Set<akd> biomesUn = Collections.unmodifiableSet(this.biomes);

        private Type(String name, Type ... subTypes) {
            this.name = name;
            this.subTypes = ImmutableList.copyOf((Object[])subTypes);
            byName.put(name, this);
        }

        private boolean hasSubTypes() {
            return !this.subTypes.isEmpty();
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static Type getType(String name, Type ... subTypes) {
            Type t = byName.get(name = name.toUpperCase());
            if (t == null) {
                t = new Type(name, subTypes);
            }
            return t;
        }
    }
}

