/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.brewing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.common.brewing.BrewingOreRecipe;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.brewing.VanillaBrewingRecipe;

public class BrewingRecipeRegistry {
    private static List<IBrewingRecipe> recipes = new ArrayList<IBrewingRecipe>();

    public static boolean addRecipe(@Nonnull afi input, @Nonnull afi ingredient, @Nonnull afi output) {
        return BrewingRecipeRegistry.addRecipe(new BrewingRecipe(input, ingredient, output));
    }

    public static boolean addRecipe(@Nonnull afi input, @Nonnull String ingredient, @Nonnull afi output) {
        return BrewingRecipeRegistry.addRecipe(new BrewingOreRecipe(input, ingredient, output));
    }

    public static boolean addRecipe(IBrewingRecipe recipe) {
        return recipes.add(recipe);
    }

    @Nonnull
    public static afi getOutput(@Nonnull afi input, @Nonnull afi ingredient) {
        if (input.b() || input.d() != 1 || input.E() != 1) {
            return afi.a;
        }
        if (ingredient.b()) {
            return afi.a;
        }
        for (IBrewingRecipe recipe : recipes) {
            afi output = recipe.getOutput(input, ingredient);
            if (output == null) continue;
            return output;
        }
        return afi.a;
    }

    public static boolean hasOutput(@Nonnull afi input, @Nonnull afi ingredient) {
        return !BrewingRecipeRegistry.getOutput(input, ingredient).b();
    }

    public static boolean canBrew(dd<afi> inputs, @Nonnull afi ingredient, int[] inputIndexes) {
        if (ingredient.b()) {
            return false;
        }
        for (int i : inputIndexes) {
            if (!BrewingRecipeRegistry.hasOutput((afi)inputs.get(i), ingredient)) continue;
            return true;
        }
        return false;
    }

    public static void brewPotions(dd<afi> inputs, @Nonnull afi ingredient, int[] inputIndexes) {
        for (int i : inputIndexes) {
            afi output = BrewingRecipeRegistry.getOutput((afi)inputs.get(i), ingredient);
            if (output.b()) continue;
            inputs.set(i, (Object)output);
        }
    }

    public static boolean isValidIngredient(@Nonnull afi stack) {
        if (stack.b()) {
            return false;
        }
        for (IBrewingRecipe recipe : recipes) {
            if (!recipe.isIngredient(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidInput(@Nonnull afi stack) {
        if (stack.d() != 1 || stack.E() != 1) {
            return false;
        }
        for (IBrewingRecipe recipe : recipes) {
            if (!recipe.isInput(stack)) continue;
            return true;
        }
        return false;
    }

    public static List<IBrewingRecipe> getRecipes() {
        return Collections.unmodifiableList(recipes);
    }

    static {
        BrewingRecipeRegistry.addRecipe(new VanillaBrewingRecipe());
    }
}

