/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.PropertyFloat;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockFluidBase
extends als
implements IFluidBlock {
    protected static final Map<als, Boolean> defaultDisplacements = Maps.newHashMap();
    protected Map<als, Boolean> displacements = Maps.newHashMap();
    public static final aty LEVEL;
    public static final PropertyFloat[] LEVEL_CORNERS;
    public static final PropertyFloat FLOW_DIRECTION;
    public static final ImmutableList<IUnlistedProperty<Float>> FLUID_RENDER_PROPS;
    protected int quantaPerBlock = 8;
    protected float quantaPerBlockFloat = 8.0f;
    protected int density = 1;
    protected int densityDir = -1;
    protected int temperature = 295;
    protected int tickRate = 20;
    protected aji renderLayer = aji.d;
    protected int maxScaledLight = 0;
    protected final String fluidName;
    protected final Fluid definedFluid;

    public BlockFluidBase(Fluid fluid, azq material) {
        super(material);
        this.a(true);
        this.p();
        this.fluidName = fluid.getName();
        this.density = fluid.density;
        this.temperature = fluid.temperature;
        this.maxScaledLight = fluid.luminosity;
        this.tickRate = fluid.viscosity / 200;
        this.densityDir = fluid.density > 0 ? -1 : 1;
        fluid.setBlock(this);
        this.definedFluid = fluid;
        this.displacements.putAll(defaultDisplacements);
        this.y(this.A.b().a((atz)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    @Nonnull
    protected atk b() {
        return new ExtendedBlockState(this, new atz[]{LEVEL}, (IUnlistedProperty[])FLUID_RENDER_PROPS.toArray((Object[])new IUnlistedProperty[0]));
    }

    public int e(@Nonnull atj state) {
        return (Integer)state.c((atz)LEVEL);
    }

    @Deprecated
    @Nonnull
    public atj a(int meta) {
        return this.t().a((atz)LEVEL, (Comparable)Integer.valueOf(meta));
    }

    public BlockFluidBase setQuantaPerBlock(int quantaPerBlock) {
        if (quantaPerBlock > 16 || quantaPerBlock < 1) {
            quantaPerBlock = 8;
        }
        this.quantaPerBlock = quantaPerBlock;
        this.quantaPerBlockFloat = quantaPerBlock;
        return this;
    }

    public BlockFluidBase setDensity(int density) {
        if (density == 0) {
            density = 1;
        }
        this.density = density;
        this.densityDir = density > 0 ? -1 : 1;
        return this;
    }

    public BlockFluidBase setTemperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public BlockFluidBase setTickRate(int tickRate) {
        if (tickRate <= 0) {
            tickRate = 20;
        }
        this.tickRate = tickRate;
        return this;
    }

    public BlockFluidBase setRenderLayer(aji renderLayer) {
        this.renderLayer = renderLayer;
        return this;
    }

    public BlockFluidBase setMaxScaledLight(int maxScaledLight) {
        this.maxScaledLight = maxScaledLight;
        return this;
    }

    public boolean canDisplace(aju world, co pos) {
        if (world.d(pos)) {
            return true;
        }
        atj state = world.o(pos);
        if (state.v() == this) {
            return false;
        }
        if (this.displacements.containsKey(state.v())) {
            return this.displacements.get(state.v());
        }
        azq material = state.a();
        if (material.c() || material == azq.E) {
            return false;
        }
        int density = BlockFluidBase.getDensity(world, pos);
        if (density == Integer.MAX_VALUE) {
            return true;
        }
        return this.density > density;
    }

    public boolean displaceIfPossible(ajq world, co pos) {
        if (world.d(pos)) {
            return true;
        }
        atj state = world.o(pos);
        als block = state.v();
        if (block == this) {
            return false;
        }
        if (this.displacements.containsKey(block)) {
            if (this.displacements.get(block).booleanValue()) {
                if (state.v() != alt.aH) {
                    block.b(world, pos, state, 0);
                }
                return true;
            }
            return false;
        }
        azq material = state.a();
        if (material.c() || material == azq.E) {
            return false;
        }
        int density = BlockFluidBase.getDensity((aju)world, pos);
        if (density == Integer.MAX_VALUE) {
            block.b(world, pos, state, 0);
            return true;
        }
        return this.density > density;
    }

    public abstract int getQuantaValue(aju var1, co var2);

    public abstract boolean a(@Nonnull atj var1, boolean var2);

    public abstract int getMaxRenderHeightMeta();

    public void c(@Nonnull ajq world, @Nonnull co pos, @Nonnull atj state) {
        world.a(pos, (als)this, this.tickRate);
    }

    public void a(@Nonnull atj state, @Nonnull ajq world, @Nonnull co pos, @Nonnull als neighborBlock, @Nonnull co neighbourPos) {
        world.a(pos, (als)this, this.tickRate);
    }

    public boolean r() {
        return false;
    }

    public boolean b(@Nonnull aju world, @Nonnull co pos) {
        return true;
    }

    @Nonnull
    public afg a(@Nonnull atj state, @Nonnull Random rand, int fortune) {
        return afk.a;
    }

    public int a(@Nonnull Random par1Random) {
        return 0;
    }

    public int a(@Nonnull ajq world) {
        return this.tickRate;
    }

    @Nonnull
    public bdu a(@Nonnull ajq world, @Nonnull co pos, @Nonnull sm entity, @Nonnull bdu vec) {
        if (this.densityDir > 0) {
            return vec;
        }
        bdu vec_flow = this.getFlowVector((aju)world, pos);
        return vec.b(vec_flow.b * (double)(this.quantaPerBlock * 4), vec_flow.c * (double)(this.quantaPerBlock * 4), vec_flow.d * (double)(this.quantaPerBlock * 4));
    }

    public int getLightValue(@Nonnull atj state, @Nonnull aju world, @Nonnull co pos) {
        if (this.maxScaledLight == 0) {
            return super.getLightValue(state, world, pos);
        }
        int data = (Integer)state.c((atz)LEVEL);
        return (int)((float)data / this.quantaPerBlockFloat * (float)this.maxScaledLight);
    }

    public boolean b(@Nonnull atj state) {
        return false;
    }

    public boolean c(@Nonnull atj state) {
        return false;
    }

    public int d(@Nonnull atj state, @Nonnull aju world, @Nonnull co pos) {
        int lightThis = world.b(pos, 0);
        int lightUp = world.b(pos.a(), 0);
        int lightThisBase = lightThis & 0xFF;
        int lightUpBase = lightUp & 0xFF;
        int lightThisExt = lightThis >> 16 & 0xFF;
        int lightUpExt = lightUp >> 16 & 0xFF;
        return (lightThisBase > lightUpBase ? lightThisBase : lightUpBase) | (lightThisExt > lightUpExt ? lightThisExt : lightUpExt) << 16;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public aji f() {
        return this.renderLayer;
    }

    public boolean a(@Nonnull atj state, @Nonnull aju world, @Nonnull co pos, @Nonnull cv side) {
        atj neighbor = world.o(pos.a(side));
        if (neighbor.a() == state.a()) {
            return false;
        }
        if (this.densityDir == -1 && side == cv.b) {
            return true;
        }
        if (this.densityDir == 1 && side == cv.a) {
            return true;
        }
        return super.a(state, world, pos, side);
    }

    @Nonnull
    public atj getExtendedState(@Nonnull atj oldState, @Nonnull aju worldIn, @Nonnull co pos) {
        IExtendedBlockState state = (IExtendedBlockState)oldState;
        state = state.withProperty(FLOW_DIRECTION, Float.valueOf((float)BlockFluidBase.getFlowDirection(worldIn, pos)));
        float[][] height = new float[3][3];
        float[][] corner = new float[2][2];
        height[1][1] = this.getFluidHeightForRender(worldIn, pos);
        if (height[1][1] == 1.0f) {
            for (int i = 0; i < 2; ++i) {
                for (int j2 = 0; j2 < 2; ++j2) {
                    corner[i][j2] = 1.0f;
                }
            }
        } else {
            int j3;
            int i;
            for (i = 0; i < 3; ++i) {
                for (j3 = 0; j3 < 3; ++j3) {
                    if (i == 1 && j3 == 1) continue;
                    height[i][j3] = this.getFluidHeightForRender(worldIn, pos.a(i - 1, 0, j3 - 1));
                }
            }
            for (i = 0; i < 2; ++i) {
                for (j3 = 0; j3 < 2; ++j3) {
                    corner[i][j3] = this.getFluidHeightAverage(height[i][j3], height[i][j3 + 1], height[i + 1][j3], height[i + 1][j3 + 1]);
                }
            }
        }
        state = state.withProperty(LEVEL_CORNERS[0], Float.valueOf(corner[0][0]));
        state = state.withProperty(LEVEL_CORNERS[1], Float.valueOf(corner[0][1]));
        state = state.withProperty(LEVEL_CORNERS[2], Float.valueOf(corner[1][1]));
        state = state.withProperty(LEVEL_CORNERS[3], Float.valueOf(corner[1][0]));
        return state;
    }

    public static final int getDensity(aju world, co pos) {
        als block = world.o(pos).v();
        if (!(block instanceof BlockFluidBase)) {
            return Integer.MAX_VALUE;
        }
        return ((BlockFluidBase)block).density;
    }

    public static final int getTemperature(aju world, co pos) {
        als block = world.o(pos).v();
        if (!(block instanceof BlockFluidBase)) {
            return Integer.MAX_VALUE;
        }
        return ((BlockFluidBase)block).temperature;
    }

    public static double getFlowDirection(aju world, co pos) {
        atj state = world.o(pos);
        if (!state.a().d()) {
            return -1000.0;
        }
        bdu vec = ((BlockFluidBase)state.v()).getFlowVector(world, pos);
        return vec.b == 0.0 && vec.d == 0.0 ? -1000.0 : Math.atan2(vec.d, vec.b) - 1.5707963267948966;
    }

    public final int getQuantaValueBelow(aju world, co pos, int belowThis) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        if (quantaRemaining >= belowThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final int getQuantaValueAbove(aju world, co pos, int aboveThis) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        if (quantaRemaining <= aboveThis) {
            return -1;
        }
        return quantaRemaining;
    }

    public final float getQuantaPercentage(aju world, co pos) {
        int quantaRemaining = this.getQuantaValue(world, pos);
        return (float)quantaRemaining / this.quantaPerBlockFloat;
    }

    public float getFluidHeightAverage(float ... flow) {
        float total = 0.0f;
        int count = 0;
        float end = 0.0f;
        for (int i = 0; i < flow.length; ++i) {
            if (flow[i] >= 0.875f) {
                total += flow[i] * 10.0f;
                count += 10;
            }
            if (!(flow[i] >= 0.0f)) continue;
            total += flow[i];
            ++count;
        }
        if (end == 0.0f) {
            end = total / (float)count;
        }
        return end;
    }

    public float getFluidHeightForRender(aju world, co pos) {
        atj here = world.o(pos);
        atj up = world.o(pos.c(this.densityDir));
        if (here.v() == this) {
            if (up.a().d() || up.v() instanceof IFluidBlock) {
                return 1.0f;
            }
            if (this.e(here) == this.getMaxRenderHeightMeta()) {
                return 0.875f;
            }
        }
        if (here.v() instanceof aoo) {
            return Math.min(1.0f - aoo.e((int)((Integer)here.c((atz)aoo.b))), 0.875f);
        }
        return !here.a().a() && up.v() == this ? 1.0f : this.getQuantaPercentage(world, pos) * 0.875f;
    }

    public bdu getFlowVector(aju world, co pos) {
        bdu vec = new bdu(0.0, 0.0, 0.0);
        int decay = this.quantaPerBlock - this.getQuantaValue(world, pos);
        for (int side = 0; side < 4; ++side) {
            int power;
            int x2 = pos.p();
            int z2 = pos.r();
            switch (side) {
                case 0: {
                    --x2;
                    break;
                }
                case 1: {
                    --z2;
                    break;
                }
                case 2: {
                    ++x2;
                    break;
                }
                case 3: {
                    ++z2;
                }
            }
            co pos2 = new co(x2, pos.q(), z2);
            int otherDecay = this.quantaPerBlock - this.getQuantaValue(world, pos2);
            if (otherDecay >= this.quantaPerBlock) {
                if (world.o(pos2).a().c() || (otherDecay = this.quantaPerBlock - this.getQuantaValue(world, pos2.b())) < 0) continue;
                power = otherDecay - (decay - this.quantaPerBlock);
                vec = vec.b((double)((pos2.p() - pos.p()) * power), 0.0, (double)((pos2.r() - pos.r()) * power));
                continue;
            }
            if (otherDecay < 0) continue;
            power = otherDecay - decay;
            vec = vec.b((double)((pos2.p() - pos.p()) * power), 0.0, (double)((pos2.r() - pos.r()) * power));
        }
        if (world.o(pos.a()).v() == this) {
            boolean flag;
            boolean bl = flag = this.a(world, pos.a(0, 0, -1), cv.c) || this.a(world, pos.a(0, 0, 1), cv.d) || this.a(world, pos.a(-1, 0, 0), cv.e) || this.a(world, pos.a(1, 0, 0), cv.f) || this.a(world, pos.a(0, 1, -1), cv.c) || this.a(world, pos.a(0, 1, 1), cv.d) || this.a(world, pos.a(-1, 1, 0), cv.e) || this.a(world, pos.a(1, 1, 0), cv.f);
            if (flag) {
                vec = vec.a().b(0.0, -6.0, 0.0);
            }
        }
        vec = vec.a();
        return vec;
    }

    @Override
    public Fluid getFluid() {
        return FluidRegistry.getFluid(this.fluidName);
    }

    @Override
    public float getFilledPercentage(ajq world, co pos) {
        int quantaRemaining = this.getQuantaValue((aju)world, pos) + 1;
        float remaining = (float)quantaRemaining / this.quantaPerBlockFloat;
        if (remaining > 1.0f) {
            remaining = 1.0f;
        }
        return remaining * (float)(this.density > 0 ? 1 : -1);
    }

    public bdr a(@Nonnull atj blockState, @Nonnull aju worldIn, @Nonnull co pos) {
        return k;
    }

    static {
        defaultDisplacements.put((als)alt.ao, false);
        defaultDisplacements.put((als)alt.ap, false);
        defaultDisplacements.put((als)alt.aq, false);
        defaultDisplacements.put((als)alt.ar, false);
        defaultDisplacements.put((als)alt.as, false);
        defaultDisplacements.put((als)alt.at, false);
        defaultDisplacements.put(alt.bd, false);
        defaultDisplacements.put(alt.cw, false);
        defaultDisplacements.put(alt.aO, false);
        defaultDisplacements.put(alt.aP, false);
        defaultDisplacements.put(alt.aQ, false);
        defaultDisplacements.put(alt.aR, false);
        defaultDisplacements.put(alt.aS, false);
        defaultDisplacements.put(alt.aT, false);
        defaultDisplacements.put(alt.bz, false);
        defaultDisplacements.put(alt.bo, false);
        defaultDisplacements.put(alt.bp, false);
        defaultDisplacements.put(alt.bq, false);
        defaultDisplacements.put(alt.br, false);
        defaultDisplacements.put(alt.bs, false);
        defaultDisplacements.put(alt.bt, false);
        defaultDisplacements.put(alt.aB, false);
        defaultDisplacements.put(alt.az, false);
        defaultDisplacements.put(alt.ch, false);
        defaultDisplacements.put(alt.ci, false);
        defaultDisplacements.put(alt.au, false);
        defaultDisplacements.put(alt.bi, false);
        defaultDisplacements.put(alt.bj, false);
        defaultDisplacements.put((als)alt.cH, false);
        defaultDisplacements.put((als)alt.aY, false);
        defaultDisplacements.put(alt.bF, false);
        defaultDisplacements.put(alt.bZ, false);
        defaultDisplacements.put(alt.cv, false);
        defaultDisplacements.put(alt.cK, false);
        defaultDisplacements.put(alt.cL, false);
        defaultDisplacements.put(alt.ba, false);
        defaultDisplacements.put((als)alt.aA, false);
        defaultDisplacements.put(alt.an, false);
        defaultDisplacements.put(alt.ax, false);
        defaultDisplacements.put((als)alt.aM, false);
        LEVEL = aty.a((String)"level", (int)0, (int)15);
        LEVEL_CORNERS = new PropertyFloat[4];
        FLOW_DIRECTION = new PropertyFloat("flow_direction");
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)FLOW_DIRECTION);
        for (int i = 0; i < 4; ++i) {
            BlockFluidBase.LEVEL_CORNERS[i] = new PropertyFloat("level_corner_" + i);
            builder.add((Object)LEVEL_CORNERS[i]);
        }
        FLUID_RENDER_PROPS = builder.build();
    }
}

