/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.base.Throwables;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ExistingSubstitutionException;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.FinalFieldHelper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.common.registry.LegacyNamespacedRegistry;
import net.minecraftforge.fml.common.registry.PersistentRegistryManager;
import net.minecraftforge.fml.common.registry.RegistryBuilder;
import net.minecraftforge.fml.common.registry.RegistryDelegate;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.Level;

public class GameData {
    private static final int MIN_BLOCK_ID = 0;
    private static final int MAX_BLOCK_ID = 4095;
    private static final int MIN_ITEM_ID = 4096;
    private static final int MAX_ITEM_ID = 31999;
    private static final int MIN_POTION_ID = 0;
    private static final int MAX_POTION_ID = 255;
    private static final int MIN_BIOME_ID = 0;
    private static final int MAX_BIOME_ID = 255;
    private static final int MIN_SOUND_ID = 0;
    private static final int MAX_SOUND_ID = 0x3FFFFFF;
    private static final int MIN_POTIONTYPE_ID = 0;
    private static final int MAX_POTIONTYPE_ID = 0x3FFFFFF;
    private static final int MIN_ENCHANTMENT_ID = 0;
    private static final int MAX_ENCHANTMENT_ID = 32766;
    private static final int MIN_ENTITY_ID = 0;
    private static final int MAX_ENTITY_ID = 0x3FFFFFF;
    private static final kq BLOCK_TO_ITEM = new kq("minecraft:blocktoitemmap");
    private static final kq BLOCKSTATE_TO_ID = new kq("minecraft:blockstatetoid");
    private static final GameData mainData = new GameData();
    private static Field blockField;
    private final FMLControlledNamespacedRegistry<als> iBlockRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.BLOCKS, als.class, new kq("minecraft:air"), 0, 4095, true, BlockCallbacks.INSTANCE, BlockCallbacks.INSTANCE, BlockCallbacks.INSTANCE, BlockCallbacks.INSTANCE);
    private final FMLControlledNamespacedRegistry<afg> iItemRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.ITEMS, afg.class, null, 4096, 31999, true, ItemCallbacks.INSTANCE, ItemCallbacks.INSTANCE, ItemCallbacks.INSTANCE, ItemCallbacks.INSTANCE);
    private final FMLControlledNamespacedRegistry<sf> iPotionRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.POTIONS, sf.class, null, 0, 255, false, PotionCallbacks.INSTANCE, PotionCallbacks.INSTANCE, PotionCallbacks.INSTANCE, null);
    private final FMLControlledNamespacedRegistry<akd> iBiomeRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.BIOMES, akd.class, null, 0, 255, false, BiomeCallbacks.INSTANCE, BiomeCallbacks.INSTANCE, BiomeCallbacks.INSTANCE, null);
    private final FMLControlledNamespacedRegistry<nm> iSoundEventRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.SOUNDEVENTS, nm.class, null, 0, 0x3FFFFFF, false, null, null, null, null);
    private final FMLControlledNamespacedRegistry<agx> iPotionTypeRegistry;
    private final FMLControlledNamespacedRegistry<aih> iEnchantmentRegistry;
    private final FMLControlledNamespacedRegistry<EntityEntry> iEntityRegistry;
    private final LegacyNamespacedRegistry<Class<? extends asa>> iTileEntityRegistry;

    public GameData() {
        kq WATER = new kq("water");
        this.iPotionTypeRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.POTIONTYPES, agx.class, WATER, 0, 0x3FFFFFF, false, null, null, null, null);
        this.iEnchantmentRegistry = PersistentRegistryManager.createRegistry(PersistentRegistryManager.ENCHANTMENTS, aih.class, null, 0, 32766, false, null, null, null, null);
        this.iEntityRegistry = (FMLControlledNamespacedRegistry)new RegistryBuilder().setName(PersistentRegistryManager.ENTITIES).setType(EntityEntry.class).setIDRange(0, 0x3FFFFFF).addCallback(EntityCallbacks.INSTANCE).create();
        try {
            blockField = FinalFieldHelper.makeWritable(ReflectionHelper.findField(adu.class, "block", "field_150939_a"));
        }
        catch (Exception e2) {
            FMLLog.log(Level.FATAL, e2, "Cannot access the 'block' field from ItemBlock, this is fatal!", new Object[0]);
            throw Throwables.propagate((Throwable)e2);
        }
        this.iTileEntityRegistry = new LegacyNamespacedRegistry();
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<als> getBlockRegistry() {
        return GameData.getMain().iBlockRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<afg> getItemRegistry() {
        return GameData.getMain().iItemRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<sf> getPotionRegistry() {
        return GameData.getMain().iPotionRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<akd> getBiomeRegistry() {
        return GameData.getMain().iBiomeRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<nm> getSoundEventRegistry() {
        return GameData.getMain().iSoundEventRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<agx> getPotionTypesRegistry() {
        return GameData.getMain().iPotionTypeRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<aih> getEnchantmentRegistry() {
        return GameData.getMain().iEnchantmentRegistry;
    }

    @Deprecated
    public static LegacyNamespacedRegistry<Class<? extends asa>> getTileEntityRegistry() {
        return GameData.getMain().iTileEntityRegistry;
    }

    @Deprecated
    public static FMLControlledNamespacedRegistry<EntityEntry> getEntityRegistry() {
        return GameData.getMain().iEntityRegistry;
    }

    @Deprecated
    static afg findItem(String modId, String name) {
        return GameData.getMain().iItemRegistry.getObject(new kq(modId, name));
    }

    @Deprecated
    static als findBlock(String modId, String name) {
        return GameData.getMain().iBlockRegistry.getObject(new kq(modId, name));
    }

    protected static GameData getMain() {
        return mainData;
    }

    void registerSubstitutionAlias(String name, GameRegistry.Type type, Object toReplace) throws ExistingSubstitutionException {
        kq nameToSubstitute = new kq(name);
        BiMap<als, afg> blockItemMap = GameData.getBlockItemMap();
        if (type == GameRegistry.Type.BLOCK) {
            this.iBlockRegistry.addSubstitutionAlias(Loader.instance().activeModContainer().getModId(), nameToSubstitute, (als)toReplace);
            this.iBlockRegistry.activateSubstitution(nameToSubstitute);
        } else if (type == GameRegistry.Type.ITEM) {
            this.iItemRegistry.addSubstitutionAlias(Loader.instance().activeModContainer().getModId(), nameToSubstitute, (afg)toReplace);
            this.iItemRegistry.activateSubstitution(nameToSubstitute);
        }
    }

    public static BiMap<als, afg> getBlockItemMap() {
        return GameData.getMain().iItemRegistry.getSlaveMap(BLOCK_TO_ITEM, BiMap.class);
    }

    static <K extends IForgeRegistryEntry<K>> K register_impl(Object object, kq location) {
        if (object == null) {
            FMLLog.getLogger().log(Level.ERROR, "Attempt to register a null object");
            throw new NullPointerException("Attempt to register a null object");
        }
        ((IForgeRegistryEntry)object).setRegistryName(location);
        return GameData.register_impl(object);
    }

    static <K extends IForgeRegistryEntry<K>> K register_impl(Object object) {
        IForgeRegistryEntry castedObj = (IForgeRegistryEntry)object;
        if (object == null) {
            FMLLog.getLogger().log(Level.ERROR, "Attempt to register a null object");
            throw new NullPointerException("Attempt to register a null object");
        }
        if (castedObj.getRegistryName() == null) {
            FMLLog.getLogger().log(Level.ERROR, "Attempt to register object without having set a registry name {} (type {})", new Object[]{object, object.getClass().getName()});
            throw new IllegalArgumentException(String.format("No registry name set for object %s (%s)", object, object.getClass().getName()));
        }
        IForgeRegistry<IForgeRegistryEntry> registry = PersistentRegistryManager.findRegistry(castedObj);
        registry.register(castedObj);
        return (K)castedObj;
    }

    public static cy<atj> getBlockStateIDMap() {
        return GameData.getMain().iBlockRegistry.getSlaveMap(BLOCKSTATE_TO_ID, cy.class);
    }

    public static void vanillaSnapshot() {
        PersistentRegistryManager.freezeVanilla();
    }

    public <T extends IForgeRegistryEntry<T>> RegistryDelegate<T> makeDelegate(T obj, Class<T> rootClass) {
        return PersistentRegistryManager.makeDelegate(obj, rootClass);
    }

    private static class EntityCallbacks
    implements IForgeRegistry.AddCallback<EntityEntry>,
    IForgeRegistry.ClearCallback<EntityEntry>,
    IForgeRegistry.CreateCallback<EntityEntry> {
        static final EntityCallbacks INSTANCE = new EntityCallbacks();

        private EntityCallbacks() {
        }

        @Override
        public void onAdd(EntityEntry entry, int id, Map<kq, ?> slaves) {
            if (entry.getEgg() != null) {
                so.c.put(entry.getRegistryName(), entry.getEgg());
            }
        }

        @Override
        public void onClear(IForgeRegistry<EntityEntry> registry, Map<kq, ?> slaveset) {
        }

        @Override
        public void onCreate(Map<kq, ?> slaveset, BiMap<kq, ? extends IForgeRegistry<?>> registries) {
        }
    }

    private static class BiomeCallbacks
    implements IForgeRegistry.AddCallback<akd>,
    IForgeRegistry.ClearCallback<akd>,
    IForgeRegistry.CreateCallback<akd> {
        static final BiomeCallbacks INSTANCE = new BiomeCallbacks();

        private BiomeCallbacks() {
        }

        @Override
        public void onAdd(akd biome, int id, Map<kq, ?> slaves) {
        }

        @Override
        public void onClear(IForgeRegistry<akd> registry, Map<kq, ?> slaveset) {
        }

        @Override
        public void onCreate(Map<kq, ?> slaveset, BiMap<kq, ? extends IForgeRegistry<?>> registries) {
        }
    }

    private static class PotionCallbacks
    implements IForgeRegistry.AddCallback<sf>,
    IForgeRegistry.ClearCallback<sf>,
    IForgeRegistry.CreateCallback<sf> {
        static final PotionCallbacks INSTANCE = new PotionCallbacks();

        private PotionCallbacks() {
        }

        @Override
        public void onAdd(sf potion, int id, Map<kq, ?> slaves) {
        }

        @Override
        public void onClear(IForgeRegistry<sf> registry, Map<kq, ?> slaveset) {
        }

        @Override
        public void onCreate(Map<kq, ?> slaveset, BiMap<kq, ? extends IForgeRegistry<?>> registries) {
        }
    }

    private static class ItemCallbacks
    implements IForgeRegistry.AddCallback<afg>,
    IForgeRegistry.ClearCallback<afg>,
    IForgeRegistry.CreateCallback<afg>,
    IForgeRegistry.SubstitutionCallback<afg> {
        static final ItemCallbacks INSTANCE = new ItemCallbacks();

        private ItemCallbacks() {
        }

        @Override
        public void onAdd(afg item, int blockId, Map<kq, ?> slaves) {
            if (item instanceof adu) {
                adu itemBlock = (adu)item;
                BiMap blockToItem = (BiMap)slaves.get(BLOCK_TO_ITEM);
                als block = (als)itemBlock.d().delegate.get();
                blockToItem.forcePut((Object)block, (Object)item);
            }
        }

        @Override
        public void onClear(IForgeRegistry<afg> registry, Map<kq, ?> slaveset) {
            Map map = (Map)slaveset.get(BLOCK_TO_ITEM);
            map.clear();
        }

        @Override
        public void onCreate(Map<kq, ?> slaveset, BiMap<kq, ? extends IForgeRegistry<?>> registries) {
            BiMap blockItemMap = ((IForgeRegistry)registries.get((Object)PersistentRegistryManager.BLOCKS)).getSlaveMap(BLOCK_TO_ITEM, BiMap.class);
            slaveset.put(BLOCK_TO_ITEM, blockItemMap);
        }

        @Override
        public void onSubstituteActivated(Map<kq, ?> slaveset, afg original, afg replacement, kq name) {
            BiMap blockItemMap = (BiMap)slaveset.get(BLOCK_TO_ITEM);
        }
    }

    private static class BlockCallbacks
    implements IForgeRegistry.AddCallback<als>,
    IForgeRegistry.ClearCallback<als>,
    IForgeRegistry.CreateCallback<als>,
    IForgeRegistry.SubstitutionCallback<als> {
        static final BlockCallbacks INSTANCE = new BlockCallbacks();

        private BlockCallbacks() {
        }

        @Override
        public void onAdd(als block, int blockId, Map<kq, ?> slaves) {
            ClearableObjectIntIdentityMap blockstateMap = (ClearableObjectIntIdentityMap)((Object)slaves.get(BLOCKSTATE_TO_ID));
            boolean[] usedMeta = new boolean[16];
            for (atj state : block.s().a()) {
                int meta = block.e(state);
                blockstateMap.a(state, blockId << 4 | meta);
                usedMeta[meta] = true;
            }
            for (int meta = 0; meta < 16; ++meta) {
                if (!usedMeta[meta]) continue;
                blockstateMap.a(block.a(meta), blockId << 4 | meta);
            }
        }

        @Override
        public void onClear(IForgeRegistry<als> registry, Map<kq, ?> slaveset) {
            ClearableObjectIntIdentityMap blockstateMap = (ClearableObjectIntIdentityMap)((Object)slaveset.get(BLOCKSTATE_TO_ID));
            blockstateMap.clear();
            Map originals = (Map)slaveset.get(PersistentRegistryManager.SUBSTITUTION_ORIGINALS);
            BiMap blockItemMap = (BiMap)slaveset.get(BLOCK_TO_ITEM);
            for (afg it : blockItemMap.values()) {
                if (!(it instanceof adu)) continue;
                adu itemBlock = (adu)it;
                kq registryKey = registry.getKey(itemBlock.a);
                if (!originals.containsKey(registryKey)) continue;
                try {
                    FinalFieldHelper.setField(blockField, itemBlock, originals.get(registryKey));
                }
                catch (Exception e2) {
                    throw Throwables.propagate((Throwable)e2);
                }
            }
        }

        @Override
        public void onCreate(Map<kq, ?> slaveset, BiMap<kq, ? extends IForgeRegistry<?>> registries) {
            ClearableObjectIntIdentityMap<atj> idMap = new ClearableObjectIntIdentityMap<atj>(){

                public int get(atj key) {
                    Integer integer = (Integer)this.a.get(key);
                    if (integer == null && key != null) {
                        integer = (Integer)this.a.get(key.v().a(key.v().e(key)));
                    }
                    return integer == null ? -1 : integer;
                }
            };
            slaveset.put(BLOCKSTATE_TO_ID, idMap);
            HashBiMap map = HashBiMap.create();
            slaveset.put(BLOCK_TO_ITEM, map);
        }

        @Override
        public void onSubstituteActivated(Map<kq, ?> slaveset, als original, als replacement, kq name) {
            BiMap blockItemMap = (BiMap)slaveset.get(BLOCK_TO_ITEM);
            if (blockItemMap.containsKey((Object)original)) {
                afg i = (afg)blockItemMap.get((Object)original);
                if (i instanceof adu) {
                    try {
                        FinalFieldHelper.setField(blockField, i, replacement);
                    }
                    catch (Exception e2) {
                        throw Throwables.propagate((Throwable)e2);
                    }
                }
                blockItemMap.forcePut((Object)replacement, (Object)i);
            }
        }
    }

    static class ClearableObjectIntIdentityMap<I>
    extends cy<I> {
        ClearableObjectIntIdentityMap() {
        }

        void clear() {
            this.a.clear();
            this.b.clear();
        }
    }
}

