/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.reflect.TypeToken;
import net.minecraftforge.fml.common.FMLContainer;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.InjectedModContainer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.PersistentRegistryManager;
import net.minecraftforge.fml.common.registry.RegistryDelegate;

public interface IForgeRegistryEntry<V> {
    public V setRegistryName(kq var1);

    public kq getRegistryName();

    public Class<? super V> getRegistryType();

    public static class Impl<T extends IForgeRegistryEntry<T>>
    implements IForgeRegistryEntry<T> {
        private TypeToken<T> token = new TypeToken<T>(this.getClass()){};
        public final RegistryDelegate<T> delegate = PersistentRegistryManager.makeDelegate(this, this.token.getRawType());
        private kq registryName = null;

        public final T setRegistryName(String name) {
            String prefix;
            if (this.getRegistryName() != null) {
                throw new IllegalStateException("Attempted to set registry name with existing registry name! New: " + name + " Old: " + this.getRegistryName());
            }
            int index = name.lastIndexOf(58);
            String oldPrefix = index == -1 ? "" : name.substring(0, index);
            name = index == -1 ? name : name.substring(index + 1);
            ModContainer mc = Loader.instance().activeModContainer();
            String string = prefix = mc == null || mc instanceof InjectedModContainer && ((InjectedModContainer)mc).wrappedContainer instanceof FMLContainer ? "minecraft" : mc.getModId().toLowerCase();
            if (!oldPrefix.equals(prefix) && oldPrefix.length() > 0) {
                FMLLog.bigWarning("Dangerous alternative prefix `%s` for name `%s`, expected `%s` invalid registry invocation/invalid name?", oldPrefix, name, prefix);
                prefix = oldPrefix;
            }
            this.registryName = new kq(prefix, name);
            return (T)this;
        }

        @Override
        public final T setRegistryName(kq name) {
            return this.setRegistryName(name.toString());
        }

        public final T setRegistryName(String modID, String name) {
            return this.setRegistryName(modID + ":" + name);
        }

        @Override
        public final kq getRegistryName() {
            if (this.delegate.name() != null) {
                return this.delegate.name();
            }
            return this.registryName != null ? this.registryName : null;
        }

        @Override
        public final Class<? super T> getRegistryType() {
            return this.token.getRawType();
        }
    }
}

