/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.items;

import javax.annotation.Nonnull;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemStackHandler
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<du> {
    protected dd<afi> stacks;

    public ItemStackHandler() {
        this(1);
    }

    public ItemStackHandler(int size) {
        this.stacks = dd.a((int)size, (Object)afi.a);
    }

    public ItemStackHandler(dd<afi> stacks) {
        this.stacks = stacks;
    }

    public void setSize(int size) {
        this.stacks = dd.a((int)size, (Object)afi.a);
    }

    @Override
    public void setStackInSlot(int slot, @Nonnull afi stack) {
        this.validateSlotIndex(slot);
        if (afi.b((afi)((afi)this.stacks.get(slot)), (afi)stack)) {
            return;
        }
        this.stacks.set(slot, (Object)stack);
        this.onContentsChanged(slot);
    }

    @Override
    public int getSlots() {
        return this.stacks.size();
    }

    @Override
    @Nonnull
    public afi getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return (afi)this.stacks.get(slot);
    }

    @Override
    @Nonnull
    public afi insertItem(int slot, @Nonnull afi stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.b()) {
            return afi.a;
        }
        this.validateSlotIndex(slot);
        afi existing = (afi)this.stacks.get(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.b()) {
            if (!ItemHandlerHelper.canItemStacksStack(stack, existing)) {
                return stack;
            }
            limit -= existing.E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.E() > limit;
        if (!simulate) {
            if (existing.b()) {
                this.stacks.set(slot, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, limit) : stack));
            } else {
                existing.f(reachedLimit ? limit : stack.E());
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize(stack, stack.E() - limit) : afi.a;
    }

    @Override
    @Nonnull
    public afi extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return afi.a;
        }
        this.validateSlotIndex(slot);
        afi existing = (afi)this.stacks.get(slot);
        if (existing.b()) {
            return afi.a;
        }
        int toExtract = Math.min(amount, existing.d());
        if (existing.E() <= toExtract) {
            if (!simulate) {
                this.stacks.set(slot, (Object)afi.a);
                this.onContentsChanged(slot);
            }
            return existing;
        }
        if (!simulate) {
            this.stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize(existing, existing.E() - toExtract));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize(existing, toExtract);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    protected int getStackLimit(int slot, @Nonnull afi stack) {
        return Math.min(this.getSlotLimit(slot), stack.d());
    }

    @Override
    public du serializeNBT() {
        ea nbtTagList = new ea();
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (((afi)this.stacks.get(i)).b()) continue;
            du itemTag = new du();
            itemTag.a("Slot", i);
            ((afi)this.stacks.get(i)).a(itemTag);
            nbtTagList.a((ei)itemTag);
        }
        du nbt = new du();
        nbt.a("Items", (ei)nbtTagList);
        nbt.a("Size", this.stacks.size());
        return nbt;
    }

    @Override
    public void deserializeNBT(du nbt) {
        this.setSize(nbt.b("Size", 3) ? nbt.h("Size") : this.stacks.size());
        ea tagList = nbt.c("Items", 10);
        for (int i = 0; i < tagList.c(); ++i) {
            du itemTags = tagList.b(i);
            int slot = itemTags.h("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            this.stacks.set(slot, (Object)new afi(itemTags));
        }
        this.onLoad();
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.stacks.size()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.stacks.size() + ")");
        }
    }

    protected void onLoad() {
    }

    protected void onContentsChanged(int slot) {
    }
}

