/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;

public class ShapedOreRecipe
implements ahn {
    public static final int MAX_CRAFT_GRID_WIDTH = 3;
    public static final int MAX_CRAFT_GRID_HEIGHT = 3;
    protected afi output = afi.a;
    protected Object[] input = null;
    protected int width = 0;
    protected int height = 0;
    protected boolean mirrored = true;

    public ShapedOreRecipe(als result, Object ... recipe) {
        this(new afi(result), recipe);
    }

    public ShapedOreRecipe(afg result, Object ... recipe) {
        this(new afi(result), recipe);
    }

    public ShapedOreRecipe(@Nonnull afi result, Object ... recipe) {
        this.output = result.l();
        String shape = "";
        int idx = 0;
        if (recipe[idx] instanceof Boolean) {
            this.mirrored = (Boolean)recipe[idx];
            if (recipe[idx + 1] instanceof Object[]) {
                recipe = (Object[])recipe[idx + 1];
            } else {
                idx = 1;
            }
        }
        if (recipe[idx] instanceof String[]) {
            String[] parts = (String[])recipe[idx++];
            for (String s : parts) {
                this.width = s.length();
                shape = shape + (String)s;
            }
            this.height = parts.length;
        } else {
            while (recipe[idx] instanceof String) {
                String s = (String)recipe[idx++];
                shape = shape + s;
                this.width = s.length();
                ++this.height;
            }
        }
        if (this.width * this.height != shape.length()) {
            String ret = "Invalid shaped ore recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
        HashMap<Character, Object> itemMap = new HashMap<Character, Object>();
        while (idx < recipe.length) {
            Character chr = (Character)recipe[idx];
            Object in = recipe[idx + 1];
            if (in instanceof afi) {
                itemMap.put(chr, ((afi)in).l());
            } else if (in instanceof afg) {
                itemMap.put(chr, new afi((afg)in));
            } else if (in instanceof als) {
                itemMap.put(chr, new afi((als)in, 1, Short.MAX_VALUE));
            } else if (in instanceof String) {
                itemMap.put(chr, OreDictionary.getOres((String)in));
            } else {
                String ret = "Invalid shaped ore recipe: ";
                for (Object tmp : recipe) {
                    ret = ret + tmp + ", ";
                }
                ret = ret + this.output;
                throw new RuntimeException(ret);
            }
            idx += 2;
        }
        this.input = new Object[this.width * this.height];
        int x = 0;
        for (char chr : shape.toCharArray()) {
            this.input[x++] = itemMap.get(Character.valueOf(chr));
        }
    }

    ShapedOreRecipe(ahq recipe, Map<afi, String> replacements) {
        this.output = recipe.b();
        this.width = recipe.a;
        this.height = recipe.b;
        this.input = new Object[recipe.c.length];
        block0: for (int i = 0; i < this.input.length; ++i) {
            afi ingredient = recipe.c[i];
            if (ingredient.b()) continue;
            this.input[i] = recipe.c[i];
            for (Map.Entry<afi, String> replace : replacements.entrySet()) {
                if (!OreDictionary.itemMatches(replace.getKey(), ingredient, true)) continue;
                this.input[i] = OreDictionary.getOres(replace.getValue());
                continue block0;
            }
        }
    }

    public afi a(acr var1) {
        return this.output.l();
    }

    public int a() {
        return this.input.length;
    }

    public afi b() {
        return this.output;
    }

    public boolean a(acr inv, ajq world) {
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (this.checkMatch(inv, x, y, false)) {
                    return true;
                }
                if (!this.mirrored || !this.checkMatch(inv, x, y, true)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkMatch(acr inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Object target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.input[this.width - subX - 1 + subY * this.width] : this.input[subX + subY * this.width];
                }
                afi slot = inv.c(x, y);
                if (target instanceof afi) {
                    if (OreDictionary.itemMatches((afi)target, slot, false)) continue;
                    return false;
                }
                if (target instanceof List) {
                    boolean matched = false;
                    Iterator itr = ((List)target).iterator();
                    while (itr.hasNext() && !matched) {
                        matched = OreDictionary.itemMatches((afi)itr.next(), slot, false);
                    }
                    if (matched) continue;
                    return false;
                }
                if (target != null || slot.b()) continue;
                return false;
            }
        }
        return true;
    }

    public ShapedOreRecipe setMirrored(boolean mirror) {
        this.mirrored = mirror;
        return this;
    }

    public Object[] getInput() {
        return this.input;
    }

    public dd<afi> b(acr inv) {
        return ForgeHooks.defaultRecipeGetRemainingItems(inv);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

