/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.resources.IResourceManager;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.tags.TagCollectionReader;
import net.minecraft.tags.TagRegistry;
import net.minecraft.tags.TagRegistryManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForgeTagHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Map<ResourceLocation, ITagCollection<?>> customTagTypes = Collections.emptyMap();
    private static Set<ResourceLocation> customTagTypeNames = Collections.emptySet();
    private static boolean tagTypesSet = false;

    @Nullable
    private static <T extends IForgeRegistryEntry<T>> TagRegistry<T> getTagRegistry(IForgeRegistry<T> registry) {
        return TagRegistryManager.get((ResourceLocation)registry.getRegistryName());
    }

    private static void validateRegistrySupportsTags(IForgeRegistry<?> registry) {
        if (!(ForgeTagHandler.getTagRegistry(registry) != null || registry instanceof ForgeRegistry && ((ForgeRegistry)registry).getTagFolder() != null)) {
            throw new IllegalArgumentException("Registry " + registry.getRegistryName() + " does not support tag types.");
        }
    }

    public static <T extends IForgeRegistryEntry<T>> ITag.INamedTag<T> makeWrapperTag(IForgeRegistry<T> registry, ResourceLocation name) {
        ForgeTagHandler.validateRegistrySupportsTags(registry);
        if (tagTypesSet) {
            TagRegistry<T> tagRegistry = ForgeTagHandler.getTagRegistry(registry);
            if (tagRegistry == null) {
                throw new IllegalArgumentException("Registry " + registry.getRegistryName() + " does not support tag types.");
            }
            return tagRegistry.func_232937_a_(name.toString());
        }
        return TagRegistry.createDelayedTag((ResourceLocation)registry.getRegistryName(), (ResourceLocation)name);
    }

    public static <T extends IForgeRegistryEntry<T>> Tags.IOptionalNamedTag<T> createOptionalTag(IForgeRegistry<T> registry, ResourceLocation name) {
        return ForgeTagHandler.createOptionalTag(registry, name, null);
    }

    public static <T extends IForgeRegistryEntry<T>> Tags.IOptionalNamedTag<T> createOptionalTag(IForgeRegistry<T> registry, ResourceLocation name, @Nullable Supplier<Set<T>> defaults) {
        ForgeTagHandler.validateRegistrySupportsTags(registry);
        if (tagTypesSet) {
            TagRegistry<T> tagRegistry = ForgeTagHandler.getTagRegistry(registry);
            if (tagRegistry == null) {
                throw new IllegalArgumentException("Registry " + registry.getRegistryName() + " does not support tag types.");
            }
            return tagRegistry.createOptional(name, defaults);
        }
        return TagRegistry.createDelayedOptional((ResourceLocation)registry.getRegistryName(), (ResourceLocation)name, defaults);
    }

    public static <T extends IForgeRegistryEntry<T>> ITag.INamedTag<T> makeWrapperTag(ResourceLocation registryName, ResourceLocation name) {
        if (tagTypesSet) {
            ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(registryName);
            if (registry == null) {
                throw new IllegalArgumentException("Could not find registry named: " + registryName);
            }
            return ForgeTagHandler.makeWrapperTag(registry, name);
        }
        return TagRegistry.createDelayedTag((ResourceLocation)registryName, (ResourceLocation)name);
    }

    public static <T extends IForgeRegistryEntry<T>> Tags.IOptionalNamedTag<T> createOptionalTag(ResourceLocation registryName, ResourceLocation name) {
        return ForgeTagHandler.createOptionalTag(registryName, name, null);
    }

    public static <T extends IForgeRegistryEntry<T>> Tags.IOptionalNamedTag<T> createOptionalTag(ResourceLocation registryName, ResourceLocation name, @Nullable Supplier<Set<T>> defaults) {
        if (tagTypesSet) {
            ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(registryName);
            if (registry == null) {
                throw new IllegalArgumentException("Could not find registry named: " + registryName);
            }
            return ForgeTagHandler.createOptionalTag(registry, name, defaults);
        }
        return TagRegistry.createDelayedOptional((ResourceLocation)registryName, (ResourceLocation)name, defaults);
    }

    public static Set<ResourceLocation> getCustomTagTypeNames() {
        return customTagTypeNames;
    }

    public static Map<ResourceLocation, ITagCollection<?>> getCustomTagTypes() {
        return customTagTypes;
    }

    public static void setCustomTagTypes(Set<ResourceLocation> customTagTypes) {
        if (tagTypesSet) {
            throw new RuntimeException("Custom tag types have already been set, this method should only be called by forge, and after registries are initialized");
        }
        tagTypesSet = true;
        customTagTypeNames = ImmutableSet.copyOf(customTagTypes);
        TagRegistry.performDelayedAdd();
    }

    public static Map<ResourceLocation, TagCollectionReader<?>> createCustomTagTypeReaders() {
        LOGGER.debug("Gathering custom tag collection reader from types.");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ResourceLocation registryName : customTagTypeNames) {
            ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(registryName);
            if (registry == null || registry.getTagFolder() == null) continue;
            builder.put((Object)registryName, (Object)new TagCollectionReader(rl -> Optional.ofNullable(registry.getValue((ResourceLocation)rl)), "tags/" + registry.getTagFolder(), registryName.func_110623_a()));
        }
        return builder.build();
    }

    public static void resetCachedTagCollections() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ResourceLocation registryName : customTagTypeNames) {
            TagRegistry tagRegistry = TagRegistryManager.get((ResourceLocation)registryName);
            if (tagRegistry == null) continue;
            builder.put((Object)registryName, (Object)ITagCollection.func_242202_a(tagRegistry.func_241288_c_().stream().distinct().collect(Collectors.toMap(ITag.INamedTag::func_230234_a_, namedTag -> namedTag))));
        }
        customTagTypes = builder.build();
    }

    public static ITagCollectionSupplier populateTagCollectionManager(ITagCollection<Block> blockTags, ITagCollection<Item> itemTags, ITagCollection<Fluid> fluidTags, ITagCollection<EntityType<?>> entityTypeTags) {
        ForgeTagHandler.resetCachedTagCollections();
        if (!customTagTypes.isEmpty()) {
            LOGGER.debug("Populated the TagCollectionManager with {} extra types", (Object)customTagTypes.size());
        }
        return ITagCollectionSupplier.func_242209_a(blockTags, itemTags, fluidTags, entityTypeTags);
    }

    public static void updateCustomTagTypes(List<TagCollectionReaderInfo> tagCollectionReaders) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TagCollectionReaderInfo info : tagCollectionReaders) {
            builder.put((Object)info.tagType, (Object)info.reader.func_242226_a(info.tagBuilders));
        }
        customTagTypes = builder.build();
    }

    public static void updateCustomTagTypes(FMLPlayMessages.SyncCustomTagTypes packet) {
        customTagTypes = packet.getCustomTagTypes();
    }

    public static CompletableFuture<List<TagCollectionReaderInfo>> getCustomTagTypeReloadResults(IResourceManager resourceManager, Executor backgroundExecutor, Map<ResourceLocation, TagCollectionReader<?>> readers) {
        CompletionStage<List<TagCollectionReaderInfo>> customResults = CompletableFuture.completedFuture(new ArrayList());
        for (Map.Entry<ResourceLocation, TagCollectionReader<?>> entry : readers.entrySet()) {
            customResults = customResults.thenCombine((CompletionStage)entry.getValue().func_242224_a(resourceManager, backgroundExecutor), (results, result) -> {
                results.add(new TagCollectionReaderInfo((ResourceLocation)entry.getKey(), (TagCollectionReader)entry.getValue(), (Map)result));
                return results;
            });
        }
        return customResults;
    }

    public static class TagCollectionReaderInfo {
        private final ResourceLocation tagType;
        private final TagCollectionReader<?> reader;
        private final Map<ResourceLocation, ITag.Builder> tagBuilders;

        private TagCollectionReaderInfo(ResourceLocation tagType, TagCollectionReader<?> reader, Map<ResourceLocation, ITag.Builder> tagBuilders) {
            this.tagType = tagType;
            this.reader = reader;
            this.tagBuilders = tagBuilders;
        }
    }
}

