/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.common.collect.Queues;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.TimeoutException;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.security.Key;
import java.util.Queue;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.minecraft.network.INetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.NettyCompressionDecoder;
import net.minecraft.network.NettyCompressionEncoder;
import net.minecraft.network.NettyEncryptingDecoder;
import net.minecraft.network.NettyEncryptingEncoder;
import net.minecraft.network.NettyPacketDecoder;
import net.minecraft.network.NettyPacketEncoder;
import net.minecraft.network.NettyVarint21FrameDecoder;
import net.minecraft.network.NettyVarint21FrameEncoder;
import net.minecraft.network.PacketDirection;
import net.minecraft.network.ProtocolType;
import net.minecraft.network.SkipableEncoderException;
import net.minecraft.network.ThreadQuickExitException;
import net.minecraft.network.login.ServerLoginNetHandler;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.server.SDisconnectPacket;
import net.minecraft.util.CryptManager;
import net.minecraft.util.LazyValue;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class NetworkManager
extends SimpleChannelInboundHandler<IPacket<?>> {
    private static final Logger field_150735_g = LogManager.getLogger();
    public static final Marker field_150740_a = MarkerManager.getMarker((String)"NETWORK");
    public static final Marker field_150738_b = MarkerManager.getMarker((String)"NETWORK_PACKETS", (Marker)field_150740_a);
    public static final AttributeKey<ProtocolType> field_150739_c = AttributeKey.valueOf((String)"protocol");
    public static final LazyValue<NioEventLoopGroup> field_179295_d = new LazyValue(() -> new NioEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Client IO #%d").setDaemon(true).build()));
    public static final LazyValue<EpollEventLoopGroup> field_181125_e = new LazyValue(() -> new EpollEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Epoll Client IO #%d").setDaemon(true).build()));
    public static final LazyValue<DefaultEventLoopGroup> field_179296_e = new LazyValue(() -> new DefaultEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Local Client IO #%d").setDaemon(true).build()));
    private final PacketDirection field_179294_g;
    private final Queue<QueuedPacket> field_150745_j = Queues.newConcurrentLinkedQueue();
    private Channel field_150746_k;
    private SocketAddress field_150743_l;
    private INetHandler field_150744_m;
    private ITextComponent field_150742_o;
    private boolean field_152463_r;
    private boolean field_179297_n;
    private int field_211394_q;
    private int field_211395_r;
    private float field_211396_s;
    private float field_211397_t;
    private int field_211398_u;
    private boolean field_211399_v;
    private Consumer<NetworkManager> activationHandler;

    public NetworkManager(PacketDirection packetDirection) {
        this.field_179294_g = packetDirection;
    }

    public void channelActive(ChannelHandlerContext p_channelActive_1_) throws Exception {
        super.channelActive(p_channelActive_1_);
        this.field_150746_k = p_channelActive_1_.channel();
        this.field_150743_l = this.field_150746_k.remoteAddress();
        if (this.activationHandler != null) {
            this.activationHandler.accept(this);
        }
        try {
            this.func_150723_a(ProtocolType.HANDSHAKING);
        }
        catch (Throwable throwable) {
            field_150735_g.fatal((Object)throwable);
        }
    }

    public void func_150723_a(ProtocolType newState) {
        this.field_150746_k.attr(field_150739_c).set((Object)newState);
        this.field_150746_k.config().setAutoRead(true);
        field_150735_g.debug("Enabled auto read");
    }

    public void channelInactive(ChannelHandlerContext p_channelInactive_1_) throws Exception {
        this.func_150718_a((ITextComponent)new TranslationTextComponent("disconnect.endOfStream"));
    }

    public void exceptionCaught(ChannelHandlerContext p_exceptionCaught_1_, Throwable p_exceptionCaught_2_) {
        if (p_exceptionCaught_2_ instanceof SkipableEncoderException) {
            field_150735_g.debug("Skipping packet due to errors", p_exceptionCaught_2_.getCause());
        } else {
            boolean flag = !this.field_211399_v;
            this.field_211399_v = true;
            if (this.field_150746_k.isOpen()) {
                if (p_exceptionCaught_2_ instanceof TimeoutException) {
                    field_150735_g.debug("Timeout", p_exceptionCaught_2_);
                    this.func_150718_a((ITextComponent)new TranslationTextComponent("disconnect.timeout"));
                } else {
                    TranslationTextComponent itextcomponent = new TranslationTextComponent("disconnect.genericReason", "Internal Exception: " + p_exceptionCaught_2_);
                    if (flag) {
                        field_150735_g.debug("Failed to sent packet", p_exceptionCaught_2_);
                        this.func_201058_a((IPacket<?>)new SDisconnectPacket((ITextComponent)itextcomponent), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)arg_0 -> this.lambda$exceptionCaught$3((ITextComponent)itextcomponent, arg_0)));
                        this.func_150721_g();
                    } else {
                        field_150735_g.debug("Double fault", p_exceptionCaught_2_);
                        this.func_150718_a((ITextComponent)itextcomponent);
                    }
                }
            }
        }
    }

    protected void channelRead0(ChannelHandlerContext p_channelRead0_1_, IPacket<?> p_channelRead0_2_) throws Exception {
        if (this.field_150746_k.isOpen()) {
            try {
                NetworkManager.func_197664_a(p_channelRead0_2_, this.field_150744_m);
            }
            catch (ThreadQuickExitException threadQuickExitException) {
                // empty catch block
            }
            ++this.field_211394_q;
        }
    }

    private static <T extends INetHandler> void func_197664_a(IPacket<T> p_197664_0_, INetHandler p_197664_1_) {
        p_197664_0_.func_148833_a(p_197664_1_);
    }

    public void func_150719_a(INetHandler handler) {
        Validate.notNull((Object)handler, (String)"packetListener", (Object[])new Object[0]);
        this.field_150744_m = handler;
    }

    public void func_179290_a(IPacket<?> packetIn) {
        this.func_201058_a(packetIn, (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)null));
    }

    public void func_201058_a(IPacket<?> packetIn, @Nullable GenericFutureListener<? extends Future<? super Void>> p_201058_2_) {
        if (this.func_150724_d()) {
            this.func_150733_h();
            this.func_150732_b(packetIn, p_201058_2_);
        } else {
            this.field_150745_j.add(new QueuedPacket(packetIn, p_201058_2_));
        }
    }

    private void func_150732_b(IPacket<?> inPacket, @Nullable GenericFutureListener<? extends Future<? super Void>> futureListeners) {
        ProtocolType protocoltype = ProtocolType.func_150752_a(inPacket);
        ProtocolType protocoltype1 = (ProtocolType)this.field_150746_k.attr(field_150739_c).get();
        ++this.field_211395_r;
        if (protocoltype1 != protocoltype) {
            field_150735_g.debug("Disabled auto read");
            this.field_150746_k.eventLoop().execute(() -> this.field_150746_k.config().setAutoRead(false));
        }
        if (this.field_150746_k.eventLoop().inEventLoop()) {
            if (protocoltype != protocoltype1) {
                this.func_150723_a(protocoltype);
            }
            ChannelFuture channelfuture = this.field_150746_k.writeAndFlush(inPacket);
            if (futureListeners != null) {
                channelfuture.addListener(futureListeners);
            }
            channelfuture.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        } else {
            this.field_150746_k.eventLoop().execute(() -> {
                if (protocoltype != protocoltype1) {
                    this.func_150723_a(protocoltype);
                }
                ChannelFuture channelfuture1 = this.field_150746_k.writeAndFlush((Object)inPacket);
                if (futureListeners != null) {
                    channelfuture1.addListener(futureListeners);
                }
                channelfuture1.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void func_150733_h() {
        if (this.field_150746_k != null && this.field_150746_k.isOpen()) {
            Queue<QueuedPacket> queue = this.field_150745_j;
            synchronized (queue) {
                QueuedPacket networkmanager$queuedpacket;
                while ((networkmanager$queuedpacket = this.field_150745_j.poll()) != null) {
                    this.func_150732_b(networkmanager$queuedpacket.field_150774_a, (GenericFutureListener<? extends Future<? super Void>>)networkmanager$queuedpacket.field_201049_b);
                }
            }
        }
    }

    public void func_74428_b() {
        this.func_150733_h();
        if (this.field_150744_m instanceof ServerLoginNetHandler) {
            ((ServerLoginNetHandler)this.field_150744_m).func_73660_a();
        }
        if (this.field_150744_m instanceof ServerPlayNetHandler) {
            ((ServerPlayNetHandler)this.field_150744_m).func_73660_a();
        }
        if (this.field_150746_k != null) {
            this.field_150746_k.flush();
        }
        if (this.field_211398_u++ % 20 == 0) {
            this.func_241877_b();
        }
    }

    protected void func_241877_b() {
        this.field_211397_t = MathHelper.func_219799_g((float)0.75f, (float)this.field_211395_r, (float)this.field_211397_t);
        this.field_211396_s = MathHelper.func_219799_g((float)0.75f, (float)this.field_211394_q, (float)this.field_211396_s);
        this.field_211395_r = 0;
        this.field_211394_q = 0;
    }

    public SocketAddress func_74430_c() {
        return this.field_150743_l;
    }

    public void func_150718_a(ITextComponent message) {
        if (this.field_150746_k.isOpen()) {
            this.field_150746_k.close().awaitUninterruptibly();
            this.field_150742_o = message;
        }
    }

    public boolean func_150731_c() {
        return this.field_150746_k instanceof LocalChannel || this.field_150746_k instanceof LocalServerChannel;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static NetworkManager func_181124_a(InetAddress address, int serverPort, boolean useNativeTransport) {
        LazyValue<NioEventLoopGroup> lazyvalue;
        Class<NioSocketChannel> oclass;
        if (address instanceof Inet6Address) {
            System.setProperty("java.net.preferIPv4Stack", "false");
        }
        final NetworkManager networkmanager = new NetworkManager(PacketDirection.CLIENTBOUND);
        networkmanager.activationHandler = NetworkHooks::registerClientLoginChannel;
        if (Epoll.isAvailable() && useNativeTransport) {
            oclass = EpollSocketChannel.class;
            lazyvalue = field_181125_e;
        } else {
            oclass = NioSocketChannel.class;
            lazyvalue = field_179295_d;
        }
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)lazyvalue.func_179281_c())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel p_initChannel_1_) throws Exception {
                try {
                    p_initChannel_1_.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                }
                catch (ChannelException channelException) {
                    // empty catch block
                }
                p_initChannel_1_.pipeline().addLast("timeout", (ChannelHandler)new ReadTimeoutHandler(30)).addLast("splitter", (ChannelHandler)new NettyVarint21FrameDecoder()).addLast("decoder", (ChannelHandler)new NettyPacketDecoder(PacketDirection.CLIENTBOUND)).addLast("prepender", (ChannelHandler)new NettyVarint21FrameEncoder()).addLast("encoder", (ChannelHandler)new NettyPacketEncoder(PacketDirection.SERVERBOUND)).addLast("packet_handler", (ChannelHandler)networkmanager);
            }
        })).channel(oclass)).connect(address, serverPort).syncUninterruptibly();
        return networkmanager;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static NetworkManager func_150722_a(SocketAddress address) {
        final NetworkManager networkmanager = new NetworkManager(PacketDirection.CLIENTBOUND);
        networkmanager.activationHandler = NetworkHooks::registerClientLoginChannel;
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)field_179296_e.func_179281_c())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel p_initChannel_1_) throws Exception {
                p_initChannel_1_.pipeline().addLast("packet_handler", (ChannelHandler)networkmanager);
            }
        })).channel(LocalChannel.class)).connect(address).syncUninterruptibly();
        return networkmanager;
    }

    public void func_150727_a(SecretKey key) {
        this.field_152463_r = true;
        this.field_150746_k.pipeline().addBefore("splitter", "decrypt", (ChannelHandler)new NettyEncryptingDecoder(CryptManager.func_151229_a((int)2, (Key)key)));
        this.field_150746_k.pipeline().addBefore("prepender", "encrypt", (ChannelHandler)new NettyEncryptingEncoder(CryptManager.func_151229_a((int)1, (Key)key)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_179292_f() {
        return this.field_152463_r;
    }

    public boolean func_150724_d() {
        return this.field_150746_k != null && this.field_150746_k.isOpen();
    }

    public boolean func_179291_h() {
        return this.field_150746_k == null;
    }

    public INetHandler func_150729_e() {
        return this.field_150744_m;
    }

    @Nullable
    public ITextComponent func_150730_f() {
        return this.field_150742_o;
    }

    public void func_150721_g() {
        this.field_150746_k.config().setAutoRead(false);
    }

    public void func_179289_a(int threshold) {
        if (threshold >= 0) {
            if (this.field_150746_k.pipeline().get("decompress") instanceof NettyCompressionDecoder) {
                ((NettyCompressionDecoder)this.field_150746_k.pipeline().get("decompress")).func_179303_a(threshold);
            } else {
                this.field_150746_k.pipeline().addBefore("decoder", "decompress", (ChannelHandler)new NettyCompressionDecoder(threshold));
            }
            if (this.field_150746_k.pipeline().get("compress") instanceof NettyCompressionEncoder) {
                ((NettyCompressionEncoder)this.field_150746_k.pipeline().get("compress")).func_179299_a(threshold);
            } else {
                this.field_150746_k.pipeline().addBefore("encoder", "compress", (ChannelHandler)new NettyCompressionEncoder(threshold));
            }
        } else {
            if (this.field_150746_k.pipeline().get("decompress") instanceof NettyCompressionDecoder) {
                this.field_150746_k.pipeline().remove("decompress");
            }
            if (this.field_150746_k.pipeline().get("compress") instanceof NettyCompressionEncoder) {
                this.field_150746_k.pipeline().remove("compress");
            }
        }
    }

    public void func_179293_l() {
        if (this.field_150746_k != null && !this.field_150746_k.isOpen()) {
            if (this.field_179297_n) {
                field_150735_g.warn("handleDisconnection() called twice");
            } else {
                this.field_179297_n = true;
                if (this.func_150730_f() != null) {
                    this.func_150729_e().func_147231_a(this.func_150730_f());
                } else if (this.func_150729_e() != null) {
                    this.func_150729_e().func_147231_a((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.generic"));
                }
            }
        }
    }

    public float func_211393_m() {
        return this.field_211396_s;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_211390_n() {
        return this.field_211397_t;
    }

    public Channel channel() {
        return this.field_150746_k;
    }

    public PacketDirection getDirection() {
        return this.field_179294_g;
    }

    private /* synthetic */ void lambda$exceptionCaught$3(ITextComponent itextcomponent, Future p_211391_2_) throws Exception {
        this.func_150718_a(itextcomponent);
    }

    static class QueuedPacket {
        private final IPacket<?> field_150774_a;
        @Nullable
        private final GenericFutureListener<? extends Future<? super Void>> field_201049_b;

        public QueuedPacket(IPacket<?> p_i48604_1_, @Nullable GenericFutureListener<? extends Future<? super Void>> p_i48604_2_) {
            this.field_150774_a = p_i48604_1_;
            this.field_201049_b = p_i48604_2_;
        }
    }
}

