/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.palette.UpgradeData;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimerTickList;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.lighting.WorldLightManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkPrimer
implements IChunk {
    private static final Logger field_201653_a = LogManager.getLogger();
    private final ChunkPos field_201654_b;
    private volatile boolean field_201655_c;
    @Nullable
    private BiomeContainer field_201656_d;
    @Nullable
    private volatile WorldLightManager field_217334_e;
    private final Map<Heightmap.Type, Heightmap> field_201657_e = Maps.newEnumMap(Heightmap.Type.class);
    private volatile ChunkStatus field_201658_f = ChunkStatus.field_223226_a_;
    private final Map<BlockPos, TileEntity> field_201659_g = Maps.newHashMap();
    private final Map<BlockPos, CompoundNBT> field_201660_h = Maps.newHashMap();
    private final ChunkSection[] field_201661_i = new ChunkSection[16];
    private final List<CompoundNBT> field_201662_j = Lists.newArrayList();
    private final List<BlockPos> field_201663_k = Lists.newArrayList();
    private final ShortList[] field_201665_m = new ShortList[16];
    private final Map<Structure<?>, StructureStart<?>> field_201666_n = Maps.newHashMap();
    private final Map<Structure<?>, LongSet> field_201667_o = Maps.newHashMap();
    private final UpgradeData field_201668_p;
    private final ChunkPrimerTickList<Block> field_201664_l;
    private final ChunkPrimerTickList<Fluid> field_205333_q;
    private long field_209217_s;
    private final Map<GenerationStage.Carving, BitSet> field_205769_s = new Object2ObjectArrayMap();
    private volatile boolean field_217335_u;

    public ChunkPrimer(ChunkPos p_i48700_1_, UpgradeData data) {
        this(p_i48700_1_, data, null, (ChunkPrimerTickList<Block>)new ChunkPrimerTickList(p_205332_0_ -> p_205332_0_ == null || p_205332_0_.func_176223_P().func_196958_f(), p_i48700_1_), (ChunkPrimerTickList<Fluid>)new ChunkPrimerTickList(p_205766_0_ -> p_205766_0_ == null || p_205766_0_ == Fluids.field_204541_a, p_i48700_1_));
    }

    public ChunkPrimer(ChunkPos p_i49941_1_, UpgradeData p_i49941_2_, @Nullable ChunkSection[] p_i49941_3_, ChunkPrimerTickList<Block> p_i49941_4_, ChunkPrimerTickList<Fluid> p_i49941_5_) {
        this.field_201654_b = p_i49941_1_;
        this.field_201668_p = p_i49941_2_;
        this.field_201664_l = p_i49941_4_;
        this.field_205333_q = p_i49941_5_;
        if (p_i49941_3_ != null) {
            if (this.field_201661_i.length == p_i49941_3_.length) {
                System.arraycopy(p_i49941_3_, 0, this.field_201661_i, 0, this.field_201661_i.length);
            } else {
                field_201653_a.warn("Could not set level chunk sections, array length is {} instead of {}", (Object)p_i49941_3_.length, (Object)this.field_201661_i.length);
            }
        }
    }

    @Override
    public BlockState func_180495_p(BlockPos pos) {
        int i = pos.func_177956_o();
        if (World.func_217405_b(i)) {
            return Blocks.field_201940_ji.func_176223_P();
        }
        ChunkSection chunksection = this.func_76587_i()[i >> 4];
        return ChunkSection.func_222628_a((ChunkSection)chunksection) ? Blocks.field_150350_a.func_176223_P() : chunksection.func_177485_a(pos.func_177958_n() & 0xF, i & 0xF, pos.func_177952_p() & 0xF);
    }

    @Override
    public FluidState func_204610_c(BlockPos pos) {
        int i = pos.func_177956_o();
        if (World.func_217405_b(i)) {
            return Fluids.field_204541_a.func_207188_f();
        }
        ChunkSection chunksection = this.func_76587_i()[i >> 4];
        return ChunkSection.func_222628_a((ChunkSection)chunksection) ? Fluids.field_204541_a.func_207188_f() : chunksection.func_206914_b(pos.func_177958_n() & 0xF, i & 0xF, pos.func_177952_p() & 0xF);
    }

    @Override
    public Stream<BlockPos> func_217304_m() {
        return this.field_201663_k.stream();
    }

    public ShortList[] func_201647_i() {
        ShortList[] ashortlist = new ShortList[16];
        for (BlockPos blockpos : this.field_201663_k) {
            IChunk.func_217308_a(ashortlist, blockpos.func_177956_o() >> 4).add(ChunkPrimer.func_201651_i(blockpos));
        }
        return ashortlist;
    }

    public void func_201646_a(short packedPosition, int lightValue) {
        this.func_201637_h(ChunkPrimer.func_201635_a(packedPosition, lightValue, this.field_201654_b));
    }

    public void func_201637_h(BlockPos lightPos) {
        this.field_201663_k.add(lightPos.func_185334_h());
    }

    @Override
    @Nullable
    public BlockState func_177436_a(BlockPos pos, BlockState state, boolean isMoving) {
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        if (j >= 0 && j < 256) {
            if (this.field_201661_i[j >> 4] == Chunk.field_186036_a && state.func_203425_a(Blocks.field_150350_a)) {
                return state;
            }
            if (state.getLightValue(this, pos) > 0) {
                this.field_201663_k.add(new BlockPos((i & 0xF) + this.func_76632_l().func_180334_c(), j, (k & 0xF) + this.func_76632_l().func_180333_d()));
            }
            ChunkSection chunksection = this.func_217332_a(j >> 4);
            BlockState blockstate = chunksection.func_222629_a(i & 0xF, j & 0xF, k & 0xF, state);
            if (this.field_201658_f.func_209003_a(ChunkStatus.field_222613_i) && state != blockstate && (state.func_200016_a(this, pos) != blockstate.func_200016_a(this, pos) || state.getLightValue(this, pos) != blockstate.getLightValue(this, pos) || state.func_215691_g() || blockstate.func_215691_g())) {
                WorldLightManager worldlightmanager = this.func_217307_e();
                worldlightmanager.func_215568_a(pos);
            }
            EnumSet<Heightmap.Type> enumset1 = this.func_201589_g().func_222595_h();
            EnumSet<Heightmap.Type> enumset = null;
            for (Heightmap.Type heightmap$type : enumset1) {
                Heightmap heightmap = this.field_201657_e.get(heightmap$type);
                if (heightmap != null) continue;
                if (enumset == null) {
                    enumset = EnumSet.noneOf(Heightmap.Type.class);
                }
                enumset.add(heightmap$type);
            }
            if (enumset != null) {
                Heightmap.func_222690_a((IChunk)this, enumset);
            }
            for (Heightmap.Type heightmap$type1 : enumset1) {
                this.field_201657_e.get(heightmap$type1).func_202270_a(i & 0xF, j, k & 0xF, state);
            }
            return blockstate;
        }
        return Blocks.field_201940_ji.func_176223_P();
    }

    public ChunkSection func_217332_a(int p_217332_1_) {
        if (this.field_201661_i[p_217332_1_] == Chunk.field_186036_a) {
            this.field_201661_i[p_217332_1_] = new ChunkSection(p_217332_1_ << 4);
        }
        return this.field_201661_i[p_217332_1_];
    }

    @Override
    public void func_177426_a(BlockPos pos, TileEntity tileEntityIn) {
        tileEntityIn.func_174878_a(pos);
        this.field_201659_g.put(pos, tileEntityIn);
    }

    @Override
    public Set<BlockPos> func_203066_o() {
        HashSet set = Sets.newHashSet(this.field_201660_h.keySet());
        set.addAll(this.field_201659_g.keySet());
        return set;
    }

    @Override
    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        return this.field_201659_g.get(pos);
    }

    public Map<BlockPos, TileEntity> func_201627_k() {
        return this.field_201659_g;
    }

    public void func_201626_b(CompoundNBT entityCompound) {
        this.field_201662_j.add(entityCompound);
    }

    @Override
    public void func_76612_a(Entity entityIn) {
        if (!entityIn.func_184218_aH()) {
            CompoundNBT compoundnbt = new CompoundNBT();
            entityIn.func_70039_c(compoundnbt);
            this.func_201626_b(compoundnbt);
        }
    }

    public List<CompoundNBT> func_201652_l() {
        return this.field_201662_j;
    }

    public void func_225548_a_(BiomeContainer p_225548_1_) {
        this.field_201656_d = p_225548_1_;
    }

    @Override
    @Nullable
    public BiomeContainer func_225549_i_() {
        return this.field_201656_d;
    }

    @Override
    public void func_177427_f(boolean modified) {
        this.field_201655_c = modified;
    }

    @Override
    public boolean func_201593_f() {
        return this.field_201655_c;
    }

    @Override
    public ChunkStatus func_201589_g() {
        return this.field_201658_f;
    }

    public void func_201574_a(ChunkStatus status) {
        this.field_201658_f = status;
        this.func_177427_f(true);
    }

    @Override
    public ChunkSection[] func_76587_i() {
        return this.field_201661_i;
    }

    @Nullable
    public WorldLightManager func_217307_e() {
        return this.field_217334_e;
    }

    @Override
    public Collection<Map.Entry<Heightmap.Type, Heightmap>> func_217311_f() {
        return Collections.unmodifiableSet(this.field_201657_e.entrySet());
    }

    @Override
    public void func_201607_a(Heightmap.Type type, long[] data) {
        this.func_217303_b(type).func_202268_a(data);
    }

    @Override
    public Heightmap func_217303_b(Heightmap.Type typeIn) {
        return this.field_201657_e.computeIfAbsent(typeIn, p_217333_1_ -> new Heightmap((IChunk)this, p_217333_1_));
    }

    @Override
    public int func_201576_a(Heightmap.Type heightmapType, int x, int z) {
        Heightmap heightmap = this.field_201657_e.get(heightmapType);
        if (heightmap == null) {
            Heightmap.func_222690_a((IChunk)this, EnumSet.of(heightmapType));
            heightmap = this.field_201657_e.get(heightmapType);
        }
        return heightmap.func_202273_a(x & 0xF, z & 0xF) - 1;
    }

    @Override
    public ChunkPos func_76632_l() {
        return this.field_201654_b;
    }

    @Override
    public void func_177432_b(long saveTime) {
    }

    @Nullable
    public StructureStart<?> func_230342_a_(Structure<?> p_230342_1_) {
        return this.field_201666_n.get(p_230342_1_);
    }

    public void func_230344_a_(Structure<?> p_230344_1_, StructureStart<?> p_230344_2_) {
        this.field_201666_n.put(p_230344_1_, p_230344_2_);
        this.field_201655_c = true;
    }

    @Override
    public Map<Structure<?>, StructureStart<?>> func_201609_c() {
        return Collections.unmodifiableMap(this.field_201666_n);
    }

    @Override
    public void func_201612_a(Map<Structure<?>, StructureStart<?>> structureStartsIn) {
        this.field_201666_n.clear();
        this.field_201666_n.putAll(structureStartsIn);
        this.field_201655_c = true;
    }

    public LongSet func_230346_b_(Structure<?> p_230346_1_) {
        return this.field_201667_o.computeIfAbsent(p_230346_1_, p_235966_0_ -> new LongOpenHashSet());
    }

    public void func_230343_a_(Structure<?> p_230343_1_, long p_230343_2_) {
        this.field_201667_o.computeIfAbsent(p_230343_1_, p_235965_0_ -> new LongOpenHashSet()).add(p_230343_2_);
        this.field_201655_c = true;
    }

    public Map<Structure<?>, LongSet> func_201604_d() {
        return Collections.unmodifiableMap(this.field_201667_o);
    }

    public void func_201606_b(Map<Structure<?>, LongSet> p_201606_1_) {
        this.field_201667_o.clear();
        this.field_201667_o.putAll(p_201606_1_);
        this.field_201655_c = true;
    }

    public static short func_201651_i(BlockPos p_201651_0_) {
        int i = p_201651_0_.func_177958_n();
        int j = p_201651_0_.func_177956_o();
        int k = p_201651_0_.func_177952_p();
        int l = i & 0xF;
        int i1 = j & 0xF;
        int j1 = k & 0xF;
        return (short)(l | i1 << 4 | j1 << 8);
    }

    public static BlockPos func_201635_a(short packedPos, int yOffset, ChunkPos chunkPosIn) {
        int i = (packedPos & 0xF) + (chunkPosIn.field_77276_a << 4);
        int j = (packedPos >>> 4 & 0xF) + (yOffset << 4);
        int k = (packedPos >>> 8 & 0xF) + (chunkPosIn.field_77275_b << 4);
        return new BlockPos(i, j, k);
    }

    @Override
    public void func_201594_d(BlockPos pos) {
        if (!World.func_189509_E(pos)) {
            IChunk.func_217308_a(this.field_201665_m, pos.func_177956_o() >> 4).add(ChunkPrimer.func_201651_i(pos));
        }
    }

    @Override
    public ShortList[] func_201614_D() {
        return this.field_201665_m;
    }

    @Override
    public void func_201636_b(short packedPosition, int index) {
        IChunk.func_217308_a(this.field_201665_m, index).add(packedPosition);
    }

    public ChunkPrimerTickList<Block> func_205218_i_() {
        return this.field_201664_l;
    }

    public ChunkPrimerTickList<Fluid> func_212247_j() {
        return this.field_205333_q;
    }

    @Override
    public UpgradeData func_196966_y() {
        return this.field_201668_p;
    }

    @Override
    public void func_177415_c(long newInhabitedTime) {
        this.field_209217_s = newInhabitedTime;
    }

    @Override
    public long func_177416_w() {
        return this.field_209217_s;
    }

    @Override
    public void func_201591_a(CompoundNBT nbt) {
        this.field_201660_h.put(new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z")), nbt);
    }

    public Map<BlockPos, CompoundNBT> func_201632_q() {
        return Collections.unmodifiableMap(this.field_201660_h);
    }

    @Override
    public CompoundNBT func_201579_g(BlockPos pos) {
        return this.field_201660_h.get(pos);
    }

    @Override
    @Nullable
    public CompoundNBT func_223134_j(BlockPos pos) {
        TileEntity tileentity = this.func_175625_s(pos);
        return tileentity != null ? tileentity.func_189515_b(new CompoundNBT()) : this.field_201660_h.get(pos);
    }

    @Override
    public void func_177425_e(BlockPos pos) {
        this.field_201659_g.remove(pos);
        this.field_201660_h.remove(pos);
    }

    @Nullable
    public BitSet func_205749_a(GenerationStage.Carving type) {
        return this.field_205769_s.get(type);
    }

    public BitSet func_230345_b_(GenerationStage.Carving p_230345_1_) {
        return this.field_205769_s.computeIfAbsent(p_230345_1_, p_235964_0_ -> new BitSet(65536));
    }

    public void func_205767_a(GenerationStage.Carving type, BitSet mask) {
        this.field_205769_s.put(type, mask);
    }

    public void func_217306_a(WorldLightManager p_217306_1_) {
        this.field_217334_e = p_217306_1_;
    }

    @Override
    public boolean func_217310_r() {
        return this.field_217335_u;
    }

    @Override
    public void func_217305_b(boolean lightCorrectIn) {
        this.field_217335_u = lightCorrectIn;
        this.func_177427_f(true);
    }
}

