/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.spawner;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.DefaultBiomeMagnifier;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.MobDensityTracker;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class WorldEntitySpawner {
    private static final Logger field_209383_a = LogManager.getLogger();
    private static final int field_234960_b_ = (int)Math.pow(17.0, 2.0);
    private static final EntityClassification[] field_234961_c_ = (EntityClassification[])Stream.of(EntityClassification.values()).filter(p_234965_0_ -> p_234965_0_ != EntityClassification.MISC).toArray(EntityClassification[]::new);

    public static EntityDensityManager func_234964_a_(int p_234964_0_, Iterable<Entity> p_234964_1_, IInitialDensityAdder p_234964_2_) {
        MobDensityTracker mobdensitytracker = new MobDensityTracker();
        Object2IntOpenHashMap object2intopenhashmap = new Object2IntOpenHashMap();
        Iterator<Entity> iterator = p_234964_1_.iterator();
        while (iterator.hasNext()) {
            MobEntity mobentity;
            Entity entity = iterator.next();
            if (entity instanceof MobEntity && ((mobentity = (MobEntity)entity).func_104002_bU() || mobentity.func_213392_I())) continue;
            Entity entity_f = entity;
            EntityClassification entityclassification = entity.getClassification(true);
            if (entityclassification == EntityClassification.MISC) continue;
            BlockPos blockpos = entity.func_233580_cy_();
            long i = ChunkPos.func_77272_a((int)(blockpos.func_177958_n() >> 4), (int)(blockpos.func_177952_p() >> 4));
            p_234964_2_.query(i, p_234971_5_ -> {
                MobSpawnInfo.SpawnCosts mobspawninfo$spawncosts = WorldEntitySpawner.func_234980_b_(blockpos, p_234971_5_).func_242433_b().func_242558_a(entity_f.func_200600_R());
                if (mobspawninfo$spawncosts != null) {
                    mobdensitytracker.func_234998_a_(entity_f.func_233580_cy_(), mobspawninfo$spawncosts.func_242585_b());
                }
                object2intopenhashmap.addTo((Object)entityclassification, 1);
            });
        }
        return new EntityDensityManager(p_234964_0_, object2intopenhashmap, mobdensitytracker);
    }

    private static Biome func_234980_b_(BlockPos p_234980_0_, IChunk p_234980_1_) {
        return DefaultBiomeMagnifier.INSTANCE.func_225532_a_(0L, p_234980_0_.func_177958_n(), p_234980_0_.func_177956_o(), p_234980_0_.func_177952_p(), (BiomeManager.IBiomeReader)p_234980_1_.func_225549_i_());
    }

    public static void func_234979_a_(ServerWorld p_234979_0_, Chunk p_234979_1_, EntityDensityManager p_234979_2_, boolean p_234979_3_, boolean p_234979_4_, boolean p_234979_5_) {
        p_234979_0_.func_217381_Z().func_76320_a("spawner");
        for (EntityClassification entityclassification : field_234961_c_) {
            if (!p_234979_3_ && entityclassification.func_75599_d() || !p_234979_4_ && !entityclassification.func_75599_d() || !p_234979_5_ && entityclassification.func_82705_e() || !p_234979_2_.func_234991_a_(entityclassification)) continue;
            WorldEntitySpawner.func_234967_a_(entityclassification, p_234979_0_, p_234979_1_, (p_234969_1_, p_234969_2_, p_234969_3_) -> p_234979_2_.func_234989_a_(p_234969_1_, p_234969_2_, p_234969_3_), (p_234970_1_, p_234970_2_) -> p_234979_2_.func_234990_a_(p_234970_1_, p_234970_2_));
        }
        p_234979_0_.func_217381_Z().func_76319_b();
    }

    public static void func_234967_a_(EntityClassification p_234967_0_, ServerWorld p_234967_1_, Chunk p_234967_2_, IDensityCheck p_234967_3_, IOnSpawnDensityAdder p_234967_4_) {
        BlockPos blockpos = WorldEntitySpawner.func_222262_a(p_234967_1_, p_234967_2_);
        if (blockpos.func_177956_o() >= 1) {
            WorldEntitySpawner.func_234966_a_(p_234967_0_, p_234967_1_, p_234967_2_, blockpos, p_234967_3_, p_234967_4_);
        }
    }

    public static void func_234966_a_(EntityClassification p_234966_0_, ServerWorld p_234966_1_, IChunk p_234966_2_, BlockPos p_234966_3_, IDensityCheck p_234966_4_, IOnSpawnDensityAdder p_234966_5_) {
        StructureManager structuremanager = p_234966_1_.func_241112_a_();
        ChunkGenerator chunkgenerator = p_234966_1_.func_72863_F().func_201711_g();
        int i = p_234966_3_.func_177956_o();
        BlockState blockstate = p_234966_2_.func_180495_p(p_234966_3_);
        if (!blockstate.func_215686_e(p_234966_2_, p_234966_3_)) {
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            int j = 0;
            block0: for (int k = 0; k < 3; ++k) {
                int l = p_234966_3_.func_177958_n();
                int i1 = p_234966_3_.func_177952_p();
                int j1 = 6;
                MobSpawnInfo.Spawners mobspawninfo$spawners = null;
                ILivingEntityData ilivingentitydata = null;
                int k1 = MathHelper.func_76123_f((float)(p_234966_1_.field_73012_v.nextFloat() * 4.0f));
                int l1 = 0;
                for (int i2 = 0; i2 < k1; ++i2) {
                    double d2;
                    blockpos$mutable.func_181079_c(l += p_234966_1_.field_73012_v.nextInt(6) - p_234966_1_.field_73012_v.nextInt(6), i, i1 += p_234966_1_.field_73012_v.nextInt(6) - p_234966_1_.field_73012_v.nextInt(6));
                    double d0 = (double)l + 0.5;
                    double d1 = (double)i1 + 0.5;
                    PlayerEntity playerentity = p_234966_1_.func_217366_a(d0, i, d1, -1.0, false);
                    if (playerentity == null || !WorldEntitySpawner.func_234978_a_(p_234966_1_, p_234966_2_, blockpos$mutable, d2 = playerentity.func_70092_e(d0, i, d1))) continue;
                    if (mobspawninfo$spawners == null) {
                        mobspawninfo$spawners = WorldEntitySpawner.func_234977_a_(p_234966_1_, structuremanager, chunkgenerator, p_234966_0_, p_234966_1_.field_73012_v, (BlockPos)blockpos$mutable);
                        if (mobspawninfo$spawners == null) continue block0;
                        k1 = mobspawninfo$spawners.field_242589_d + p_234966_1_.field_73012_v.nextInt(1 + mobspawninfo$spawners.field_242590_e - mobspawninfo$spawners.field_242589_d);
                    }
                    if (!WorldEntitySpawner.func_234975_a_(p_234966_1_, p_234966_0_, structuremanager, chunkgenerator, mobspawninfo$spawners, blockpos$mutable, d2) || !p_234966_4_.test(mobspawninfo$spawners.field_242588_c, (BlockPos)blockpos$mutable, p_234966_2_)) continue;
                    MobEntity mobentity = WorldEntitySpawner.func_234973_a_(p_234966_1_, mobspawninfo$spawners.field_242588_c);
                    if (mobentity == null) {
                        return;
                    }
                    mobentity.func_70012_b(d0, i, d1, p_234966_1_.field_73012_v.nextFloat() * 360.0f, 0.0f);
                    int canSpawn = ForgeHooks.canEntitySpawn((MobEntity)mobentity, (IWorld)p_234966_1_, (double)d0, (double)i, (double)d1, null, (SpawnReason)SpawnReason.NATURAL);
                    if (canSpawn == -1 || canSpawn != 1 && !WorldEntitySpawner.func_234974_a_(p_234966_1_, mobentity, d2)) continue;
                    if (!ForgeEventFactory.doSpecialSpawn((MobEntity)mobentity, (World)p_234966_1_, (float)((float)d0), (float)i, (float)((float)d1), null, (SpawnReason)SpawnReason.NATURAL)) {
                        ilivingentitydata = mobentity.func_213386_a((IServerWorld)p_234966_1_, p_234966_1_.func_175649_E(mobentity.func_233580_cy_()), SpawnReason.NATURAL, ilivingentitydata, null);
                    }
                    ++l1;
                    p_234966_1_.func_242417_l(mobentity);
                    p_234966_5_.run(mobentity, p_234966_2_);
                    if (++j >= ForgeEventFactory.getMaxSpawnPackSize((MobEntity)mobentity)) {
                        return;
                    }
                    if (mobentity.func_204209_c(l1)) continue block0;
                }
            }
        }
    }

    private static boolean func_234978_a_(ServerWorld p_234978_0_, IChunk p_234978_1_, BlockPos.Mutable p_234978_2_, double p_234978_3_) {
        if (p_234978_3_ <= 576.0) {
            return false;
        }
        if (p_234978_0_.func_241135_u_().func_218137_a((IPosition)new Vector3d((double)p_234978_2_.func_177958_n() + 0.5, p_234978_2_.func_177956_o(), (double)p_234978_2_.func_177952_p() + 0.5), 24.0)) {
            return false;
        }
        ChunkPos chunkpos = new ChunkPos((BlockPos)p_234978_2_);
        return Objects.equals(chunkpos, p_234978_1_.func_76632_l()) || p_234978_0_.func_72863_F().func_222865_a(chunkpos);
    }

    private static boolean func_234975_a_(ServerWorld p_234975_0_, EntityClassification p_234975_1_, StructureManager p_234975_2_, ChunkGenerator p_234975_3_, MobSpawnInfo.Spawners p_234975_4_, BlockPos.Mutable p_234975_5_, double p_234975_6_) {
        EntityType entitytype = p_234975_4_.field_242588_c;
        if (entitytype.func_220339_d() == EntityClassification.MISC) {
            return false;
        }
        if (!entitytype.func_225437_d() && p_234975_6_ > (double)(entitytype.func_220339_d().func_233671_f_() * entitytype.func_220339_d().func_233671_f_())) {
            return false;
        }
        if (entitytype.func_200720_b() && WorldEntitySpawner.func_234976_a_(p_234975_0_, p_234975_2_, p_234975_3_, p_234975_1_, p_234975_4_, (BlockPos)p_234975_5_)) {
            EntitySpawnPlacementRegistry.PlacementType entityspawnplacementregistry$placementtype = EntitySpawnPlacementRegistry.func_209344_a(entitytype);
            if (!WorldEntitySpawner.func_209382_a(entityspawnplacementregistry$placementtype, (IWorldReader)((Object)p_234975_0_), (BlockPos)p_234975_5_, entitytype)) {
                return false;
            }
            if (!EntitySpawnPlacementRegistry.func_223515_a(entitytype, (IServerWorld)p_234975_0_, SpawnReason.NATURAL, (BlockPos)p_234975_5_, p_234975_0_.field_73012_v)) {
                return false;
            }
            return p_234975_0_.func_226664_a_(entitytype.func_220328_a((double)p_234975_5_.func_177958_n() + 0.5, p_234975_5_.func_177956_o(), (double)p_234975_5_.func_177952_p() + 0.5));
        }
        return false;
    }

    @Nullable
    private static MobEntity func_234973_a_(ServerWorld p_234973_0_, EntityType<?> p_234973_1_) {
        try {
            Object entity = p_234973_1_.func_200721_a(p_234973_0_);
            if (!(entity instanceof MobEntity)) {
                throw new IllegalStateException("Trying to spawn a non-mob: " + Registry.field_212629_r.func_177774_c(p_234973_1_));
            }
            return (MobEntity)((Object)entity);
        }
        catch (Exception exception) {
            field_209383_a.warn("Failed to create mob", (Throwable)exception);
            return null;
        }
    }

    private static boolean func_234974_a_(ServerWorld p_234974_0_, MobEntity p_234974_1_, double p_234974_2_) {
        if (p_234974_2_ > (double)(p_234974_1_.func_200600_R().func_220339_d().func_233671_f_() * p_234974_1_.func_200600_R().func_220339_d().func_233671_f_()) && p_234974_1_.func_213397_c(p_234974_2_)) {
            return false;
        }
        return p_234974_1_.func_213380_a(p_234974_0_, SpawnReason.NATURAL) && p_234974_1_.func_205019_a((IWorldReader)((Object)p_234974_0_));
    }

    @Nullable
    private static MobSpawnInfo.Spawners func_234977_a_(ServerWorld p_234977_0_, StructureManager p_234977_1_, ChunkGenerator p_234977_2_, EntityClassification p_234977_3_, Random p_234977_4_, BlockPos p_234977_5_) {
        Biome biome = p_234977_0_.func_226691_t_(p_234977_5_);
        if (p_234977_3_ == EntityClassification.WATER_AMBIENT && biome.func_201856_r() == Biome.Category.RIVER && p_234977_4_.nextFloat() < 0.98f) {
            return null;
        }
        List list = WorldEntitySpawner.func_241463_a_(p_234977_0_, p_234977_1_, p_234977_2_, p_234977_3_, p_234977_5_, biome);
        return (list = ForgeEventFactory.getPotentialSpawns((IWorld)p_234977_0_, (EntityClassification)p_234977_3_, (BlockPos)p_234977_5_, list)).isEmpty() ? null : (MobSpawnInfo.Spawners)WeightedRandom.func_76271_a((Random)p_234977_4_, (List)list);
    }

    private static boolean func_234976_a_(ServerWorld p_234976_0_, StructureManager p_234976_1_, ChunkGenerator p_234976_2_, EntityClassification p_234976_3_, MobSpawnInfo.Spawners p_234976_4_, BlockPos p_234976_5_) {
        return WorldEntitySpawner.func_241463_a_(p_234976_0_, p_234976_1_, p_234976_2_, p_234976_3_, p_234976_5_, null).contains(p_234976_4_);
    }

    private static List<MobSpawnInfo.Spawners> func_241463_a_(ServerWorld p_241463_0_, StructureManager p_241463_1_, ChunkGenerator p_241463_2_, EntityClassification p_241463_3_, BlockPos p_241463_4_, @Nullable Biome p_241463_5_) {
        return p_241463_3_ == EntityClassification.MONSTER && p_241463_0_.func_180495_p(p_241463_4_.func_177977_b()).func_177230_c() == Blocks.field_196653_dH && p_241463_1_.func_235010_a_(p_241463_4_, false, Structure.field_236378_n_).func_75069_d() ? Structure.field_236378_n_.func_202279_e() : p_241463_2_.func_230353_a_(p_241463_5_ != null ? p_241463_5_ : p_241463_0_.func_226691_t_(p_241463_4_), p_241463_1_, p_241463_3_, p_241463_4_);
    }

    private static BlockPos func_222262_a(World worldIn, Chunk p_222262_1_) {
        ChunkPos chunkpos = p_222262_1_.func_76632_l();
        int i = chunkpos.func_180334_c() + worldIn.field_73012_v.nextInt(16);
        int j = chunkpos.func_180333_d() + worldIn.field_73012_v.nextInt(16);
        int k = p_222262_1_.func_201576_a(Heightmap.Type.WORLD_SURFACE, i, j) + 1;
        int l = worldIn.field_73012_v.nextInt(k + 1);
        return new BlockPos(i, l, j);
    }

    public static boolean func_234968_a_(IBlockReader p_234968_0_, BlockPos p_234968_1_, BlockState p_234968_2_, FluidState p_234968_3_, EntityType<?> p_234968_4_) {
        if (p_234968_2_.func_235785_r_(p_234968_0_, p_234968_1_)) {
            return false;
        }
        if (p_234968_2_.func_185897_m()) {
            return false;
        }
        if (!p_234968_3_.func_206888_e()) {
            return false;
        }
        if (p_234968_2_.func_235714_a_(BlockTags.field_232884_az_)) {
            return false;
        }
        return !p_234968_4_.func_233597_a_(p_234968_2_);
    }

    public static boolean func_209382_a(EntitySpawnPlacementRegistry.PlacementType placeType, IWorldReader worldIn, BlockPos pos, @Nullable EntityType<?> entityTypeIn) {
        if (placeType == EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS) {
            return true;
        }
        if (entityTypeIn != null && worldIn.func_175723_af().func_177746_a(pos)) {
            return placeType.canSpawnAt(worldIn, pos, entityTypeIn);
        }
        return false;
    }

    public static boolean canSpawnAtBody(EntitySpawnPlacementRegistry.PlacementType placeType, IWorldReader worldIn, BlockPos pos, @Nullable EntityType<?> entityTypeIn) {
        BlockState blockstate = worldIn.func_180495_p(pos);
        FluidState fluidstate = worldIn.func_204610_c(pos);
        BlockPos blockpos = pos.func_177984_a();
        BlockPos blockpos1 = pos.func_177977_b();
        switch (placeType) {
            case IN_WATER: {
                return fluidstate.func_206884_a(FluidTags.field_206959_a) && worldIn.func_204610_c(blockpos1).func_206884_a(FluidTags.field_206959_a) && !worldIn.func_180495_p(blockpos).func_215686_e((IBlockReader)((Object)worldIn), blockpos);
            }
            case IN_LAVA: {
                return fluidstate.func_206884_a(FluidTags.field_206960_b);
            }
        }
        BlockState blockstate1 = worldIn.func_180495_p(blockpos1);
        if (!blockstate1.canCreatureSpawn(worldIn, blockpos1, placeType, entityTypeIn)) {
            return false;
        }
        return WorldEntitySpawner.func_234968_a_((IBlockReader)((Object)worldIn), pos, blockstate, fluidstate, entityTypeIn) && WorldEntitySpawner.func_234968_a_((IBlockReader)((Object)worldIn), blockpos, worldIn.func_180495_p(blockpos), worldIn.func_204610_c(blockpos), entityTypeIn);
    }

    public static void func_77191_a(IServerWorld worldIn, Biome biomeIn, int centerX, int centerZ, Random diameterX) {
        MobSpawnInfo mobspawninfo = biomeIn.func_242433_b();
        List list = mobspawninfo.func_242559_a(EntityClassification.CREATURE);
        if (!list.isEmpty()) {
            int i = centerX << 4;
            int j = centerZ << 4;
            while (diameterX.nextFloat() < mobspawninfo.func_242557_a()) {
                MobSpawnInfo.Spawners mobspawninfo$spawners = (MobSpawnInfo.Spawners)WeightedRandom.func_76271_a((Random)diameterX, (List)list);
                int k = mobspawninfo$spawners.field_242589_d + diameterX.nextInt(1 + mobspawninfo$spawners.field_242590_e - mobspawninfo$spawners.field_242589_d);
                ILivingEntityData ilivingentitydata = null;
                int l = i + diameterX.nextInt(16);
                int i1 = j + diameterX.nextInt(16);
                int j1 = l;
                int k1 = i1;
                for (int l1 = 0; l1 < k; ++l1) {
                    boolean flag = false;
                    for (int i2 = 0; !flag && i2 < 4; ++i2) {
                        BlockPos blockpos = WorldEntitySpawner.func_208498_a((IWorldReader)worldIn, mobspawninfo$spawners.field_242588_c, l, i1);
                        if (mobspawninfo$spawners.field_242588_c.func_200720_b() && WorldEntitySpawner.func_209382_a(EntitySpawnPlacementRegistry.func_209344_a(mobspawninfo$spawners.field_242588_c), (IWorldReader)worldIn, blockpos, mobspawninfo$spawners.field_242588_c)) {
                            Object entity;
                            float f = mobspawninfo$spawners.field_242588_c.func_220333_h();
                            double d0 = MathHelper.func_151237_a((double)l, (double)((double)i + (double)f), (double)((double)i + 16.0 - (double)f));
                            double d1 = MathHelper.func_151237_a((double)i1, (double)((double)j + (double)f), (double)((double)j + 16.0 - (double)f));
                            if (!worldIn.func_226664_a_(mobspawninfo$spawners.field_242588_c.func_220328_a(d0, blockpos.func_177956_o(), d1)) || !EntitySpawnPlacementRegistry.func_223515_a(mobspawninfo$spawners.field_242588_c, worldIn, SpawnReason.CHUNK_GENERATION, new BlockPos(d0, (double)blockpos.func_177956_o(), d1), worldIn.func_201674_k())) continue;
                            try {
                                entity = mobspawninfo$spawners.field_242588_c.func_200721_a(worldIn.func_201672_e());
                            }
                            catch (Exception exception) {
                                field_209383_a.warn("Failed to create mob", (Throwable)exception);
                                continue;
                            }
                            ((Entity)((Object)entity)).func_70012_b(d0, blockpos.func_177956_o(), d1, diameterX.nextFloat() * 360.0f, 0.0f);
                            if (entity instanceof MobEntity) {
                                MobEntity mobentity = (MobEntity)((Object)entity);
                                if (ForgeHooks.canEntitySpawn((MobEntity)mobentity, (IWorld)worldIn, (double)d0, (double)blockpos.func_177956_o(), (double)d1, null, (SpawnReason)SpawnReason.CHUNK_GENERATION) == -1) continue;
                                if (mobentity.func_213380_a((IWorld)worldIn, SpawnReason.CHUNK_GENERATION) && mobentity.func_205019_a((IWorldReader)worldIn)) {
                                    ilivingentitydata = mobentity.func_213386_a(worldIn, worldIn.func_175649_E(mobentity.func_233580_cy_()), SpawnReason.CHUNK_GENERATION, ilivingentitydata, null);
                                    worldIn.func_242417_l((Entity)mobentity);
                                    flag = true;
                                }
                            }
                        }
                        l += diameterX.nextInt(5) - diameterX.nextInt(5);
                        i1 += diameterX.nextInt(5) - diameterX.nextInt(5);
                        while (l < i || l >= i + 16 || i1 < j || i1 >= j + 16) {
                            l = j1 + diameterX.nextInt(5) - diameterX.nextInt(5);
                            i1 = k1 + diameterX.nextInt(5) - diameterX.nextInt(5);
                        }
                    }
                }
            }
        }
    }

    private static BlockPos func_208498_a(IWorldReader worldIn, EntityType<?> p_208498_1_, int x, int z) {
        BlockPos blockpos;
        int i = worldIn.func_201676_a(EntitySpawnPlacementRegistry.func_209342_b(p_208498_1_), x, z);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(x, i, z);
        if (worldIn.func_230315_m_().func_236037_d_()) {
            do {
                blockpos$mutable.func_189536_c(Direction.DOWN);
            } while (!worldIn.func_180495_p((BlockPos)blockpos$mutable).func_196958_f());
            do {
                blockpos$mutable.func_189536_c(Direction.DOWN);
            } while (worldIn.func_180495_p((BlockPos)blockpos$mutable).func_196958_f() && blockpos$mutable.func_177956_o() > 0);
        }
        if (EntitySpawnPlacementRegistry.func_209344_a(p_208498_1_) == EntitySpawnPlacementRegistry.PlacementType.ON_GROUND && worldIn.func_180495_p(blockpos = blockpos$mutable.func_177977_b()).func_196957_g((IBlockReader)((Object)worldIn), blockpos, PathType.LAND)) {
            return blockpos;
        }
        return blockpos$mutable.func_185334_h();
    }

    @FunctionalInterface
    public static interface IOnSpawnDensityAdder {
        public void run(MobEntity var1, IChunk var2);
    }

    @FunctionalInterface
    public static interface IInitialDensityAdder {
        public void query(long var1, Consumer<Chunk> var3);
    }

    @FunctionalInterface
    public static interface IDensityCheck {
        public boolean test(EntityType<?> var1, BlockPos var2, IChunk var3);
    }

    public static class EntityDensityManager {
        private final int field_234981_a_;
        private final Object2IntOpenHashMap<EntityClassification> field_234982_b_;
        private final MobDensityTracker field_234983_c_;
        private final Object2IntMap<EntityClassification> field_234984_d_;
        @Nullable
        private BlockPos field_234985_e_;
        @Nullable
        private EntityType<?> field_234986_f_;
        private double field_234987_g_;

        private EntityDensityManager(int p_i231621_1_, Object2IntOpenHashMap<EntityClassification> p_i231621_2_, MobDensityTracker p_i231621_3_) {
            this.field_234981_a_ = p_i231621_1_;
            this.field_234982_b_ = p_i231621_2_;
            this.field_234983_c_ = p_i231621_3_;
            this.field_234984_d_ = Object2IntMaps.unmodifiable(p_i231621_2_);
        }

        private boolean func_234989_a_(EntityType<?> p_234989_1_, BlockPos p_234989_2_, IChunk p_234989_3_) {
            double d0;
            this.field_234985_e_ = p_234989_2_;
            this.field_234986_f_ = p_234989_1_;
            MobSpawnInfo.SpawnCosts mobspawninfo$spawncosts = WorldEntitySpawner.func_234980_b_(p_234989_2_, p_234989_3_).func_242433_b().func_242558_a(p_234989_1_);
            if (mobspawninfo$spawncosts == null) {
                this.field_234987_g_ = 0.0;
                return true;
            }
            this.field_234987_g_ = d0 = mobspawninfo$spawncosts.func_242585_b();
            double d1 = this.field_234983_c_.func_234999_b_(p_234989_2_, d0);
            return d1 <= mobspawninfo$spawncosts.func_242582_a();
        }

        private void func_234990_a_(MobEntity p_234990_1_, IChunk p_234990_2_) {
            MobSpawnInfo.SpawnCosts mobspawninfo$spawncosts;
            EntityType<?> entitytype = p_234990_1_.func_200600_R();
            BlockPos blockpos = p_234990_1_.func_233580_cy_();
            double d0 = blockpos.equals((Object)this.field_234985_e_) && entitytype == this.field_234986_f_ ? this.field_234987_g_ : ((mobspawninfo$spawncosts = WorldEntitySpawner.func_234980_b_(blockpos, p_234990_2_).func_242433_b().func_242558_a(entitytype)) != null ? mobspawninfo$spawncosts.func_242585_b() : 0.0);
            this.field_234983_c_.func_234998_a_(blockpos, d0);
            this.field_234982_b_.addTo((Object)entitytype.func_220339_d(), 1);
        }

        @OnlyIn(value=Dist.CLIENT)
        public int func_234988_a_() {
            return this.field_234981_a_;
        }

        public Object2IntMap<EntityClassification> func_234995_b_() {
            return this.field_234984_d_;
        }

        private boolean func_234991_a_(EntityClassification p_234991_1_) {
            int i = p_234991_1_.func_75601_b() * this.field_234981_a_ / field_234960_b_;
            return this.field_234982_b_.getInt((Object)p_234991_1_) < i;
        }
    }
}

