/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class SlabBlock
extends Block
implements IWaterLoggable {
    public static final EnumProperty<SlabType> field_196505_a = BlockStateProperties.field_208145_at;
    public static final BooleanProperty field_204512_b = BlockStateProperties.field_208198_y;
    protected static final VoxelShape field_196506_b = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    protected static final VoxelShape field_196507_c = Block.func_208617_a(0.0, 8.0, 0.0, 16.0, 16.0, 16.0);

    public SlabBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a(field_196505_a, SlabType.BOTTOM)).func_206870_a(field_204512_b, false));
    }

    @Override
    public boolean func_220074_n(BlockState blockState) {
        return blockState.func_177229_b(field_196505_a) != SlabType.DOUBLE;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_196505_a, field_204512_b);
    }

    @Override
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        SlabType slabType = blockState.func_177229_b(field_196505_a);
        switch (slabType) {
            case DOUBLE: {
                return VoxelShapes.func_197868_b();
            }
            case TOP: {
                return field_196507_c;
            }
        }
        return field_196506_b;
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        BlockPos blockPos = blockItemUseContext.func_195995_a();
        BlockState \u26032 = blockItemUseContext.func_195991_k().func_180495_p(blockPos);
        if (\u26032.func_203425_a(this)) {
            return (BlockState)((BlockState)\u26032.func_206870_a(field_196505_a, SlabType.DOUBLE)).func_206870_a(field_204512_b, false);
        }
        FluidState \u26033 = blockItemUseContext.func_195991_k().func_204610_c(blockPos);
        BlockState \u26034 = (BlockState)((BlockState)this.func_176223_P().func_206870_a(field_196505_a, SlabType.BOTTOM)).func_206870_a(field_204512_b, \u26033.func_206886_c() == Fluids.field_204546_a);
        Direction \u26035 = blockItemUseContext.func_196000_l();
        if (\u26035 == Direction.DOWN || \u26035 != Direction.UP && blockItemUseContext.func_221532_j().field_72448_b - (double)blockPos.func_177956_o() > 0.5) {
            return (BlockState)\u26034.func_206870_a(field_196505_a, SlabType.TOP);
        }
        return \u26034;
    }

    @Override
    public boolean func_196253_a(BlockState blockState, BlockItemUseContext blockItemUseContext) {
        ItemStack itemStack = blockItemUseContext.func_195996_i();
        SlabType \u26032 = blockState.func_177229_b(field_196505_a);
        if (\u26032 == SlabType.DOUBLE || itemStack.func_77973_b() != this.func_199767_j()) {
            return false;
        }
        if (blockItemUseContext.func_196012_c()) {
            boolean bl = blockItemUseContext.func_221532_j().field_72448_b - (double)blockItemUseContext.func_195995_a().func_177956_o() > 0.5;
            Direction \u26033 = blockItemUseContext.func_196000_l();
            if (\u26032 == SlabType.BOTTOM) {
                return \u26033 == Direction.UP || bl && \u26033.func_176740_k().func_176722_c();
            }
            return \u26033 == Direction.DOWN || !bl && \u26033.func_176740_k().func_176722_c();
        }
        return true;
    }

    @Override
    public FluidState func_204507_t(BlockState blockState) {
        if (blockState.func_177229_b(field_204512_b).booleanValue()) {
            return Fluids.field_204546_a.func_207204_a(false);
        }
        return super.func_204507_t(blockState);
    }

    @Override
    public boolean func_204509_a(IWorld iWorld, BlockPos blockPos, BlockState blockState, FluidState fluidState) {
        if (blockState.func_177229_b(field_196505_a) != SlabType.DOUBLE) {
            return IWaterLoggable.super.func_204509_a(iWorld, blockPos, blockState, fluidState);
        }
        return false;
    }

    @Override
    public boolean func_204510_a(IBlockReader iBlockReader, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        if (blockState.func_177229_b(field_196505_a) != SlabType.DOUBLE) {
            return IWaterLoggable.super.func_204510_a(iBlockReader, blockPos, blockState, fluid);
        }
        return false;
    }

    @Override
    public BlockState func_196271_a(BlockState blockState, Direction direction, BlockState blockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        if (blockState.func_177229_b(field_204512_b).booleanValue()) {
            iWorld.func_205219_F_().func_205360_a(blockPos, Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a(iWorld));
        }
        return super.func_196271_a(blockState, direction, blockState2, iWorld, blockPos, blockPos2);
    }

    @Override
    public boolean func_196266_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, PathType pathType) {
        switch (pathType) {
            case LAND: {
                return false;
            }
            case WATER: {
                return iBlockReader.func_204610_c(blockPos).func_206884_a(FluidTags.field_206959_a);
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }
}

