/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.CatLieOnBedGoal;
import net.minecraft.entity.ai.goal.CatSitOnBlockGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.ai.goal.OcelotAttackGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;

public class CatEntity
extends TameableEntity {
    private static final Ingredient field_213426_bE = Ingredient.func_199804_a(Items.field_196086_aW, Items.field_196087_aX);
    private static final DataParameter<Integer> field_213427_bF = EntityDataManager.func_187226_a(CatEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> field_213428_bG = EntityDataManager.func_187226_a(CatEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> field_213429_bH = EntityDataManager.func_187226_a(CatEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Integer> field_213430_bI = EntityDataManager.func_187226_a(CatEntity.class, DataSerializers.field_187192_b);
    public static final Map<Integer, ResourceLocation> field_213425_bD = Util.func_200696_a(Maps.newHashMap(), hashMap -> {
        hashMap.put(0, new ResourceLocation("textures/entity/cat/tabby.png"));
        hashMap.put(1, new ResourceLocation("textures/entity/cat/black.png"));
        hashMap.put(2, new ResourceLocation("textures/entity/cat/red.png"));
        hashMap.put(3, new ResourceLocation("textures/entity/cat/siamese.png"));
        hashMap.put(4, new ResourceLocation("textures/entity/cat/british_shorthair.png"));
        hashMap.put(5, new ResourceLocation("textures/entity/cat/calico.png"));
        hashMap.put(6, new ResourceLocation("textures/entity/cat/persian.png"));
        hashMap.put(7, new ResourceLocation("textures/entity/cat/ragdoll.png"));
        hashMap.put(8, new ResourceLocation("textures/entity/cat/white.png"));
        hashMap.put(9, new ResourceLocation("textures/entity/cat/jellie.png"));
        hashMap.put(10, new ResourceLocation("textures/entity/cat/all_black.png"));
    });
    private AvoidPlayerGoal<PlayerEntity> field_213431_bJ;
    private net.minecraft.entity.ai.goal.TemptGoal field_213432_bK;
    private float field_213433_bL;
    private float field_213434_bM;
    private float field_213435_bN;
    private float field_213436_bO;
    private float field_213437_bP;
    private float field_213438_bQ;

    public CatEntity(EntityType<? extends CatEntity> entityType, World world) {
        super((EntityType<? extends TameableEntity>)entityType, world);
    }

    public ResourceLocation func_213423_ee() {
        return field_213425_bD.getOrDefault(this.func_213413_ef(), field_213425_bD.get(0));
    }

    @Override
    protected void func_184651_r() {
        this.field_213432_bK = new TemptGoal(this, 0.6, field_213426_bE, true);
        this.field_70714_bg.func_75776_a(1, new SwimGoal(this));
        this.field_70714_bg.func_75776_a(1, new SitGoal(this));
        this.field_70714_bg.func_75776_a(2, new MorningGiftGoal(this));
        this.field_70714_bg.func_75776_a(3, this.field_213432_bK);
        this.field_70714_bg.func_75776_a(5, new CatLieOnBedGoal(this, 1.1, 8));
        this.field_70714_bg.func_75776_a(6, new FollowOwnerGoal(this, 1.0, 10.0f, 5.0f, false));
        this.field_70714_bg.func_75776_a(7, new CatSitOnBlockGoal(this, 0.8));
        this.field_70714_bg.func_75776_a(8, new LeapAtTargetGoal(this, 0.3f));
        this.field_70714_bg.func_75776_a(9, new OcelotAttackGoal(this));
        this.field_70714_bg.func_75776_a(10, new BreedGoal(this, 0.8));
        this.field_70714_bg.func_75776_a(11, new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8, 1.0000001E-5f));
        this.field_70714_bg.func_75776_a(12, new LookAtGoal(this, PlayerEntity.class, 10.0f));
        this.field_70715_bh.func_75776_a(1, new NonTamedTargetGoal<RabbitEntity>(this, RabbitEntity.class, false, null));
        this.field_70715_bh.func_75776_a(1, new NonTamedTargetGoal<TurtleEntity>(this, TurtleEntity.class, false, TurtleEntity.field_203029_bx));
    }

    public int func_213413_ef() {
        return this.field_70180_af.func_187225_a(field_213427_bF);
    }

    public void func_213422_r(int n) {
        if (n < 0 || n >= 11) {
            n = this.field_70146_Z.nextInt(10);
        }
        this.field_70180_af.func_187227_b(field_213427_bF, n);
    }

    public void func_213419_u(boolean bl) {
        this.field_70180_af.func_187227_b(field_213428_bG, bl);
    }

    public boolean func_213416_eg() {
        return this.field_70180_af.func_187225_a(field_213428_bG);
    }

    public void func_213415_v(boolean bl) {
        this.field_70180_af.func_187227_b(field_213429_bH, bl);
    }

    public boolean func_213409_eh() {
        return this.field_70180_af.func_187225_a(field_213429_bH);
    }

    public DyeColor func_213414_ei() {
        return DyeColor.func_196056_a(this.field_70180_af.func_187225_a(field_213430_bI));
    }

    public void func_213417_a(DyeColor dyeColor) {
        this.field_70180_af.func_187227_b(field_213430_bI, dyeColor.func_196059_a());
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_213427_bF, 1);
        this.field_70180_af.func_187214_a(field_213428_bG, false);
        this.field_70180_af.func_187214_a(field_213429_bH, false);
        this.field_70180_af.func_187214_a(field_213430_bI, DyeColor.RED.func_196059_a());
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74768_a("CatType", this.func_213413_ef());
        compoundNBT.func_74774_a("CollarColor", (byte)this.func_213414_ei().func_196059_a());
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        this.func_213422_r(compoundNBT.func_74762_e("CatType"));
        if (compoundNBT.func_150297_b("CollarColor", 99)) {
            this.func_213417_a(DyeColor.func_196056_a(compoundNBT.func_74762_e("CollarColor")));
        }
    }

    @Override
    public void func_70619_bc() {
        if (this.func_70605_aq().func_75640_a()) {
            double d = this.func_70605_aq().func_75638_b();
            if (d == 0.6) {
                this.func_213301_b(Pose.CROUCHING);
                this.func_70031_b(false);
            } else if (d == 1.33) {
                this.func_213301_b(Pose.STANDING);
                this.func_70031_b(true);
            } else {
                this.func_213301_b(Pose.STANDING);
                this.func_70031_b(false);
            }
        } else {
            this.func_213301_b(Pose.STANDING);
            this.func_70031_b(false);
        }
    }

    @Override
    @Nullable
    protected SoundEvent func_184639_G() {
        if (this.func_70909_n()) {
            if (this.func_70880_s()) {
                return SoundEvents.field_187645_R;
            }
            if (this.field_70146_Z.nextInt(4) == 0) {
                return SoundEvents.field_187648_S;
            }
            return SoundEvents.field_187636_O;
        }
        return SoundEvents.field_219606_aE;
    }

    @Override
    public int func_70627_aG() {
        return 120;
    }

    public void func_213420_ej() {
        this.func_184185_a(SoundEvents.field_189106_R, this.func_70599_aP(), this.func_70647_i());
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187642_Q;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187639_P;
    }

    public static AttributeModifierMap.MutableAttribute func_234184_eY_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233821_d_, 0.3f).func_233815_a_(Attributes.field_233823_f_, 3.0);
    }

    @Override
    public boolean func_225503_b_(float f, float f2) {
        return false;
    }

    @Override
    protected void func_175505_a(PlayerEntity playerEntity, ItemStack itemStack) {
        if (this.func_70877_b(itemStack)) {
            this.func_184185_a(SoundEvents.field_219607_aG, 1.0f, 1.0f);
        }
        super.func_175505_a(playerEntity, itemStack);
    }

    private float func_226510_eF_() {
        return (float)this.func_233637_b_(Attributes.field_233823_f_);
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        return entity.func_70097_a(DamageSource.func_76358_a(this), this.func_226510_eF_());
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_213432_bK != null && this.field_213432_bK.func_75277_f() && !this.func_70909_n() && this.field_70173_aa % 100 == 0) {
            this.func_184185_a(SoundEvents.field_219608_aI, 1.0f, 1.0f);
        }
        this.func_213412_ek();
    }

    private void func_213412_ek() {
        if ((this.func_213416_eg() || this.func_213409_eh()) && this.field_70173_aa % 5 == 0) {
            this.func_184185_a(SoundEvents.field_187645_R, 0.6f + 0.4f * (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()), 1.0f);
        }
        this.func_213418_el();
        this.func_213411_em();
    }

    private void func_213418_el() {
        this.field_213434_bM = this.field_213433_bL;
        this.field_213436_bO = this.field_213435_bN;
        if (this.func_213416_eg()) {
            this.field_213433_bL = Math.min(1.0f, this.field_213433_bL + 0.15f);
            this.field_213435_bN = Math.min(1.0f, this.field_213435_bN + 0.08f);
        } else {
            this.field_213433_bL = Math.max(0.0f, this.field_213433_bL - 0.22f);
            this.field_213435_bN = Math.max(0.0f, this.field_213435_bN - 0.13f);
        }
    }

    private void func_213411_em() {
        this.field_213438_bQ = this.field_213437_bP;
        this.field_213437_bP = this.func_213409_eh() ? Math.min(1.0f, this.field_213437_bP + 0.1f) : Math.max(0.0f, this.field_213437_bP - 0.13f);
    }

    @Override
    public CatEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        CatEntity catEntity = EntityType.field_220360_g.func_200721_a(serverWorld);
        if (ageableEntity instanceof CatEntity) {
            if (this.field_70146_Z.nextBoolean()) {
                catEntity.func_213422_r(this.func_213413_ef());
            } else {
                catEntity.func_213422_r(((CatEntity)ageableEntity).func_213413_ef());
            }
            if (this.func_70909_n()) {
                catEntity.func_184754_b(this.func_184753_b());
                catEntity.func_70903_f(true);
                if (this.field_70146_Z.nextBoolean()) {
                    catEntity.func_213417_a(this.func_213414_ei());
                } else {
                    catEntity.func_213417_a(((CatEntity)ageableEntity).func_213414_ei());
                }
            }
        }
        return catEntity;
    }

    @Override
    public boolean func_70878_b(AnimalEntity animalEntity) {
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(animalEntity instanceof CatEntity)) {
            return false;
        }
        CatEntity catEntity = (CatEntity)animalEntity;
        return catEntity.func_70909_n() && super.func_70878_b(animalEntity);
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld iServerWorld, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData iLivingEntityData2, @Nullable CompoundNBT compoundNBT) {
        ILivingEntityData iLivingEntityData2 = super.func_213386_a(iServerWorld, difficultyInstance, spawnReason, iLivingEntityData2, compoundNBT);
        if (iServerWorld.func_242413_ae() > 0.9f) {
            this.func_213422_r(this.field_70146_Z.nextInt(11));
        } else {
            this.func_213422_r(this.field_70146_Z.nextInt(10));
        }
        ServerWorld \u26032 = iServerWorld.func_201672_e();
        if (\u26032 instanceof ServerWorld && \u26032.func_241112_a_().func_235010_a_(this.func_233580_cy_(), true, Structure.field_236374_j_).func_75069_d()) {
            this.func_213422_r(10);
            this.func_110163_bv();
        }
        return iLivingEntityData2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ActionResultType func_230254_b_(PlayerEntity playerEntity, Hand hand) {
        ItemStack itemStack = playerEntity.func_184586_b(hand);
        Item \u26032 = itemStack.func_77973_b();
        if (this.field_70170_p.field_72995_K) {
            if (this.func_70909_n() && this.func_152114_e(playerEntity)) {
                return ActionResultType.SUCCESS;
            }
            if (this.func_70877_b(itemStack) && (this.func_110143_aJ() < this.func_110138_aP() || !this.func_70909_n())) {
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
        if (this.func_70909_n()) {
            if (this.func_152114_e(playerEntity)) {
                if (\u26032 instanceof DyeItem) {
                    Enum enum_ = ((DyeItem)\u26032).func_195962_g();
                    if (enum_ != this.func_213414_ei()) {
                        this.func_213417_a((DyeColor)enum_);
                        if (!playerEntity.field_71075_bZ.field_75098_d) {
                            itemStack.func_190918_g(1);
                        }
                        this.func_110163_bv();
                        return ActionResultType.CONSUME;
                    }
                } else {
                    if (\u26032.func_219971_r() && this.func_70877_b(itemStack) && this.func_110143_aJ() < this.func_110138_aP()) {
                        this.func_175505_a(playerEntity, itemStack);
                        this.func_70691_i(\u26032.func_219967_s().func_221466_a());
                        return ActionResultType.CONSUME;
                    }
                    ActionResultType \u26033 = super.func_230254_b_(playerEntity, hand);
                    if (!\u26033.func_226246_a_() || this.func_70631_g_()) {
                        this.func_233687_w_(!this.func_233685_eM_());
                    }
                    return \u26033;
                }
            }
        } else if (this.func_70877_b(itemStack)) {
            this.func_175505_a(playerEntity, itemStack);
            if (this.field_70146_Z.nextInt(3) == 0) {
                this.func_193101_c(playerEntity);
                this.func_233687_w_(true);
                this.field_70170_p.func_72960_a(this, (byte)7);
            } else {
                this.field_70170_p.func_72960_a(this, (byte)6);
            }
            this.func_110163_bv();
            return ActionResultType.CONSUME;
        }
        if (((ActionResultType)(enum_ = super.func_230254_b_(playerEntity, hand))).func_226246_a_()) {
            this.func_110163_bv();
        }
        return enum_;
    }

    @Override
    public boolean func_70877_b(ItemStack itemStack) {
        return field_213426_bE.test(itemStack);
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize entitySize) {
        return entitySize.field_220316_b * 0.5f;
    }

    @Override
    public boolean func_213397_c(double d) {
        return !this.func_70909_n() && this.field_70173_aa > 2400;
    }

    @Override
    protected void func_175544_ck() {
        if (this.field_213431_bJ == null) {
            this.field_213431_bJ = new AvoidPlayerGoal<PlayerEntity>(this, PlayerEntity.class, 16.0f, 0.8, 1.33);
        }
        this.field_70714_bg.func_85156_a(this.field_213431_bJ);
        if (!this.func_70909_n()) {
            this.field_70714_bg.func_75776_a(4, this.field_213431_bJ);
        }
    }

    @Override
    public /* synthetic */ AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return this.func_241840_a(serverWorld, ageableEntity);
    }

    static class MorningGiftGoal
    extends Goal {
        private final CatEntity field_220806_a;
        private PlayerEntity field_220807_b;
        private BlockPos field_220808_c;
        private int field_220809_d;

        public MorningGiftGoal(CatEntity catEntity) {
            this.field_220806_a = catEntity;
        }

        @Override
        public boolean func_75250_a() {
            if (!this.field_220806_a.func_70909_n()) {
                return false;
            }
            if (this.field_220806_a.func_233685_eM_()) {
                return false;
            }
            LivingEntity livingEntity = this.field_220806_a.func_70902_q();
            if (livingEntity instanceof PlayerEntity) {
                this.field_220807_b = (PlayerEntity)livingEntity;
                if (!livingEntity.func_70608_bn()) {
                    return false;
                }
                if (this.field_220806_a.func_70068_e(this.field_220807_b) > 100.0) {
                    return false;
                }
                BlockPos blockPos = this.field_220807_b.func_233580_cy_();
                BlockState \u26032 = this.field_220806_a.field_70170_p.func_180495_p(blockPos);
                if (\u26032.func_177230_c().func_203417_a(BlockTags.field_219747_F)) {
                    this.field_220808_c = \u26032.func_235903_d_(BedBlock.field_185512_D).map(direction -> blockPos.func_177972_a(direction.func_176734_d())).orElseGet(() -> new BlockPos(blockPos));
                    return !this.func_220805_g();
                }
            }
            return false;
        }

        private boolean func_220805_g() {
            List<CatEntity> list = this.field_220806_a.field_70170_p.func_217357_a(CatEntity.class, new AxisAlignedBB(this.field_220808_c).func_186662_g(2.0));
            for (CatEntity catEntity : list) {
                if (catEntity == this.field_220806_a || !catEntity.func_213416_eg() && !catEntity.func_213409_eh()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean func_75253_b() {
            return this.field_220806_a.func_70909_n() && !this.field_220806_a.func_233685_eM_() && this.field_220807_b != null && this.field_220807_b.func_70608_bn() && this.field_220808_c != null && !this.func_220805_g();
        }

        @Override
        public void func_75249_e() {
            if (this.field_220808_c != null) {
                this.field_220806_a.func_233686_v_(false);
                this.field_220806_a.func_70661_as().func_75492_a(this.field_220808_c.func_177958_n(), this.field_220808_c.func_177956_o(), this.field_220808_c.func_177952_p(), 1.1f);
            }
        }

        @Override
        public void func_75251_c() {
            this.field_220806_a.func_213419_u(false);
            float f = this.field_220806_a.field_70170_p.func_242415_f(1.0f);
            if (this.field_220807_b.func_71060_bI() >= 100 && (double)f > 0.77 && (double)f < 0.8 && (double)this.field_220806_a.field_70170_p.func_201674_k().nextFloat() < 0.7) {
                this.func_220804_h();
            }
            this.field_220809_d = 0;
            this.field_220806_a.func_213415_v(false);
            this.field_220806_a.func_70661_as().func_75499_g();
        }

        private void func_220804_h() {
            Random random = this.field_220806_a.func_70681_au();
            BlockPos.Mutable \u26032 = new BlockPos.Mutable();
            \u26032.func_189533_g(this.field_220806_a.func_233580_cy_());
            this.field_220806_a.func_213373_a(\u26032.func_177958_n() + random.nextInt(11) - 5, \u26032.func_177956_o() + random.nextInt(5) - 2, \u26032.func_177952_p() + random.nextInt(11) - 5, false);
            \u26032.func_189533_g(this.field_220806_a.func_233580_cy_());
            LootTable \u26033 = this.field_220806_a.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(LootTables.field_215797_af);
            LootContext.Builder \u26034 = new LootContext.Builder((ServerWorld)this.field_220806_a.field_70170_p).func_216015_a(LootParameters.field_237457_g_, this.field_220806_a.func_213303_ch()).func_216015_a(LootParameters.field_216281_a, this.field_220806_a).func_216023_a(random);
            List<ItemStack> \u26035 = \u26033.func_216113_a(\u26034.func_216022_a(LootParameterSets.field_216264_e));
            for (ItemStack itemStack : \u26035) {
                this.field_220806_a.field_70170_p.func_217376_c(new ItemEntity(this.field_220806_a.field_70170_p, (double)\u26032.func_177958_n() - (double)MathHelper.func_76126_a(this.field_220806_a.field_70761_aq * ((float)Math.PI / 180)), \u26032.func_177956_o(), (double)\u26032.func_177952_p() + (double)MathHelper.func_76134_b(this.field_220806_a.field_70761_aq * ((float)Math.PI / 180)), itemStack));
            }
        }

        @Override
        public void func_75246_d() {
            if (this.field_220807_b != null && this.field_220808_c != null) {
                this.field_220806_a.func_233686_v_(false);
                this.field_220806_a.func_70661_as().func_75492_a(this.field_220808_c.func_177958_n(), this.field_220808_c.func_177956_o(), this.field_220808_c.func_177952_p(), 1.1f);
                if (this.field_220806_a.func_70068_e(this.field_220807_b) < 2.5) {
                    ++this.field_220809_d;
                    if (this.field_220809_d > 16) {
                        this.field_220806_a.func_213419_u(true);
                        this.field_220806_a.func_213415_v(false);
                    } else {
                        this.field_220806_a.func_70625_a(this.field_220807_b, 45.0f, 45.0f);
                        this.field_220806_a.func_213415_v(true);
                    }
                } else {
                    this.field_220806_a.func_213419_u(false);
                }
            }
        }
    }

    static class TemptGoal
    extends net.minecraft.entity.ai.goal.TemptGoal {
        @Nullable
        private PlayerEntity field_220763_c;
        private final CatEntity field_220764_d;

        public TemptGoal(CatEntity catEntity, double d, Ingredient ingredient, boolean bl) {
            super((CreatureEntity)catEntity, d, ingredient, bl);
            this.field_220764_d = catEntity;
        }

        @Override
        public void func_75246_d() {
            super.func_75246_d();
            if (this.field_220763_c == null && this.field_75284_a.func_70681_au().nextInt(600) == 0) {
                this.field_220763_c = this.field_75289_h;
            } else if (this.field_75284_a.func_70681_au().nextInt(500) == 0) {
                this.field_220763_c = null;
            }
        }

        @Override
        protected boolean func_220761_g() {
            if (this.field_220763_c != null && this.field_220763_c.equals(this.field_75289_h)) {
                return false;
            }
            return super.func_220761_g();
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a() && !this.field_220764_d.func_70909_n();
        }
    }

    static class AvoidPlayerGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final CatEntity field_220873_i;

        public AvoidPlayerGoal(CatEntity catEntity, Class<T> clazz, float f, double d, double d2) {
            super(catEntity, clazz, f, d, d2, EntityPredicates.field_188444_d::test);
            this.field_220873_i = catEntity;
        }

        @Override
        public boolean func_75250_a() {
            return !this.field_220873_i.func_70909_n() && super.func_75250_a();
        }

        @Override
        public boolean func_75253_b() {
            return !this.field_220873_i.func_70909_n() && super.func_75253_b();
        }
    }
}

