/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEventData;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.INPC;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.merchant.IReputationTracking;
import net.minecraft.entity.merchant.IReputationType;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateBlockBreakPacket;
import net.minecraft.network.play.server.SBlockActionPacket;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.network.play.server.SEntityStatusPacket;
import net.minecraft.network.play.server.SExplosionPacket;
import net.minecraft.network.play.server.SPlaySoundEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.network.play.server.SSpawnMovingSoundEffectPacket;
import net.minecraft.network.play.server.SSpawnParticlePacket;
import net.minecraft.network.play.server.SWorldSpawnChangedPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.profiler.IProfiler;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Unit;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.DimensionType;
import net.minecraft.world.Explosion;
import net.minecraft.world.ExplosionContext;
import net.minecraft.world.ForcedChunksSaveData;
import net.minecraft.world.GameRules;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.ITickList;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.end.DragonFightManager;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.raid.Raid;
import net.minecraft.world.raid.RaidManager;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerTickList;
import net.minecraft.world.server.TicketType;
import net.minecraft.world.spawner.ISpecialSpawner;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapIdTracker;
import net.minecraft.world.storage.SaveFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerWorld
extends World
implements ISeedReader {
    public static final BlockPos field_241108_a_ = new BlockPos(100, 50, 0);
    private static final Logger field_147491_a = LogManager.getLogger();
    private final Int2ObjectMap<Entity> field_217498_x = new Int2ObjectLinkedOpenHashMap();
    private final Map<UUID, Entity> field_175741_N = Maps.newHashMap();
    private final Queue<Entity> field_217499_z = Queues.newArrayDeque();
    private final List<ServerPlayerEntity> field_217491_A = Lists.newArrayList();
    private final ServerChunkProvider field_241102_C_;
    boolean field_217492_a;
    private final MinecraftServer field_73061_a;
    private final IServerWorldInfo field_241103_E_;
    public boolean field_73058_d;
    private boolean field_73068_P;
    private int field_80004_Q;
    private final Teleporter field_85177_Q;
    private final ServerTickList<Block> field_94579_S = new ServerTickList<Block>(this, block -> block == null || block.func_176223_P().func_196958_f(), Registry.field_212618_g::func_177774_c, this::func_205338_b);
    private final ServerTickList<Fluid> field_205342_P = new ServerTickList<Fluid>(this, fluid -> fluid == null || fluid == Fluids.field_204541_a, Registry.field_212619_h::func_177774_c, this::func_205339_a);
    private final Set<PathNavigator> field_217495_I = Sets.newHashSet();
    protected final RaidManager field_217494_c;
    private final ObjectLinkedOpenHashSet<BlockEventData> field_147490_S = new ObjectLinkedOpenHashSet();
    private boolean field_211159_Q;
    private final List<ISpecialSpawner> field_241104_N_;
    @Nullable
    private final DragonFightManager field_241105_O_;
    private final StructureManager field_241106_P_;
    private final boolean field_241107_Q_;

    public ServerWorld(MinecraftServer minecraftServer, Executor executor, SaveFormat.LevelSave levelSave, IServerWorldInfo iServerWorldInfo, RegistryKey<World> registryKey, DimensionType dimensionType, IChunkStatusListener iChunkStatusListener, ChunkGenerator chunkGenerator, boolean bl, long l, List<ISpecialSpawner> list, boolean bl2) {
        super(iServerWorldInfo, registryKey, dimensionType, minecraftServer::func_213185_aS, false, bl, l);
        this.field_241107_Q_ = bl2;
        this.field_73061_a = minecraftServer;
        this.field_241104_N_ = list;
        this.field_241103_E_ = iServerWorldInfo;
        this.field_241102_C_ = new ServerChunkProvider(this, levelSave, minecraftServer.func_195563_aC(), minecraftServer.func_240792_aT_(), executor, chunkGenerator, minecraftServer.func_184103_al().func_72395_o(), minecraftServer.func_230540_aS_(), iChunkStatusListener, () -> minecraftServer.func_241755_D_().func_217481_x());
        this.field_85177_Q = new Teleporter(this);
        this.func_72966_v();
        this.func_72947_a();
        this.func_175723_af().func_177725_a(minecraftServer.func_175580_aG());
        this.field_217494_c = this.func_217481_x().func_215752_a(() -> new RaidManager(this), RaidManager.func_234620_a_(this.func_230315_m_()));
        if (!minecraftServer.func_71264_H()) {
            iServerWorldInfo.func_230392_a_(minecraftServer.func_71265_f());
        }
        this.field_241106_P_ = new StructureManager(this, minecraftServer.func_240793_aU_().func_230418_z_());
        this.field_241105_O_ = this.func_230315_m_().func_236046_h_() ? new DragonFightManager(this, minecraftServer.func_240793_aU_().func_230418_z_().func_236221_b_(), minecraftServer.func_240793_aU_().func_230402_B_()) : null;
    }

    public void func_241113_a_(int n, int n2, boolean bl, boolean bl2) {
        this.field_241103_E_.func_230391_a_(n);
        this.field_241103_E_.func_76080_g(n2);
        this.field_241103_E_.func_76090_f(n2);
        this.field_241103_E_.func_76084_b(bl);
        this.field_241103_E_.func_76069_a(bl2);
    }

    @Override
    public Biome func_225604_a_(int n, int n2, int n3) {
        return this.func_72863_F().func_201711_g().func_202090_b().func_225526_b_(n, n2, n3);
    }

    public StructureManager func_241112_a_() {
        return this.field_241106_P_;
    }

    public void func_72835_b(BooleanSupplier booleanSupplier) {
        IProfiler iProfiler = this.func_217381_Z();
        this.field_211159_Q = true;
        iProfiler.func_76320_a("world border");
        this.func_175723_af().func_212673_r();
        iProfiler.func_219895_b("weather");
        boolean \u26032 = this.func_72896_J();
        if (this.func_230315_m_().func_218272_d()) {
            if (this.func_82736_K().func_223586_b(GameRules.field_223617_t)) {
                int n = this.field_241103_E_.func_230395_g_();
                \u2603 = this.field_241103_E_.func_76071_n();
                \u2603 = this.field_241103_E_.func_76083_p();
                boolean \u26033 = this.field_72986_A.func_76061_m();
                boolean \u26034 = this.field_72986_A.func_76059_o();
                if (n > 0) {
                    --n;
                    \u2603 = \u26033 ? 0 : 1;
                    \u2603 = \u26034 ? 0 : 1;
                    \u26033 = false;
                    \u26034 = false;
                } else {
                    if (\u2603 > 0) {
                        if (--\u2603 == 0) {
                            \u26033 = !\u26033;
                        }
                    } else {
                        \u2603 = \u26033 ? this.field_73012_v.nextInt(12000) + 3600 : this.field_73012_v.nextInt(168000) + 12000;
                    }
                    if (\u2603 > 0) {
                        if (--\u2603 == 0) {
                            \u26034 = !\u26034;
                        }
                    } else {
                        \u2603 = \u26034 ? this.field_73012_v.nextInt(12000) + 12000 : this.field_73012_v.nextInt(168000) + 12000;
                    }
                }
                this.field_241103_E_.func_76090_f(\u2603);
                this.field_241103_E_.func_76080_g(\u2603);
                this.field_241103_E_.func_230391_a_(n);
                this.field_241103_E_.func_76069_a(\u26033);
                this.field_241103_E_.func_76084_b(\u26034);
            }
            this.field_73018_p = this.field_73017_q;
            this.field_73017_q = this.field_72986_A.func_76061_m() ? (float)((double)this.field_73017_q + 0.01) : (float)((double)this.field_73017_q - 0.01);
            this.field_73017_q = MathHelper.func_76131_a(this.field_73017_q, 0.0f, 1.0f);
            this.field_73003_n = this.field_73004_o;
            this.field_73004_o = this.field_72986_A.func_76059_o() ? (float)((double)this.field_73004_o + 0.01) : (float)((double)this.field_73004_o - 0.01);
            this.field_73004_o = MathHelper.func_76131_a(this.field_73004_o, 0.0f, 1.0f);
        }
        if (this.field_73003_n != this.field_73004_o) {
            this.field_73061_a.func_184103_al().func_232642_a_(new SChangeGameStatePacket(SChangeGameStatePacket.field_241771_h_, this.field_73004_o), this.func_234923_W_());
        }
        if (this.field_73018_p != this.field_73017_q) {
            this.field_73061_a.func_184103_al().func_232642_a_(new SChangeGameStatePacket(SChangeGameStatePacket.field_241772_i_, this.field_73017_q), this.func_234923_W_());
        }
        if (\u26032 != this.func_72896_J()) {
            if (\u26032) {
                this.field_73061_a.func_184103_al().func_148540_a(new SChangeGameStatePacket(SChangeGameStatePacket.field_241766_c_, 0.0f));
            } else {
                this.field_73061_a.func_184103_al().func_148540_a(new SChangeGameStatePacket(SChangeGameStatePacket.field_241765_b_, 0.0f));
            }
            this.field_73061_a.func_184103_al().func_148540_a(new SChangeGameStatePacket(SChangeGameStatePacket.field_241771_h_, this.field_73004_o));
            this.field_73061_a.func_184103_al().func_148540_a(new SChangeGameStatePacket(SChangeGameStatePacket.field_241772_i_, this.field_73017_q));
        }
        if (this.field_73068_P && this.field_217491_A.stream().noneMatch(serverPlayerEntity -> !serverPlayerEntity.func_175149_v() && !serverPlayerEntity.func_71026_bH())) {
            this.field_73068_P = false;
            if (this.func_82736_K().func_223586_b(GameRules.field_223607_j)) {
                long \u26035 = this.field_72986_A.func_76073_f() + 24000L;
                this.func_241114_a_(\u26035 - \u26035 % 24000L);
            }
            this.func_229856_ab_();
            if (this.func_82736_K().func_223586_b(GameRules.field_223617_t)) {
                this.func_73051_P();
            }
        }
        this.func_72966_v();
        this.func_241126_b_();
        iProfiler.func_219895_b("chunkSource");
        this.func_72863_F().func_217207_a(booleanSupplier);
        iProfiler.func_219895_b("tickPending");
        if (!this.func_234925_Z_()) {
            this.field_94579_S.func_205365_a();
            this.field_205342_P.func_205365_a();
        }
        iProfiler.func_219895_b("raid");
        this.field_217494_c.func_215171_a();
        iProfiler.func_219895_b("blockEvents");
        this.func_147488_Z();
        this.field_211159_Q = false;
        iProfiler.func_219895_b("entities");
        boolean bl = \u2603 = !this.field_217491_A.isEmpty() || !this.func_217469_z().isEmpty();
        if (\u2603) {
            this.func_82742_i();
        }
        if (\u2603 || this.field_80004_Q++ < 300) {
            if (this.field_241105_O_ != null) {
                this.field_241105_O_.func_186105_b();
            }
            this.field_217492_a = true;
            ObjectIterator objectIterator = this.field_217498_x.int2ObjectEntrySet().iterator();
            while (objectIterator.hasNext()) {
                Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)objectIterator.next();
                Entity \u26036 = (Entity)entry.getValue();
                Entity \u26037 = \u26036.func_184187_bx();
                if (!this.field_73061_a.func_230537_U_() && (\u26036 instanceof AnimalEntity || \u26036 instanceof WaterMobEntity)) {
                    \u26036.func_70106_y();
                }
                if (!this.field_73061_a.func_230538_V_() && \u26036 instanceof INPC) {
                    \u26036.func_70106_y();
                }
                iProfiler.func_76320_a("checkDespawn");
                if (!\u26036.field_70128_L) {
                    \u26036.func_70623_bb();
                }
                iProfiler.func_76319_b();
                if (\u26037 != null) {
                    if (!\u26037.field_70128_L && \u26037.func_184196_w(\u26036)) continue;
                    \u26036.func_184210_p();
                }
                iProfiler.func_76320_a("tick");
                if (!\u26036.field_70128_L && !(\u26036 instanceof EnderDragonPartEntity)) {
                    this.func_217390_a(this::func_217479_a, \u26036);
                }
                iProfiler.func_76319_b();
                iProfiler.func_76320_a("remove");
                if (\u26036.field_70128_L) {
                    this.func_217454_n(\u26036);
                    objectIterator.remove();
                    this.func_217484_g(\u26036);
                }
                iProfiler.func_76319_b();
            }
            this.field_217492_a = false;
            while ((\u2603 = this.field_217499_z.poll()) != null) {
                this.func_217465_m(\u2603);
            }
            this.func_217391_K();
        }
        iProfiler.func_76319_b();
    }

    protected void func_241126_b_() {
        if (!this.field_241107_Q_) {
            return;
        }
        long l = this.field_72986_A.func_82573_f() + 1L;
        this.field_241103_E_.func_82572_b(l);
        this.field_241103_E_.func_215763_z().func_216331_a(this.field_73061_a, l);
        if (this.field_72986_A.func_82574_x().func_223586_b(GameRules.field_223607_j)) {
            this.func_241114_a_(this.field_72986_A.func_76073_f() + 1L);
        }
    }

    public void func_241114_a_(long l) {
        this.field_241103_E_.func_76068_b(l);
    }

    public void func_241123_a_(boolean bl, boolean bl2) {
        for (ISpecialSpawner iSpecialSpawner : this.field_241104_N_) {
            iSpecialSpawner.func_230253_a_(this, bl, bl2);
        }
    }

    private void func_229856_ab_() {
        this.field_217491_A.stream().filter(LivingEntity::func_70608_bn).collect(Collectors.toList()).forEach(serverPlayerEntity -> serverPlayerEntity.func_225652_a_(false, false));
    }

    public void func_217441_a(Chunk chunk, int n) {
        BlockPos blockPos;
        ChunkPos chunkPos = chunk.func_76632_l();
        boolean \u26032 = this.func_72896_J();
        int \u26033 = chunkPos.func_180334_c();
        int \u26034 = chunkPos.func_180333_d();
        IProfiler \u26035 = this.func_217381_Z();
        \u26035.func_76320_a("thunder");
        if (\u26032 && this.func_72911_I() && this.field_73012_v.nextInt(100000) == 0 && this.func_175727_C(blockPos = this.func_175736_a(this.func_217383_a(\u26033, 0, \u26034, 15)))) {
            DifficultyInstance difficultyInstance = this.func_175649_E(blockPos);
            boolean bl = \u2603 = this.func_82736_K().func_223586_b(GameRules.field_223601_d) && this.field_73012_v.nextDouble() < (double)difficultyInstance.func_180168_b() * 0.01;
            if (\u2603) {
                SkeletonHorseEntity skeletonHorseEntity = EntityType.field_200742_ah.func_200721_a(this);
                skeletonHorseEntity.func_190691_p(true);
                skeletonHorseEntity.func_70873_a(0);
                skeletonHorseEntity.func_70107_b(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
                this.func_217376_c(skeletonHorseEntity);
            }
            LightningBoltEntity lightningBoltEntity = EntityType.field_200728_aG.func_200721_a(this);
            lightningBoltEntity.func_233576_c_(Vector3d.func_237492_c_(blockPos));
            lightningBoltEntity.func_233623_a_(\u2603);
            this.func_217376_c(lightningBoltEntity);
        }
        \u26035.func_219895_b("iceandsnow");
        if (this.field_73012_v.nextInt(16) == 0) {
            BlockPos blockPos2 = this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, this.func_217383_a(\u26033, 0, \u26034, 15));
            BlockPos \u26036 = blockPos2.func_177977_b();
            Biome \u26037 = this.func_226691_t_(blockPos2);
            if (\u26037.func_201848_a(this, \u26036)) {
                this.func_175656_a(\u26036, Blocks.field_150432_aD.func_176223_P());
            }
            if (\u26032 && \u26037.func_201850_b(this, blockPos2)) {
                this.func_175656_a(blockPos2, Blocks.field_150433_aE.func_176223_P());
            }
            if (\u26032 && this.func_226691_t_(\u26036).func_201851_b() == Biome.RainType.RAIN) {
                this.func_180495_p(\u26036).func_177230_c().func_176224_k(this, \u26036);
            }
        }
        \u26035.func_219895_b("tickBlocks");
        if (n > 0) {
            for (ChunkSection chunkSection : chunk.func_76587_i()) {
                if (chunkSection == Chunk.field_186036_a || !chunkSection.func_206915_b()) continue;
                int n2 = chunkSection.func_222632_g();
                for (int i = 0; i < n; ++i) {
                    blockPos = this.func_217383_a(\u26033, n2, \u26034, 15);
                    \u26035.func_76320_a("randomTick");
                    BlockState \u26038 = chunkSection.func_177485_a(blockPos.func_177958_n() - \u26033, blockPos.func_177956_o() - n2, blockPos.func_177952_p() - \u26034);
                    if (\u26038.func_204519_t()) {
                        \u26038.func_227034_b_(this, blockPos, this.field_73012_v);
                    }
                    if ((\u2603 = \u26038.func_204520_s()).func_206890_h()) {
                        \u2603.func_206891_b(this, blockPos, this.field_73012_v);
                    }
                    \u26035.func_76319_b();
                }
            }
        }
        \u26035.func_76319_b();
    }

    protected BlockPos func_175736_a(BlockPos blockPos) {
        BlockPos blockPos2;
        blockPos2 = this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, blockPos);
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB(blockPos2, new BlockPos(blockPos2.func_177958_n(), this.func_217301_I(), blockPos2.func_177952_p())).func_186662_g(3.0);
        List<LivingEntity> \u26032 = this.func_175647_a(LivingEntity.class, axisAlignedBB, livingEntity -> livingEntity != null && livingEntity.func_70089_S() && this.func_226660_f_(livingEntity.func_233580_cy_()));
        if (!\u26032.isEmpty()) {
            return \u26032.get(this.field_73012_v.nextInt(\u26032.size())).func_233580_cy_();
        }
        if (blockPos2.func_177956_o() == -1) {
            blockPos2 = blockPos2.func_177981_b(2);
        }
        return blockPos2;
    }

    public boolean func_211158_j_() {
        return this.field_211159_Q;
    }

    public void func_72854_c() {
        this.field_73068_P = false;
        if (!this.field_217491_A.isEmpty()) {
            int n;
            int n2 = 0;
            n = 0;
            for (ServerPlayerEntity serverPlayerEntity : this.field_217491_A) {
                if (serverPlayerEntity.func_175149_v()) {
                    ++n2;
                    continue;
                }
                if (!serverPlayerEntity.func_70608_bn()) continue;
                ++n;
            }
            this.field_73068_P = n > 0 && n >= this.field_217491_A.size() - n2;
        }
    }

    @Override
    public ServerScoreboard func_96441_U() {
        return this.field_73061_a.func_200251_aP();
    }

    private void func_73051_P() {
        this.field_241103_E_.func_76080_g(0);
        this.field_241103_E_.func_76084_b(false);
        this.field_241103_E_.func_76090_f(0);
        this.field_241103_E_.func_76069_a(false);
    }

    public void func_82742_i() {
        this.field_80004_Q = 0;
    }

    private void func_205339_a(NextTickListEntry<Fluid> nextTickListEntry) {
        FluidState fluidState = this.func_204610_c(nextTickListEntry.field_180282_a);
        if (fluidState.func_206886_c() == nextTickListEntry.func_151351_a()) {
            fluidState.func_206880_a(this, nextTickListEntry.field_180282_a);
        }
    }

    private void func_205338_b(NextTickListEntry<Block> nextTickListEntry) {
        BlockState blockState = this.func_180495_p(nextTickListEntry.field_180282_a);
        if (blockState.func_203425_a(nextTickListEntry.func_151351_a())) {
            blockState.func_227033_a_(this, nextTickListEntry.field_180282_a, this.field_73012_v);
        }
    }

    public void func_217479_a(Entity entity2) {
        Entity entity2;
        if (!(entity2 instanceof PlayerEntity) && !this.func_72863_F().func_217204_a(entity2)) {
            this.func_217464_b(entity2);
            return;
        }
        entity2.func_226286_f_(entity2.func_226277_ct_(), entity2.func_226278_cu_(), entity2.func_226281_cx_());
        entity2.field_70126_B = entity2.field_70177_z;
        entity2.field_70127_C = entity2.field_70125_A;
        if (entity2.field_70175_ag) {
            ++entity2.field_70173_aa;
            IProfiler iProfiler = this.func_217381_Z();
            iProfiler.func_194340_a(() -> Registry.field_212629_r.func_177774_c(entity2.func_200600_R()).toString());
            iProfiler.func_230035_c_("tickNonPassenger");
            entity2.func_70071_h_();
            iProfiler.func_76319_b();
        }
        this.func_217464_b(entity2);
        if (entity2.field_70175_ag) {
            for (Entity entity3 : entity2.func_184188_bt()) {
                this.func_217459_a(entity2, entity3);
            }
        }
    }

    public void func_217459_a(Entity entity, Entity entity22) {
        Entity entity22;
        if (entity22.field_70128_L || entity22.func_184187_bx() != entity) {
            entity22.func_184210_p();
            return;
        }
        if (!(entity22 instanceof PlayerEntity) && !this.func_72863_F().func_217204_a(entity22)) {
            return;
        }
        entity22.func_226286_f_(entity22.func_226277_ct_(), entity22.func_226278_cu_(), entity22.func_226281_cx_());
        entity22.field_70126_B = entity22.field_70177_z;
        entity22.field_70127_C = entity22.field_70125_A;
        if (entity22.field_70175_ag) {
            ++entity22.field_70173_aa;
            IProfiler iProfiler = this.func_217381_Z();
            iProfiler.func_194340_a(() -> Registry.field_212629_r.func_177774_c(entity22.func_200600_R()).toString());
            iProfiler.func_230035_c_("tickPassenger");
            entity22.func_70098_U();
            iProfiler.func_76319_b();
        }
        this.func_217464_b(entity22);
        if (entity22.field_70175_ag) {
            for (Entity entity3 : entity22.func_184188_bt()) {
                this.func_217459_a(entity22, entity3);
            }
        }
    }

    public void func_217464_b(Entity entity) {
        if (!entity.func_233578_ci_()) {
            return;
        }
        this.func_217381_Z().func_76320_a("chunkCheck");
        int n = MathHelper.func_76128_c(entity.func_226277_ct_() / 16.0);
        \u2603 = MathHelper.func_76128_c(entity.func_226278_cu_() / 16.0);
        \u2603 = MathHelper.func_76128_c(entity.func_226281_cx_() / 16.0);
        if (!entity.field_70175_ag || entity.field_70176_ah != n || entity.field_70162_ai != \u2603 || entity.field_70164_aj != \u2603) {
            if (entity.field_70175_ag && this.func_217354_b(entity.field_70176_ah, entity.field_70164_aj)) {
                this.func_212866_a_(entity.field_70176_ah, entity.field_70164_aj).func_76608_a(entity, entity.field_70162_ai);
            }
            if (entity.func_233577_ch_() || this.func_217354_b(n, \u2603)) {
                this.func_212866_a_(n, \u2603).func_76612_a(entity);
            } else {
                if (entity.field_70175_ag) {
                    field_147491_a.warn("Entity {} left loaded chunk area", (Object)entity);
                }
                entity.field_70175_ag = false;
            }
        }
        this.func_217381_Z().func_76319_b();
    }

    @Override
    public boolean func_175660_a(PlayerEntity playerEntity, BlockPos blockPos) {
        return !this.field_73061_a.func_175579_a(this, blockPos, playerEntity) && this.func_175723_af().func_177746_a(blockPos);
    }

    public void func_217445_a(@Nullable IProgressUpdate iProgressUpdate, boolean bl, boolean bl2) {
        ServerChunkProvider serverChunkProvider = this.func_72863_F();
        if (bl2) {
            return;
        }
        if (iProgressUpdate != null) {
            iProgressUpdate.func_200210_a(new TranslationTextComponent("menu.savingLevel"));
        }
        this.func_73042_a();
        if (iProgressUpdate != null) {
            iProgressUpdate.func_200209_c(new TranslationTextComponent("menu.savingChunks"));
        }
        serverChunkProvider.func_217210_a(bl);
    }

    private void func_73042_a() {
        if (this.field_241105_O_ != null) {
            this.field_73061_a.func_240793_aU_().func_230413_a_(this.field_241105_O_.func_186088_a());
        }
        this.func_72863_F().func_217227_h().func_212775_b();
    }

    public List<Entity> func_217482_a(@Nullable EntityType<?> entityType, Predicate<? super Entity> predicate) {
        ArrayList arrayList = Lists.newArrayList();
        ServerChunkProvider \u26032 = this.func_72863_F();
        for (Entity entity : this.field_217498_x.values()) {
            if (entityType != null && entity.func_200600_R() != entityType || !\u26032.func_73149_a(MathHelper.func_76128_c(entity.func_226277_ct_()) >> 4, MathHelper.func_76128_c(entity.func_226281_cx_()) >> 4) || !predicate.test(entity)) continue;
            arrayList.add(entity);
        }
        return arrayList;
    }

    public List<EnderDragonEntity> func_217439_j() {
        ArrayList arrayList = Lists.newArrayList();
        for (Entity entity : this.field_217498_x.values()) {
            if (!(entity instanceof EnderDragonEntity) || !entity.func_70089_S()) continue;
            arrayList.add((EnderDragonEntity)entity);
        }
        return arrayList;
    }

    public List<ServerPlayerEntity> func_217490_a(Predicate<? super ServerPlayerEntity> predicate) {
        ArrayList arrayList = Lists.newArrayList();
        for (ServerPlayerEntity serverPlayerEntity : this.field_217491_A) {
            if (!predicate.test(serverPlayerEntity)) continue;
            arrayList.add(serverPlayerEntity);
        }
        return arrayList;
    }

    @Nullable
    public ServerPlayerEntity func_217472_l_() {
        List<ServerPlayerEntity> list = this.func_217490_a(LivingEntity::func_70089_S);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(this.field_73012_v.nextInt(list.size()));
    }

    @Override
    public boolean func_217376_c(Entity entity) {
        return this.func_72838_d(entity);
    }

    public boolean func_217470_d(Entity entity) {
        return this.func_72838_d(entity);
    }

    public void func_217460_e(Entity entity) {
        boolean bl = entity.field_98038_p;
        entity.field_98038_p = true;
        this.func_217470_d(entity);
        entity.field_98038_p = bl;
        this.func_217464_b(entity);
    }

    public void func_217446_a(ServerPlayerEntity serverPlayerEntity) {
        this.func_217448_f(serverPlayerEntity);
        this.func_217464_b(serverPlayerEntity);
    }

    public void func_217447_b(ServerPlayerEntity serverPlayerEntity) {
        this.func_217448_f(serverPlayerEntity);
        this.func_217464_b(serverPlayerEntity);
    }

    public void func_217435_c(ServerPlayerEntity serverPlayerEntity) {
        this.func_217448_f(serverPlayerEntity);
    }

    public void func_217433_d(ServerPlayerEntity serverPlayerEntity) {
        this.func_217448_f(serverPlayerEntity);
    }

    private void func_217448_f(ServerPlayerEntity serverPlayerEntity) {
        Entity entity = this.field_175741_N.get(serverPlayerEntity.func_110124_au());
        if (entity != null) {
            field_147491_a.warn("Force-added player with duplicate UUID {}", (Object)serverPlayerEntity.func_110124_au().toString());
            entity.func_213319_R();
            this.func_217434_e((ServerPlayerEntity)entity);
        }
        this.field_217491_A.add(serverPlayerEntity);
        this.func_72854_c();
        IChunk \u26032 = this.func_217353_a(MathHelper.func_76128_c(serverPlayerEntity.func_226277_ct_() / 16.0), MathHelper.func_76128_c(serverPlayerEntity.func_226281_cx_() / 16.0), ChunkStatus.field_222617_m, true);
        if (\u26032 instanceof Chunk) {
            \u26032.func_76612_a(serverPlayerEntity);
        }
        this.func_217465_m(serverPlayerEntity);
    }

    private boolean func_72838_d(Entity entity) {
        if (entity.field_70128_L) {
            field_147491_a.warn("Tried to add entity {} but it was marked as removed already", (Object)EntityType.func_200718_a(entity.func_200600_R()));
            return false;
        }
        if (this.func_217478_l(entity)) {
            return false;
        }
        IChunk iChunk = this.func_217353_a(MathHelper.func_76128_c(entity.func_226277_ct_() / 16.0), MathHelper.func_76128_c(entity.func_226281_cx_() / 16.0), ChunkStatus.field_222617_m, entity.field_98038_p);
        if (!(iChunk instanceof Chunk)) {
            return false;
        }
        iChunk.func_76612_a(entity);
        this.func_217465_m(entity);
        return true;
    }

    public boolean func_217440_f(Entity entity) {
        if (this.func_217478_l(entity)) {
            return false;
        }
        this.func_217465_m(entity);
        return true;
    }

    private boolean func_217478_l(Entity entity) {
        UUID uUID = entity.func_110124_au();
        Entity \u26032 = this.func_242105_c(uUID);
        if (\u26032 == null) {
            return false;
        }
        field_147491_a.warn("Trying to add entity with duplicated UUID {}. Existing {}#{}, new: {}#{}", (Object)uUID, (Object)EntityType.func_200718_a(\u26032.func_200600_R()), (Object)\u26032.func_145782_y(), (Object)EntityType.func_200718_a(entity.func_200600_R()), (Object)entity.func_145782_y());
        return true;
    }

    @Nullable
    private Entity func_242105_c(UUID uUID) {
        Entity entity = this.field_175741_N.get(uUID);
        if (entity != null) {
            return entity;
        }
        if (this.field_217492_a) {
            for (Entity entity2 : this.field_217499_z) {
                if (!entity2.func_110124_au().equals(uUID)) continue;
                return entity2;
            }
        }
        return null;
    }

    public boolean func_242106_g(Entity entity) {
        if (entity.func_226276_cg_().anyMatch(this::func_217478_l)) {
            return false;
        }
        this.func_242417_l(entity);
        return true;
    }

    public void func_217466_a(Chunk chunk) {
        this.field_147483_b.addAll(chunk.func_177434_r().values());
        for (ClassInheritanceMultiMap<Entity> classInheritanceMultiMap : chunk.func_177429_s()) {
            for (Entity entity : classInheritanceMultiMap) {
                if (entity instanceof ServerPlayerEntity) continue;
                if (this.field_217492_a) {
                    throw Util.func_229757_c_(new IllegalStateException("Removing entity while ticking!"));
                }
                this.field_217498_x.remove(entity.func_145782_y());
                this.func_217484_g(entity);
            }
        }
    }

    public void func_217484_g(Entity entity2) {
        Entity entity2;
        if (entity2 instanceof EnderDragonEntity) {
            for (EnderDragonPartEntity enderDragonPartEntity : ((EnderDragonEntity)entity2).func_213404_dT()) {
                enderDragonPartEntity.func_70106_y();
            }
        }
        this.field_175741_N.remove(entity2.func_110124_au());
        this.func_72863_F().func_217226_b(entity2);
        if (entity2 instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)entity2;
            this.field_217491_A.remove(serverPlayerEntity);
        }
        this.func_96441_U().func_181140_a(entity2);
        if (entity2 instanceof MobEntity) {
            this.field_217495_I.remove(((MobEntity)entity2).func_70661_as());
        }
    }

    private void func_217465_m(Entity entity2) {
        if (this.field_217492_a) {
            this.field_217499_z.add(entity2);
        } else {
            Entity entity2;
            this.field_217498_x.put(entity2.func_145782_y(), (Object)entity2);
            if (entity2 instanceof EnderDragonEntity) {
                for (EnderDragonPartEntity enderDragonPartEntity : ((EnderDragonEntity)entity2).func_213404_dT()) {
                    this.field_217498_x.put(enderDragonPartEntity.func_145782_y(), (Object)enderDragonPartEntity);
                }
            }
            this.field_175741_N.put(entity2.func_110124_au(), entity2);
            this.func_72863_F().func_217230_c(entity2);
            if (entity2 instanceof MobEntity) {
                this.field_217495_I.add(((MobEntity)entity2).func_70661_as());
            }
        }
    }

    public void func_217467_h(Entity entity) {
        if (this.field_217492_a) {
            throw Util.func_229757_c_(new IllegalStateException("Removing entity while ticking!"));
        }
        this.func_217454_n(entity);
        this.field_217498_x.remove(entity.func_145782_y());
        this.func_217484_g(entity);
    }

    private void func_217454_n(Entity entity) {
        IChunk iChunk = this.func_217353_a(entity.field_70176_ah, entity.field_70164_aj, ChunkStatus.field_222617_m, false);
        if (iChunk instanceof Chunk) {
            ((Chunk)iChunk).func_76622_b(entity);
        }
    }

    public void func_217434_e(ServerPlayerEntity serverPlayerEntity) {
        serverPlayerEntity.func_70106_y();
        this.func_217467_h(serverPlayerEntity);
        this.func_72854_c();
    }

    @Override
    public void func_175715_c(int n, BlockPos blockPos, int n2) {
        for (ServerPlayerEntity serverPlayerEntity : this.field_73061_a.func_184103_al().func_181057_v()) {
            if (serverPlayerEntity == null || serverPlayerEntity.field_70170_p != this || serverPlayerEntity.func_145782_y() == n || !((\u2603 = (double)blockPos.func_177958_n() - serverPlayerEntity.func_226277_ct_()) * \u2603 + (\u2603 = (double)blockPos.func_177956_o() - serverPlayerEntity.func_226278_cu_()) * \u2603 + (\u2603 = (double)blockPos.func_177952_p() - serverPlayerEntity.func_226281_cx_()) * \u2603 < 1024.0)) continue;
            serverPlayerEntity.field_71135_a.func_147359_a(new SAnimateBlockBreakPacket(n, blockPos, n2));
        }
    }

    @Override
    public void func_184148_a(@Nullable PlayerEntity playerEntity, double d, double d2, double d3, SoundEvent soundEvent, SoundCategory soundCategory, float f, float f2) {
        this.field_73061_a.func_184103_al().func_148543_a(playerEntity, d, d2, d3, f > 1.0f ? (double)(16.0f * f) : 16.0, this.func_234923_W_(), new SPlaySoundEffectPacket(soundEvent, soundCategory, d, d2, d3, f, f2));
    }

    @Override
    public void func_217384_a(@Nullable PlayerEntity playerEntity, Entity entity, SoundEvent soundEvent, SoundCategory soundCategory, float f, float f2) {
        this.field_73061_a.func_184103_al().func_148543_a(playerEntity, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), f > 1.0f ? (double)(16.0f * f) : 16.0, this.func_234923_W_(), new SSpawnMovingSoundEffectPacket(soundEvent, soundCategory, entity, f, f2));
    }

    @Override
    public void func_175669_a(int n, BlockPos blockPos, int n2) {
        this.field_73061_a.func_184103_al().func_148540_a(new SPlaySoundEventPacket(n, blockPos, n2, true));
    }

    @Override
    public void func_217378_a(@Nullable PlayerEntity playerEntity, int n, BlockPos blockPos, int n2) {
        this.field_73061_a.func_184103_al().func_148543_a(playerEntity, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), 64.0, this.func_234923_W_(), new SPlaySoundEventPacket(n, blockPos, n2, false));
    }

    @Override
    public void func_184138_a(BlockPos blockPos, BlockState blockState, BlockState blockState2, int n) {
        this.func_72863_F().func_217217_a(blockPos);
        VoxelShape voxelShape = blockState.func_196952_d(this, blockPos);
        \u2603 = blockState2.func_196952_d(this, blockPos);
        if (!VoxelShapes.func_197879_c(voxelShape, \u2603, IBooleanFunction.field_223236_g_)) {
            return;
        }
        for (PathNavigator pathNavigator : this.field_217495_I) {
            if (pathNavigator.func_188553_i()) continue;
            pathNavigator.func_220970_c(blockPos);
        }
    }

    @Override
    public void func_72960_a(Entity entity, byte by) {
        this.func_72863_F().func_217216_a(entity, new SEntityStatusPacket(entity, by));
    }

    @Override
    public ServerChunkProvider func_72863_F() {
        return this.field_241102_C_;
    }

    @Override
    public Explosion func_230546_a_(@Nullable Entity entity, @Nullable DamageSource damageSource, @Nullable ExplosionContext explosionContext, double d, double d2, double d3, float f, boolean bl, Explosion.Mode mode) {
        Explosion explosion = new Explosion(this, entity, damageSource, explosionContext, d, d2, d3, f, bl, mode);
        explosion.func_77278_a();
        explosion.func_77279_a(false);
        if (mode == Explosion.Mode.NONE) {
            explosion.func_180342_d();
        }
        for (ServerPlayerEntity serverPlayerEntity : this.field_217491_A) {
            if (!(serverPlayerEntity.func_70092_e(d, d2, d3) < 4096.0)) continue;
            serverPlayerEntity.field_71135_a.func_147359_a(new SExplosionPacket(d, d2, d3, f, explosion.func_180343_e(), explosion.func_77277_b().get(serverPlayerEntity)));
        }
        return explosion;
    }

    @Override
    public void func_175641_c(BlockPos blockPos, Block block, int n, int n2) {
        this.field_147490_S.add((Object)new BlockEventData(blockPos, block, n, n2));
    }

    private void func_147488_Z() {
        while (!this.field_147490_S.isEmpty()) {
            BlockEventData blockEventData = (BlockEventData)this.field_147490_S.removeFirst();
            if (!this.func_147485_a(blockEventData)) continue;
            this.field_73061_a.func_184103_al().func_148543_a(null, blockEventData.func_180328_a().func_177958_n(), blockEventData.func_180328_a().func_177956_o(), blockEventData.func_180328_a().func_177952_p(), 64.0, this.func_234923_W_(), new SBlockActionPacket(blockEventData.func_180328_a(), blockEventData.func_151337_f(), blockEventData.func_151339_d(), blockEventData.func_151338_e()));
        }
    }

    private boolean func_147485_a(BlockEventData blockEventData) {
        BlockState blockState = this.func_180495_p(blockEventData.func_180328_a());
        if (blockState.func_203425_a(blockEventData.func_151337_f())) {
            return blockState.func_235728_a_(this, blockEventData.func_180328_a(), blockEventData.func_151339_d(), blockEventData.func_151338_e());
        }
        return false;
    }

    public ServerTickList<Block> func_205220_G_() {
        return this.field_94579_S;
    }

    public ServerTickList<Fluid> func_205219_F_() {
        return this.field_205342_P;
    }

    @Override
    @Nonnull
    public MinecraftServer func_73046_m() {
        return this.field_73061_a;
    }

    public Teleporter func_85176_s() {
        return this.field_85177_Q;
    }

    public TemplateManager func_184163_y() {
        return this.field_73061_a.func_240792_aT_();
    }

    public <T extends IParticleData> int func_195598_a(T t, double d, double d2, double d3, int n, double d4, double d5, double d6, double d7) {
        SSpawnParticlePacket sSpawnParticlePacket = new SSpawnParticlePacket(t, false, d, d2, d3, (float)d4, (float)d5, (float)d6, (float)d7, n);
        int \u26032 = 0;
        for (int i = 0; i < this.field_217491_A.size(); ++i) {
            ServerPlayerEntity serverPlayerEntity = this.field_217491_A.get(i);
            if (!this.func_195601_a(serverPlayerEntity, false, d, d2, d3, sSpawnParticlePacket)) continue;
            ++\u26032;
        }
        return \u26032;
    }

    public <T extends IParticleData> boolean func_195600_a(ServerPlayerEntity serverPlayerEntity, T t, boolean bl, double d, double d2, double d3, int n, double d4, double d5, double d6, double d7) {
        SSpawnParticlePacket sSpawnParticlePacket = new SSpawnParticlePacket(t, bl, d, d2, d3, (float)d4, (float)d5, (float)d6, (float)d7, n);
        return this.func_195601_a(serverPlayerEntity, bl, d, d2, d3, sSpawnParticlePacket);
    }

    private boolean func_195601_a(ServerPlayerEntity serverPlayerEntity, boolean bl, double d, double d2, double d3, IPacket<?> iPacket) {
        if (serverPlayerEntity.func_71121_q() != this) {
            return false;
        }
        BlockPos blockPos = serverPlayerEntity.func_233580_cy_();
        if (blockPos.func_218137_a(new Vector3d(d, d2, d3), bl ? 512.0 : 32.0)) {
            serverPlayerEntity.field_71135_a.func_147359_a(iPacket);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Entity func_73045_a(int n) {
        return (Entity)this.field_217498_x.get(n);
    }

    @Nullable
    public Entity func_217461_a(UUID uUID) {
        return this.field_175741_N.get(uUID);
    }

    @Nullable
    public BlockPos func_241117_a_(Structure<?> structure, BlockPos blockPos, int n, boolean bl) {
        if (!this.field_73061_a.func_240793_aU_().func_230418_z_().func_236222_c_()) {
            return null;
        }
        return this.func_72863_F().func_201711_g().func_235956_a_(this, structure, blockPos, n, bl);
    }

    @Nullable
    public BlockPos func_241116_a_(Biome biome, BlockPos blockPos, int n, int n2) {
        return this.func_72863_F().func_201711_g().func_202090_b().func_230321_a_(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), n, n2, biome2 -> biome2 == biome, this.field_73012_v, true);
    }

    @Override
    public RecipeManager func_199532_z() {
        return this.field_73061_a.func_199529_aN();
    }

    @Override
    public ITagCollectionSupplier func_205772_D() {
        return this.field_73061_a.func_244266_aF();
    }

    @Override
    public boolean func_217402_u() {
        return this.field_73058_d;
    }

    @Override
    public DynamicRegistries func_241828_r() {
        return this.field_73061_a.func_244267_aX();
    }

    public DimensionSavedDataManager func_217481_x() {
        return this.func_72863_F().func_217227_h();
    }

    @Override
    @Nullable
    public MapData func_217406_a(String string) {
        return this.func_73046_m().func_241755_D_().func_217481_x().func_215753_b(() -> new MapData(string), string);
    }

    @Override
    public void func_217399_a(MapData mapData) {
        this.func_73046_m().func_241755_D_().func_217481_x().func_215757_a(mapData);
    }

    @Override
    public int func_217395_y() {
        return this.func_73046_m().func_241755_D_().func_217481_x().func_215752_a(MapIdTracker::new, "idcounts").func_215162_a();
    }

    public void func_241124_a__(BlockPos blockPos, float f) {
        ChunkPos chunkPos = new ChunkPos(new BlockPos(this.field_72986_A.func_76079_c(), 0, this.field_72986_A.func_76074_e()));
        this.field_72986_A.func_176143_a(blockPos, f);
        this.func_72863_F().func_217222_b(TicketType.field_219488_a, chunkPos, 11, Unit.INSTANCE);
        this.func_72863_F().func_217228_a(TicketType.field_219488_a, new ChunkPos(blockPos), 11, Unit.INSTANCE);
        this.func_73046_m().func_184103_al().func_148540_a(new SWorldSpawnChangedPacket(blockPos, f));
    }

    public BlockPos func_241135_u_() {
        BlockPos blockPos = new BlockPos(this.field_72986_A.func_76079_c(), this.field_72986_A.func_76075_d(), this.field_72986_A.func_76074_e());
        if (!this.func_175723_af().func_177746_a(blockPos)) {
            blockPos = this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, new BlockPos(this.func_175723_af().func_230316_a_(), 0.0, this.func_175723_af().func_230317_b_()));
        }
        return blockPos;
    }

    public float func_242107_v() {
        return this.field_72986_A.func_241860_d();
    }

    public LongSet func_217469_z() {
        ForcedChunksSaveData forcedChunksSaveData = this.func_217481_x().func_215753_b(ForcedChunksSaveData::new, "chunks");
        return forcedChunksSaveData != null ? LongSets.unmodifiable((LongSet)forcedChunksSaveData.func_212438_a()) : LongSets.EMPTY_SET;
    }

    public boolean func_217458_b(int n, int n2, boolean bl) {
        boolean \u26034;
        ForcedChunksSaveData forcedChunksSaveData = this.func_217481_x().func_215752_a(ForcedChunksSaveData::new, "chunks");
        ChunkPos \u26032 = new ChunkPos(n, n2);
        long \u26033 = \u26032.func_201841_a();
        if (bl) {
            \u26034 = forcedChunksSaveData.func_212438_a().add(\u26033);
            if (\u26034) {
                this.func_212866_a_(n, n2);
            }
        } else {
            \u26034 = forcedChunksSaveData.func_212438_a().remove(\u26033);
        }
        forcedChunksSaveData.func_76186_a(\u26034);
        if (\u26034) {
            this.func_72863_F().func_217206_a(\u26032, bl);
        }
        return \u26034;
    }

    public List<ServerPlayerEntity> func_217369_A() {
        return this.field_217491_A;
    }

    @Override
    public void func_217393_a(BlockPos blockPos, BlockState blockState, BlockState blockState2) {
        Optional<PointOfInterestType> optional = PointOfInterestType.func_221047_b(blockState);
        if (Objects.equals(optional, \u2603 = PointOfInterestType.func_221047_b(blockState2))) {
            return;
        }
        BlockPos \u26032 = blockPos.func_185334_h();
        optional.ifPresent(pointOfInterestType -> this.func_73046_m().execute(() -> {
            this.func_217443_B().func_219140_a(\u26032);
            DebugPacketSender.func_218805_b(this, \u26032);
        }));
        \u2603.ifPresent(pointOfInterestType -> this.func_73046_m().execute(() -> {
            this.func_217443_B().func_219135_a(\u26032, (PointOfInterestType)pointOfInterestType);
            DebugPacketSender.func_218799_a(this, \u26032);
        }));
    }

    public PointOfInterestManager func_217443_B() {
        return this.func_72863_F().func_217231_i();
    }

    public boolean func_217483_b_(BlockPos blockPos) {
        return this.func_241119_a_(blockPos, 1);
    }

    public boolean func_222887_a(SectionPos sectionPos) {
        return this.func_217483_b_(sectionPos.func_218160_t());
    }

    public boolean func_241119_a_(BlockPos blockPos, int n) {
        if (n > 6) {
            return false;
        }
        return this.func_217486_a(SectionPos.func_218167_a(blockPos)) <= n;
    }

    public int func_217486_a(SectionPos sectionPos) {
        return this.func_217443_B().func_219150_a(sectionPos);
    }

    public RaidManager func_217452_C() {
        return this.field_217494_c;
    }

    @Nullable
    public Raid func_217475_c_(BlockPos blockPos) {
        return this.field_217494_c.func_215174_a(blockPos, 9216);
    }

    public boolean func_217455_d_(BlockPos blockPos) {
        return this.func_217475_c_(blockPos) != null;
    }

    public void func_217489_a(IReputationType iReputationType, Entity entity, IReputationTracking iReputationTracking) {
        iReputationTracking.func_213739_a(iReputationType, entity);
    }

    public void func_225322_a(Path path) throws IOException {
        ChunkManager chunkManager = this.func_72863_F().field_217237_a;
        try (Object \u26032 = Files.newBufferedWriter(path.resolve("stats.txt"), new OpenOption[0]);){
            ((Writer)\u26032).write(String.format("spawning_chunks: %d\n", chunkManager.func_219246_e().func_219358_b()));
            Object object = this.func_72863_F().func_241101_k_();
            if (object != null) {
                for (Object \u26033 : ((WorldEntitySpawner.EntityDensityManager)object).func_234995_b_().object2IntEntrySet()) {
                    ((Writer)\u26032).write(String.format("spawn_count.%s: %d\n", ((EntityClassification)\u26033.getKey()).func_220363_a(), \u26033.getIntValue()));
                }
            }
            ((Writer)\u26032).write(String.format("entities: %d\n", this.field_217498_x.size()));
            ((Writer)\u26032).write(String.format("block_entities: %d\n", this.field_147482_g.size()));
            ((Writer)\u26032).write(String.format("block_ticks: %d\n", ((ServerTickList)this.func_205220_G_()).func_225420_a()));
            ((Writer)\u26032).write(String.format("fluid_ticks: %d\n", ((ServerTickList)this.func_205219_F_()).func_225420_a()));
            ((Writer)\u26032).write("distance_manager: " + chunkManager.func_219246_e().func_225412_c() + "\n");
            ((Writer)\u26032).write(String.format("pending_tasks: %d\n", this.func_72863_F().func_225314_f()));
        }
        \u26032 = new CrashReport("Level dump", new Exception("dummy"));
        this.func_72914_a((CrashReport)\u26032);
        Object object = Files.newBufferedWriter(path.resolve("example_crash.txt"), new OpenOption[0]);
        object = null;
        try {
            ((Writer)object).write(((CrashReport)\u26032).func_71502_e());
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (object != null) {
                    try {
                        ((Writer)object).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ((Writer)object).close();
                }
            }
        }
        object = path.resolve("chunks.csv");
        object = Files.newBufferedWriter((Path)object, new OpenOption[0]);
        Object object2 = null;
        try {
            chunkManager.func_225406_a((Writer)object);
        }
        catch (Throwable \u26033) {
            object2 = \u26033;
            throw \u26033;
        }
        finally {
            if (object != null) {
                if (object2 != null) {
                    try {
                        ((Writer)object).close();
                    }
                    catch (Throwable \u26033) {
                        ((Throwable)object2).addSuppressed(\u26033);
                    }
                } else {
                    ((Writer)object).close();
                }
            }
        }
        object = path.resolve("entities.csv");
        \u2603 = Files.newBufferedWriter((Path)object, new OpenOption[0]);
        Object \u26033 = null;
        try {
            ServerWorld.func_225320_a((Writer)\u2603, (Iterable<Entity>)this.field_217498_x.values());
        }
        catch (Throwable throwable) {
            \u26033 = throwable;
            throw throwable;
        }
        finally {
            if (\u2603 != null) {
                if (\u26033 != null) {
                    try {
                        ((Writer)\u2603).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)\u26033).addSuppressed(throwable);
                    }
                } else {
                    ((Writer)\u2603).close();
                }
            }
        }
        \u2603 = path.resolve("block_entities.csv");
        \u26033 = Files.newBufferedWriter((Path)\u2603, new OpenOption[0]);
        Throwable throwable = null;
        try {
            this.func_225321_a((Writer)\u26033);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (\u26033 != null) {
                if (throwable != null) {
                    try {
                        ((Writer)\u26033).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    ((Writer)\u26033).close();
                }
            }
        }
    }

    private static void func_225320_a(Writer writer, Iterable<Entity> iterable) throws IOException {
        CSVWriter cSVWriter = CSVWriter.func_225428_a().func_225423_a("x").func_225423_a("y").func_225423_a("z").func_225423_a("uuid").func_225423_a("type").func_225423_a("alive").func_225423_a("display_name").func_225423_a("custom_name").func_225422_a(writer);
        for (Entity entity : iterable) {
            ITextComponent iTextComponent = entity.func_200201_e();
            \u2603 = entity.func_145748_c_();
            cSVWriter.func_225426_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.func_110124_au(), Registry.field_212629_r.func_177774_c(entity.func_200600_R()), entity.func_70089_S(), \u2603.getString(), iTextComponent != null ? iTextComponent.getString() : null);
        }
    }

    private void func_225321_a(Writer writer) throws IOException {
        CSVWriter cSVWriter = CSVWriter.func_225428_a().func_225423_a("x").func_225423_a("y").func_225423_a("z").func_225423_a("type").func_225422_a(writer);
        for (TileEntity tileEntity : this.field_147482_g) {
            BlockPos blockPos = tileEntity.func_174877_v();
            cSVWriter.func_225426_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), Registry.field_212626_o.func_177774_c(tileEntity.func_200662_C()));
        }
    }

    @VisibleForTesting
    public void func_229854_a_(MutableBoundingBox mutableBoundingBox) {
        this.field_147490_S.removeIf(blockEventData -> mutableBoundingBox.func_175898_b(blockEventData.func_180328_a()));
    }

    @Override
    public void func_230547_a_(BlockPos blockPos, Block block) {
        if (!this.func_234925_Z_()) {
            this.func_195593_d(blockPos, block);
        }
    }

    public Iterable<Entity> func_241136_z_() {
        return Iterables.unmodifiableIterable((Iterable)this.field_217498_x.values());
    }

    public String toString() {
        return "ServerLevel[" + this.field_241103_E_.func_76065_j() + "]";
    }

    public boolean func_241109_A_() {
        return this.field_73061_a.func_240793_aU_().func_230418_z_().func_236228_i_();
    }

    @Override
    public long func_72905_C() {
        return this.field_73061_a.func_240793_aU_().func_230418_z_().func_236221_b_();
    }

    @Nullable
    public DragonFightManager func_241110_C_() {
        return this.field_241105_O_;
    }

    @Override
    public Stream<? extends StructureStart<?>> func_241827_a(SectionPos sectionPos, Structure<?> structure) {
        return this.func_241112_a_().func_235011_a_(sectionPos, structure);
    }

    @Override
    public ServerWorld func_201672_e() {
        return this;
    }

    public static void func_241121_a_(ServerWorld serverWorld) {
        BlockPos blockPos2 = field_241108_a_;
        int \u26032 = blockPos2.func_177958_n();
        int \u26033 = blockPos2.func_177956_o() - 2;
        int \u26034 = blockPos2.func_177952_p();
        BlockPos.func_191531_b(\u26032 - 2, \u26033 + 1, \u26034 - 2, \u26032 + 2, \u26033 + 3, \u26034 + 2).forEach(blockPos -> serverWorld.func_175656_a((BlockPos)blockPos, Blocks.field_150343_Z.func_176223_P()));
        BlockPos.func_191531_b(\u26032 - 2, \u26033, \u26034 - 2, \u26032 + 2, \u26033, \u26034 + 2).forEach(blockPos -> serverWorld.func_175656_a((BlockPos)blockPos, Blocks.field_150343_Z.func_176223_P()));
    }

    @Override
    public /* synthetic */ Scoreboard func_96441_U() {
        return this.func_96441_U();
    }

    @Override
    public /* synthetic */ AbstractChunkProvider func_72863_F() {
        return this.func_72863_F();
    }

    public /* synthetic */ ITickList func_205219_F_() {
        return this.func_205219_F_();
    }

    public /* synthetic */ ITickList func_205220_G_() {
        return this.func_205220_G_();
    }

    private static /* synthetic */ void func_241122_a_(ServerWorld serverWorld, BlockPos blockPos) {
        serverWorld.func_175656_a(blockPos, Blocks.field_150350_a.func_176223_P());
    }
}

