/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.blocks;

import java.util.List;
import mods.tinker.tconstruct.TConstruct;
import mods.tinker.tconstruct.blocks.logic.CraftingStationLogic;
import mods.tinker.tconstruct.blocks.logic.PartCrafterLogic;
import mods.tinker.tconstruct.blocks.logic.PatternChestLogic;
import mods.tinker.tconstruct.blocks.logic.StencilTableLogic;
import mods.tinker.tconstruct.blocks.logic.ToolForgeLogic;
import mods.tinker.tconstruct.blocks.logic.ToolStationLogic;
import mods.tinker.tconstruct.common.TContent;
import mods.tinker.tconstruct.common.TProxyCommon;
import mods.tinker.tconstruct.library.TConstructRegistry;
import mods.tinker.tconstruct.library.blocks.InventoryBlock;
import mods.tinker.tconstruct.util.PHConstruct;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CraftingSlab
extends InventoryBlock {
    public CraftingSlab(int id, Material material) {
        super(id, material);
        this.func_71849_a(TConstructRegistry.blockTab);
        this.func_71848_c(2.0f);
        this.func_71884_a(Block.field_71967_e);
    }

    @Override
    public String[] getTextureNames() {
        String[] textureNames = new String[]{"craftingstation_top", "craftingstation_slab_side", "craftingstation_bottom", "toolstation_top", "toolstation_slab_side", "toolstation_bottom", "partbuilder_oak_top", "partbuilder_slab_side", "partbuilder_oak_bottom", "stenciltable_oak_top", "stenciltable_slab_side", "stenciltable_oak_bottom", "patternchest_top", "patternchest_slab_side", "patternchest_bottom", "toolforge_top", "toolforge_slab_side", "toolforge_top"};
        return textureNames;
    }

    public Icon func_71858_a(int side, int meta) {
        return this.icons[meta % 8 * 3 + this.getTextureIndex(side)];
    }

    public int getTextureIndex(int side) {
        if (side == 0) {
            return 2;
        }
        if (side == 1) {
            return 0;
        }
        return 1;
    }

    public boolean func_71886_c() {
        return false;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71877_c(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return true;
    }

    public AxisAlignedBB func_71911_a_(World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == 5) {
            return AxisAlignedBB.func_72332_a().func_72299_a((double)x + this.field_72026_ch, (double)y + this.field_72023_ci, (double)z + this.field_72024_cj, (double)x + this.field_72021_ck, (double)y + this.field_72022_cl - 0.125, (double)z + this.field_72019_cm);
        }
        return AxisAlignedBB.func_72332_a().func_72299_a((double)x + this.field_72026_ch, (double)y + this.field_72023_ci, (double)z + this.field_72024_cj, (double)x + this.field_72021_ck, (double)y + this.field_72022_cl, (double)z + this.field_72019_cm);
    }

    @Override
    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata % 8) {
            case 0: {
                return new CraftingStationLogic();
            }
            case 1: {
                return new ToolStationLogic();
            }
            case 2: {
                return new PartCrafterLogic();
            }
            case 3: {
                return new StencilTableLogic();
            }
            case 4: {
                return new PatternChestLogic();
            }
            case 5: {
                return new ToolForgeLogic();
            }
        }
        return null;
    }

    @Override
    public Integer getGui(World world, int x, int y, int z, EntityPlayer entityplayer) {
        int meta = world.func_72805_g(x, y, z) % 8;
        switch (meta) {
            case 0: {
                return TProxyCommon.craftingStationID;
            }
            case 1: {
                return TProxyCommon.toolStationID;
            }
            case 2: {
                return TProxyCommon.partBuilderID;
            }
            case 3: {
                return TProxyCommon.stencilTableID;
            }
            case 4: {
                return TProxyCommon.patternChestID;
            }
            case 5: {
                return TProxyCommon.toolForgeID;
            }
        }
        return -1;
    }

    @Override
    public Object getModInstance() {
        return TConstruct.instance;
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (int iter = 0; iter < 6; ++iter) {
            list.add(new ItemStack(id, 1, iter));
        }
    }

    @Override
    public void func_71860_a(World world, int x, int y, int z, EntityLiving entityliving, ItemStack stack) {
        int meta;
        if (PHConstruct.freePatterns && (meta = world.func_72805_g(x, y, z)) == 4) {
            PatternChestLogic logic = (PatternChestLogic)world.func_72796_p(x, y, z);
            for (int i = 1; i <= 13; ++i) {
                logic.func_70299_a(i - 1, new ItemStack(TContent.woodPattern, 1, i));
            }
            logic.func_70299_a(13, new ItemStack(TContent.woodPattern, 1, 22));
        }
        super.func_71860_a(world, x, y, z, entityliving, stack);
    }

    public void func_71871_a(World world, int x, int y, int z, AxisAlignedBB axisalignedbb, List arraylist, Entity entity) {
        this.func_71902_a((IBlockAccess)world, x, y, z);
        super.func_71871_a(world, x, y, z, axisalignedbb, arraylist, entity);
    }

    public void func_71919_f() {
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z) / 8;
        float minY = meta == 1 ? 0.5f : 0.0f;
        float maxY = meta == 1 ? 1.0f : 0.5f;
        this.func_71905_a(0.0f, minY, 0.0f, 1.0f, maxY, 1.0f);
    }

    @Override
    public int func_85104_a(World par1World, int blockX, int blockY, int blockZ, int side, float clickX, float clickY, float clickZ, int metadata) {
        if (side == 1) {
            return metadata;
        }
        if (side == 0 || clickY >= 0.5f) {
            return metadata | 8;
        }
        return metadata;
    }

    @Override
    public int func_71899_b(int meta) {
        return meta % 8;
    }
}

