/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.blocks.logic;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import mods.tinker.tconstruct.blocks.logic.CastingBasinLogic;
import mods.tinker.tconstruct.blocks.logic.CastingTableLogic;
import mods.tinker.tconstruct.blocks.logic.LavaTankLogic;
import mods.tinker.tconstruct.library.util.IActiveLogic;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidEvent;
import net.minecraftforge.liquids.LiquidStack;

public class CastingChannelLogic
extends TileEntity
implements ILiquidTank,
ITankContainer,
IActiveLogic {
    public static final int fillMax = 288;
    public static final int outputMax = 48;
    public LiquidStack liquid;
    public ForgeDirection lastProvider = ForgeDirection.UNKNOWN;
    private int ticks = 0;
    private int ticksLPReset = 0;
    public int recentlyFilledDelay = 0;
    boolean pullingLiquids;

    public void func_70316_g() {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        ++this.ticks;
        ++this.ticksLPReset;
        if (!this.field_70331_k.field_72995_K && this.pullingLiquids) {
            this.pullLiquids();
        }
        if (this.ticks == 20) {
            if (this.recentlyFilledDelay != 0) {
                --this.recentlyFilledDelay;
            }
            if (this.recentlyFilledDelay == 0) {
                this.moveLiquidToTanks();
            }
            this.ticks = 0;
        }
        if (this.ticksLPReset == 60) {
            this.lastProvider = ForgeDirection.UNKNOWN;
            this.ticksLPReset = 0;
        }
    }

    void pullLiquids() {
        if (!(this.pullLiquid(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n, ForgeDirection.EAST) || this.pullLiquid(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n, ForgeDirection.WEST) || this.pullLiquid(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1, ForgeDirection.NORTH) || this.pullLiquid(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1, ForgeDirection.SOUTH))) {
            this.pullingLiquids = false;
        }
    }

    boolean pullLiquid(int x, int y, int z, ForgeDirection direction) {
        LiquidStack templiquid;
        TileEntity tank = this.field_70331_k.func_72796_p(x, y, z);
        if (tank instanceof ITankContainer && !(tank instanceof CastingChannelLogic) && (templiquid = ((ITankContainer)tank).drain(direction, 3, false)) != null) {
            if (this.liquid == null) {
                if (templiquid.amount > 288) {
                    templiquid.amount = 288;
                }
                this.liquid = ((ITankContainer)tank).drain(direction, templiquid.amount, true);
                return true;
            }
            if (this.liquid.isLiquidEqual(templiquid)) {
                if (templiquid.amount + this.liquid.amount > 288) {
                    templiquid.amount = 288 - this.liquid.amount;
                }
                this.liquid.amount += ((ITankContainer)tank).drain((ForgeDirection)direction, (int)templiquid.amount, (boolean)true).amount;
                return true;
            }
        }
        return false;
    }

    private void moveLiquidToChannels() {
        if (this.liquid == null || this.liquid.amount <= 0) {
            return;
        }
        TileEntity tankXplus = null;
        TileEntity tankXminus = null;
        TileEntity tankZplus = null;
        TileEntity tankZminus = null;
        TileEntity tankYminus = null;
        HashMap tankMap = this.getOutputs();
        if (tankMap.size() <= 0) {
            return;
        }
        boolean yFilled = false;
        if (tankMap.containsKey("yMinus")) {
            int filled;
            tankYminus = (TileEntity)tankMap.get("yMinus");
            LiquidStack liquidToPush = this.drain(24, false);
            if (liquidToPush != null && liquidToPush.amount > 0 && (filled = ((ITankContainer)tankYminus).fill(ForgeDirection.UP, liquidToPush, true)) > 0) {
                yFilled = true;
                this.drain(filled, true);
            }
        }
        if (!yFilled) {
            int filled;
            LiquidStack liquidToPush;
            int divisionSurplus = this.liquid.amount % tankMap.size();
            int amountXp = 48 / tankMap.size();
            int amountXm = 48 / tankMap.size();
            int amountZp = 48 / tankMap.size();
            int amountZm = 48 / tankMap.size();
            if (divisionSurplus > 0) {
                ++amountXp;
            }
            if (divisionSurplus > 1) {
                ++amountXm;
            }
            if (divisionSurplus > 2) {
                ++amountZp;
            }
            if (tankMap.containsKey("xPlus")) {
                tankXplus = (TileEntity)tankMap.get("xPlus");
                liquidToPush = this.drain(amountXp, false);
                if (liquidToPush != null && liquidToPush.amount > 0) {
                    filled = ((ITankContainer)tankXplus).fill(ForgeDirection.WEST, liquidToPush, true);
                    this.drain(filled, true);
                }
            }
            if (tankMap.containsKey("xMinus")) {
                tankXminus = (TileEntity)tankMap.get("xMinus");
                liquidToPush = this.drain(amountXm, false);
                if (liquidToPush != null && liquidToPush.amount > 0) {
                    filled = ((ITankContainer)tankXminus).fill(ForgeDirection.EAST, liquidToPush, true);
                    this.drain(filled, true);
                }
            }
            if (tankMap.containsKey("zPlus")) {
                tankZplus = (TileEntity)tankMap.get("zPlus");
                liquidToPush = this.drain(amountZp, false);
                if (liquidToPush != null && liquidToPush.amount > 0) {
                    filled = ((ITankContainer)tankZplus).fill(ForgeDirection.NORTH, liquidToPush, true);
                    this.drain(filled, true);
                }
            }
            if (tankMap.containsKey("zMinus")) {
                tankZminus = (TileEntity)tankMap.get("zMinus");
                liquidToPush = this.drain(amountZm, false);
                if (liquidToPush != null && liquidToPush.amount > 0) {
                    filled = ((ITankContainer)tankZminus).fill(ForgeDirection.SOUTH, liquidToPush, true);
                    this.drain(filled, true);
                }
            }
        }
    }

    private void moveLiquidToTanks() {
        if (this.liquid == null || this.liquid.amount <= 0) {
            return;
        }
        TileEntity tankXplus = null;
        TileEntity tankXminus = null;
        TileEntity tankZplus = null;
        TileEntity tankZminus = null;
        TileEntity tankYminus = null;
        HashMap tankMap = this.getOutputs();
        if (tankMap == null) {
            tankMap = this.getOutputs();
        }
        if (tankMap.size() <= 0) {
            return;
        }
        boolean yFilled = false;
        if (tankMap.containsKey("yMinus")) {
            int filled;
            tankYminus = (TileEntity)tankMap.get("yMinus");
            LiquidStack liquidToPush = this.drain(24, false);
            if (liquidToPush != null && liquidToPush.amount > 0 && (filled = ((ITankContainer)tankYminus).fill(ForgeDirection.UP, liquidToPush, true)) > 0) {
                yFilled = true;
                this.drain(filled, true);
            }
        }
        if (!yFilled) {
            int filled;
            LiquidStack liquidToPush;
            int divisionSurplus = this.liquid.amount % tankMap.size();
            int amountXp = 48 / tankMap.size();
            int amountXm = 48 / tankMap.size();
            int amountZp = 48 / tankMap.size();
            int amountZm = 48 / tankMap.size();
            if (divisionSurplus > 0) {
                ++amountXp;
            }
            if (divisionSurplus > 1) {
                ++amountXm;
            }
            if (divisionSurplus > 2) {
                ++amountZp;
            }
            if (tankMap.containsKey("xPlus")) {
                tankXplus = (TileEntity)tankMap.get("xPlus");
                liquidToPush = this.drain(amountXp, false);
                if (liquidToPush != null && liquidToPush.amount > 0) {
                    filled = ((ITankContainer)tankXplus).fill(ForgeDirection.WEST, liquidToPush, true);
                    this.drain(filled, true);
                }
            }
            if (tankMap.containsKey("xMinus")) {
                tankXminus = (TileEntity)tankMap.get("xMinus");
                liquidToPush = this.drain(amountXm, false);
                if (liquidToPush != null && liquidToPush.amount > 0) {
                    filled = ((ITankContainer)tankXminus).fill(ForgeDirection.EAST, liquidToPush, true);
                    this.drain(filled, true);
                }
            }
            if (tankMap.containsKey("zPlus")) {
                tankZplus = (TileEntity)tankMap.get("zPlus");
                liquidToPush = this.drain(amountZp, false);
                if (liquidToPush != null && liquidToPush.amount > 0) {
                    filled = ((ITankContainer)tankZplus).fill(ForgeDirection.NORTH, liquidToPush, true);
                    this.drain(filled, true);
                }
            }
            if (tankMap.containsKey("zMinus")) {
                tankZminus = (TileEntity)tankMap.get("zMinus");
                liquidToPush = this.drain(amountZm, false);
                if (liquidToPush != null && liquidToPush.amount > 0) {
                    filled = ((ITankContainer)tankZminus).fill(ForgeDirection.SOUTH, liquidToPush, true);
                    this.drain(filled, true);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float tankBelow() {
        TileEntity te = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n);
        if (te instanceof CastingChannelLogic) {
            return -0.5f;
        }
        if (te instanceof LavaTankLogic) {
            return -1.0f;
        }
        if (te instanceof CastingBasinLogic) {
            return -0.75f;
        }
        if (te instanceof CastingTableLogic) {
            return -0.125f;
        }
        if (te instanceof ITankContainer) {
            return 0.0f;
        }
        return 0.5f;
    }

    public boolean hasChannelConnected(ForgeDirection dir) {
        switch (dir) {
            case DOWN: {
                return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n) instanceof CastingChannelLogic;
            }
            case NORTH: {
                return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1) instanceof CastingChannelLogic;
            }
            case SOUTH: {
                return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1) instanceof CastingChannelLogic;
            }
            case WEST: {
                return this.field_70331_k.func_72796_p(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n) instanceof CastingChannelLogic;
            }
            case EAST: {
                return this.field_70331_k.func_72796_p(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n) instanceof CastingChannelLogic;
            }
        }
        return false;
    }

    public boolean hasTankConnected(ForgeDirection dir) {
        switch (dir) {
            case DOWN: {
                return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n) instanceof ITankContainer;
            }
            case NORTH: {
                return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1) instanceof ITankContainer;
            }
            case SOUTH: {
                return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1) instanceof ITankContainer;
            }
            case WEST: {
                return this.field_70331_k.func_72796_p(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n) instanceof ITankContainer;
            }
            case EAST: {
                return this.field_70331_k.func_72796_p(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n) instanceof ITankContainer;
            }
        }
        return false;
    }

    private HashMap getOutputs() {
        HashMap<String, TileEntity> map = new HashMap<String, TileEntity>();
        TileEntity tankXplus = this.field_70331_k.func_72796_p(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n);
        TileEntity tankXminus = this.field_70331_k.func_72796_p(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n);
        TileEntity tankZplus = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1);
        TileEntity tankZminus = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1);
        TileEntity tankYminus = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n);
        if (this.pullingLiquids) {
            if (this.hasChannelConnected(ForgeDirection.EAST) && this.lastProvider != ForgeDirection.EAST) {
                map.put("xPlus", tankXplus);
            }
            if (this.hasChannelConnected(ForgeDirection.WEST) && this.lastProvider != ForgeDirection.WEST) {
                map.put("xMinus", tankXminus);
            }
            if (this.hasChannelConnected(ForgeDirection.SOUTH) && this.lastProvider != ForgeDirection.SOUTH) {
                map.put("zPlus", tankZplus);
            }
            if (this.hasChannelConnected(ForgeDirection.NORTH) && this.lastProvider != ForgeDirection.NORTH) {
                map.put("zMinus", tankZminus);
            }
            if (this.hasChannelConnected(ForgeDirection.DOWN) && this.lastProvider != ForgeDirection.DOWN) {
                map.put("yMinus", tankYminus);
            }
        } else {
            if (this.hasTankConnected(ForgeDirection.EAST) && this.lastProvider != ForgeDirection.EAST) {
                map.put("xPlus", tankXplus);
            }
            if (this.hasTankConnected(ForgeDirection.WEST) && this.lastProvider != ForgeDirection.WEST) {
                map.put("xMinus", tankXminus);
            }
            if (this.hasTankConnected(ForgeDirection.SOUTH) && this.lastProvider != ForgeDirection.SOUTH) {
                map.put("zPlus", tankZplus);
            }
            if (this.hasTankConnected(ForgeDirection.NORTH) && this.lastProvider != ForgeDirection.NORTH) {
                map.put("zMinus", tankZminus);
            }
            if (this.hasTankConnected(ForgeDirection.DOWN) && this.lastProvider != ForgeDirection.DOWN) {
                map.put("yMinus", tankYminus);
            }
        }
        return map;
    }

    public int fill(LiquidStack stack, boolean doFill) {
        if (stack == null) {
            return 0;
        }
        if (this.liquid == null) {
            LiquidStack transfered = stack.copy();
            if (transfered.amount > 288) {
                transfered.amount = 288;
            }
            if (doFill) {
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                this.liquid = transfered;
            }
            this.recentlyFilledDelay = 2;
            if (this.lastProvider == ForgeDirection.UP) {
                this.recentlyFilledDelay = 3;
            }
            return transfered.amount;
        }
        if (stack.isLiquidEqual(this.liquid)) {
            if (stack.amount + this.liquid.amount >= 288) {
                int spaceInTank = 288 - this.liquid.amount;
                if (doFill && spaceInTank > 0) {
                    this.liquid.amount = 288;
                    this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                }
                return spaceInTank;
            }
            if (doFill) {
                this.liquid.amount += stack.amount;
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
            return stack.amount;
        }
        return 0;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        this.lastProvider = from;
        this.ticksLPReset = 0;
        int filled = this.fill(resource, doFill);
        if (from == ForgeDirection.UP) {
            this.moveLiquidToTanks();
        }
        return filled;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return this.fill(ForgeDirection.UNKNOWN, resource, doFill);
    }

    public LiquidStack drain(int maxDrain, boolean doDrain) {
        if (this.liquid == null || this.liquid.itemID <= 0) {
            return null;
        }
        if (this.liquid.amount <= 0) {
            return null;
        }
        int toDrain = maxDrain;
        if (this.liquid.amount < toDrain) {
            toDrain = this.liquid.amount;
        }
        if (doDrain) {
            this.liquid.amount -= toDrain;
        }
        LiquidStack drained = new LiquidStack(this.liquid.itemID, toDrain, this.liquid.itemMeta);
        if (this.liquid.amount <= 0) {
            this.liquid = null;
        }
        if (doDrain) {
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            LiquidEvent.fireEvent((LiquidEvent)new LiquidEvent.LiquidDrainingEvent(drained, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, (ILiquidTank)this));
        }
        return drained;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        this.drain(0, maxDrain, doDrain);
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        this.drain(maxDrain, doDrain);
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        ILiquidTank[] tanks = new ILiquidTank[]{this};
        return tanks;
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this;
    }

    public LiquidStack getLiquid() {
        return this.liquid;
    }

    public int getCapacity() {
        return 288;
    }

    public int getTankPressure() {
        return 0;
    }

    public int getLiquidAmount() {
        return this.liquid.amount;
    }

    public void func_70307_a(NBTTagCompound tags) {
        super.func_70307_a(tags);
        this.readCustomNBT(tags);
        this.pullingLiquids = tags.func_74767_n("PullingLiquids");
    }

    public void readCustomNBT(NBTTagCompound tags) {
        this.liquid = tags.func_74767_n("hasLiquid") ? new LiquidStack(tags.func_74762_e("itemID"), tags.func_74762_e("amount"), tags.func_74762_e("itemMeta")) : null;
        this.recentlyFilledDelay = tags.func_74762_e("recentlyFilledDelay");
        this.lastProvider = this.convertIntToFD(tags.func_74762_e("LastProvider"));
    }

    public void func_70310_b(NBTTagCompound tags) {
        super.func_70310_b(tags);
        this.writeCustomNBT(tags);
        tags.func_74757_a("PullingLiquids", this.pullingLiquids);
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        tags.func_74757_a("hasLiquid", this.liquid != null);
        if (this.liquid != null) {
            tags.func_74768_a("itemID", this.liquid.itemID);
            tags.func_74768_a("amount", this.liquid.amount);
            tags.func_74768_a("itemMeta", this.liquid.itemMeta);
        }
        tags.func_74768_a("LastProvider", this.convertFDToInt(this.lastProvider));
        tags.func_74768_a("recentlyFilledDelay", this.recentlyFilledDelay);
    }

    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.readCustomNBT(packet.field_73331_e);
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public int convertFDToInt(ForgeDirection dir) {
        switch (dir) {
            case DOWN: {
                return 0;
            }
            case UP: {
                return 1;
            }
            case NORTH: {
                return 2;
            }
            case SOUTH: {
                return 3;
            }
            case WEST: {
                return 4;
            }
            case EAST: {
                return 5;
            }
        }
        return -1;
    }

    public ForgeDirection convertIntToFD(int i) {
        switch (i) {
            case 0: {
                return ForgeDirection.DOWN;
            }
            case 1: {
                return ForgeDirection.UP;
            }
            case 2: {
                return ForgeDirection.NORTH;
            }
            case 3: {
                return ForgeDirection.SOUTH;
            }
            case 4: {
                return ForgeDirection.WEST;
            }
            case 5: {
                return ForgeDirection.EAST;
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    @Override
    public boolean getActive() {
        return this.pullingLiquids;
    }

    @Override
    public void setActive(boolean flag) {
        this.pullingLiquids = flag;
    }

    public void updateChannels() {
    }
}

