/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.client.block;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import mods.tinker.tconstruct.blocks.logic.CastingChannelLogic;
import mods.tinker.tconstruct.client.block.BlockSkinRenderHelper;
import mods.tinker.tconstruct.client.block.RenderLiquid;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class BlockRenderCastingChannel
implements ISimpleBlockRenderingHandler {
    public static int renderID = RenderingRegistry.getNextAvailableRenderId();

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        renderer.func_83020_a(0.3125, 0.375, 0.3125, 0.6875, 0.5, 0.6875);
        this.renderStandardBlock(block, metadata, renderer);
        renderer.func_83020_a(0.3125, 0.375, 0.0, 0.6875, 0.5, 0.3125);
        this.renderStandardBlock(block, metadata, renderer);
        renderer.func_83020_a(0.3125, 0.5, 0.0, 0.375, 0.625, 0.3125);
        this.renderStandardBlock(block, metadata, renderer);
        renderer.func_83020_a(0.625, 0.5, 0.0, 0.6875, 0.625, 0.3125);
        this.renderStandardBlock(block, metadata, renderer);
        renderer.func_83020_a(0.3125, 0.375, 0.6875, 0.6875, 0.5, 1.0);
        this.renderStandardBlock(block, metadata, renderer);
        renderer.func_83020_a(0.3125, 0.5, 0.6875, 0.375, 0.625, 1.0);
        this.renderStandardBlock(block, metadata, renderer);
        renderer.func_83020_a(0.625, 0.5, 0.6875, 0.6875, 0.625, 1.0);
        this.renderStandardBlock(block, metadata, renderer);
        renderer.func_83020_a(0.3125, 0.375, 0.3125, 0.375, 0.625, 0.6875);
        this.renderStandardBlock(block, metadata, renderer);
        renderer.func_83020_a(0.625, 0.375, 0.3125, 0.6875, 0.625, 0.6875);
        this.renderStandardBlock(block, metadata, renderer);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelID, RenderBlocks renderer) {
        if (modelID == renderID) {
            CastingChannelLogic tile = (CastingChannelLogic)world.func_72796_p(x, y, z);
            if (!tile.hasTankConnected(ForgeDirection.DOWN)) {
                renderer.func_83020_a(0.3125, 0.375, 0.3125, 0.6875, 0.5, 0.6875);
                renderer.func_78570_q(block, x, y, z);
            } else {
                renderer.func_83020_a(0.375, 0.125, 0.3125, 0.625, 0.5, 0.375);
                renderer.func_78570_q(block, x, y, z);
                renderer.func_83020_a(0.375, 0.125, 0.625, 0.625, 0.5, 0.6875);
                renderer.func_78570_q(block, x, y, z);
                renderer.func_83020_a(0.3125, 0.125, 0.3125, 0.375, 0.5, 0.6875);
                renderer.func_78570_q(block, x, y, z);
                renderer.func_83020_a(0.625, 0.125, 0.3125, 0.6875, 0.5, 0.6875);
                renderer.func_78570_q(block, x, y, z);
            }
            if (tile.hasTankConnected(ForgeDirection.NORTH)) {
                renderer.func_83020_a(0.3125, 0.375, 0.0, 0.6875, 0.5, 0.3125);
                renderer.func_78570_q(block, x, y, z);
                renderer.func_83020_a(0.3125, 0.5, 0.0, 0.375, 0.625, 0.3125);
                renderer.func_78570_q(block, x, y, z);
                renderer.func_83020_a(0.625, 0.5, 0.0, 0.6875, 0.625, 0.3125);
                renderer.func_78570_q(block, x, y, z);
            } else {
                renderer.func_83020_a(0.375, 0.5, 0.3125, 0.625, 0.625, 0.375);
                renderer.func_78570_q(block, x, y, z);
            }
            if (tile.hasTankConnected(ForgeDirection.SOUTH)) {
                renderer.func_83020_a(0.3125, 0.375, 0.6875, 0.6875, 0.5, 1.0);
                renderer.func_78570_q(block, x, y, z);
                renderer.func_83020_a(0.3125, 0.5, 0.6875, 0.375, 0.625, 1.0);
                renderer.func_78570_q(block, x, y, z);
                renderer.func_83020_a(0.625, 0.5, 0.6875, 0.6875, 0.625, 1.0);
                renderer.func_78570_q(block, x, y, z);
            } else {
                renderer.func_83020_a(0.375, 0.5, 0.625, 0.625, 0.625, 0.6875);
                renderer.func_78570_q(block, x, y, z);
            }
            if (tile.hasTankConnected(ForgeDirection.WEST)) {
                renderer.func_83020_a(0.0, 0.375, 0.3125, 0.3125, 0.5, 0.6875);
                renderer.func_78570_q(block, x, y, z);
                renderer.func_83020_a(0.0, 0.5, 0.3125, 0.375, 0.625, 0.375);
                renderer.func_78570_q(block, x, y, z);
                renderer.func_83020_a(0.0, 0.5, 0.625, 0.375, 0.625, 0.6875);
                renderer.func_78570_q(block, x, y, z);
            } else {
                renderer.func_83020_a(0.3125, 0.5, 0.3125, 0.375, 0.625, 0.6875);
                renderer.func_78570_q(block, x, y, z);
            }
            if (tile.hasTankConnected(ForgeDirection.EAST)) {
                renderer.func_83020_a(0.6875, 0.375, 0.3125, 1.0, 0.5, 0.6875);
                renderer.func_78570_q(block, x, y, z);
                renderer.func_83020_a(0.625, 0.5, 0.3125, 1.0, 0.625, 0.375);
                renderer.func_78570_q(block, x, y, z);
                renderer.func_83020_a(0.625, 0.5, 0.625, 1.0, 0.625, 0.6875);
                renderer.func_78570_q(block, x, y, z);
            } else {
                renderer.func_83020_a(0.625, 0.5, 0.3125, 0.6875, 0.625, 0.6875);
                renderer.func_78570_q(block, x, y, z);
            }
            if (tile.liquid != null) {
                float height = (float)tile.getLiquidAmount() / ((float)tile.getCapacity() * 1.05f);
                float j = tile.liquid.amount / 288;
                double startY = tile.tankBelow();
                float liquidAmount = (float)tile.liquid.amount / 288.0f * 0.125f;
                renderer.func_83020_a(0.375, startY, 0.375, 0.625, 0.5 + (double)liquidAmount, 0.625);
                this.renderLiquidPart(world, x, y, z, block, renderer, tile);
                if (tile.hasTankConnected(ForgeDirection.NORTH)) {
                    if (tile.lastProvider == ForgeDirection.NORTH) {
                        renderer.func_83020_a(0.375, 0.5, 0.0, 0.625, 0.5 + (double)liquidAmount, 0.375);
                        this.renderLiquidPart(world, x, y, z, block, renderer, tile);
                    } else if (tile.recentlyFilledDelay == 0) {
                        renderer.func_83020_a(0.375, 0.5, 0.0, 0.625, 0.5 + (double)liquidAmount, 0.375);
                        this.renderLiquidPart(world, x, y, z, block, renderer, tile);
                    }
                }
                if (tile.hasTankConnected(ForgeDirection.SOUTH)) {
                    if (tile.lastProvider == ForgeDirection.SOUTH) {
                        renderer.func_83020_a(0.375, 0.5, 0.625, 0.625, 0.5 + (double)liquidAmount, 1.0);
                        this.renderLiquidPart(world, x, y, z, block, renderer, tile);
                    } else if (tile.recentlyFilledDelay == 0) {
                        renderer.func_83020_a(0.375, 0.5, 0.625, 0.625, 0.5 + (double)liquidAmount, 1.0);
                        this.renderLiquidPart(world, x, y, z, block, renderer, tile);
                    }
                }
                if (tile.hasTankConnected(ForgeDirection.WEST)) {
                    if (tile.lastProvider == ForgeDirection.WEST) {
                        renderer.func_83020_a(0.0, 0.5, 0.375, 0.375, 0.5 + (double)liquidAmount, 0.625);
                        this.renderLiquidPart(world, x, y, z, block, renderer, tile);
                    } else if (tile.recentlyFilledDelay == 0) {
                        renderer.func_83020_a(0.0, 0.5, 0.375, 0.375, 0.5 + (double)liquidAmount, 0.625);
                        this.renderLiquidPart(world, x, y, z, block, renderer, tile);
                    }
                }
                if (tile.hasTankConnected(ForgeDirection.EAST)) {
                    if (tile.lastProvider == ForgeDirection.EAST) {
                        renderer.func_83020_a(0.625, 0.5, 0.375, 1.0, 0.5 + (double)liquidAmount, 0.625);
                        this.renderLiquidPart(world, x, y, z, block, renderer, tile);
                    } else if (tile.recentlyFilledDelay == 0) {
                        renderer.func_83020_a(0.625, 0.5, 0.375, 1.0, 0.5 + (double)liquidAmount, 0.625);
                        this.renderLiquidPart(world, x, y, z, block, renderer, tile);
                    }
                }
            }
        }
        return true;
    }

    private void renderLiquidPart(IBlockAccess world, int x, int y, int z, Block block, RenderBlocks renderer, CastingChannelLogic tile) {
        if (tile.liquid.itemID < 4096) {
            Block liquidBlock = Block.field_71973_m[tile.liquid.itemID];
            if (liquidBlock != null) {
                int color = block.func_71920_b(world, x, y, z);
                float red = (float)(color >> 16 & 0xFF) / 255.0f;
                float green = (float)(color >> 8 & 0xFF) / 255.0f;
                float blue = (float)(color & 0xFF) / 255.0f;
                BlockSkinRenderHelper.renderMetadataBlock(liquidBlock, tile.liquid.itemMeta, x, y, z, renderer, world);
            }
        } else {
            Item liquidItem = Item.field_77698_e[tile.liquid.itemID];
            if (liquidItem != null) {
                Block block2 = Block.field_71981_t;
                int var5 = block2.func_71920_b(world, x, y, z);
                float var6 = (float)(var5 >> 16 & 0xFF) / 255.0f;
                float var7 = (float)(var5 >> 8 & 0xFF) / 255.0f;
                float var8 = (float)(var5 & 0xFF) / 255.0f;
                RenderLiquid.renderFakeBlockWithColorMultiplier(liquidItem.func_77617_a(tile.liquid.itemMeta), x, y, z, var6, var7, var8, renderer, world);
            }
        }
    }

    private void renderStandardBlock(Block block, int meta, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_78613_a(block, 0.0, 0.0, 0.0, block.func_71858_a(0, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_78617_b(block, 0.0, 0.0, 0.0, block.func_71858_a(1, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_78611_c(block, 0.0, 0.0, 0.0, block.func_71858_a(2, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_78622_d(block, 0.0, 0.0, 0.0, block.func_71858_a(3, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_78573_e(block, 0.0, 0.0, 0.0, block.func_71858_a(4, meta));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_78605_f(block, 0.0, 0.0, 0.0, block.func_71858_a(5, meta));
        tessellator.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return renderID;
    }
}

