/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.items.tools;

import java.util.List;
import mods.tinker.tconstruct.common.TContent;
import mods.tinker.tconstruct.library.crafting.ToolBuilder;
import mods.tinker.tconstruct.library.tools.AbilityHelper;
import mods.tinker.tconstruct.library.tools.DualHarvestTool;
import mods.tinker.tconstruct.util.PHConstruct;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class Mattock
extends DualHarvestTool {
    static Material[] axeMaterials = new Material[]{Material.field_76245_d, Material.field_76268_x, Material.field_76266_z, Material.field_76254_j, Material.field_76255_k};
    static Material[] shovelMaterials = new Material[]{Material.field_76247_b, Material.field_76248_c, Material.field_76267_y};

    public Mattock(int itemID) {
        super(itemID, 3);
        this.func_77655_b("InfiTool.Mattock");
    }

    @Override
    protected Material[] getEffectiveMaterials() {
        return axeMaterials;
    }

    @Override
    protected Material[] getEffectiveSecondaryMaterials() {
        return shovelMaterials;
    }

    @Override
    protected String getHarvestType() {
        return "axe";
    }

    @Override
    protected String getSecondHarvestType() {
        return "shovel";
    }

    @Override
    public Item getHeadItem() {
        return TContent.hatchetHead;
    }

    @Override
    public Item getAccessoryItem() {
        return TContent.shovelHead;
    }

    @Override
    public int durabilityTypeAccessory() {
        return 2;
    }

    @Override
    public String getIconSuffix(int partType) {
        switch (partType) {
            case 0: {
                return "_mattock_head";
            }
            case 1: {
                return "_mattock_head_broken";
            }
            case 2: {
                return "_mattock_handle";
            }
            case 3: {
                return "_mattock_back";
            }
        }
        return "";
    }

    @Override
    public String getEffectSuffix() {
        return "_mattock_effect";
    }

    @Override
    public String getDefaultFolder() {
        return "mattock";
    }

    @Override
    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float clickX, float clickY, float clickZ) {
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        if (tags.func_74767_n("Broken")) {
            return false;
        }
        return AbilityHelper.hoeGround(stack, player, world, x, y, z, side, this.random);
    }

    @Override
    public void buildTool(int id, String name, List list) {
        if (!PHConstruct.denyMattock || this.allowCrafting(id)) {
            Item accessory = this.getAccessoryItem();
            ItemStack accessoryStack = accessory != null ? new ItemStack(this.getAccessoryItem(), 1, id) : null;
            Item extra = this.getExtraItem();
            ItemStack extraStack = extra != null ? new ItemStack(extra, 1, id) : null;
            ItemStack tool = ToolBuilder.instance.buildTool(new ItemStack(this.getHeadItem(), 1, id), new ItemStack(this.getHandleItem(), 1, id), accessoryStack, extraStack, name + this.getToolName());
            if (tool == null) {
                System.out.println("Creative builder failed tool for " + name + this.getToolName());
                System.out.println("Make sure you do not have item ID conflicts");
            } else {
                tool.func_77978_p().func_74775_l("InfiTool").func_74757_a("Built", true);
                list.add(tool);
            }
        }
    }

    private boolean allowCrafting(int head) {
        int[] nonMetals = new int[]{0, 1, 3, 4, 5, 6, 7, 8, 9, 17};
        for (int i = 0; i < nonMetals.length; ++i) {
            if (head != nonMetals[i]) continue;
            return false;
        }
        return true;
    }
}

