/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.items.tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.tinker.tconstruct.common.TContent;
import mods.tinker.tconstruct.items.tools.BowBase;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class Shortbow
extends BowBase {
    public Shortbow(int itemID) {
        super(itemID);
        this.func_77655_b("InfiTool.Shortbow");
    }

    @Override
    public String getIconSuffix(int partType) {
        switch (partType) {
            case 0: {
                return "_bow_top";
            }
            case 1: {
                return "_bowstring_broken";
            }
            case 2: {
                return "_bowstring";
            }
            case 3: {
                return "_bow_bottom";
            }
        }
        return "";
    }

    @Override
    public String getEffectSuffix() {
        return "_bow_effect";
    }

    @Override
    public String getDefaultFolder() {
        return "shortbow";
    }

    @Override
    public Item getHeadItem() {
        return TContent.toolRod;
    }

    @Override
    public Item getHandleItem() {
        return TContent.bowstring;
    }

    @Override
    public Item getAccessoryItem() {
        return TContent.toolRod;
    }

    @Override
    public String[] toolCategories() {
        return new String[]{"weapon", "ranged", "bow"};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        EntityPlayerSP player;
        ItemStack usingItem;
        super.func_77663_a(stack, world, entity, par4, par5);
        if (entity instanceof EntityPlayerSP && (usingItem = (player = (EntityPlayerSP)entity).func_71011_bu()) != null && usingItem.func_77973_b() == this) {
            player.field_71158_b.field_78900_b *= 2.0f;
            player.field_71158_b.field_78902_a *= 2.0f;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound tags = stack.func_77978_p();
        if (tags.func_74764_b("charge")) {
            String color = "";
            int power = tags.func_74762_e("charge");
            if (power != 0) {
                color = power <= this.getMaxCharge(stack) / 3 ? "\u00a74" : (power > this.getMaxCharge(stack) * 2 / 3 ? "\u00a72" : "\u00a76");
            }
            String charge = color + tags.func_74762_e("charge") + "/" + this.getMaxCharge(stack) + " EU";
            list.add(charge);
        }
        if (tags.func_74764_b("InfiTool")) {
            boolean broken = tags.func_74775_l("InfiTool").func_74767_n("Broken");
            if (broken) {
                list.add("\u00a7oBroken");
            } else {
                int unbreaking;
                String reinforced;
                String extraName;
                String bindingName;
                String handleName;
                int head = tags.func_74775_l("InfiTool").func_74762_e("Head");
                int handle = tags.func_74775_l("InfiTool").func_74762_e("Handle");
                int binding = tags.func_74775_l("InfiTool").func_74762_e("Accessory");
                int extra = tags.func_74775_l("InfiTool").func_74762_e("Extra");
                String headName = this.getAbilityNameForType(head);
                if (!headName.equals("")) {
                    list.add(Shortbow.getStyleForType(head) + headName);
                }
                if (!(handleName = this.getBowstringName(handle)).equals("") && handle != head) {
                    list.add(handleName);
                }
                if (this.getPartAmount() >= 3 && !(bindingName = this.getAbilityNameForType(binding)).equals("") && binding != head && binding != handle) {
                    list.add(Shortbow.getStyleForType(binding) + bindingName);
                }
                if (this.getPartAmount() >= 4 && !(extraName = this.getAbilityNameForType(extra)).equals("") && extra != head && extra != handle && extra != binding) {
                    list.add(Shortbow.getStyleForType(extra) + extraName);
                }
                if (!(reinforced = this.getReinforcedName(head, handle, binding, extra, unbreaking = tags.func_74775_l("InfiTool").func_74762_e("Unbreaking"))).equals("")) {
                    list.add(reinforced);
                }
                boolean displayToolTips = true;
                int tipNum = 0;
                while (displayToolTips) {
                    String tooltip = "Tooltip" + ++tipNum;
                    if (tags.func_74775_l("InfiTool").func_74764_b(tooltip)) {
                        String tipName = tags.func_74775_l("InfiTool").func_74779_i(tooltip);
                        if (tipName.equals("")) continue;
                        list.add(tipName);
                        continue;
                    }
                    displayToolTips = false;
                }
            }
        }
    }

    public String getBowstringName(int type) {
        switch (type) {
            case 0: {
                return "";
            }
            case 1: {
                return "\u00a7bEnchanted";
            }
        }
        return "";
    }
}

