/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.library.tools;

import mods.tinker.tconstruct.library.ActiveToolMod;
import mods.tinker.tconstruct.library.TConstructRegistry;
import mods.tinker.tconstruct.library.tools.HarvestTool;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public abstract class DualHarvestTool
extends HarvestTool {
    public DualHarvestTool(int itemID, int baseDamage) {
        super(itemID, baseDamage);
    }

    @Override
    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        World world = player.field_70170_p;
        int bID = player.field_70170_p.func_72798_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        Block block = Block.field_71973_m[bID];
        if (block == null || bID < 1) {
            return false;
        }
        int hlvl = MinecraftForge.getBlockHarvestLevel((Block)block, (int)meta, (String)this.getHarvestType());
        int shlvl = MinecraftForge.getBlockHarvestLevel((Block)block, (int)meta, (String)this.getSecondHarvestType());
        if (hlvl <= tags.func_74762_e("HarvestLevel") && shlvl <= tags.func_74762_e("HarvestLevel2")) {
            boolean cancelHarvest = false;
            for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
                if (!mod.beforeBlockBreak(this, stack, x, y, z, (EntityLiving)player)) continue;
                cancelHarvest = true;
            }
            return cancelHarvest;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            this.func_77660_a(stack, world, bID, x, y, z, (EntityLiving)player);
        }
        world.func_94571_i(x, y, z);
        if (!world.field_72995_K) {
            world.func_72926_e(2001, x, y, z, bID + (meta << 12));
        }
        return true;
    }

    @Override
    public float getStrVsBlock(ItemStack stack, Block block, int meta) {
        int i;
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        if (tags.func_74767_n("Broken")) {
            return 0.1f;
        }
        Material[] materials = this.getEffectiveMaterials();
        for (i = 0; i < materials.length; ++i) {
            if (materials[i] != block.field_72018_cp) continue;
            float speed = tags.func_74762_e("MiningSpeed");
            speed /= 100.0f;
            int hlvl = MinecraftForge.getBlockHarvestLevel((Block)block, (int)meta, (String)this.getHarvestType());
            int durability = tags.func_74762_e("Damage");
            float shoddy = tags.func_74760_g("Shoddy");
            speed += shoddy * (float)durability / 100.0f;
            if (hlvl <= tags.func_74762_e("HarvestLevel")) {
                return speed;
            }
            return 0.1f;
        }
        materials = this.getEffectiveSecondaryMaterials();
        for (i = 0; i < materials.length; ++i) {
            if (materials[i] != block.field_72018_cp) continue;
            float speed = tags.func_74762_e("MiningSpeed2");
            speed /= 100.0f;
            int hlvl = MinecraftForge.getBlockHarvestLevel((Block)block, (int)meta, (String)this.getHarvestType());
            int durability = tags.func_74762_e("Damage");
            float shoddy = tags.func_74760_g("Shoddy");
            speed += shoddy * (float)durability / 100.0f;
            if (hlvl <= tags.func_74762_e("HarvestLevel2")) {
                return speed;
            }
            return 0.1f;
        }
        return super.getStrVsBlock(stack, block, meta);
    }

    @Override
    public boolean func_77641_a(Block block) {
        if (block.field_72018_cp.func_76229_l()) {
            return true;
        }
        for (Material m : this.getEffectiveMaterials()) {
            if (m != block.field_72018_cp) continue;
            return true;
        }
        for (Material m : this.getEffectiveSecondaryMaterials()) {
            if (m != block.field_72018_cp) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] toolCategories() {
        return new String[]{"harvest", "dualharvest"};
    }

    protected abstract Material[] getEffectiveSecondaryMaterials();

    protected abstract String getSecondHarvestType();
}

