/*
 * Decompiled with CFR 0.152.
 */
package mods.tinker.tconstruct.util;

import java.util.ArrayList;
import java.util.Random;
import mods.tinker.tconstruct.TConstruct;
import mods.tinker.tconstruct.blocks.logic.LiquidTextureLogic;
import mods.tinker.tconstruct.common.TContent;
import mods.tinker.tconstruct.crystal.CrystalValues;
import mods.tinker.tconstruct.crystal.Crystallinity;
import mods.tinker.tconstruct.library.TConstructRegistry;
import mods.tinker.tconstruct.library.crafting.PatternBuilder;
import mods.tinker.tconstruct.library.crafting.Smeltery;
import mods.tinker.tconstruct.library.crafting.ToolBuilder;
import mods.tinker.tconstruct.library.event.PartBuilderEvent;
import mods.tinker.tconstruct.library.event.ToolCraftEvent;
import mods.tinker.tconstruct.library.tools.ArrowMaterial;
import mods.tinker.tconstruct.library.tools.BowMaterial;
import mods.tinker.tconstruct.library.tools.BowstringMaterial;
import mods.tinker.tconstruct.library.tools.FletchingMaterial;
import mods.tinker.tconstruct.library.tools.ToolCore;
import mods.tinker.tconstruct.library.util.ValueCoordTuple;
import mods.tinker.tconstruct.modifiers.ModAttack;
import mods.tinker.tconstruct.util.PHConstruct;
import mods.tinker.tconstruct.util.player.TPlayerStats;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.oredict.OreDictionary;

public class TEventHandler {
    Random random = new Random();

    @ForgeSubscribe
    public void craftTool(ToolCraftEvent.NormalTool event) {
        int modifiers;
        int accessory;
        int handle;
        int head;
        NBTTagCompound toolTag = event.toolTag.func_74775_l("InfiTool");
        if (PHConstruct.denyMattock && event.tool == TContent.mattock && !this.allowCrafting(head = toolTag.func_74762_e("Head"), handle = toolTag.func_74762_e("Handle"), accessory = toolTag.func_74762_e("Accessory"))) {
            event.setResult(Event.Result.DENY);
            return;
        }
        int thaum = 0;
        if (toolTag.func_74762_e("Head") == 31) {
            ++thaum;
        }
        if (toolTag.func_74762_e("Handle") == 31) {
            ++thaum;
        }
        if (toolTag.func_74762_e("Accessory") == 31) {
            ++thaum;
        }
        if (toolTag.func_74762_e("Extra") == 31) {
            ++thaum;
        }
        if (thaum >= 3 || !toolTag.func_74764_b("Accessory") && thaum >= 2) {
            modifiers = toolTag.func_74762_e("Modifiers");
            toolTag.func_74768_a("Modifiers", modifiers += 2);
        } else if (thaum >= 1) {
            modifiers = toolTag.func_74762_e("Modifiers");
            toolTag.func_74768_a("Modifiers", ++modifiers);
        }
        if (event.tool == TContent.shortbow) {
            BowMaterial top = TConstructRegistry.getBowMaterial(toolTag.func_74762_e("Head"));
            BowMaterial bottom = TConstructRegistry.getBowMaterial(toolTag.func_74762_e("Accessory"));
            BowstringMaterial string = (BowstringMaterial)TConstructRegistry.getCustomMaterial(toolTag.func_74762_e("Handle"), BowstringMaterial.class);
            if (top != null && bottom != null && string != null) {
                if (toolTag.func_74762_e("Handle") == 1) {
                    int modifiers2 = toolTag.func_74762_e("Modifiers");
                    toolTag.func_74768_a("Modifiers", ++modifiers2);
                }
                int durability = (int)((float)((top.durability + bottom.durability) / 2) * string.durabilityModifier);
                toolTag.func_74768_a("TotalDurability", durability);
                toolTag.func_74768_a("BaseDurability", durability);
                int drawSpeed = (int)((float)((top.drawspeed + bottom.drawspeed) / 2) * string.drawspeedModifier);
                toolTag.func_74768_a("DrawSpeed", drawSpeed);
                toolTag.func_74768_a("BaseDrawSpeed", drawSpeed);
                float flightSpeed = (top.flightSpeedMax + bottom.flightSpeedMax) / 2.0f * string.flightSpeedModifier;
                toolTag.func_74776_a("FlightSpeed", flightSpeed);
            }
        }
        if (event.tool == TContent.arrow) {
            ArrowMaterial head2 = TConstructRegistry.getArrowMaterial(toolTag.func_74762_e("Head"));
            ArrowMaterial shaft = TConstructRegistry.getArrowMaterial(toolTag.func_74762_e("Handle"));
            FletchingMaterial fletching = (FletchingMaterial)TConstructRegistry.getCustomMaterial(toolTag.func_74762_e("Accessory"), FletchingMaterial.class);
            if (head2 != null && shaft != null && fletching != null) {
                float mass = head2.mass / 5.0f + shaft.mass + fletching.mass;
                float shatter = (head2.breakChance + shaft.breakChance + fletching.breakChance) / 4.0f;
                float accuracy = (head2.accuracy + shaft.accuracy + fletching.accuracy) / 3.0f;
                ItemStack arrow = new ItemStack((Item)event.tool, 4);
                toolTag.func_74768_a("TotalDurability", 0);
                toolTag.func_74776_a("Mass", mass);
                toolTag.func_74776_a("BreakChance", shatter);
                toolTag.func_74776_a("Accuracy", accuracy);
                toolTag.func_74768_a("Unbreaking", 10);
                arrow.func_77982_d(event.toolTag);
                event.overrideResult(arrow);
            }
        }
    }

    private boolean allowCrafting(int head, int handle, int accessory) {
        int[] nonMetals = new int[]{0, 1, 3, 4, 5, 6, 7, 8, 9, 17};
        for (int i = 0; i < nonMetals.length; ++i) {
            if (head != nonMetals[i] && handle != nonMetals[i] && accessory != nonMetals[i]) continue;
            return false;
        }
        return true;
    }

    @ForgeSubscribe
    public void craftPart(PartBuilderEvent.NormalPart event) {
        ItemStack result;
        if (event.pattern.func_77973_b() == TContent.woodPattern && event.pattern.func_77960_j() == 23 && (result = TEventHandler.craftBowString(event.material)) != null) {
            event.overrideResult(new ItemStack[]{result, null});
        }
        if (event.pattern.func_77973_b() == TContent.woodPattern && event.pattern.func_77960_j() == 24 && (result = TEventHandler.craftFletching(event.material)) != null) {
            event.overrideResult(new ItemStack[]{result, null});
        }
    }

    public static ItemStack craftBowString(ItemStack stack) {
        if (stack.field_77994_a < 3) {
            return null;
        }
        BowstringMaterial mat = (BowstringMaterial)TConstructRegistry.getCustomMaterial(stack, BowstringMaterial.class);
        if (mat != null) {
            return mat.craftingItem.func_77946_l();
        }
        return null;
    }

    public static ItemStack craftFletching(ItemStack stack) {
        if (TEventHandler.matchesLeaves(stack)) {
            FletchingMaterial leaves = (FletchingMaterial)TConstructRegistry.getCustomMaterial(new ItemStack((Block)Block.field_71952_K), FletchingMaterial.class);
            return leaves.craftingItem.func_77946_l();
        }
        FletchingMaterial mat = (FletchingMaterial)TConstructRegistry.getCustomMaterial(stack, FletchingMaterial.class);
        if (mat != null) {
            return mat.craftingItem.func_77946_l();
        }
        return null;
    }

    public static boolean matchesLeaves(ItemStack stack) {
        if (stack.field_77993_c >= 4095) {
            return false;
        }
        Block block = Block.field_71973_m[stack.field_77993_c];
        return block != null && block.isLeaves(null, 0, 0, 0);
    }

    @ForgeSubscribe
    public void onHurt(LivingHurtEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            ItemStack stack = player.func_71045_bC();
            if (stack != null && stack.func_77973_b() == TContent.cutlass && player.func_71039_bw()) {
                player.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 60, 1));
            }
            if (PHConstruct.alphaHunger) {
                player.func_71024_bL().func_75114_a(10);
            }
        }
    }

    @ForgeSubscribe
    public void onLivingDrop(LivingDropsEvent event) {
        int beheading;
        ItemStack stack;
        EntityItem entityitem;
        ItemStack dropStack;
        if (this.random.nextInt(500) == 0 && event.entityLiving instanceof IMob && event.entityLiving.field_71093_bK == 0) {
            dropStack = new ItemStack(TContent.heartCanister, 1, 1);
            entityitem = new EntityItem(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, dropStack);
            entityitem.field_70293_c = 10;
            event.drops.add(entityitem);
        }
        if (event.entityLiving instanceof EntityWither && this.random.nextInt(5) == 0) {
            dropStack = new ItemStack(TContent.heartCanister, 1, 1);
            entityitem = new EntityItem(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, dropStack);
            entityitem.field_70293_c = 10;
            event.drops.add(entityitem);
        }
        if (!event.entityLiving.func_70631_g_()) {
            if (event.entityLiving.getClass() == EntityCow.class) {
                int amount = this.random.nextInt(3) + this.random.nextInt(1 + event.lootingLevel) + this.random.nextInt(3) + this.random.nextInt(1 + event.lootingLevel) + 1;
                for (int iter = 0; iter < amount; ++iter) {
                    this.addDrops(event, new ItemStack(Item.field_77770_aF, 1));
                }
            } else if (event.entityLiving.getClass() == EntityChicken.class) {
                int amount = this.random.nextInt(3) + this.random.nextInt(1 + event.lootingLevel) + this.random.nextInt(3) + this.random.nextInt(1 + event.lootingLevel) + 1;
                for (int iter = 0; iter < amount; ++iter) {
                    this.addDrops(event, new ItemStack(Item.field_77676_L, 1));
                }
            }
        }
        if (event.recentlyHit) {
            if (event.entityLiving.getClass() == EntitySkeleton.class) {
                EntityPlayer player;
                EntitySkeleton enemy = (EntitySkeleton)event.entityLiving;
                if (event.source.field_76373_n.equals("player") && (stack = (player = (EntityPlayer)event.source.func_76346_g()).func_71045_bC()) != null && stack.func_77942_o() && stack.func_77973_b() instanceof ToolCore) {
                    beheading = stack.func_77978_p().func_74775_l("InfiTool").func_74762_e("Beheading");
                    if (stack.func_77973_b() == TContent.cleaver) {
                        beheading += 2;
                    }
                    if (beheading > 0 && this.random.nextInt(100) < beheading * 10) {
                        this.addDrops(event, new ItemStack(Item.field_82799_bQ.field_77779_bT, 1, enemy.func_82202_m()));
                    }
                }
                if (enemy.func_82202_m() == 1 && this.random.nextInt(Math.max(1, 5 - event.lootingLevel)) == 0) {
                    this.addDrops(event, new ItemStack(TContent.materials, 1, 8));
                }
            }
            if (event.entityLiving.getClass() == EntityZombie.class) {
                EntityPlayer player;
                EntityZombie enemy = (EntityZombie)event.entityLiving;
                if (event.source.field_76373_n.equals("player") && (stack = (player = (EntityPlayer)event.source.func_76346_g()).func_71045_bC()) != null && stack.func_77942_o() && stack.func_77973_b() instanceof ToolCore) {
                    beheading = stack.func_77978_p().func_74775_l("InfiTool").func_74762_e("Beheading");
                    if (stack.func_77973_b() == TContent.cleaver) {
                        beheading += 2;
                    }
                    if (beheading > 0 && this.random.nextInt(100) < beheading * 10) {
                        this.addDrops(event, new ItemStack(Item.field_82799_bQ.field_77779_bT, 1, 2));
                    }
                }
            }
            if (event.entityLiving.getClass() == EntityCreeper.class) {
                EntityPlayer player;
                EntityCreeper enemy = (EntityCreeper)event.entityLiving;
                if (event.source.field_76373_n.equals("player") && (stack = (player = (EntityPlayer)event.source.func_76346_g()).func_71045_bC()) != null && stack.func_77942_o() && stack.func_77973_b() instanceof ToolCore) {
                    beheading = stack.func_77978_p().func_74775_l("InfiTool").func_74762_e("Beheading");
                    if (stack.func_77973_b() == TContent.cleaver) {
                        beheading += 2;
                    }
                    if (beheading > 0 && this.random.nextInt(100) < beheading * 5) {
                        this.addDrops(event, new ItemStack(Item.field_82799_bQ.field_77779_bT, 1, 4));
                    }
                }
            }
        }
        if (event.entityLiving.getClass() == EntityGhast.class) {
            if (PHConstruct.uhcGhastDrops) {
                for (EntityItem o : event.drops) {
                    if (o.func_92059_d().field_77993_c != Item.field_77732_bp.field_77779_bT) continue;
                    o.func_92058_a(new ItemStack(Item.field_77717_p, 1));
                }
            } else {
                this.addDrops(event, new ItemStack(Item.field_77732_bp, 1));
            }
        }
        if (event.entityLiving instanceof EntityPlayer) {
            TPlayerStats stats;
            EntityPlayer source;
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            if (PHConstruct.dropPlayerHeads) {
                ItemStack dropStack2 = new ItemStack(Item.field_82799_bQ.field_77779_bT, 1, 3);
                NBTTagCompound nametag = new NBTTagCompound();
                nametag.func_74778_a("SkullOwner", player.field_71092_bJ);
                dropStack2.func_77982_d(nametag);
                this.addDrops(event, dropStack2);
            } else if (event.source.field_76373_n.equals("player") && (stack = (source = (EntityPlayer)event.source.func_76346_g()).func_71045_bC()) != null && stack.func_77942_o() && stack.func_77973_b() instanceof ToolCore) {
                beheading = stack.func_77978_p().func_74775_l("InfiTool").func_74762_e("Beheading");
                if (stack.func_77973_b() == TContent.cleaver) {
                    beheading += 2;
                }
                if (beheading > 0 && this.random.nextInt(100) < beheading * 50) {
                    ItemStack dropStack3 = new ItemStack(Item.field_82799_bQ.field_77779_bT, 1, 3);
                    NBTTagCompound nametag = new NBTTagCompound();
                    nametag.func_74778_a("SkullOwner", player.field_71092_bJ);
                    dropStack3.func_77982_d(nametag);
                    this.addDrops(event, dropStack3);
                }
            }
            if (!player.field_70170_p.func_82736_K().func_82766_b("keepInventory") && (stats = TConstruct.playerTracker.getPlayerStats(player.field_71092_bJ)) != null) {
                stats.armor.dropItems();
                stats.knapsack.dropItems();
            }
        }
    }

    void addDrops(LivingDropsEvent event, ItemStack dropStack) {
        EntityItem entityitem = new EntityItem(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, dropStack);
        entityitem.field_70293_c = 10;
        event.drops.add(entityitem);
    }

    @ForgeSubscribe
    public void onLivingSpawn(LivingSpawnEvent.SpecialSpawn event) {
        if (event.entityLiving.getClass() == EntitySpider.class && this.random.nextInt(100) == 0) {
            EntityCreeper creeper = new EntityCreeper(event.entityLiving.field_70170_p);
            TEventHandler.spawnEntity(event.entityLiving.field_70165_t, event.entityLiving.field_70163_u + 1.0, event.entityLiving.field_70161_v, (Entity)creeper, event.entityLiving.field_70170_p);
            creeper.func_70078_a((Entity)event.entityLiving);
        }
    }

    public static void spawnEntity(double x, double y, double z, Entity entity, World world) {
        if (!world.field_72995_K) {
            entity.func_70107_b(x, y, z);
            ((EntityLiving)entity).func_82163_bD();
            world.func_72838_d(entity);
        }
    }

    @ForgeSubscribe
    public void chunkDataLoad(ChunkDataEvent.Load event) {
        Chunk chunk = event.getChunk();
        int worldID = chunk.field_76637_e.field_73011_w.field_76574_g;
        ValueCoordTuple coord = new ValueCoordTuple(worldID, chunk.field_76635_g, chunk.field_76647_h);
        CrystalValues theft = new CrystalValues("Theft");
        Crystallinity.theftValue.put(coord, theft.loadFromNBT(event.getData()));
        CrystalValues charge = new CrystalValues("Charge");
        Crystallinity.theftValue.put(coord, charge.loadFromNBT(event.getData()));
    }

    @ForgeSubscribe
    public void chunkDataSave(ChunkDataEvent.Save event) {
        CrystalValues crystal;
        Chunk chunk = event.getChunk();
        int worldID = chunk.field_76637_e.field_73011_w.field_76574_g;
        ValueCoordTuple coord = new ValueCoordTuple(worldID, chunk.field_76635_g, chunk.field_76647_h);
        if (Crystallinity.theftValue.containsKey(coord)) {
            crystal = (CrystalValues)Crystallinity.theftValue.get(coord);
            crystal.saveToNBT(event.getData());
            if (!event.getChunk().field_76636_d) {
                Crystallinity.theftValue.remove(coord);
            }
        }
        if (Crystallinity.charge.containsKey(coord)) {
            crystal = (CrystalValues)Crystallinity.charge.get(coord);
            crystal.saveToNBT(event.getData());
            if (!event.getChunk().field_76636_d) {
                Crystallinity.charge.remove(coord);
            }
        }
    }

    @ForgeSubscribe
    public void bonemealEvent(BonemealEvent event) {
        if (!event.world.field_72995_K && event.ID == TContent.slimeSapling.field_71990_ca && TContent.slimeSapling.boneFertilize(event.world, event.X, event.Y, event.Z, event.world.field_73012_v, event.entityPlayer)) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @ForgeSubscribe
    public void registerOre(OreDictionary.OreRegisterEvent evt) {
        String ingot = evt.Name.toLowerCase();
        if (ingot.contains("ingot")) {
            TConstruct.tableCasting.addCastingRecipe(new ItemStack(TContent.metalPattern, 1, 0), new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 8), evt.Ore, false, 50);
            TConstruct.tableCasting.addCastingRecipe(new ItemStack(TContent.metalPattern, 1, 0), new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 288, 1), evt.Ore, false, 50);
        }
        if (evt.Name == "battery") {
            TContent.modE.batteries.add(evt.Ore);
        } else if (evt.Name == "basicCircuit") {
            TContent.modE.circuits.add(evt.Ore);
        } else if (evt.Name == "plankWood") {
            PatternBuilder.instance.registerMaterial(evt.Ore, 2, "Wood");
        } else if (evt.Name == "crystalQuartz") {
            ToolBuilder.registerToolMod(new ModAttack("Quartz", new ItemStack[]{evt.Ore}, 11, 2));
        } else if (evt.Name == "crystalCerusQuartz") {
            ToolBuilder.registerToolMod(new ModAttack("Quartz", new ItemStack[]{evt.Ore}, 11, 24));
        } else if (evt.Name == "ingotCopper") {
            PatternBuilder.instance.registerMaterial(evt.Ore, 2, "Copper");
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 3, 450, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 2));
        } else if (evt.Name == "ingotTin") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 5, 175, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 3));
        } else if (evt.Name == "ingotBronze") {
            PatternBuilder.instance.registerMaterial(evt.Ore, 2, "Bronze");
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 4, 500, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 7));
        } else if (evt.Name == "ingotCobalt") {
            PatternBuilder.instance.registerMaterial(evt.Ore, 2, "Cobalt");
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 650, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 5));
        } else if (evt.Name == "ingotArdite") {
            PatternBuilder.instance.registerMaterial(evt.Ore, 2, "Ardite");
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 1, 650, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 6));
        } else if (evt.Name == "ingotManyullyn") {
            PatternBuilder.instance.registerMaterial(evt.Ore, 2, "Manyullyn");
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 2, 750, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 9));
        } else if (evt.Name == "ingotNaturalAluminum") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 6, 250, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 4));
        } else if (evt.Name == "naturalAluminum") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 6, 250, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 4));
        } else if (evt.Name == "ingotAluminumBrass") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 7, 350, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 8));
        } else if (evt.Name == "ingotAlumite") {
            PatternBuilder.instance.registerMaterial(evt.Ore, 2, "Alumite");
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 8, 500, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 10));
        } else if (evt.Name == "ingotSteel") {
            PatternBuilder.instance.registerMaterial(evt.Ore, 2, "Steel");
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 9, 500, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 12));
        } else if (evt.Name == "ingotNickel") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 17));
        } else if (evt.Name == "ingotLead") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 18));
        } else if (evt.Name == "ingotSilver") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 19));
        } else if (evt.Name == "ingotPlatinum") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 20));
        } else if (evt.Name == "ingotInvar") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 21));
        } else if (evt.Name == "ingotElectrum") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 22));
        } else if (evt.Name == "oreCopper") {
            Smeltery.addMelting(evt.Ore, 550, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 288, 2));
        } else if (evt.Name == "oreTin") {
            Smeltery.addMelting(evt.Ore, 275, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 288, 3));
        } else if (evt.Name == "oreNaturalAluminum") {
            Smeltery.addMelting(evt.Ore, 350, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 288, 4));
        } else if (evt.Name == "oreCobalt") {
            Smeltery.addMelting(evt.Ore, 750, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 288, 5));
        } else if (evt.Name == "oreArdite") {
            Smeltery.addMelting(evt.Ore, 750, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 288, 6));
        } else if (evt.Name == "oreNickel") {
            Smeltery.addMelting(evt.Ore, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 288, 17));
        } else if (evt.Name == "oreLead") {
            Smeltery.addMelting(evt.Ore, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 288, 18));
        } else if (evt.Name == "oreSilver") {
            Smeltery.addMelting(evt.Ore, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 288, 19));
        } else if (evt.Name == "orePlatinum") {
            Smeltery.addMelting(evt.Ore, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 288, 20));
        } else if (evt.Name == "oreInvar") {
            Smeltery.addMelting(evt.Ore, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 288, 21));
        } else if (evt.Name == "oreElectrum") {
            Smeltery.addMelting(evt.Ore, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 288, 22));
        } else if (evt.Name == "blockCopper") {
            Smeltery.addMelting(evt.Ore, 550, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 2));
        } else if (evt.Name == "blockTin") {
            Smeltery.addMelting(evt.Ore, 275, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 3));
        } else if (evt.Name == "blockBronze") {
            Smeltery.addMelting(evt.Ore, 500, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 7));
        } else if (evt.Name == "blockNaturalAluminum") {
            Smeltery.addMelting(evt.Ore, 350, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 4));
        } else if (evt.Name == "blockCobalt") {
            Smeltery.addMelting(evt.Ore, 750, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 5));
        } else if (evt.Name == "blockArdite") {
            Smeltery.addMelting(evt.Ore, 750, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 6));
        } else if (evt.Name == "blockManyullyn") {
            Smeltery.addMelting(evt.Ore, 800, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 9));
        } else if (evt.Name == "blockAluminumBrass") {
            Smeltery.addMelting(evt.Ore, 350, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 8));
        } else if (evt.Name == "blockAlumite") {
            Smeltery.addMelting(evt.Ore, 500, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 10));
        } else if (evt.Name == "blockSteel") {
            Smeltery.addMelting(evt.Ore, 500, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 12));
        } else if (evt.Name == "blockNickel") {
            Smeltery.addMelting(evt.Ore, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 17));
        } else if (evt.Name == "blockLead") {
            Smeltery.addMelting(evt.Ore, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 18));
        } else if (evt.Name == "blockSilver") {
            Smeltery.addMelting(evt.Ore, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 19));
        } else if (evt.Name == "blockPlatinum") {
            Smeltery.addMelting(evt.Ore, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 20));
        } else if (evt.Name == "blockInvar") {
            Smeltery.addMelting(evt.Ore, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 21));
        } else if (evt.Name == "blockElectrum") {
            Smeltery.addMelting(evt.Ore, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 22));
        } else if (evt.Name == "dustIron") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 0, evt.Ore.func_77960_j()), Block.field_72083_ai.field_71990_ca, 0, 600, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 0));
        } else if (evt.Name == "dustGold") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 1, evt.Ore.func_77960_j()), Block.field_72105_ah.field_71990_ca, 0, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 1));
        } else if (evt.Name == "dustCopper") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 3, 450, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 2));
        } else if (evt.Name == "dustTin") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 5, 175, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 3));
        } else if (evt.Name == "dustBronze") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 4, 500, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 7));
        } else if (evt.Name == "dustCobalt") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 650, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 5));
        } else if (evt.Name == "dustArdite") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 1, 650, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 6));
        } else if (evt.Name == "dustManyullyn") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 2, 750, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 9));
        } else if (evt.Name == "dustAluminum") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 6, 250, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 4));
        } else if (evt.Name == "dustNaturalAluminum") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 6, 250, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 4));
        } else if (evt.Name == "dustAluminumBrass") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 7, 350, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 8));
        } else if (evt.Name == "dustAlumite") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 8, 500, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 10));
        } else if (evt.Name == "dustSteel") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 9, 500, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 12));
        } else if (evt.Name == "dustNickel") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 9, 500, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 16));
        } else if (evt.Name == "dustLead") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 9, 500, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 17));
        } else if (evt.Name == "dustSilver") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 9, 500, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 18));
        } else if (evt.Name == "dustPlatinum") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 9, 500, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 19));
        } else if (evt.Name == "dustInvar") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 9, 500, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 20));
        } else if (evt.Name == "dustElectrum") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 9, 500, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 21));
        } else if (evt.Name == "nuggetIron") {
            Smeltery.addMelting(new ItemStack(evt.Ore.field_77993_c, 2, evt.Ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 3, 450, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 16, 0));
        }
    }

    public void unfuxOreDictionary() {
        ArrayList ores = OreDictionary.getOres((String)"plankWood");
        for (ItemStack ore : ores) {
            PatternBuilder.instance.registerMaterial(ore, 2, "Wood");
        }
        ores = OreDictionary.getOres((String)"ingotCopper");
        for (ItemStack ore : ores) {
            PatternBuilder.instance.registerMaterial(ore, 2, "Copper");
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 3, 450, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 2));
        }
        ores = OreDictionary.getOres((String)"ingotTin");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 5, 175, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 3));
        }
        ores = OreDictionary.getOres((String)"ingotBronze");
        for (ItemStack ore : ores) {
            PatternBuilder.instance.registerMaterial(ore, 2, "Bronze");
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 4, 500, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 7));
        }
        ores = OreDictionary.getOres((String)"ingotCobalt");
        for (ItemStack ore : ores) {
            PatternBuilder.instance.registerMaterial(ore, 2, "Cobalt");
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 650, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 5));
        }
        ores = OreDictionary.getOres((String)"ingotArdite");
        for (ItemStack ore : ores) {
            PatternBuilder.instance.registerMaterial(ore, 2, "Ardite");
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 1, 650, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 6));
        }
        ores = OreDictionary.getOres((String)"ingotManyullyn");
        for (ItemStack ore : ores) {
            PatternBuilder.instance.registerMaterial(ore, 2, "Manyullyn");
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 2, 750, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 9));
        }
        ores = OreDictionary.getOres((String)"naturalAluminum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 6, 250, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 4));
        }
        ores = OreDictionary.getOres((String)"ingotNaturalAluminum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 6, 250, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 4));
        }
        ores = OreDictionary.getOres((String)"ingotAluminumBrass");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 7, 350, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 8));
        }
        ores = OreDictionary.getOres((String)"ingotAlumite");
        for (ItemStack ore : ores) {
            PatternBuilder.instance.registerMaterial(ore, 2, "Alumite");
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 8, 500, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 10));
        }
        ores = OreDictionary.getOres((String)"ingotSteel");
        for (ItemStack ore : ores) {
            PatternBuilder.instance.registerMaterial(ore, 2, "Steel");
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 9, 500, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 12));
        }
        ores = OreDictionary.getOres((String)"ingotSteel");
        for (ItemStack ore : ores) {
            PatternBuilder.instance.registerMaterial(ore, 2, "Steel");
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 9, 500, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 12));
        }
        ores = OreDictionary.getOres((String)"ingotNickel");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 17));
        }
        ores = OreDictionary.getOres((String)"ingotLead");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 18));
        }
        ores = OreDictionary.getOres((String)"ingotSilver");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 19));
        }
        ores = OreDictionary.getOres((String)"ingotPlatinum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 20));
        }
        ores = OreDictionary.getOres((String)"ingotInvar");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 21));
        }
        ores = OreDictionary.getOres((String)"ingotElectrum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 22));
        }
        ores = OreDictionary.getOres((String)"oreCopper");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 550, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 288, 2));
        }
        ores = OreDictionary.getOres((String)"oreTin");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 275, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 288, 3));
        }
        ores = OreDictionary.getOres((String)"oreNaturalAluminum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 350, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 288, 4));
        }
        ores = OreDictionary.getOres((String)"oreCobalt");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 750, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 288, 5));
        }
        ores = OreDictionary.getOres((String)"oreArdite");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 750, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 288, 6));
        }
        ores = OreDictionary.getOres((String)"oreNickel");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 288, 17));
        }
        ores = OreDictionary.getOres((String)"oreLead");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 288, 18));
        }
        ores = OreDictionary.getOres((String)"oreSilver");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 288, 19));
        }
        ores = OreDictionary.getOres((String)"orePlatinum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 288, 20));
        }
        ores = OreDictionary.getOres((String)"oreInvar");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 288, 21));
        }
        ores = OreDictionary.getOres((String)"oreElectrum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 288, 22));
        }
        ores = OreDictionary.getOres((String)"blockCopper");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 550, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 2));
        }
        ores = OreDictionary.getOres((String)"blockTin");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 275, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 3));
        }
        ores = OreDictionary.getOres((String)"blockBronze");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 500, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 7));
        }
        ores = OreDictionary.getOres((String)"blockNaturalAluminum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 350, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 4));
        }
        ores = OreDictionary.getOres((String)"blockCobalt");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 750, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 5));
        }
        ores = OreDictionary.getOres((String)"blockArdite");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 750, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 6));
        }
        ores = OreDictionary.getOres((String)"blockManyullyn");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 800, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 9));
        }
        ores = OreDictionary.getOres((String)"blockAluminumBrass");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 350, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 8));
        }
        ores = OreDictionary.getOres((String)"blockAlumite");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 500, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 10));
        }
        ores = OreDictionary.getOres((String)"blockSteel");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 500, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 12));
        }
        ores = OreDictionary.getOres((String)"blockNickel");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 17));
        }
        ores = OreDictionary.getOres((String)"blockLead");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 18));
        }
        ores = OreDictionary.getOres((String)"blockSilver");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 19));
        }
        ores = OreDictionary.getOres((String)"blockPlatinum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 20));
        }
        ores = OreDictionary.getOres((String)"blockInvar");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 21));
        }
        ores = OreDictionary.getOres((String)"blockElectrum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(ore, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 1296, 22));
        }
        ores = OreDictionary.getOres((String)"dustIron");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 0, ore.func_77960_j()), Block.field_72083_ai.field_71990_ca, 0, 600, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 0));
        }
        ores = OreDictionary.getOres((String)"dustGold");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 1, ore.func_77960_j()), Block.field_72105_ah.field_71990_ca, 0, 450, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 1));
        }
        ores = OreDictionary.getOres((String)"dustCopper");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 3, 450, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 2));
        }
        ores = OreDictionary.getOres((String)"dustTin");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 5, 175, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 3));
        }
        ores = OreDictionary.getOres((String)"dustBronze");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 4, 500, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 7));
        }
        ores = OreDictionary.getOres((String)"dustCobalt");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 650, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 5));
        }
        ores = OreDictionary.getOres((String)"dustArdite");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 1, 650, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 6));
        }
        ores = OreDictionary.getOres((String)"dustManyullyn");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 2, 750, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 9));
        }
        ores = OreDictionary.getOres((String)"dustNaturalAluminum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 6, 250, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 4));
        }
        ores = OreDictionary.getOres((String)"dustAluminumBrass");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 7, 350, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 8));
        }
        ores = OreDictionary.getOres((String)"dustAlumite");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 8, 500, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 10));
        }
        ores = OreDictionary.getOres((String)"dustSteel");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 9, 500, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 12));
        }
        ores = OreDictionary.getOres((String)"dustNickel");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 17));
        }
        ores = OreDictionary.getOres((String)"dustLead");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 18));
        }
        ores = OreDictionary.getOres((String)"dustSilver");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 19));
        }
        ores = OreDictionary.getOres((String)"dustPlatinum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 20));
        }
        ores = OreDictionary.getOres((String)"dustInvar");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 21));
        }
        ores = OreDictionary.getOres((String)"dustElectrum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 144, 22));
        }
        ores = OreDictionary.getOres((String)"nuggetIron");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 3, 450, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 16, 0));
        }
        ores = OreDictionary.getOres((String)"nuggetCopper");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 3, 450, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 16, 2));
        }
        ores = OreDictionary.getOres((String)"nuggetTin");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 5, 175, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 16, 3));
        }
        ores = OreDictionary.getOres((String)"nuggetNaturalAluminum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 6, 250, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 16, 4));
        }
        ores = OreDictionary.getOres((String)"nuggetNickel");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 16, 17));
        }
        ores = OreDictionary.getOres((String)"nuggetLead");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 16, 18));
        }
        ores = OreDictionary.getOres((String)"nuggetSilver");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 16, 19));
        }
        ores = OreDictionary.getOres((String)"nuggetPlatinum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 16, 20));
        }
        ores = OreDictionary.getOres((String)"nuggetInvar");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 16, 21));
        }
        ores = OreDictionary.getOres((String)"nuggetElectrum");
        for (ItemStack ore : ores) {
            Smeltery.addMelting(new ItemStack(ore.field_77993_c, 2, ore.func_77960_j()), TContent.metalBlock.field_71990_ca, 0, 400, new LiquidStack(TContent.liquidMetalStill.field_71990_ca, 16, 22));
        }
    }

    @ForgeSubscribe
    public void bucketFill(FillBucketEvent evt) {
        if (evt.current.func_77973_b() == Item.field_77788_aw && evt.target.field_72313_a == EnumMovingObjectType.TILE) {
            int hitX = evt.target.field_72311_b;
            int hitY = evt.target.field_72312_c;
            int hitZ = evt.target.field_72309_d;
            if (evt.entityPlayer != null && !evt.entityPlayer.func_82247_a(hitX, hitY, hitZ, evt.target.field_72310_e, evt.current)) {
                return;
            }
            int bID = evt.world.func_72798_a(hitX, hitY, hitZ);
            int meta = -1;
            if (bID == TContent.liquidMetalStill.field_71990_ca) {
                LiquidTextureLogic logic = (LiquidTextureLogic)evt.world.func_72796_p(hitX, hitY, hitZ);
                meta = logic.getLiquidType();
            }
            if (meta != -1) {
                evt.world.func_94571_i(hitX, hitY, hitZ);
                evt.result = new ItemStack(TContent.buckets, 1, meta);
                evt.setResult(Event.Result.ALLOW);
            }
        }
    }
}

