/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.plugins.minefactoryreloaded.harvestables;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.api.IFactoryHarvestable;

public class HarvestableNaturaCropPlant
implements IFactoryHarvestable {
    private int _sourceId;
    private int _cottonItemId;

    public HarvestableNaturaCropPlant(int sourceId, int cottonItemId) {
        this._sourceId = sourceId;
        this._cottonItemId = cottonItemId;
    }

    @Override
    public int getPlantId() {
        return this._sourceId;
    }

    @Override
    public HarvestType getHarvestType() {
        return HarvestType.Normal;
    }

    @Override
    public boolean breakBlock() {
        return false;
    }

    @Override
    public boolean canBeHarvested(World world, Map harvesterSettings, int x, int y, int z) {
        return world.func_72805_g(x, y, z) == 3 || world.func_72805_g(x, y, z) == 8;
    }

    @Override
    public List getDrops(World world, Random rand, Map harvesterSettings, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == 8) {
            ItemStack[] returnItems = new ItemStack[]{new ItemStack(this._cottonItemId, 1, 3)};
            return Arrays.asList(returnItems);
        }
        return Block.field_71973_m[this._sourceId].getBlockDropped(world, x, y, z, world.func_72805_g(x, y, z), 0);
    }

    @Override
    public void preHarvest(World world, int x, int y, int z) {
    }

    @Override
    public void postHarvest(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == 3) {
            world.func_94571_i(x, y, z);
        } else if (world.func_72805_g(x, y, z) == 8) {
            world.func_72921_c(x, y, z, 6, 2);
        }
    }
}

