/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraftforge.common.MinecraftForge;
import shukaro.artifice.ArtificeBlocks;
import shukaro.artifice.ArtificeConfig;
import shukaro.artifice.ArtificeItems;
import shukaro.artifice.ArtificeTooltips;
import shukaro.artifice.event.EventHandler;
import shukaro.artifice.multiblock.TileEntityMultiblock;
import shukaro.artifice.net.ClientProxy;
import shukaro.artifice.net.CommonProxy;
import shukaro.artifice.recipe.ArtificeRecipes;
import shukaro.artifice.world.ArtificeWorldGen;

@Mod(modid="Artifice", name="Artifice", version="1.5.2R1.1.2")
public class ArtificeCore {
    @SidedProxy(clientSide="shukaro.artifice.net.ClientProxy", serverSide="shukaro.artifice.net.CommonProxy")
    public static CommonProxy proxy;
    public static final String modID = "Artifice";
    public static final String modName = "Artifice";
    public static final String modVersion = "1.5.2R1.1.2";
    public static ArtificeWorldGen worldGen;
    public static Logger logger;
    public static EventHandler eventHandler;
    public static int frameRenderID;
    public static int lotusRenderID;
    public static String[] tiers;
    public static String[] flora;
    public static String[] rocks;
    @Mod.Instance(value="Artifice")
    public static ArtificeCore instance;

    @Mod.ServerStarting
    public void serverStarting(FMLServerStartingEvent evt) {
    }

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent evt) {
        ArtificeConfig.setConfigFolderBase(evt.getModConfigurationDirectory());
        ArtificeConfig.initCommon(evt);
        ArtificeConfig.initClient(evt);
        ArtificeConfig.extractLang(new String[]{"en_US"});
        ArtificeConfig.loadLang();
        logger = evt.getModLog();
        eventHandler = new EventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        ClientProxy.init();
        CommonProxy.init();
    }

    @Mod.Init
    public void init(FMLInitializationEvent evt) {
        ArtificeBlocks.initBlocks();
        ArtificeItems.initItems();
        ArtificeTooltips.initTooltips();
        if (ArtificeConfig.enableWorldGen.getBoolean(true)) {
            worldGen = new ArtificeWorldGen();
            GameRegistry.registerWorldGenerator((IWorldGenerator)worldGen);
        }
        if (ArtificeConfig.floraBoneMeal.getBoolean(true) && ArtificeConfig.enableWorldGen.getBoolean(true)) {
            MinecraftForge.addGrassPlant((Block)ArtificeBlocks.blockFlora, (int)0, (int)10);
            MinecraftForge.addGrassPlant((Block)ArtificeBlocks.blockFlora, (int)1, (int)10);
            MinecraftForge.addGrassPlant((Block)ArtificeBlocks.blockFlora, (int)2, (int)10);
            MinecraftForge.addGrassPlant((Block)ArtificeBlocks.blockFlora, (int)3, (int)10);
        }
        ArtificeRecipes.registerRecipes();
        GameRegistry.registerTileEntity(TileEntityMultiblock.class, (String)"ArtificeMultiblock");
    }

    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent evt) {
    }

    static {
        tiers = new String[]{"Basic", "Reinforced", "Industrial", "Advanced"};
        flora = new String[]{"Bluebell", "Orchid", "Iris", "Lotus", "LotusClosed"};
        rocks = new String[]{"", "Cobblestone", "Brick", "Paver", "Antipaver", "Chiseled"};
    }
}

