/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.block.frame;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import shukaro.artifice.ArtificeConfig;
import shukaro.artifice.ArtificeCore;
import shukaro.artifice.block.frame.BlockFrame;
import shukaro.artifice.render.IconHandler;
import shukaro.artifice.render.connectedtexture.ConnectedTexture;
import shukaro.artifice.render.connectedtexture.ConnectedTextureBase;
import shukaro.artifice.render.connectedtexture.IConnectedTexture;
import shukaro.artifice.render.connectedtexture.ILayeredRender;
import shukaro.artifice.render.connectedtexture.SolidConnectedTexture;
import shukaro.artifice.util.BlockCoord;

public class BlockFrameScaffold
extends BlockFrame
implements IConnectedTexture,
ILayeredRender {
    private static final ForgeDirection[] sides = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.DOWN};
    private Icon[] sideIcons = new Icon[ArtificeCore.tiers.length];
    private Icon[] vertIcons = new Icon[ArtificeCore.tiers.length];
    private ConnectedTextureBase basic = new SolidConnectedTexture(ConnectedTexture.BasicFrame);
    private ConnectedTextureBase reinforced = new SolidConnectedTexture(ConnectedTexture.ReinforcedFrame);
    private ConnectedTextureBase industrial = new SolidConnectedTexture(ConnectedTexture.IndustrialFrame);
    private ConnectedTextureBase advanced = new SolidConnectedTexture(ConnectedTexture.AdvancedFrame);

    public BlockFrameScaffold(int id) {
        super(id);
        this.func_71864_b("artifice.scaffold");
    }

    public void func_71869_a(World world, int x, int y, int z, Entity entity) {
        if (entity instanceof EntityPlayerMP) {
            ((EntityPlayerMP)entity).field_71135_a.field_72572_g = 0;
            entity.field_70143_R = 0.0f;
        }
    }

    public void func_71921_a(World world, int x, int y, int z, EntityPlayer player) {
        ItemStack held = player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c];
        if (held != null && held.field_77993_c == this.field_71990_ca && held.func_77960_j() == world.func_72805_g(x, y, z)) {
            while (world.func_72798_a(x, y, z) == this.field_71990_ca) {
                ++y;
            }
            if (this.checkStay(world, x, y, z, held.func_77960_j()) && (Block.field_71973_m[world.func_72798_a(x, y, z)] == null || Block.field_71973_m[world.func_72798_a(x, y, z)].isAirBlock(world, x, y, z))) {
                world.func_72832_d(x, y, z, this.field_71990_ca, held.func_77960_j(), 3);
                if (!player.field_71075_bZ.field_75098_d) {
                    --held.field_77994_a;
                    if (held.field_77994_a <= 0) {
                        held = null;
                    }
                }
            }
        }
    }

    public boolean func_94331_a(World world, int x, int y, int z, int side, ItemStack stack) {
        return this.checkStay(world, x, y, z, stack.func_77960_j());
    }

    public int getOverhang(int meta) {
        switch (meta) {
            case 0: {
                return 4;
            }
            case 1: {
                return 8;
            }
            case 2: {
                return 12;
            }
            case 3: {
                return 16;
            }
        }
        return 0;
    }

    public boolean func_71854_d(World world, int x, int y, int z) {
        return this.checkStay(world, x, y, z, world.func_72805_g(x, y, z));
    }

    public boolean checkStay(World world, int x, int y, int z, int meta) {
        BlockCoord c = new BlockCoord(x, y, z);
        if (this.isRooted(world, x, y, z, meta)) {
            return true;
        }
        for (ForgeDirection d : sides) {
            BlockCoord t = c.copy().offset(d.ordinal());
            if (!(t.getBlock(world) instanceof BlockFrameScaffold)) continue;
            if (t.blockEquals(world, this.field_71990_ca, meta)) {
                if (this.isRooted(world, t.x, t.y, t.z, meta)) {
                    return true;
                }
                for (BlockCoord match : c.getRadiusMatches(world, this.getOverhang(meta), this.field_71990_ca, meta)) {
                    if (!this.isRooted(world, match.x, match.y, match.z, meta) || !c.isConnected(world, match, this.field_71990_ca, meta) || !(c.getDistance(match) <= (float)this.getOverhang(meta))) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isRooted(World world, int x, int y, int z, int meta) {
        for (int i = y - 1; i > 0; --i) {
            if (world.isBlockSolidOnSide(x, i, z, ForgeDirection.UP)) {
                if (world.func_72798_a(x, i, z) == this.field_71990_ca) {
                    if (world.func_72805_g(x, i, z) == meta) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void func_71863_a(World world, int x, int y, int z, int side) {
        if (!this.func_71854_d(world, x, y, z)) {
            this.func_71897_c(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_94571_i(x, y, z);
        }
    }

    @Override
    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return side == ForgeDirection.UP || side == ForgeDirection.DOWN;
    }

    public TileEntity func_72274_a(World world) {
        return null;
    }

    @Override
    public Icon getRenderIcon(int side, int meta) {
        if (side == 0 || side == 1) {
            return this.vertIcons[meta];
        }
        return null;
    }

    @Override
    public ConnectedTexture getTextureType(int side, int meta) {
        if (side == 0 || side == 1) {
            switch (meta) {
                case 0: {
                    return ConnectedTexture.BasicFrame;
                }
                case 1: {
                    return ConnectedTexture.ReinforcedFrame;
                }
                case 2: {
                    return ConnectedTexture.IndustrialFrame;
                }
                case 3: {
                    return ConnectedTexture.AdvancedFrame;
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public ConnectedTextureBase getTextureRenderer(int side, int meta) {
        if (side == 0 || side == 1) {
            switch (meta) {
                case 0: {
                    return this.basic;
                }
                case 1: {
                    return this.reinforced;
                }
                case 2: {
                    return this.industrial;
                }
                case 3: {
                    return this.advanced;
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean func_71926_d() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister reg) {
        ArtificeConfig.registerConnectedTextures(reg);
        for (int i = 0; i < ArtificeCore.tiers.length; ++i) {
            this.sideIcons[i] = IconHandler.registerSingle(reg, ArtificeCore.tiers[i].toLowerCase() + "_side", "scaffold");
            this.vertIcons[i] = IconHandler.registerSingle(reg, ArtificeCore.tiers[i].toLowerCase() + "_vert", "scaffold");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        if (side == 0 || side == 1) {
            return this.getTextureType((int)side, (int)meta).textureList[0];
        }
        return this.sideIcons[meta];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess block, int x, int y, int z, int side) {
        if (side == 0 || side == 1) {
            return this.getTextureType((int)side, (int)block.func_72805_g((int)x, (int)y, (int)z)).textureList[this.getTextureRenderer(side, block.func_72805_g(x, y, z)).getTextureIndex(block, x, y, z, side)];
        }
        return this.sideIcons[block.func_72805_g(x, y, z)];
    }
}

