/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.compat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import shukaro.artifice.ArtificeConfig;
import shukaro.artifice.ArtificeCore;
import shukaro.artifice.util.IdMetaPair;

public abstract class ArtificeRegistry {
    private static List floraBlacklist = new ArrayList();
    private static List dimensionBlacklist = new ArrayList();
    private static Set stoneTypes = new HashSet();
    private static List worldTypeBlacklist = new ArrayList();
    private static List lotusWhitelist = new ArrayList();
    private static Map sledgeBlocks = new HashMap();
    private static Map wildSledgeBlocks = new HashMap();
    private static Map tooltipMap = new HashMap();
    private static List marbleTypes = new ArrayList();
    private static List basaltTypes = new ArrayList();

    public static void registerMarbleType(int id, int meta) {
        ItemStack stack = new ItemStack(id, 1, meta);
        if (marbleTypes.isEmpty()) {
            marbleTypes.add(stack);
        } else if (!marbleTypes.contains(stack)) {
            marbleTypes.add(stack);
            if (marbleTypes.size() < 3) {
                ShapelessOreRecipe inner = new ShapelessOreRecipe((ItemStack)marbleTypes.get(1), new Object[]{marbleTypes.get(0)});
                ShapelessOreRecipe wrap = new ShapelessOreRecipe((ItemStack)marbleTypes.get(0), new Object[]{marbleTypes.get(1)});
                CraftingManager.func_77594_a().func_77592_b().add(inner);
                CraftingManager.func_77594_a().func_77592_b().add(wrap);
            } else {
                ShapelessOreRecipe old = new ShapelessOreRecipe((ItemStack)marbleTypes.get(0), new Object[]{marbleTypes.get(marbleTypes.size() - 2)});
                ShapelessOreRecipe inner = new ShapelessOreRecipe((ItemStack)marbleTypes.get(marbleTypes.size()), new Object[]{marbleTypes.get(marbleTypes.size() - 1)});
                ShapelessOreRecipe wrap = new ShapelessOreRecipe((ItemStack)marbleTypes.get(0), new Object[]{marbleTypes.get(marbleTypes.size() - 1)});
                CraftingManager.func_77594_a().func_77592_b().remove(old);
                CraftingManager.func_77594_a().func_77592_b().add(inner);
                CraftingManager.func_77594_a().func_77592_b().add(wrap);
            }
        }
    }

    public static List getMarbleTypes() {
        return marbleTypes;
    }

    public static void registerBasaltType(int id, int meta) {
        ItemStack stack = new ItemStack(id, 1, meta);
        if (basaltTypes.isEmpty()) {
            basaltTypes.add(stack);
        } else if (!basaltTypes.contains(stack)) {
            basaltTypes.add(stack);
            if (!ArtificeConfig.stoneCycleRecipes.getBoolean(true)) {
                return;
            }
            if (basaltTypes.size() < 3) {
                ShapelessOreRecipe inner = new ShapelessOreRecipe((ItemStack)basaltTypes.get(1), new Object[]{basaltTypes.get(0)});
                ShapelessOreRecipe wrap = new ShapelessOreRecipe((ItemStack)basaltTypes.get(0), new Object[]{basaltTypes.get(1)});
                CraftingManager.func_77594_a().func_77592_b().add(inner);
                CraftingManager.func_77594_a().func_77592_b().add(wrap);
            } else {
                ShapelessOreRecipe old = new ShapelessOreRecipe((ItemStack)basaltTypes.get(0), new Object[]{basaltTypes.get(basaltTypes.size() - 2)});
                ShapelessOreRecipe inner = new ShapelessOreRecipe((ItemStack)basaltTypes.get(basaltTypes.size()), new Object[]{basaltTypes.get(basaltTypes.size() - 1)});
                ShapelessOreRecipe wrap = new ShapelessOreRecipe((ItemStack)basaltTypes.get(0), new Object[]{basaltTypes.get(basaltTypes.size() - 1)});
                CraftingManager.func_77594_a().func_77592_b().remove(old);
                CraftingManager.func_77594_a().func_77592_b().add(inner);
                CraftingManager.func_77594_a().func_77592_b().add(wrap);
            }
        }
    }

    public static List getBasaltTypes() {
        return basaltTypes;
    }

    public static void registerTooltip(int id, int meta, String line) {
        IdMetaPair pair = new IdMetaPair(id, meta);
        if (tooltipMap.get(pair) == null) {
            ArrayList<String> temp = new ArrayList<String>();
            temp.add(line);
            tooltipMap.put(pair, temp);
        } else {
            ((List)tooltipMap.get(pair)).add(line);
        }
    }

    public static Map getTooltipMap() {
        return tooltipMap;
    }

    public static void registerSledgeBlock(int id, int meta, ArrayList drops) {
        IdMetaPair pair = new IdMetaPair(id, meta);
        if (!pair.isValidBlock()) {
            ArtificeCore.logger.log(Level.WARNING, "Tried to register non-block id-meta pair in the sledgeBlock map: " + pair.toString());
        } else if (sledgeBlocks.get(pair) == null) {
            sledgeBlocks.put(pair, drops);
        }
    }

    public static void registerWildSledgeBlock(int id, ArrayList drops) {
        if (wildSledgeBlocks.get(id) == null) {
            wildSledgeBlocks.put(id, drops);
        }
    }

    public static Map getWildSledgeBlocks() {
        return wildSledgeBlocks;
    }

    public static Map getSledgeBlocks() {
        return sledgeBlocks;
    }

    public static void registerFloraBlacklist(String biome) {
        if (!floraBlacklist.contains(biome)) {
            floraBlacklist.add(biome);
        }
    }

    public static List getFloraBlacklist() {
        return floraBlacklist;
    }

    public static void registerDimensionBlacklist(int dimID) {
        if (!dimensionBlacklist.contains(dimID)) {
            dimensionBlacklist.add(dimID);
        }
    }

    public static List getDimensionBlacklist() {
        return dimensionBlacklist;
    }

    public static void registerStoneType(int stoneID) {
        if (!stoneTypes.contains(stoneID)) {
            stoneTypes.add(stoneID);
        }
    }

    public static Set getStoneTypes() {
        return stoneTypes;
    }

    public static void registerWorldTypeBlacklist(String type) {
        if (!worldTypeBlacklist.contains(type)) {
            worldTypeBlacklist.add(type);
        }
    }

    public static List getWorldTypeBlacklist() {
        return worldTypeBlacklist;
    }

    public static void registerLotusWhitelist(String biome) {
        if (!lotusWhitelist.contains(biome)) {
            lotusWhitelist.add(biome);
        }
    }

    public static List getLotusWhitelist() {
        return lotusWhitelist;
    }
}

